/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.preferences;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.ide.config.Preferences;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeListener;

public class BuildTextPreferencesPanelSettings
extends HashStructureAdapter {
    private static final String DATA_KEY = "oracle.dmt.dataminer.workflow.preferences.BuildTextPreferencesPanelSettings";
    private static String DEFAULT_TRANSFORM_TYPE = "Token";
    private static int CATEGORICAL_CUTOFF_VALUE = 200;
    private static int MAX_NUM_PER_DOC = 50;
    private static int MAX_NUM_ALL_DOCS = 3000;
    private static String DEFAULT_LANGUAGE = "ENGLISH";

    static BuildTextPreferencesPanelSettings getInstance() {
        return BuildTextPreferencesPanelSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    private BuildTextPreferencesPanelSettings(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static BuildTextPreferencesPanelSettings getInstance(PropertyStorage propertyStorage) {
        return new BuildTextPreferencesPanelSettings(BuildTextPreferencesPanelSettings.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY));
    }

    public void addStructureChangeListener(StructureChangeListener structureChangeListener) {
        this._hash.addStructureChangeListener(structureChangeListener);
    }

    public void removeStructureChangeListener(StructureChangeListener structureChangeListener) {
        this._hash.removeStructureChangeListener(structureChangeListener);
    }

    public int getCategoricalCutoffValue() {
        return this._hash.getInt("CategoricalCutoffValue", CATEGORICAL_CUTOFF_VALUE);
    }

    public void setCategoricalCutoffValue(int n) {
        this._hash.putLong("CategoricalCutoffValue", (long)n);
    }

    public String getTransformType() {
        return this._hash.getString("TransformType", DEFAULT_TRANSFORM_TYPE);
    }

    public void setTransformType(String string) {
        this._hash.putString("TransformType", string);
    }

    public boolean useStemming() {
        return this._hash.getBoolean("Stemming", false);
    }

    public void setStemming(boolean bl) {
        this._hash.putBoolean("Stemming", bl);
    }

    public String getTokenStoplist() {
        return this._hash.getString("TokenStoplist", "Default");
    }

    public void setTokenStoplist(String string) {
        this._hash.putString("TokenStoplist", string);
    }

    public int getTokenMaxNumPerDoc() {
        return this._hash.getInt("TokenMaxNumPerDoc", MAX_NUM_PER_DOC);
    }

    public void setTokenMaxNumPerDoc(int n) {
        this._hash.putLong("TokenMaxNumPerDoc", (long)n);
    }

    public void removeTokenMaxNumPerDoc() {
        this._hash.remove("TokenMaxNumPerDoc");
    }

    public int getTokenMaxNumAllDocs() {
        return this._hash.getInt("TokenMaxNumAllDocs", MAX_NUM_ALL_DOCS);
    }

    public void setTokenMaxNumAllDocs(int n) {
        this._hash.putLong("TokenMaxNumAllDocs", (long)n);
    }

    public void removeTokenMaxNumAllDocs() {
        this._hash.remove("TokenMaxNumAllDocs");
    }

    public void setTokenLanguages(List<String> list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : list) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("|");
            }
            stringBuffer.append(string);
        }
        this._hash.putString("TokenLanguages", stringBuffer.toString());
    }

    public ArrayList<String> getTokenLanguages() {
        String string = this._hash.getString("TokenLanguages", DEFAULT_LANGUAGE);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            arrayList.add(string2);
        }
        return arrayList;
    }

    public String getThemeStoplist() {
        return this._hash.getString("ThemeStoplist", "Default");
    }

    public void setThemeStoplist(String string) {
        this._hash.putString("ThemeStoplist", string);
    }

    public void removeTokenLanguages() {
        this._hash.remove("TokenLanguages");
    }

    public void setThemeLanguages(List<String> list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : list) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("|");
            }
            stringBuffer.append(string);
        }
        this._hash.putString("ThemeLanguages", stringBuffer.toString());
    }

    public ArrayList<String> getThemeLanguages() {
        String string = this._hash.getString("ThemeLanguages", DEFAULT_LANGUAGE);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            arrayList.add(string2);
        }
        return arrayList;
    }

    public void removeThemeLanguages() {
        this._hash.remove("ThemeLanguages");
    }

    public int getThemeMaxNumPerDoc() {
        return this._hash.getInt("ThemeMaxNumPerDoc", MAX_NUM_PER_DOC);
    }

    public void setThemeMaxNumPerDoc(int n) {
        this._hash.putLong("ThemeMaxNumPerDoc", (long)n);
    }

    public void removeThemeMaxNumPerDoc() {
        this._hash.remove("ThemeMaxNumPerDoc");
    }

    public int getThemeMaxNumAllDocs() {
        return this._hash.getInt("ThemeMaxNumAllDocs", MAX_NUM_ALL_DOCS);
    }

    public void setThemeMaxNumAllDocs(int n) {
        this._hash.putLong("ThemeMaxNumAllDocs", (long)n);
    }

    public void removeThemeMaxNumAllDocs() {
        this._hash.remove("ThemeMaxNumAllDocs");
    }
}

