/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.task;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.Version;
import oracle.ideimpl.webupdate.task.AtomicTask;
import oracle.ideimpl.webupdate.task.CreateDirectory;
import oracle.ideimpl.webupdate.task.MoveFile;
import oracle.ideimpl.webupdate.task.TaskContext;
import oracle.ideimpl.webupdate.task.TaskFailedException;
import oracle.ideimpl.webupdate.task.TaskStack;

public class DeinstallExtensionTask
extends AtomicTask {
    private static final String KEY_EXTENSION_ID = "extensionId";
    private static final String KEY_VERSION = "version";
    private TaskStack _tasks;

    public DeinstallExtensionTask() {
    }

    public DeinstallExtensionTask(String extensionId) {
        if (extensionId == null) {
            throw new IllegalArgumentException("Extension id must not be null");
        }
        Extension descriptor = ExtensionRegistry.getExtensionRegistry().findExtension(extensionId);
        if (descriptor == null) {
            throw new IllegalArgumentException("Extension " + extensionId + " does not exist, or is not loaded. ");
        }
        Version currentVersion = descriptor.getVersion();
        this.getProperties().putString(KEY_EXTENSION_ID, extensionId);
        this.getProperties().putString(KEY_VERSION, currentVersion.toString());
    }

    @Override
    public void perform(TaskContext tc) throws TaskFailedException {
        this._tasks = new TaskStack();
        tc.getProgress().setPercentProgress(0.0);
        String extensionId = this.getProperties().getString(KEY_EXTENSION_ID);
        String version = this.getProperties().getString(KEY_VERSION);
        File[] files = new File[]{};
        boolean isUserExt = true;
        File userExtDir = new File(tc.getDirectories().getUserExtensionsHome());
        if (userExtDir.exists() && userExtDir.isDirectory()) {
            files = this.findExtensionFiles(userExtDir, extensionId);
        }
        if (files.length == 0) {
            isUserExt = false;
            File systemExtDir = new File(tc.getDirectories().getGlobalExtensionsHome());
            if (systemExtDir.exists() && systemExtDir.isDirectory()) {
                files = this.findExtensionFiles(systemExtDir, extensionId);
                if (files.length == 0) {
                    tc.getProgress().setPercentProgress(1.0);
                    return;
                }
            } else {
                tc.getProgress().setPercentProgress(1.0);
                return;
            }
        }
        File backupsDir = new File(isUserExt ? tc.getDirectories().getUserSettingsHome() : tc.getDirectories().getGlobalSettingsHome(), "oracle.ideimpl.webupdate.backup");
        this._tasks.performTask(new CreateDirectory(backupsDir), tc);
        tc.getProgress().setPercentProgress(0.33);
        this.pause();
        String backupId = extensionId + "." + version;
        File extBackupDir = new File(backupsDir, backupId);
        if (extBackupDir.exists()) {
            int suffix = 1;
            while ((extBackupDir = new File(backupsDir, backupId + "_" + String.valueOf(suffix))).exists()) {
                ++suffix;
            }
        }
        this._tasks.performTask(new CreateDirectory(extBackupDir), tc);
        tc.getProgress().setPercentProgress(0.66);
        this.pause();
        for (int i = 0; i < files.length; ++i) {
            File originalFile = files[i];
            File backupFile = new File(extBackupDir, originalFile.getName());
            this._tasks.performTask(new MoveFile(originalFile, backupFile), tc);
        }
        tc.getProgress().setPercentProgress(1.0);
    }

    private File[] findExtensionFiles(File extDir, String id) {
        ArrayList<File> alFiles = new ArrayList<File>(2);
        File[] children = extDir.listFiles();
        for (int i = 0; i < children.length; ++i) {
            File child = children[i];
            if (!id.equals(this.getExtensionID(child))) continue;
            alFiles.add(child);
        }
        return alFiles.toArray(new File[alFiles.size()]);
    }

    private String getExtensionID(File file) {
        StringBuffer idBuffer = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(file.getName(), ".");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if ("jar".equalsIgnoreCase(token) || DeinstallExtensionTask.isNumber(token)) continue;
            idBuffer.append(token);
            idBuffer.append(".");
        }
        if (idBuffer.length() == 0) {
            return null;
        }
        idBuffer.setLength(idBuffer.length() - 1);
        return idBuffer.toString();
    }

    private static final boolean isNumber(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void rollback(TaskContext tc) throws TaskFailedException {
        if (this._tasks == null) {
            throw new IllegalStateException("Attempt to rollback task before performed.");
        }
        this._tasks.rollbackTasks(tc);
    }
}

