/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.wizard;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.Extension;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import oracle.ide.ExtensionRegistry;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.webupdate.CheckUpdatesRunnable;
import oracle.ideimpl.webupdate.LocalUpdateBundle;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateCenter;
import oracle.ideimpl.webupdate.UpdateCenterMonitor;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.wizard.UpdateItem;
import oracle.ideimpl.webupdate.wizard.UpdateWizardModel;
import oracle.ideimpl.webupdate.wizard.UpdatesTreePanel;
import oracle.javatools.controls.HyperlinkButton;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ListUtil;
import org.xml.sax.SAXParseException;

abstract class CFUUpdatesTreePanel
extends UpdatesTreePanel {
    private static final Logger LOG = Logger.getLogger(CFUUpdatesTreePanel.class.getName());
    private boolean _checkedForUpdates;
    private final JButton _progressStop = new JButton();
    private final JProgressBar _progressBar = new JProgressBar();
    private final JLabel _progressBarStatus = new JLabel();
    private final JPanel _progressPanel = new JPanel();
    private final HyperlinkButton _statusLink = new HyperlinkButton();
    private ActionListener _statusLinkListener;
    private boolean _stoppedCheck;

    CFUUpdatesTreePanel() {
        this.initializeGUI();
    }

    public boolean canFinish() {
        return this._checkedForUpdates && this.getSelectedUpdates().isEmpty();
    }

    public boolean isComplete() {
        if (!this._checkedForUpdates) {
            return false;
        }
        return !this.getSelectedUpdates().isEmpty();
    }

    boolean isCheckedForUpdates() {
        return this._checkedForUpdates;
    }

    void restart() {
        this._checkedForUpdates = false;
        this.clear();
        this.cleanUp();
    }

    public void populate(final UpdateWizardModel model) {
        this._checkedForUpdates = false;
        this.completeValueChanged();
        this.setStopped(false);
        this._onlyUpgrades.setEnabled(false);
        if (model.getLocalBundle() == null) {
            CheckUpdatesRunnable checkRunnable = new CheckUpdatesRunnable(model.getSelectedCenters()){

                @Override
                protected void finished(final Collection<UpdateInfo> updates) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Collection requestedExtensions = CFUUpdatesTreePanel.this.getRequestedExtensionIds(model, updates);
                                if (requestedExtensions == null) {
                                    CFUUpdatesTreePanel.this.populateUpdates(updates, false);
                                } else {
                                    if (requestedExtensions.isEmpty()) {
                                        CFUUpdatesTreePanel.this._progressPanel.setVisible(false);
                                        MessageDialog.information((Component)CFUUpdatesTreePanel.this, (Object)UpdateArb.getString(215), (String)UpdateArb.getString(216), null);
                                        return;
                                    }
                                    CFUUpdatesTreePanel.this.populateUpdates(requestedExtensions, true);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            finally {
                                CFUUpdatesTreePanel.this._checkedForUpdates = true;
                                CFUUpdatesTreePanel.this.completeValueChanged();
                            }
                        }
                    });
                }

                @Override
                protected void stopped() {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CFUUpdatesTreePanel.this._checkedForUpdates = true;
                            CFUUpdatesTreePanel.this.showStatusMessage(OracleIcons.getIcon((String)"warning.png"), UpdateArb.getString(214));
                        }
                    });
                }

                @Override
                protected void updateCenterError(final UpdateCenter center, final Throwable t) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CFUUpdatesTreePanel.this.showStatusMessage(OracleIcons.getIcon((String)"error.png"), UpdateArb.format(151, center.getName()), t);
                        }
                    });
                }
            };
            UpdateCenterMonitor monitor = new UpdateCenterMonitor(){

                @Override
                public void setMessage(final String message) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CFUUpdatesTreePanel.this._progressBarStatus.setText(message);
                        }
                    });
                }

                @Override
                public void setProgress(final int progress) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CFUUpdatesTreePanel.this._progressBar.setValue(progress);
                            CFUUpdatesTreePanel.this._progressBar.setIndeterminate(false);
                            if (progress < CFUUpdatesTreePanel.this._progressBar.getMaximum()) {
                                new Thread(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            Thread.sleep(2000L);
                                            SwingUtilities.invokeLater(new Runnable(){

                                                @Override
                                                public void run() {
                                                    if (CFUUpdatesTreePanel.this._progressBar.getValue() == progress) {
                                                        CFUUpdatesTreePanel.this._progressBar.setIndeterminate(true);
                                                    }
                                                }
                                            });
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                }).start();
                            }
                        }
                    });
                }

                @Override
                public void setMaximum(final int max) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CFUUpdatesTreePanel.this._progressBar.setMaximum(max);
                        }
                    });
                }

                @Override
                public void start() {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CFUUpdatesTreePanel.this._progressBar.setValue(0);
                            CFUUpdatesTreePanel.this._progressBar.setIndeterminate(true);
                            CFUUpdatesTreePanel.this._progressBar.setVisible(true);
                            CFUUpdatesTreePanel.this._progressStop.setVisible(true);
                            CFUUpdatesTreePanel.this._progressBarStatus.setVisible(true);
                            CFUUpdatesTreePanel.this._progressStop.setEnabled(true);
                            CFUUpdatesTreePanel.this._statusLink.setVisible(false);
                            CFUUpdatesTreePanel.this._progressPanel.setVisible(true);
                            CFUUpdatesTreePanel.this._progressPanel.invalidate();
                            CFUUpdatesTreePanel.this._progressPanel.validate();
                        }
                    });
                }

                @Override
                public void finish() {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (CFUUpdatesTreePanel.this.hasUpdates()) {
                                CFUUpdatesTreePanel.this._progressPanel.setVisible(false);
                            }
                        }
                    });
                }

                @Override
                public boolean isStopped() {
                    return CFUUpdatesTreePanel.this.isStopped();
                }
            };
            checkRunnable.setMonitor(monitor);
            Thread t = new Thread((Runnable)checkRunnable, "Check for updates");
            t.start();
        } else {
            this._progressPanel.setVisible(false);
            LocalUpdateBundle localBundle = model.getLocalBundle();
            this.populateUpdates(localBundle.getBundle().getUpdates(), false);
            this._onlyUpgrades.setEnabled(false);
            this._onlyUpgrades.setSelected(false);
            this.completeValueChanged();
        }
    }

    private Collection<UpdateInfo> getRequestedExtensionIds(UpdateWizardModel model, Collection<UpdateInfo> updates) {
        HashSet<UpdateInfo> requestedUpdates = null;
        if (model.hasRequestedExtensions()) {
            requestedUpdates = new HashSet<UpdateInfo>();
            Collection<String> requestedExtensions = null;
            if (model.getRequestedExtensionID() != null) {
                requestedExtensions = new HashSet<String>();
                requestedExtensions.add(model.getRequestedExtensionID());
            } else {
                requestedExtensions = model.getRequestedExtensionIDs();
            }
            for (String extensionID : requestedExtensions) {
                boolean foundExtension = false;
                for (UpdateInfo update : updates) {
                    if (!extensionID.equals(update.getID())) continue;
                    requestedUpdates.add(update);
                    foundExtension = true;
                    break;
                }
                if (foundExtension) continue;
                ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
                Extension extension = registry.findExtension(extensionID);
                if (extension != null) {
                    LOG.info(UpdateArb.format(212, extensionID));
                    continue;
                }
                LOG.info(UpdateArb.format(213, extensionID));
            }
        }
        return requestedUpdates;
    }

    @Override
    protected void populateUpdates(Collection<UpdateInfo> updates, boolean selectAll) {
        this._onlyUpgrades.setEnabled(!updates.isEmpty());
        if (updates.isEmpty()) {
            this.showStatusMessage(OracleIcons.getIcon((String)"warning.png"), UpdateArb.getString(18), null);
        }
        super.populateUpdates(updates, selectAll);
    }

    protected synchronized void setStopped(boolean stopped) {
        this._stoppedCheck = stopped;
        this._progressStop.setEnabled(!stopped);
    }

    private synchronized boolean isStopped() {
        return this._stoppedCheck;
    }

    @Override
    protected JPanel getLayoutProgressBar() {
        this._progressPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 5);
        gbc.anchor = 17;
        this._progressPanel.add((Component)this._progressBar, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        this._progressPanel.add((Component)this._progressStop, gbc);
        ResourceUtils.resButton((AbstractButton)this._progressStop, (String)UpdateArb.getString(14));
        ResourceUtils.setComponentName((Object)this, (Component)this._progressStop, (String)"_progressStop");
        this._progressStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CFUUpdatesTreePanel.this.setStopped(true);
            }
        });
        ++gbc.gridx;
        this._progressPanel.add((Component)this._statusLink, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 5);
        gbc.anchor = 18;
        this._progressPanel.add((Component)this._progressBarStatus, gbc);
        return this._progressPanel;
    }

    @Override
    protected JComponent getSearchPanelRightComponent() {
        this._onlyUpgrades.setSelected(false);
        ResourceUtils.resButton((AbstractButton)this._onlyUpgrades, (String)UpdateArb.getString(13));
        ResourceUtils.setComponentName((Object)this, (Component)this._onlyUpgrades, (String)"_onlyUpgrades");
        return this._onlyUpgrades;
    }

    @Override
    protected void updateDependencies(UpdateItem item) {
        UpdateInfo updateInfo = item.getUpdate();
        if (item.isSelected() && !updateInfo.getRequiredUpdates().isEmpty()) {
            HashSet<UpdateItem> required = new HashSet<UpdateItem>();
            this.findUncheckedDependencies(required, item);
            if (!required.isEmpty()) {
                if (this.confirmInstallDepedencies(item.getUpdate().getName(), required, true)) {
                    for (UpdateItem requiredItem : required) {
                        requiredItem.setSelected(true);
                    }
                } else {
                    item.setSelected(false);
                }
            }
        } else if (!item.isSelected()) {
            boolean ok;
            ArrayList<String> deps = new ArrayList<String>();
            for (UpdateItem otherItem : this.getMapOfUpdateInfos().values()) {
                if (!otherItem.isSelected() || !otherItem.getUpdate().getRequiredUpdates().contains(updateInfo)) continue;
                deps.add(otherItem.getUpdate().getName());
            }
            if (deps.size() > 0 && !(ok = MessageDialog.confirm((Component)this, (Object)UpdateArb.format(53, updateInfo.getName(), ListUtil.join(deps, (String)"\n")), (String)UpdateArb.getString(52), null))) {
                item.setSelected(true);
            }
        }
        UpdateBundle bundle = item.getUpdate().getBundle();
        if (bundle != null) {
            ArrayList<String> bundles = new ArrayList<String>();
            for (UpdateInfo update : bundle.getUpdates()) {
                if (update == item.getUpdate()) continue;
                UpdateItem bundleItem = this.getMapOfUpdateInfos().get(update);
                bundles.add(bundleItem.getUpdate().getName());
                bundleItem.setSelected(item.isSelected());
            }
            if (!bundles.isEmpty() && item.isSelected()) {
                MessageDialog.information((Component)this, (Object)UpdateArb.format(221, updateInfo.getName(), ListUtil.join(bundles, (String)"\n")), (String)UpdateArb.getString(220), null);
            }
        }
    }

    private void findUncheckedDependencies(Set<UpdateItem> dependents, UpdateItem item) {
        UpdateInfo updateInfo = item.getUpdate();
        if (!updateInfo.getRequiredUpdates().isEmpty()) {
            for (UpdateInfo requiredInfo : updateInfo.getRequiredUpdates()) {
                UpdateItem requiredItem = this.getMapOfUpdateInfos().get(requiredInfo);
                if (requiredItem.isSelected()) continue;
                dependents.add(requiredItem);
                this.findUncheckedDependencies(dependents, requiredItem);
            }
        }
    }

    private void showStatusMessage(Icon icon, String message) {
        this.showStatusMessage(icon, message, null);
    }

    private void showStatusMessage(Icon icon, String message, Throwable t) {
        LOG.warning(message);
        if (t != null) {
            LOG.log(Level.FINE, t.toString(), t);
        }
        this._progressBar.setVisible(false);
        this._progressStop.setVisible(false);
        this._statusLink.setVisible(t != null);
        this._progressBarStatus.setVisible(false);
        this._progressPanel.setVisible(true);
        if (t != null) {
            if (this._statusLinkListener != null) {
                this._statusLink.removeActionListener(this._statusLinkListener);
            }
            this._statusLinkListener = this.createStatusLinkListener(t, message);
            this._statusLink.addActionListener(this._statusLinkListener);
        }
    }

    private ActionListener createStatusLinkListener(Throwable t, String message) {
        if (t instanceof SAXParseException) {
            return new KnownExceptionAction(t, message, UpdateArb.getString(187));
        }
        if (t instanceof FileNotFoundException) {
            return new KnownExceptionAction(t, message, UpdateArb.getString(188));
        }
        if (t instanceof IOException) {
            return new KnownExceptionAction(t, message, UpdateArb.getString(189));
        }
        return new UnknownExceptionAction(t, message);
    }

    private class UnknownExceptionAction
    implements ActionListener {
        private final Throwable _exception;
        private final String _message;

        public UnknownExceptionAction(Throwable exception, String message) {
            this._exception = exception;
            this._message = message;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ExceptionDialog.showExceptionDialog((Component)CFUUpdatesTreePanel.this, (Throwable)this._exception, (String)this._message, (String)UpdateArb.getString(1), null);
        }
    }

    private class KnownExceptionAction
    implements ActionListener {
        private final String _baseMessage;
        private final String _detailMessage;

        public KnownExceptionAction(Throwable exception, String baseMessage, String detailMessage) {
            this._baseMessage = baseMessage;
            this._detailMessage = detailMessage;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            MessageDialog.error((Component)CFUUpdatesTreePanel.this, (Object)(this._baseMessage + "\n" + this._detailMessage), (String)UpdateArb.getString(1), null);
        }
    }
}

