/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.util.ArrayList;
import oracle.bali.inspector.multi.SelectionModel;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.inspector.IdePropertyModel;
import oracle.ide.inspector.InspectorContext;
import oracle.ide.inspector.PropertySetCommand;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;

public class IdeMultiObjectModel
extends IdePropertyModel {
    private Context context;
    private Subject[] subjects;

    protected Context getContext() {
        return this.context;
    }

    @Override
    public void setContext(Context context) {
        Node node;
        this.context = context;
        Element[] selection = context.getSelection();
        ArrayList<Object> list = new ArrayList<Object>();
        Integer[] offsets = InspectorContext.getInspectableOffsets(context);
        if (offsets != null) {
            for (int i = 0; i < offsets.length; ++i) {
                Element element = selection[offsets[i]];
                if (!(element instanceof Subject)) continue;
                list.add(element);
            }
        }
        if (list.size() == 0 && (node = context.getNode()) != null) {
            list.add(node);
        }
        this.subjects = new Subject[list.size()];
        list.toArray(this.subjects);
    }

    @Override
    public Subject[] getSubjects() {
        return this.subjects;
    }

    public void setValueAt(Object data, int row, int col) {
        Command cmd = this.createCommand(data, row, col);
        if (cmd != null) {
            try {
                CommandProcessor processor = CommandProcessor.getInstance();
                cmd.setContext(this.context);
                int status = processor.invoke(cmd);
                if (0 == status) {
                    this.invalidateValueData();
                }
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new IllegalArgumentException();
            }
        }
    }

    protected Command createCommand(Object data, int row, int col) {
        Object id = this.getValueAt(row, this.getColumnIndex(COLUMN_ID));
        SelectionModel model = this.getSelectionModel();
        return id != null ? new PropertySetCommand(model, id, col, data) : null;
    }
}

