/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JComboBox;
import oracle.bali.inspector.InspectorPropertyEditor;
import oracle.bali.inspector.JavaBeansPropertyEditorAdapter;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.PropertyGroup;
import oracle.bali.inspector.editor.ComboBoxEditor;
import oracle.bali.inspector.editor.EditorComponentFactoryRegistry;
import oracle.bali.inspector.editor.EditorComponentSetupRegistry;
import oracle.bali.inspector.editor.PropertyValueApplier;
import oracle.ide.inspector.ConflictingValues;
import oracle.ide.inspector.CustomEditorButton;
import oracle.ide.inspector.CustomEditors;
import oracle.ide.inspector.DisplayValues;
import oracle.ide.inspector.EditorContainer;
import oracle.ide.inspector.LabelAndEditor;
import oracle.ide.inspector.Orientation;
import oracle.ide.inspector.PropertyEditorFinder;
import oracle.ide.inspector.PropertyEditorListeners;
import oracle.ide.inspector.PropertyInfo;
import oracle.ide.inspector.UpdateComponentWithFocusListener;
import oracle.ide.inspector.ValidationIssues;
import oracle.javatools.util.StringUtil;

final class SingletonPropertyEditorFinder
implements PropertyEditorFinder {
    private static final String COMPONENT_NAME_DELIMITER = " :: ";

    @Override
    public LabelAndEditor editorFor(PropertyInfo property, Orientation orientation) {
        EditorContainer editor = this.editor(property, orientation);
        if (editor == null) {
            return null;
        }
        LabelAndEditor labelAndEditor = new LabelAndEditor(property, editor);
        labelAndEditor.addActionsAndHelpPopupListener(property);
        return labelAndEditor;
    }

    public EditorContainer editor(PropertyInfo property, Orientation orientation) {
        if (property == null || property.editorFactory() == null) {
            return null;
        }
        Component inlineEditor = this.findEditor(property);
        Component newInlineEditor = DisplayValues.truncateDisplayValue(inlineEditor, property);
        if (newInlineEditor == inlineEditor) {
            DisplayValues.showDisplayValueInInlineEditor(inlineEditor, property);
        } else {
            inlineEditor = newInlineEditor;
        }
        inlineEditor.setName(this.getComponentIdentifier(property));
        ConflictingValues.showConflictingValue(inlineEditor, property);
        return this.setupEditor(inlineEditor, property, orientation);
    }

    private String getComponentIdentifier(PropertyInfo property) {
        Object propertyId;
        String groupId;
        if (property == null) {
            return null;
        }
        ArrayList<String> parts = new ArrayList<String>();
        PropertyGroup group = property.groupFromModel();
        String string = groupId = group != null ? group.getName(Locale.US) : null;
        if (groupId != null) {
            parts.add(groupId);
        }
        String propertyIdString = (propertyId = property.id()) instanceof String ? (String)propertyId : property.displayName();
        parts.add(propertyIdString);
        return StringUtil.assembleTokens((String[])parts.toArray(new String[parts.size()]), (String)COMPONENT_NAME_DELIMITER);
    }

    private Component findEditor(PropertyInfo property) {
        PropertyEditorFactory2 propertyEditor = property.editorFactory();
        if (propertyEditor.isPaintable()) {
            return this.paintableEditor(propertyEditor, property);
        }
        if (propertyEditor.hasInlineEditor() && property.writable()) {
            Component inlineEditor = this.writableInlineEditor(propertyEditor);
            inlineEditor.setName("PropertyEditor " + property.displayName());
            if (EditorComponentSetupRegistry.instance().configure(inlineEditor, (PropertyValueApplier)property, propertyEditor)) {
                return inlineEditor;
            }
            this.configureInDeprecatedWay(property, inlineEditor);
            return inlineEditor;
        }
        return EditorComponentFactoryRegistry.instance().createReadOnlyEditor(propertyEditor);
    }

    private void configureInDeprecatedWay(PropertyInfo property, Component inlineEditor) {
        PropertyEditorFactory2 propertyEditor = property.editorFactory();
        PropertyEditorListeners.addPropertyInspectorListeners(inlineEditor, propertyEditor);
        property.attachToPropertyEditor(propertyEditor, inlineEditor);
    }

    private Component writableInlineEditor(PropertyEditorFactory2 propertyEditor) {
        Component inlineEditor;
        if (propertyEditor instanceof InspectorPropertyEditor && (inlineEditor = propertyEditor.getInlineEditor()) != null) {
            if (propertyEditor instanceof JavaBeansPropertyEditorAdapter) {
                JavaBeansPropertyEditorAdapter adapter = (JavaBeansPropertyEditorAdapter)propertyEditor;
                adapter.detachFromProperyEditor();
            }
            return inlineEditor;
        }
        return propertyEditor.getInlineEditor();
    }

    private Component paintableEditor(PropertyEditorFactory2 propertyEditor, PropertyInfo property) {
        EditorComponentFactoryRegistry registry = EditorComponentFactoryRegistry.instance();
        return registry.createPaintableEditor(propertyEditor, property.writable());
    }

    private EditorContainer setupEditor(Component inlineEditor, PropertyInfo property, Orientation orientation) {
        this.makeComboBoxTableCellEditor(inlineEditor);
        PropertyEditorListeners.addFocusListenerToEditor(inlineEditor, property.updatePropertyDescriptionFocusListener());
        ValidationIssues.addValidationIssues(inlineEditor, property, orientation);
        UpdateComponentWithFocusListener.addUpdateComponentWithFocusListener(property, inlineEditor);
        EditorContainer e = this.addCustomEditor(property, inlineEditor);
        return e;
    }

    private void makeComboBoxTableCellEditor(Component inlineEditor) {
        if (!(inlineEditor instanceof JComboBox)) {
            return;
        }
        if (inlineEditor instanceof ComboBoxEditor) {
            return;
        }
        ComboBoxEditor.makeTableCellEditor((JComboBox)((JComboBox)inlineEditor));
    }

    private EditorContainer addCustomEditor(PropertyInfo property, Component inlineEditor) {
        if (!property.writable()) {
            return new EditorContainer(inlineEditor);
        }
        CustomEditorButton customEditor = CustomEditors.customEditor(property, inlineEditor);
        if (customEditor == null) {
            return new EditorContainer(inlineEditor);
        }
        return new EditorContainer(inlineEditor, customEditor);
    }

    static SingletonPropertyEditorFinder instance() {
        return SingletonPropertyEditorFinderHolder.instance;
    }

    private SingletonPropertyEditorFinder() {
    }

    private static class SingletonPropertyEditorFinderHolder {
        static SingletonPropertyEditorFinder instance = new SingletonPropertyEditorFinder();

        private SingletonPropertyEditorFinderHolder() {
        }
    }
}

