/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.search;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.search.BaseSearchPanel;
import oracle.dbtools.raptor.controls.search.ItemNode;
import oracle.dbtools.raptor.controls.search.NodeRenderer;
import oracle.dbtools.raptor.controls.search.ResultsTreeNode;
import oracle.dbtools.raptor.controls.search.SchemaNode;
import oracle.dbtools.raptor.controls.search.SearchIdeNode;
import oracle.dbtools.raptor.controls.search.TypeNode;
import oracle.dbtools.raptor.dialogs.BasicObjectModifier;
import oracle.dbtools.raptor.format.ui.ExportContextMenuListener;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.plsql.PinningTracker;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.View;
import oracle.javatools.icons.OracleIcons;

public class SearchResultsEditor
extends Editor
implements TreeSelectionListener,
Controller {
    private JTree tree;
    private Toolbar toolbar;
    private IdeAction pinAction;
    private ToggleToolButton pinToggle;
    private SearchIdeNode node;
    private int PIN_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"VE_Pin_Editor");
    private MouseListener onClick = new UIUtils.MousePopupTriggerListener(){

        protected void doPopup(MouseEvent mouseEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseClicked(MouseEvent mouseEvent) {
            Object object;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            TreePath treePath = SearchResultsEditor.this.tree.getPathForLocation(n, n2);
            if (mouseEvent.getButton() == 3 || mouseEvent.getButton() == 2) {
                if (treePath == null) {
                    treePath = SearchResultsEditor.this.tree.getPathForLocation(n + 40, n2);
                }
                if (treePath == null) {
                    System.out.println("path == null");
                    return;
                }
                object = treePath.getLastPathComponent();
                if (object instanceof SchemaNode || object instanceof TypeNode) {
                    SearchResultsEditor.this.generateMenu(object.getClass()).show(SearchResultsEditor.this.tree, n, n2);
                    return;
                }
            }
            if (mouseEvent.getClickCount() == 2) {
                return;
            }
            object = (ResultsTreeNode)treePath.getLastPathComponent();
            if (object == null || !((DefaultMutableTreeNode)object).isLeaf() || !(object instanceof ItemNode)) {
                return;
            }
            ItemNode itemNode = (ItemNode)object;
            if (mouseEvent.getButton() == 3 || mouseEvent.getButton() == 2) {
                URL uRL;
                String string = itemNode.item.objName;
                if ("MATERIALIZED VIEW LOG".equals(itemNode.item.objType)) {
                    string = string.substring(0, string.indexOf(40));
                }
                if ((uRL = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", SearchResultsEditor.this.node.conn, null, itemNode.item.owner, itemNode.item.objType), string)) != null) {
                    Connections connections = Connections.getInstance();
                    Connection connection = null;
                    DBObject dBObject = new DBObject(uRL);
                    String string2 = dBObject.getConnectionName();
                    try {
                        connection = connections.getConnection(string2, false);
                        if (connection == null || !connections.lock(connection, true)) {
                            return;
                        }
                        Context context = Context.newIdeContext((Node)dBObject.getNode());
                        context.setEvent((EventObject)mouseEvent);
                        context.setProperty("ObjectAction.DBOBJECT", (Object)dBObject);
                        ContextMenu contextMenu = new ContextMenu();
                        contextMenu.addContextMenuListener((ContextMenuListener)new BasicObjectModifier());
                        contextMenu.addContextMenuListener((ContextMenuListener)ExportContextMenuListener.getInstance());
                        contextMenu.show(context);
                    }
                    catch (Exception exception) {
                        Logger.getLogger(BaseSearchPanel.class.getClass().getName()).log(Level.WARNING, exception.getMessage());
                    }
                    finally {
                        if (connection != null) {
                            connections.unlock(connection);
                        }
                    }
                }
            } else if (mouseEvent.getButton() == 1) {
                itemNode.item.goTo(SearchResultsEditor.this.node.conn);
            }
        }
    };

    public Toolbar getFixedTopMargin() {
        if (this.toolbar == null) {
            this.toolbar = new Toolbar();
            this.pinAction = IdeAction.get((int)this.PIN_EDITOR_CMD_ID);
            this.pinAction.addController((Controller)this);
            this.pinToggle = new ToggleToolButton((ToggleAction)this.pinAction);
            this.toolbar.add((Component)this.pinToggle, 0);
            boolean bl = PinningTracker.isPinned(this.node);
            this.pinAction.setState(bl);
            if (!bl) {
                this.pinToggle.setIcon(OracleIcons.getIcon((String)"pin.png"));
            } else {
                this.pinToggle.setIcon(RaptorImagesArb.getIcon("PINNED"));
            }
            this.toolbar.add((Component)new JLabel("<html>" + MessageFormat.format(ControlsArb.getString("SearchPanel.47"), "<font bgcolor=#bbffbb>" + this.node.cardinality + "</font>", "<font bgcolor=#dddddd>" + this.node.time + "</font>")));
            this.toolbar.add(Box.createHorizontalGlue());
            this.toolbar.add((Component)this.node.dbSelector.getJComboBox());
        }
        return this.toolbar;
    }

    public void open() {
        this.node = (SearchIdeNode)this.getContext().getNode();
    }

    public Component getGUI() {
        if (this.tree == null) {
            this.tree = new JTree(this.node.root){

                @Override
                public String getToolTipText(MouseEvent mouseEvent) {
                    if (this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY()) == -1) {
                        return null;
                    }
                    TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    ResultsTreeNode resultsTreeNode = (ResultsTreeNode)treePath.getLastPathComponent();
                    if (resultsTreeNode != null) {
                        return resultsTreeNode.getTooltip();
                    }
                    return null;
                }
            };
            ToolTipManager.sharedInstance().registerComponent(this.tree);
            this.tree.setRootVisible(false);
            this.tree.setShowsRootHandles(true);
            this.tree.setCellRenderer(new NodeRenderer());
            for (int i = 0; i < this.tree.getRowCount(); ++i) {
                this.tree.expandRow(i);
            }
            this.tree.getSelectionModel().setSelectionMode(1);
            this.tree.addTreeSelectionListener(this);
            this.tree.addMouseListener(this.onClick);
        }
        return this.tree;
    }

    public JPopupMenu generateMenu(final Class clazz) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        String string = ControlsArb.getString("Schemas");
        if (clazz == TypeNode.class) {
            string = ControlsArb.getString("Types");
        }
        JMenuItem jMenuItem = new JMenuItem(ControlsArb.getString("Expand") + " " + string, OracleIcons.getIcon((String)"expandall.png"));
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchResultsEditor.this.expandOrCollapseByType(clazz, true);
            }
        });
        jMenuItem = new JMenuItem(ControlsArb.getString("Collapse") + " " + string, OracleIcons.getIcon((String)"collapseall.png"));
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchResultsEditor.this.expandOrCollapseByType(clazz, false);
            }
        });
        return jPopupMenu;
    }

    private void expandOrCollapseByType(Class<TreeNode> clazz, boolean bl) {
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            TreePath treePath = this.tree.getPathForRow(i);
            Object object = treePath.getLastPathComponent();
            if (!clazz.isInstance(object)) continue;
            if (bl) {
                this.tree.expandPath(treePath);
                continue;
            }
            this.tree.collapsePath(treePath);
        }
    }

    public void update(Object object, UpdateMessage updateMessage) {
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        ResultsTreeNode resultsTreeNode = (ResultsTreeNode)this.tree.getLastSelectedPathComponent();
        if (resultsTreeNode == null || !resultsTreeNode.isLeaf() || !(resultsTreeNode instanceof ItemNode)) {
            return;
        }
        ItemNode itemNode = (ItemNode)resultsTreeNode;
        itemNode.item.goTo(this.node.conn);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == this.PIN_EDITOR_CMD_ID) {
            boolean bl = PinningTracker.isPinned(this.node);
            if (!bl) {
                this.pinToggle.setIcon(RaptorImagesArb.getIcon("PINNED"));
                PinningTracker.pinNode(this.node);
            } else {
                this.pinToggle.setIcon(OracleIcons.getIcon((String)"pin.png"));
                PinningTracker.unpinNode(this.node);
            }
            View.updateToolbarActions((Toolbar)this.toolbar);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == this.PIN_EDITOR_CMD_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        return false;
    }
}

