/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadField;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.extract.ExtractResources;
import oracle.dbtools.importer.ImportResources;
import oracle.dbtools.importer.core.ImportDataFormat;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.extract.models.ExtractListModelHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.icons.OracleIcons;

public class ImportSummaryTreeModel {
    public static DefaultTreeModel getSummaryTreeModel(ImportProperties importProperties, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        if (!importProperties.getValueBoolean(ImportKeys.IS_CART).booleanValue()) {
            defaultMutableTreeNode.add(ImportSummaryTreeModel.getConnectionNode(importProperties));
        }
        defaultMutableTreeNode.add(ImportSummaryTreeModel.getFileNode(importProperties));
        defaultMutableTreeNode.add(ImportSummaryTreeModel.getSelectedFields(importProperties));
        if (!importProperties.getValueBoolean(ImportKeys.IS_CART).booleanValue()) {
            defaultMutableTreeNode.add(ImportSummaryTreeModel.getSelectableFields(importProperties));
            defaultMutableTreeNode.add(ImportSummaryTreeModel.getImportMethodSummaryNode(importProperties));
        }
        return new DefaultTreeModel(defaultMutableTreeNode);
    }

    public static DefaultMutableTreeNode getConnectionNode(ImportProperties importProperties) {
        String string = (String)importProperties.get(ImportKeys.CONNECTION_NAME);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(ImportResources.getString((String)"CONN"));
        if (string != null) {
            JLabel jLabel = new JLabel();
            String string2 = Connections.getDisplayName(string);
            jLabel.setText(ImportResources.getString((String)"DEST_CONN") + ": " + string2);
            jLabel.setIcon(ExtractResources.getIcon((String)"CONNECTION_ICON"));
            defaultMutableTreeNode = new DefaultMutableTreeNode(jLabel);
            JLabel jLabel2 = new JLabel();
            DBObject dBObject = (DBObject)((Object)importProperties.get(ImportKeys.DBOBJECT));
            jLabel2.setText(ImportResources.getString((String)"TABLE") + ": " + dBObject.getSchemaName() + "." + dBObject.getObjectName());
            jLabel2.setIcon(OracleIcons.getIcon((String)"table.png"));
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(jLabel2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            GenericTable genericTable = (GenericTable)importProperties.get(ImportKeys.TABLE);
            for (Column column : genericTable.getColumns()) {
                JLabel jLabel3 = new JLabel();
                jLabel3.setText(ImportResources.getString((String)"COLUMN") + ": " + column.getName());
                if (column.isEditable()) {
                    jLabel3.setIcon(OracleIcons.getIcon((String)"field.png"));
                } else {
                    jLabel3.setIcon(OracleIcons.getIcon((String)"expression.png"));
                }
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(jLabel3));
            }
        }
        return defaultMutableTreeNode;
    }

    public static DefaultMutableTreeNode getFileNode(ImportProperties importProperties) {
        LoadFile loadFile = (LoadFile)importProperties.get(ImportKeys.LOAD_FILE);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(ImportResources.getString((String)"FILE"));
        if (loadFile != null) {
            JLabel jLabel;
            JLabel jLabel2 = new JLabel();
            boolean bl = importProperties.getValueBoolean(ImportKeys.IS_SOURCE_OSS);
            if (bl) {
                jLabel2.setText(ImportResources.getString((String)"SOURCE_FILE") + ": " + importProperties.get(ImportKeys.OSS_PATH));
            } else {
                jLabel2.setText(ImportResources.getString((String)"SOURCE_FILE") + ": " + loadFile.getName());
            }
            jLabel2.setIcon(OracleIcons.getIcon((String)"filesave.png"));
            defaultMutableTreeNode = new DefaultMutableTreeNode(jLabel2);
            if (bl) {
                jLabel = new JLabel();
                jLabel.setText(DataImportArb.getString("SOURCE_CREDENTIAL") + ": " + importProperties.get(ImportKeys.OSS_CREDENTIAL));
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(jLabel));
            }
            defaultMutableTreeNode.add(ImportSummaryTreeModel.getFileFormatSummaryNode(importProperties));
            jLabel = new JLabel(ImportResources.getString((String)"FIELDS"));
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(jLabel);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            for (LoadField loadField : loadFile.getFields()) {
                JLabel jLabel3 = new JLabel();
                jLabel3.setText(ImportResources.getString((String)"FIELD") + ": " + loadField.getName() + "  " + ImportResources.getString((String)"SIZE") + ": " + loadField.getLength());
                jLabel3.setIcon(OracleIcons.getIcon((String)"field.png"));
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(jLabel3));
            }
        }
        return defaultMutableTreeNode;
    }

    public static DefaultMutableTreeNode getSelectedFields(ImportProperties importProperties) {
        LoadFile loadFile = (LoadFile)importProperties.get(ImportKeys.LOAD_FILE);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(ImportResources.getString((String)"SEL_FIELDS"));
        if (loadFile != null) {
            Column[] columnArray;
            JLabel jLabel = new JLabel();
            jLabel.setText(ImportResources.getString((String)"SEL_FIELDS"));
            jLabel.setIcon(OracleIcons.getIcon((String)"shuttle_right.png"));
            defaultMutableTreeNode = new DefaultMutableTreeNode(jLabel);
            for (Column column : columnArray = (Column[])importProperties.get(ImportKeys.SELECTED_COLUMNS)) {
                JLabel jLabel2 = new JLabel();
                jLabel2.setText(ImportResources.getString((String)"FIELD") + ": " + column.getSourceColumnName() + "  --> " + column.getName());
                jLabel2.setIcon(OracleIcons.getIcon((String)"field.png"));
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(jLabel2));
            }
        }
        return defaultMutableTreeNode;
    }

    public static DefaultMutableTreeNode getSelectableFields(ImportProperties importProperties) {
        LoadFile loadFile = (LoadFile)importProperties.get(ImportKeys.LOAD_FILE);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(ImportResources.getString((String)"NOT_SEL_FIELDS"));
        if (loadFile != null) {
            Column[] columnArray;
            JLabel jLabel = new JLabel();
            jLabel.setText(ImportResources.getString((String)"NOT_SEL_FIELDS"));
            jLabel.setIcon(OracleIcons.getIcon((String)"shuttle_left.png"));
            defaultMutableTreeNode = new DefaultMutableTreeNode(jLabel);
            for (Column column : columnArray = (Column[])importProperties.get(ImportKeys.SELECTABLE_COLUMNS)) {
                JLabel jLabel2 = new JLabel();
                jLabel2.setText(ImportResources.getString((String)"FIELD") + ": " + column.getSourceColumnName());
                jLabel2.setIcon(OracleIcons.getIcon((String)"field.png"));
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(jLabel2));
            }
        }
        return defaultMutableTreeNode;
    }

    public static DefaultMutableTreeNode getFileFormatSummaryNode(ImportProperties importProperties) {
        ImportDataFormat importDataFormat = (ImportDataFormat)importProperties.get(ImportKeys.IMPORT_DATA_FORMAT);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(ImportResources.getString((String)"FILE_PROPERTIES") + ": " + importDataFormat.getFormat() + " format");
        if (importDataFormat.isHeaderOptionSupported()) {
            defaultMutableTreeNode.add(ExtractListModelHelper.getSummaryBooleanItem(ExtractResources.getString((String)"HEADER"), importDataFormat.isHeader()));
        }
        if (importDataFormat.getSkipRows() > 0) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(ImportResources.format((String)"SKIP", (Object[])new Object[]{new Integer(importDataFormat.getSkipRows()).toString()})));
            if (importDataFormat.isHeaderLocationSupported()) {
                if (importDataFormat.isHeaderAfter()) {
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(ImportResources.getString((String)"AFTER_SKIP")));
                } else {
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(ImportResources.getString((String)"BEFORE_SKIP")));
                }
            }
        }
        if (importDataFormat.getOptions().isDelimiterSupported()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(ExtractResources.getString((String)"DELIMITER") + ": " + importDataFormat.getDelimiter()));
        }
        if (importDataFormat.getOptions().isEnclosuresSupported()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(ExtractResources.getString((String)"ENCLOSURE_LEFT") + ": " + importDataFormat.getEnclosureLeft()));
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(ExtractResources.getString((String)"ENCLOSURE_RIGHT") + ": " + importDataFormat.getEnclosureRight()));
        }
        if (importDataFormat.getOptions().isLineTerminatorSupported()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(ExtractResources.getString((String)"RECORD_TERMINATOR") + ": " + importDataFormat.getRecordTerminator()));
        }
        if (importDataFormat.getWorksneet() != null && importDataFormat.getWorksneet().length() > 0) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(ExtractResources.getString((String)"WORKSHEET_NAME") + ": " + importDataFormat.getWorksneet()));
        }
        return defaultMutableTreeNode;
    }

    public static DefaultMutableTreeNode getImportMethodSummaryNode(ImportProperties importProperties) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        DefaultMutableTreeNode defaultMutableTreeNode2;
        boolean bl;
        DefaultMutableTreeNode defaultMutableTreeNode3;
        ImportDataFormat importDataFormat = (ImportDataFormat)importProperties.get(ImportKeys.IMPORT_DATA_FORMAT);
        boolean bl2 = (Boolean)importProperties.get(ImportKeys.IS_EXISTING_TABLE);
        boolean bl3 = (Boolean)importProperties.get(ImportKeys.IS_SOURCE_OSS);
        int n = (Integer)importProperties.get(ImportKeys.LOAD_METHOD);
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(ImportResources.getString((String)"SHOW_LOAD_METHOD") + ": " + ImportDataFormat.getLoadMethodName((int)n));
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(ImportResources.getString((String)"METHOD_OPTIONS"));
        boolean bl4 = (Boolean)importProperties.get(ImportKeys.USE_LOAD_LIMIT);
        DefaultMutableTreeNode defaultMutableTreeNode6 = ExtractListModelHelper.getSummaryBooleanItem(ImportResources.getString((String)"LIMIT_ROWS"), bl4);
        defaultMutableTreeNode5.add(defaultMutableTreeNode6);
        if (bl4) {
            defaultMutableTreeNode6.add(new DefaultMutableTreeNode(ImportResources.getString((String)"SHOW_LOAD_LIMIT") + " " + ((Integer)importProperties.get(ImportKeys.LOAD_LIMIT)).toString()));
        }
        if (!bl2 && importProperties.get(ImportKeys.SEND_TO_WORKSHEET) != null) {
            defaultMutableTreeNode5.add(ExtractListModelHelper.getSummaryBooleanItem(ImportResources.getString((String)"METHOD_SEND_TO_WORKSHEET"), (Boolean)importProperties.get(ImportKeys.SEND_TO_WORKSHEET)));
        }
        if (n == 3) {
            defaultMutableTreeNode5.add(new DefaultMutableTreeNode(ImportResources.getString((String)"STAGING_TABLE_NAME_LABEL") + " " + (String)importProperties.get(ImportKeys.STAGING_TABLE_NAME)));
            defaultMutableTreeNode5.add(ExtractListModelHelper.getSummaryBooleanItem(StringUtils.stripMnemonic((String)ImportResources.getString((String)"METHOD_DROP_STAGING")), (Boolean)importProperties.get(ImportKeys.DROP_STAGING_TABLE)));
        }
        defaultMutableTreeNode4.add(defaultMutableTreeNode5);
        boolean bl5 = (Boolean)importProperties.get(ImportKeys.IS_DWCS);
        if (!(bl5 || n != 3 && n != 2)) {
            defaultMutableTreeNode3 = new DefaultMutableTreeNode(ImportResources.getString((String)"EXTERNAL_TABLE_OPTIONS"));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(ImportResources.getString((String)"SERVER_SIDE_PATH") + " " + (String)importProperties.get(ImportKeys.DIRPATH)));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(ImportResources.getString((String)"ORACLE_DIRECTORY_NAME") + " " + (String)importProperties.get(ImportKeys.ORADIRNAME)));
            bl = (Boolean)importProperties.get(ImportKeys.USELOGFILE);
            defaultMutableTreeNode2 = ExtractListModelHelper.getSummaryBooleanItem(ImportResources.getString((String)"USE_LOG"), bl);
            defaultMutableTreeNode3.add(defaultMutableTreeNode2);
            if (bl) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(ImportResources.getString((String)"ORACLE_DIRECTORY_NAME") + " " + (String)importProperties.get(ImportKeys.ORALOGDIRNAME)));
            }
            bl = (Boolean)importProperties.get(ImportKeys.USEBADFILE);
            defaultMutableTreeNode = ExtractListModelHelper.getSummaryBooleanItem(ImportResources.getString((String)"USE_BAD"), bl);
            defaultMutableTreeNode3.add(defaultMutableTreeNode);
            if (bl) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(ImportResources.getString((String)"ORACLE_DIRECTORY_NAME") + " " + (String)importProperties.get(ImportKeys.ORABADDIRNAME)));
            }
            bl = (Boolean)importProperties.get(ImportKeys.USEDISCARDFILE);
            DefaultMutableTreeNode defaultMutableTreeNode7 = ExtractListModelHelper.getSummaryBooleanItem(ImportResources.getString((String)"USE_DISCARD"), bl);
            defaultMutableTreeNode3.add(defaultMutableTreeNode7);
            if (bl) {
                defaultMutableTreeNode7.add(new DefaultMutableTreeNode(ImportResources.getString((String)"ORACLE_DIRECTORY_NAME") + " " + (String)importProperties.get(ImportKeys.ORADISCARDDIRNAME)));
            }
            defaultMutableTreeNode4.add(defaultMutableTreeNode3);
        } else if (n == 4 && !importProperties.getValueBoolean(ImportKeys.IS_CART).booleanValue()) {
            defaultMutableTreeNode3 = new DefaultMutableTreeNode(ImportResources.getString((String)"SQLLDR_OPTIONS"));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(ImportResources.getString((String)"LOG_FILE_DIR") + " " + (String)importProperties.get(ImportKeys.LOGDIRNAME)));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(ImportResources.getString((String)"BAD_FILE_DIR") + " " + (String)importProperties.get(ImportKeys.BADDIRNAME)));
            bl = (Boolean)importProperties.get(ImportKeys.USEGENDIR) == false;
            defaultMutableTreeNode2 = ExtractListModelHelper.getSummaryBooleanItem(ImportResources.getString((String)"SAVE_IN_IMPORT"), bl);
            defaultMutableTreeNode3.add(defaultMutableTreeNode2);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(ImportResources.getString((String)"SAVE_IN_GEN_DIR") + " " + (String)importProperties.get(ImportKeys.GENDIR)));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(ImportResources.getString((String)"GENERATED_FILE_NEWLINE") + " " + (String)importProperties.get(ImportKeys.FILEOUTNEWLINE)));
            defaultMutableTreeNode4.add(defaultMutableTreeNode3);
        }
        if (n == 3 || n == 2 || n == 5 && bl3 || n == 4 && !importProperties.getValueBoolean(ImportKeys.IS_CART).booleanValue()) {
            defaultMutableTreeNode3 = new DefaultMutableTreeNode(ImportResources.getString((String)"GENERIC_OPTIONS"));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(ImportResources.getString((String)"NUMBER_OF_CHARACTERS") + " " + (String)importProperties.get(ImportKeys.CHARNUMCHARACTERS)));
            String string = (String)importProperties.get(ImportKeys.CHARSETVAL);
            boolean bl6 = string != null && string.length() > 0;
            defaultMutableTreeNode = ExtractListModelHelper.getSummaryBooleanItem(ImportResources.getString((String)"GEN_FILE_CHARSET"), bl6);
            defaultMutableTreeNode3.add(defaultMutableTreeNode);
            if (bl6) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(ImportResources.getString((String)"FILE_CHARSET") + ": " + string));
            }
            defaultMutableTreeNode4.add(defaultMutableTreeNode3);
        }
        return defaultMutableTreeNode4;
    }
}

