/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dbdiff.models;

import java.io.StringWriter;
import java.sql.SQLException;
import java.util.HashMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.dbtools.common.ddl.DDLFormat;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.raptor.dbdiff.DBDiffResources;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;
import oracle.jdbc.OracleConnection;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.CMConnection;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorClient;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorException;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorSettings;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Node;

public class DbDiffObject {
    private static XMLAccessorSettings xacImpl;
    private XMLAccessor accessor;
    private ExtractObject extractObject;
    private DDLFormat ddlFormat;
    private boolean isChanged;
    private boolean isAvailable = true;
    private String destConnName;
    private String sourceConnName;
    private String ALTER_LEFT;
    private String ALTER_RIGHT;
    private String CREATE_LEFT;
    private String CREATE_RIGHT;
    private String DROP_DDL;

    public DbDiffObject(ExtractObject extractObject, String string, String string2, DDLFormat dDLFormat) {
        this.extractObject = extractObject;
        this.sourceConnName = string;
        this.destConnName = string2;
        this.ddlFormat = dDLFormat;
    }

    public void initialize() {
        this.loadXML();
        this.loadDDL();
        if (this.accessor != null) {
            this.accessor.releaseXML();
            this.accessor = null;
            xacImpl = null;
        }
    }

    protected static String getXMLFromDoc(XMLDocument xMLDocument) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult streamResult = new StreamResult(new StringWriter());
            DOMSource dOMSource = new DOMSource((Node)xMLDocument);
            transformer.transform(dOMSource, streamResult);
            String string = streamResult.getWriter().toString();
            return string;
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    public String getAlterLeft() {
        return this.ALTER_LEFT;
    }

    public String getAlterRight() {
        return this.ALTER_RIGHT;
    }

    public String getCreateLeft() {
        return this.CREATE_LEFT;
    }

    public String getCreateRight() {
        return this.CREATE_RIGHT;
    }

    public String getDropDDL() {
        return this.DROP_DDL;
    }

    private XMLAccessorSettings getAccessorSettings() {
        if (xacImpl == null) {
            xacImpl = new XMLAccessorSettings();
        }
        xacImpl.setGenerateConstraintIndexes(this.ddlFormat.getGenerateConstraintIndexes());
        xacImpl.setGenerateConstraints(this.ddlFormat.getGenerateConstraints());
        xacImpl.setGeneratePasswordValue(this.ddlFormat.getGeneratePasswordValue());
        xacImpl.setGenerateRefConstraints(this.ddlFormat.getGenerateRefConstraints());
        xacImpl.setGenerateSQLTerminator(this.ddlFormat.getGenerateSQLTerminator());
        xacImpl.setIgnorePhysicalAttributes(this.ddlFormat.getIgnoreSegmentAttributes());
        xacImpl.setIgnoreSegmentAttributes(this.ddlFormat.getIgnoreSegmentAttributes());
        xacImpl.setIgnoreStorage(this.ddlFormat.getIgnoreStorage());
        xacImpl.setIgnoreTableColumnPosition(this.ddlFormat.getIgnoreTableColumnPosition());
        xacImpl.setIgnoreTablespace(this.ddlFormat.getIgnoreTablespace());
        xacImpl.setMatchConstraintsByName(this.ddlFormat.getMatchConstraintsByName());
        xacImpl.setReportConstraintNameDifferences(this.ddlFormat.getReportConstraintNameDifferences());
        xacImpl.setGenerateComments(this.ddlFormat.getGenerateComments());
        xacImpl.setStatistics(this.ddlFormat.getStatistics());
        xacImpl.setIgnorePartitioning(this.ddlFormat.getIgnorePartitioning());
        xacImpl.setIgnoreHighValues(this.ddlFormat.getIgnoreHighValues());
        xacImpl.setLogicalCompare(this.ddlFormat.getLogicalCompare());
        xacImpl.setChangeMode(1);
        if (this.ddlFormat.getGenerateSchema()) {
            xacImpl.setSuppressSchema(false);
        } else {
            xacImpl.setSuppressSchema(true);
        }
        return xacImpl;
    }

    private CMConnection getCmConnection(String string) throws DBException {
        OracleConnection oracleConnection = string.startsWith("IdeConnections%23") ? (OracleConnection)Connections.getInstance().getConnection(string) : (OracleConnection)Connections.getInstance().getConnection("IdeConnections%23" + string);
        return new CMConnection(oracleConnection);
    }

    private XMLDocument getSXml(CMConnection cMConnection, String string, String string2, String string3) throws SQLException, XMLAccessorException {
        XMLAccessor xMLAccessor = null;
        xMLAccessor = XMLAccessor.getXMLAccessorForType((int)XMLAccessor.MDAPITypeToIntType((String)string3), (XMLAccessorClient)this.getAccessorSettings());
        xMLAccessor.initFromDatabase(cMConnection, string, string2, true);
        return xMLAccessor.getDocument();
    }

    private void loadXML() {
        try {
            this.accessor = XMLAccessor.getXMLAccessorForType((int)XMLAccessor.MDAPITypeToIntType((String)this.getObjectType()), (XMLAccessorClient)this.getAccessorSettings());
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            if (this.extractObject.isExistsDest()) {
                this.accessor.initFromDatabase(this.getCmConnection(this.destConnName), this.getDestSchemaName(), this.getObjectName(), true);
                if (this.extractObject.isExistsDest()) {
                    XMLDocument xMLDocument = this.getSXml(this.getCmConnection(this.sourceConnName), this.getSchemaName(), this.getObjectName(), this.getObjectType());
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    if (this.ddlFormat.getIgnoreSchema()) {
                        hashMap.put(this.getSchemaName(), this.getDestSchemaName());
                    }
                    this.isChanged = this.accessor.compareDefinition(xMLDocument, hashMap);
                }
            } else {
                this.accessor.initFromDatabase(this.getCmConnection(this.sourceConnName), this.getSchemaName(), this.getObjectName(), true);
            }
        }
        catch (Exception exception) {
            this.isAvailable = false;
            this.isChanged = true;
        }
    }

    private void loadDDL() {
        if (!this.isAvailable) {
            this.CREATE_LEFT = this.getSourceObject() + "\n" + this.getNotAvailable();
            this.CREATE_RIGHT = this.getDestObject();
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.ddlFormat.getIgnoreSchema()) {
            hashMap.put(this.getSchemaName(), this.getDestSchemaName());
        }
        try {
            this.ALTER_LEFT = this.accessor.getDDLForExecution(4, hashMap);
        }
        catch (XMLAccessorException xMLAccessorException) {
            this.ALTER_LEFT = this.getNotAvailable();
        }
        try {
            this.ALTER_RIGHT = this.accessor.getDDLForExecution(3, hashMap);
        }
        catch (XMLAccessorException xMLAccessorException) {
            this.ALTER_RIGHT = this.getNotAvailable();
        }
        try {
            this.CREATE_LEFT = this.ddlFormat.getGenerateSchema() ? this.accessor.getDDLForExecution(2, hashMap) : this.accessor.getDDLForExecution(2);
        }
        catch (XMLAccessorException xMLAccessorException) {
            this.CREATE_LEFT = this.getNotAvailable();
        }
        try {
            this.CREATE_RIGHT = this.extractObject.isExistsDest() ? (this.ddlFormat.getGenerateSchema() ? this.accessor.getDDLForExecution(1, hashMap) : this.accessor.getDDLForExecution(1)) : "";
        }
        catch (XMLAccessorException xMLAccessorException) {
            this.CREATE_RIGHT = this.getNotAvailable();
        }
        try {
            this.DROP_DDL = this.ddlFormat.getGenerateSchema() ? this.accessor.getDDLForExecution(5, hashMap) : this.accessor.getDDLForExecution(5);
        }
        catch (XMLAccessorException xMLAccessorException) {
            this.DROP_DDL = this.getNotAvailable();
        }
    }

    private String getSourceObject() {
        String string = this.getSchemaName() + "." + this.getObjectName();
        String string2 = this.getSourceConnDisplayName();
        return string2 != null ? DBDiffResources.format("DbDiffObject_object", string, string2) : DBDiffResources.format("DbDiffObject_object2", string);
    }

    private String getDestObject() {
        String string = this.getDestSchemaName() + "." + this.getObjectName();
        String string2 = this.getDestConnDisplayName();
        return string2 != null ? DBDiffResources.format("DbDiffObject_object", string, string2) : DBDiffResources.format("DbDiffObject_object2", string);
    }

    public String getNotAvailable() {
        return DBDiffResources.get("DbDiffObject_unableToCompare") + "\n" + DBDiffResources.get("DbDiffObject_permissions") + "\n" + DBDiffResources.get("DbDiffObject_permissions2");
    }

    public ExtractObject getExtractObject() {
        return this.extractObject;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public BasicDBObject getDbObject() {
        return this.extractObject.getDBObject();
    }

    public String getSourceConnDisplayName() {
        return Connections.getDisplayName(Connections.getInstance().getConnectionName(this.extractObject.getListModel().getSourceConn()));
    }

    public String getDestConnDisplayName() {
        return Connections.getDisplayName(Connections.getInstance().getConnectionName(this.extractObject.getListModel().getDestConn()));
    }

    public String getSchemaName() {
        return this.getDbObject().getSchemaName();
    }

    public String getDestSchemaName() {
        if (this.ddlFormat.getIgnoreSchema()) {
            String string = this.extractObject.getDestConnUser(false);
            return string != null && string.length() > 0 ? string : this.extractObject.getDBObject().getSchemaName();
        }
        return this.extractObject.getDBObject().getSchemaName();
    }

    public String getObjectName() {
        return this.getDbObject().getObjectName();
    }

    public String getObjectType() {
        if (this.getDbObject().getObjectType().equals("PACKAGE")) {
            return "PACKAGE_SPEC";
        }
        if (this.getDbObject().getObjectType().equals("PACKAGE BODY")) {
            return "PACKAGE_BODY";
        }
        if (this.getDbObject().getObjectType().equals("MATERIALIZED VIEW")) {
            return "MATERIALIZED_VIEW";
        }
        if (this.getDbObject().getObjectType().equals("MATERIALIZED VIEW LOG")) {
            return "MATERIALIZED_VIEW_LOG";
        }
        if (this.getDbObject().getObjectType().equals("DATABASE LINK")) {
            return "DB_LINK";
        }
        return this.getDbObject().getObjectType();
    }

    public XMLAccessor getAccessor() {
        return this.accessor;
    }
}

