/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.mimeeditor;

import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.config.ExternalEditorConfig;
import oracle.dbtools.raptor.datatypes.blob.BlobMimeXmlParser;
import oracle.dbtools.raptor.datatypes.blob.IBlobMimeXmlParser;
import oracle.dbtools.raptor.extendedtype.ExtendedType;
import oracle.dbtools.raptor.extendedtype.XMLExtendeType;
import oracle.dbtools.raptor.mimeeditor.MimeEditorArb;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.Log;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class ExternalBlobEditor {
    private static final Logger LOGGER = Logger.getLogger(ExternalBlobEditor.class.getName());
    private int MINIMUM_BYTES = 128;
    private FileOutputStream outputFileOutputStream = null;
    private static String m_localTempFile = null;
    private long m_initialTimeStamp;
    private long m_finalTimeStamp;
    private boolean m_fileModified = false;
    private RaptorTask<Boolean> m_MimeTask;
    private String m_Extension = null;
    private ExtendedType m_ExtendedType = null;
    private boolean m_done = true;
    private boolean m_isOleType = false;
    private int m_oleHeaderLength = 0;
    private String m_oleExtension = "ole";

    public void startExternalBlobEditor(ExtendedType extendedType, RaptorTaskAdapter raptorTaskAdapter) {
        this.startExternalBlobEditorMain(extendedType, raptorTaskAdapter);
    }

    public void startExternalBlobEditorMain(final ExtendedType extendedType, RaptorTaskAdapter raptorTaskAdapter) {
        IRaptorTaskRunMode iRaptorTaskRunMode = IRaptorTaskRunMode.MODAL;
        this.m_MimeTask = new RaptorTask<Boolean>(MessageFormat.format(MimeEditorArb.getString("EXTERNAL_EDITOR_PROGRESS_MSG"), MimeEditorArb.getString("EXTERNAL_EDITOR_PROGRESS_MSG"), "Format"), true, iRaptorTaskRunMode){

            public Boolean doWork() {
                return ExternalBlobEditor.this.startExternalEditor(extendedType);
            }
        };
        this.m_MimeTask.getDescriptor().addListener((IRaptorTaskListener)raptorTaskAdapter);
        RaptorTaskManager.getInstance().addTask(this.m_MimeTask);
    }

    public boolean startExternalEditor(ExtendedType extendedType) {
        URL uRL = null;
        try {
            if (extendedType instanceof XMLExtendeType) {
                int n;
                InputStream inputStream = extendedType.getBinaryStream();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n = inputStream.read()) != -1) {
                    byteArrayOutputStream.write((char)n);
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                uRL = this.displayBlobEditor(byteArrayInputStream);
            } else {
                uRL = this.displayBlobEditor(extendedType.getBinaryStream());
            }
            if (uRL == null) {
                return false;
            }
            extendedType.setLoadFromURL(uRL);
            this.setExtendedType(extendedType);
            this.setProcessCompleted(false);
            return true;
        }
        catch (SQLException sQLException) {
            LOGGER.log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        catch (IOException iOException) {
            if (iOException.getCause() instanceof CancellationException) {
                Log.status((String)MimeEditorArb.getString("EDIT_CANCELLED"));
            }
            LOGGER.log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        return true;
    }

    public URL displayBlobEditor(InputStream inputStream) {
        BlobMimeXmlParser blobMimeXmlParser = null;
        String string = null;
        URL uRL = null;
        try {
            blobMimeXmlParser = new BlobMimeXmlParser(inputStream);
            if (!blobMimeXmlParser.isMimeTypeSupported()) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)MessageFormat.format(MimeEditorArb.getString("NO_EXT_SUPPORT_ERR"), "." + string), (String)MimeEditorArb.getString("NO_EXT_SUPPORT_ERR_TITLE"), null);
                return null;
            }
            string = blobMimeXmlParser.getExtension();
            this.setExtension(string);
            if (string == null) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)MessageFormat.format(MimeEditorArb.getString("NO_EXT_SUPPORT_ERR"), "." + string), (String)MimeEditorArb.getString("NO_EXT_SUPPORT_ERR_TITLE"), null);
                return null;
            }
            if (string.equals(this.m_oleExtension)) {
                this.m_oleHeaderLength = this.findOleFileExtension(inputStream, (IBlobMimeXmlParser)blobMimeXmlParser);
                if (this.m_oleHeaderLength > 0) {
                    this.m_isOleType = true;
                }
            }
            this.createLocalTempFile(inputStream, this.getExtension());
            uRL = this.executeExternalEditor(true);
            return uRL;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            return uRL;
        }
    }

    public URL executeExternalEditor(boolean bl) {
        URL uRL = null;
        String string = null;
        try {
            string = ExternalEditorConfig.getInstance().getCommandLine("." + this.getExtension());
            if (string != null && !string.equals("")) {
                this.execProcess(string, this.getAbsolutePathFileName(), bl);
                if (bl) {
                    uRL = this.saveToStream();
                    if (this.getInitialTimeStamp() != this.getFinalTimeStamp()) {
                        this.setFileModified(true);
                    }
                }
            } else {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)MessageFormat.format(MimeEditorArb.getString("NO_COMMAND_ERR"), "." + this.getExtension()), (String)MimeEditorArb.getString("NO_COMMAND_ERR_TITLE"), null);
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        catch (SQLException sQLException) {
            LOGGER.log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createLocalTempFile(InputStream inputStream, String string) throws IOException {
        File file = File.createTempFile("blob", "." + string);
        this.outputFileOutputStream = new FileOutputStream(file);
        this.setAbsolutePathFileName(file);
        try {
            if (inputStream != null) {
                byte[] byArray = new byte[256];
                int n = 0;
                if (this.m_isOleType) {
                    inputStream.skip(this.m_oleHeaderLength / 2);
                }
                while ((n = inputStream.read(byArray)) != -1) {
                    this.outputFileOutputStream.write(byArray, 0, n);
                }
            }
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
        finally {
            if (this.outputFileOutputStream != null) {
                try {
                    this.outputFileOutputStream.close();
                    this.setInitialTimeStamp(file.lastModified());
                    this.setFinalTimeStamp(file.lastModified());
                }
                catch (IOException iOException) {
                    ExceptionHandler.handleException((Throwable)iOException);
                }
            }
        }
    }

    public URL saveToStream() throws IOException, SQLException {
        try {
            File file = new File(m_localTempFile);
            this.setFinalTimeStamp(file.lastModified());
            return file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.log(Level.WARNING, malformedURLException.getStackTrace()[0].toString(), malformedURLException);
            ExceptionHandler.handleException((Throwable)malformedURLException);
            throw malformedURLException;
        }
    }

    public boolean checkIfSufficentBytesToRead(InputStream inputStream) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = 0;
            if (inputStream != null) {
                byte[] byArray = new byte[2];
                while ((n = inputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
            }
            return byteArrayOutputStream.size() >= this.MINIMUM_BYTES;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            ExceptionHandler.handleException((Throwable)iOException);
            return false;
        }
    }

    public void execProcess(String string, String string2) {
        this.execProcess(string, string2, true);
    }

    public void execProcess(String string, String string2, boolean bl) {
        Process process = null;
        try {
            String[] stringArray = new String[]{string, string2};
            process = Runtime.getRuntime().exec(stringArray);
            if (bl) {
                process.waitFor();
            }
        }
        catch (InterruptedException interruptedException) {
            process.destroy();
        }
        catch (Exception exception) {
            process.destroy();
        }
    }

    private int findOleFileExtension(InputStream inputStream, IBlobMimeXmlParser iBlobMimeXmlParser) {
        boolean bl = false;
        int n = 0;
        String string = null;
        try {
            String string2 = iBlobMimeXmlParser.getOleHexStream(inputStream);
            Map<String, String> map = this.InitializeOleExtension();
            for (String string3 : map.keySet()) {
                string = map.get(string3);
                if (!string2.contains(string)) continue;
                n = string2.indexOf(string);
                this.setExtension(string3);
                break;
            }
        }
        catch (IOException iOException) {
            return n;
        }
        return n;
    }

    public Map<String, String> InitializeOleExtension() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("bmp", "424D");
        hashMap.put("jpg", "FFD8");
        hashMap.put("pdf", "25504446");
        return hashMap;
    }

    public void setAbsolutePathFileName(File file) {
        m_localTempFile = file.getAbsolutePath();
        this.m_Extension = m_localTempFile.substring(m_localTempFile.lastIndexOf(46) + 1);
    }

    public String getAbsolutePathFileName() {
        return m_localTempFile;
    }

    public void setInitialTimeStamp(long l) {
        this.m_initialTimeStamp = l;
    }

    public long getInitialTimeStamp() {
        return this.m_initialTimeStamp;
    }

    public void setFinalTimeStamp(long l) {
        this.m_finalTimeStamp = l;
    }

    public long getFinalTimeStamp() {
        return this.m_finalTimeStamp;
    }

    public void setExtension(String string) {
        this.m_Extension = string;
    }

    public String getExtension() {
        return this.m_Extension;
    }

    public boolean isFileModified() {
        return this.m_fileModified;
    }

    public void setFileModified(boolean bl) {
        this.m_fileModified = bl;
    }

    public void setExtendedType(ExtendedType extendedType) {
        this.m_ExtendedType = extendedType;
    }

    public ExtendedType getExtendedType() {
        return this.m_ExtendedType;
    }

    public boolean getProcessCompleted() {
        return this.m_done;
    }

    public void setProcessCompleted(boolean bl) {
        this.m_done = bl;
    }
}

