/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.navigator.db.BaseConnectionNode;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.OtherSchemasFolder;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DatabaseFeatureRegistry;
import oracle.ide.explorer.IconOverlay;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.model.Element;
import oracle.javatools.db.DBException;
import oracle.javatools.icons.OracleIcons;

public final class DatabaseOverlayClient {
    private static final int OVERLAY_BATCH_SIZE = 10;
    public static final String INFO_TYPE_ID = "jdbcNodeInfoType";
    private static IconOverlayTracker s_tracker;
    private static final Icon debugOverlayIcon;

    public static final IconOverlayTracker getTracker() {
        DatabaseOverlayClient.initializeOverlays();
        return s_tracker;
    }

    private DatabaseOverlayClient() {
    }

    static synchronized void initializeOverlays() {
        if (s_tracker == null) {
            s_tracker = new NodeOverlayTracker();
        }
    }

    public static final void updateOverlay(Element element) {
        IconOverlayTracker iconOverlayTracker = DatabaseOverlayClient.getTracker();
        if (iconOverlayTracker != null) {
            iconOverlayTracker.validateOverlay(element);
            iconOverlayTracker.repaintOverlays();
        }
    }

    private static Icon getDebugOverlay(DatabaseNode databaseNode, Connection connection) {
        if (databaseNode instanceof PlSqlNode) {
            Object object;
            int n = 12;
            try {
                object = (PlSqlNode)databaseNode;
                if (connection != null) {
                    n = connection.getMetaData().getDatabaseMajorVersion();
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            if (n <= 11) {
                object = (String)databaseNode.getProperty("PLSQL_DEBUG");
                if (Boolean.parseBoolean((String)object)) {
                    return debugOverlayIcon;
                }
            } else {
                object = databaseNode.getProperty("PLSQL_OPTIMIZE_LEVEL");
                if (object instanceof BigDecimal && ((BigDecimal)object).intValue() <= 1) {
                    return debugOverlayIcon;
                }
                if (object instanceof Integer && (Integer)object <= 1) {
                    return debugOverlayIcon;
                }
                if (object instanceof String && Integer.parseInt((String)object) <= 1) {
                    return debugOverlayIcon;
                }
            }
        }
        return null;
    }

    public static Icon getDebugOverlay(DatabaseNode databaseNode) {
        String string;
        if (databaseNode instanceof PlSqlNode && Boolean.parseBoolean(string = (String)databaseNode.getProperty("PLSQL_DEBUG"))) {
            return debugOverlayIcon;
        }
        return null;
    }

    static {
        debugOverlayIcon = RaptorImagesArb.getIcon("BUG_OVERLAY");
    }

    private static final class NodeOverlayTracker
    extends IconOverlayTracker {
        private static final IconOverlay INVALID_OVERLAY_INFORMATION = new IconOverlay(RaptorImagesArb.getIcon("INVALID"), null, null);
        private static final IconOverlay CONNECTED_OVERLAY_INFORMATION = new IconOverlay(RaptorImagesArb.getIcon("PLUG_OVERLAY"), null, null);
        private static final IconOverlay SHARDED_USER_OVERLAY_INFORMATION = new IconOverlay(RaptorImagesArb.getIcon("SHARDED_CONNECTION_OVERLAY"), null, null);
        private static final IconOverlay FILTER_OVERLAY_INFORMATION = new IconOverlay(OracleIcons.getIcon((String)"overlay/filter.png"), null, null);
        private static final IconOverlay PUB_SYN_OVERLAY_INFORMATION = new IconOverlay(OracleIcons.getIcon((String)"publicsynonym.png"), null, null);
        private static final IconOverlay PLSQL_DEBUG_INFORMATION = new IconOverlay(debugOverlayIcon, null, null);

        private NodeOverlayTracker() {
            super(DatabaseOverlayClient.INFO_TYPE_ID, IconOverlayCache.getInstance(), 10);
        }

        protected boolean isControlled(Element element) {
            return element instanceof DatabaseConnection || element instanceof DatabaseNode || element instanceof ObjectFolder || element instanceof OtherSchemasFolder;
        }

        protected IconOverlay[] getOverlays(Element[] elementArray) {
            ArrayList<IconOverlay> arrayList = new ArrayList<IconOverlay>(elementArray.length);
            Connection connection = null;
            for (int i = 0; i < elementArray.length; ++i) {
                Object object;
                Object object2;
                Element element = elementArray[i];
                IconOverlay iconOverlay = null;
                if (element instanceof DatabaseNode) {
                    object2 = (DatabaseNode)element;
                    object = (String)object2.getProperty("INVALID");
                    if (Boolean.parseBoolean((String)object)) {
                        iconOverlay = INVALID_OVERLAY_INFORMATION;
                    } else if ("SYNONYM".equals(object2.getProperty("TYPE")) && "PUBLIC".equals(object2.getProperty("SCHEMA"))) {
                        iconOverlay = PUB_SYN_OVERLAY_INFORMATION;
                    }
                    if (connection == null && object2 instanceof PlSqlNode) {
                        try {
                            connection = Connections.getInstance().getConnection(((PlSqlNode)object2).getConnectionName());
                        }
                        catch (DBException dBException) {
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
                        }
                    }
                    if (iconOverlay == null && connection != null && debugOverlayIcon == DatabaseOverlayClient.getDebugOverlay((DatabaseNode)object2, connection)) {
                        iconOverlay = PLSQL_DEBUG_INFORMATION;
                    }
                } else if (element instanceof DatabaseConnection) {
                    object2 = (DatabaseConnection)element;
                    if (((BaseConnectionNode)object2).isConnectionOpen()) {
                        iconOverlay = CONNECTED_OVERLAY_INFORMATION;
                        try {
                            ConnectionIdentifier connectionIdentifier;
                            object = (Connection)((BaseConnectionNode)object2).getConnection();
                            if (Connections.getInstance().isOracle((Connection)object) && DatabaseFeatureRegistry.isFeatureEnabled((ConnectionIdentifier)(connectionIdentifier = DefaultConnectionIdentifier.createIdentifier((Connection)object)), (String)"sharded_user")) {
                                iconOverlay = SHARDED_USER_OVERLAY_INFORMATION;
                            }
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                } else if (element instanceof ObjectFolder) {
                    object2 = ((ObjectFolder)element).getFolderInstance();
                    if (object2 != null && object2.isFiltered()) {
                        iconOverlay = FILTER_OVERLAY_INFORMATION;
                    }
                } else if (element instanceof OtherSchemasFolder && (object2 = ((OtherSchemasFolder)element).getDBSchemasInstance()) != null && object2.isFiltered()) {
                    iconOverlay = FILTER_OVERLAY_INFORMATION;
                }
                arrayList.add(iconOverlay);
            }
            return arrayList.toArray(new IconOverlay[0]);
        }
    }
}

