/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.runner.debug;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.ewt.spinBox.SpinBuddy;
import oracle.dbtools.raptor.runner.RunnerArb;
import oracle.dbtools.raptor.runner.debug.DebuggerSettings;
import oracle.ide.controls.CustomColorChoice;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.runner.debug.DbgArb;

public class DebuggerSettingsPanel
extends DefaultTraversablePanel
implements ItemListener {
    private JCheckBox toolTipCheckBox;
    private JCheckBox toolbarCheckBox;
    private JLabel connectionRetriesLabel;
    private NumericSpinBox connectionRetriesBox;
    private JCheckBox promptHostDatabaseCheckBox;
    private JCheckBox detectMethodEvalDeadlocksCheckBox;
    private JCheckBox localPortRangeCheckBox;
    private JLabel localPortRangeMinLabel;
    private NumericSpinBox localPortRangeMinBox;
    private JLabel localPortRangeMaxLabel;
    private NumericSpinBox localPortRangeMaxBox;
    private JRadioButton startRunningRadio;
    private JRadioButton startStepOverRadio;
    private JRadioButton startStepIntoRadio;
    private JCheckBox enableChangeTrackingCheckbox;
    private CustomColorChoice changedCellForegroundColorChoice;
    private CustomColorChoice changedCellBackgroundColorChoice;
    private JRadioButton useJDWPRadio;
    private JRadioButton useProbeRadio;

    public DebuggerSettingsPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_pref_debug_html");
        this.toolTipCheckBox = new JCheckBox();
        this.toolbarCheckBox = new JCheckBox();
        this.connectionRetriesLabel = new JLabel();
        this.connectionRetriesBox = new NumericSpinBox(0, 1000);
        this.promptHostDatabaseCheckBox = new JCheckBox();
        this.detectMethodEvalDeadlocksCheckBox = new JCheckBox();
        this.localPortRangeCheckBox = new JCheckBox();
        this.localPortRangeMinLabel = new JLabel();
        this.localPortRangeMinBox = new NumericSpinBox(0, 65535);
        this.localPortRangeMaxLabel = new JLabel();
        this.localPortRangeMaxBox = new NumericSpinBox(0, 65535);
        this.startRunningRadio = new JRadioButton();
        this.startStepOverRadio = new JRadioButton();
        this.startStepIntoRadio = new JRadioButton();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.startRunningRadio);
        buttonGroup.add(this.startStepOverRadio);
        buttonGroup.add(this.startStepIntoRadio);
        this.enableChangeTrackingCheckbox = new JCheckBox();
        this.changedCellForegroundColorChoice = new CustomColorChoice();
        this.changedCellBackgroundColorChoice = new CustomColorChoice();
        this.useJDWPRadio = new JRadioButton();
        this.useProbeRadio = new JRadioButton();
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.useJDWPRadio);
        buttonGroup.add(this.useProbeRadio);
        ResourceUtils.resButton((AbstractButton)this.toolTipCheckBox, (String)DbgArb.getString((int)630));
        ResourceUtils.resButton((AbstractButton)this.toolbarCheckBox, (String)DbgArb.getString((int)631));
        ResourceUtils.resLabel((JLabel)this.connectionRetriesLabel, (Component)this.connectionRetriesBox, (String)DbgArb.getString((int)632));
        ResourceUtils.resButton((AbstractButton)this.promptHostDatabaseCheckBox, (String)DbgArb.getString((int)633));
        ResourceUtils.resButton((AbstractButton)this.detectMethodEvalDeadlocksCheckBox, (String)DbgArb.getString((int)850));
        ResourceUtils.resButton((AbstractButton)this.localPortRangeCheckBox, (String)DbgArb.getString((int)634));
        ResourceUtils.resLabel((JLabel)this.localPortRangeMinLabel, (Component)this.localPortRangeMinBox, (String)DbgArb.getString((int)635));
        ResourceUtils.resLabel((JLabel)this.localPortRangeMaxLabel, (Component)this.localPortRangeMaxBox, (String)DbgArb.getString((int)636));
        ResourceUtils.resButton((AbstractButton)this.startRunningRadio, (String)DbgArb.getString((int)317));
        ResourceUtils.resButton((AbstractButton)this.startStepOverRadio, (String)DbgArb.getString((int)318));
        ResourceUtils.resButton((AbstractButton)this.startStepIntoRadio, (String)DbgArb.getString((int)319));
        ResourceUtils.resButton((AbstractButton)this.enableChangeTrackingCheckbox, (String)DbgArb.getString((int)638));
        ResourceUtils.resButton((AbstractButton)this.changedCellForegroundColorChoice, (String)DbgArb.getString((int)639));
        ResourceUtils.resButton((AbstractButton)this.changedCellBackgroundColorChoice, (String)DbgArb.getString((int)640));
        ResourceUtils.resButton((AbstractButton)this.useJDWPRadio, (String)RunnerArb.getString("CHOICE_JDWP_PROTOCOL"));
        ResourceUtils.resButton((AbstractButton)this.useProbeRadio, (String)RunnerArb.getString("CHOICE_PROBE_PROTOCOL"));
        this.localPortRangeCheckBox.addItemListener(this);
        this.useJDWPRadio.addItemListener(this);
        this.useProbeRadio.addItemListener(this);
        this.setSpinBuddyAlignment(this.connectionRetriesBox);
        this.setSpinBuddyAlignment(this.localPortRangeMinBox);
        this.setSpinBuddyAlignment(this.localPortRangeMaxBox);
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.add(this.toolTipCheckBox, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.toolbarCheckBox, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.makeConnectionRetriesPanel(), new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.makeProtocolSelectionPanel(), new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.add(this.makeStartPanel(), new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.add(this.makeChangeTrackingPanel(), new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.add(new JLabel(), new GridBagConstraints(0, n, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void setSpinBuddyAlignment(NumericSpinBox numericSpinBox) {
        SpinBuddy spinBuddy = numericSpinBox.getSpinBuddy();
        if (spinBuddy instanceof JTextField) {
            ((JTextField)spinBuddy).setHorizontalAlignment(4);
        }
    }

    private JPanel makeConnectionRetriesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.connectionRetriesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.connectionRetriesBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel makeProtocolSelectionPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(RunnerArb.getString("LABEL_DEBUG_PROTOCOL"));
        int n = 0;
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        jPanel.add((Component)this.useJDWPRadio, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 25, 5, 0), 0, 0));
        jPanel.add((Component)this.makeJDWPOptionsPanel(), new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 50, 5, 0), 0, 0));
        jPanel.add((Component)this.useProbeRadio, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 25, 5, 0), 0, 0));
        return jPanel;
    }

    private JPanel makeJDWPOptionsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = 0;
        jPanel.add((Component)this.promptHostDatabaseCheckBox, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 2, 5), 0, 0));
        jPanel.add((Component)this.detectMethodEvalDeadlocksCheckBox, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 2, 5), 0, 0));
        jPanel.add((Component)this.makeLocalPortRangePanel(), new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        return jPanel;
    }

    private JPanel makeLocalPortRangePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = 0;
        jPanel.add((Component)this.localPortRangeCheckBox, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.localPortRangeMinLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 25, 0, 0), 0, 0));
        jPanel.add((Component)this.localPortRangeMinBox, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
        jPanel.add((Component)this.localPortRangeMaxLabel, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 10, 0, 0), 0, 0));
        jPanel.add((Component)this.localPortRangeMaxBox, new GridBagConstraints(3, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel makeStartPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(DbgArb.getString((int)316));
        int n = 0;
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        jPanel.add((Component)this.startRunningRadio, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 2, 0), 0, 0));
        jPanel.add((Component)this.startStepOverRadio, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 2, 0), 0, 0));
        jPanel.add((Component)this.startStepIntoRadio, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 2, 0), 0, 0));
        jPanel.add((Component)new JLabel(), new GridBagConstraints(0, n, 0, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel makeChangeTrackingPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = 0;
        jPanel.add((Component)this.enableChangeTrackingCheckbox, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        jPanel.add((Component)this.changedCellForegroundColorChoice, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 2, 0), 0, 0));
        jPanel.add((Component)this.changedCellBackgroundColorChoice, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 2, 0), 0, 0));
        jPanel.add((Component)new JLabel(), new GridBagConstraints(0, n, 0, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private void enableLocalPortRange() {
        boolean bl = this.localPortRangeCheckBox.isSelected() && this.useJDWPRadio.isSelected();
        this.localPortRangeMinLabel.setEnabled(bl);
        this.localPortRangeMinBox.setEnabled(bl);
        this.localPortRangeMaxLabel.setEnabled(bl);
        this.localPortRangeMaxBox.setEnabled(bl);
    }

    private void enableJdwpProtocolOptions() {
        boolean bl = this.useJDWPRadio.isSelected();
        this.promptHostDatabaseCheckBox.setEnabled(bl);
        this.detectMethodEvalDeadlocksCheckBox.setEnabled(bl);
        this.localPortRangeCheckBox.setEnabled(bl);
        this.enableLocalPortRange();
    }

    private DebuggerSettings getSettings(TraversableContext traversableContext) {
        return DebuggerSettings.getInstance(traversableContext.getPropertyStorage());
    }

    public void onEntry(TraversableContext traversableContext) {
        DebuggerSettings debuggerSettings = this.getSettings(traversableContext);
        DebuggerSettings.Protocol protocol = debuggerSettings.getDatabaseDebugProtocol();
        if (protocol == DebuggerSettings.Protocol.DBMS_DEBUG) {
            this.useProbeRadio.setSelected(true);
        } else {
            this.useJDWPRadio.setSelected(true);
        }
        this.toolTipCheckBox.setSelected(debuggerSettings.isShowToolTipInCodeEditor());
        this.toolbarCheckBox.setSelected(debuggerSettings.isShowActionButtonsOnToolbar());
        this.connectionRetriesBox.setIntValue(debuggerSettings.getConnectionRetries());
        this.promptHostDatabaseCheckBox.setSelected(debuggerSettings.isPromptForDebuggerHostForDatabaseDebugging());
        this.detectMethodEvalDeadlocksCheckBox.setSelected(debuggerSettings.isDetectMethodEvalDeadlocks());
        this.localPortRangeCheckBox.setSelected(debuggerSettings.isLocalPortRange());
        this.localPortRangeMinBox.setIntValue(debuggerSettings.getLocalPortRangeMin());
        this.localPortRangeMaxBox.setIntValue(debuggerSettings.getLocalPortRangeMax());
        this.enableLocalPortRange();
        this.startRunningRadio.setSelected(false);
        this.startStepOverRadio.setSelected(false);
        this.startStepIntoRadio.setSelected(false);
        String string = debuggerSettings.getStartOption();
        if (string.equals("stepover")) {
            this.startStepOverRadio.setSelected(true);
        } else if (string.equals("stepinto")) {
            this.startStepIntoRadio.setSelected(true);
        } else {
            this.startRunningRadio.setSelected(true);
        }
        this.enableChangeTrackingCheckbox.setSelected(debuggerSettings.isChangeTrackingEnabled());
        this.changedCellForegroundColorChoice.setClosestSelectedColor(debuggerSettings.getChangedCellForegroundColor());
        this.changedCellBackgroundColorChoice.setClosestSelectedColor(debuggerSettings.getChangedCellBackgroundColor());
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (this.localPortRangeCheckBox.isSelected() && this.localPortRangeMinBox.getIntValue() > this.localPortRangeMaxBox.getIntValue()) {
            throw new TraversalException(DbgArb.getString((int)637));
        }
        DebuggerSettings debuggerSettings = this.getSettings(traversableContext);
        debuggerSettings.setDatabaseDebugProtocol(this.useProbeRadio.isSelected() ? DebuggerSettings.Protocol.DBMS_DEBUG : DebuggerSettings.Protocol.DBMS_DEBUG_JDWP);
        debuggerSettings.setShowToolTipInCodeEditor(this.toolTipCheckBox.isSelected());
        debuggerSettings.resetToStringBehavior();
        debuggerSettings.setShowActionButtonsOnToolbar(this.toolbarCheckBox.isSelected());
        debuggerSettings.setConnectionRetries(this.connectionRetriesBox.getIntValue());
        debuggerSettings.setPromptForDebuggerHostForDatabaseDebugging(this.promptHostDatabaseCheckBox.isSelected());
        debuggerSettings.setDetectMethodEvalDeadlocks(this.detectMethodEvalDeadlocksCheckBox.isSelected());
        debuggerSettings.setLocalPortRange(this.localPortRangeCheckBox.isSelected());
        debuggerSettings.setLocalPortRangeMin(this.localPortRangeMinBox.getIntValue());
        debuggerSettings.setLocalPortRangeMax(this.localPortRangeMaxBox.getIntValue());
        String string = this.startStepOverRadio.isSelected() ? "stepover" : (this.startStepIntoRadio.isSelected() ? "stepinto" : "running");
        debuggerSettings.setStartOption(string);
        debuggerSettings.setChangeTrackingEnabled(this.enableChangeTrackingCheckbox.isSelected());
        debuggerSettings.setChangedCellBackgroundColor(this.changedCellBackgroundColorChoice.getSelectedColor());
        debuggerSettings.setChangedCellForegroundColor(this.changedCellForegroundColorChoice.getSelectedColor());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.localPortRangeCheckBox) {
            this.enableLocalPortRange();
        } else if (object == this.useJDWPRadio || object == this.useProbeRadio) {
            this.enableJdwpProtocolOptions();
        }
    }
}

