/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui.controls;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;

public class OptionalActionControl
extends ActionControl
implements LayoutControl {
    protected ActionControl optionalControl;
    protected BooleanCheckBoxActionControl booleanControl;
    protected ArrayList<ActionControl> childControls;
    protected JPanel ui;
    protected CardLayout cardLayout;
    protected JPanel cardPanel;
    protected OptionalType optionalType;
    protected boolean defaultValue;

    public OptionalActionControl(String string, String string2, OptionalType optionalType, boolean bl, ActionControl actionControl) {
        super(string, string2);
        this.optionalType = optionalType;
        this.childControls = new ArrayList();
        this.optionalControl = actionControl;
        this.booleanControl = new BooleanCheckBoxActionControl(null, null, bl);
        this.childControls.add(this.optionalControl);
        this.childControls.add(this.booleanControl);
        this.ui = this.createUI();
        boolean bl2 = this.optionalControl.isUIEnabled();
        if (!bl2) {
            this.booleanControl.enableUI(false);
        } else {
            this.enableUI(this.booleanControl.getValue());
        }
        this.booleanControl.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ActionControl.Value value = (ActionControl.Value)propertyChangeEvent.getNewValue();
                OptionalActionControl.this.enableUI(value);
                OptionalActionControl.this.firePropertyChangeListeners();
            }
        });
        this.optionalControl.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                OptionalActionControl.this.firePropertyChangeListeners();
            }
        });
    }

    public OptionalActionControl(OptionalType optionalType, boolean bl, ActionControl actionControl) {
        this(actionControl.getName(), actionControl.getPrompt(), optionalType, bl, actionControl);
    }

    public OptionalActionControl(boolean bl, ActionControl actionControl) {
        this(actionControl.getName(), actionControl.getPrompt(), OptionalType.NULL, bl, actionControl);
    }

    protected boolean isOptional(ActionControl.Value value) {
        return !Boolean.parseBoolean(value.get());
    }

    @Override
    public ActionControl.Value getValue() {
        if (this.isOptional(this.booleanControl.getValue())) {
            return null;
        }
        return this.optionalControl.getValue();
    }

    @Override
    public void setEditable(boolean bl) {
        this.booleanControl.setEditable(bl);
        this.optionalControl.setEditable(bl);
    }

    public void setEditable(ActionControl.Value value) {
        boolean bl = !this.isOptional(value);
        this.optionalControl.setEditable(bl);
    }

    public JPanel createUI() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.cardLayout = new CardLayout(0, 0);
        this.cardPanel = new JPanel(this.cardLayout);
        this.cardPanel.add(this.optionalControl.getUI(), Show.CONTROL.toString());
        JLabel jLabel = new JLabel(DBConfig.getInstance().getString("NULLDISPLAY"));
        this.cardPanel.add((Component)jLabel, Show.LABEL.toString());
        jPanel.add((Component)this.cardPanel, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        jPanel.add(this.booleanControl.getUI(), LayoutControl.GBC.gbc(1, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2BUTTON_COMP, LayoutControl.GBC.Fill.NONE));
        return jPanel;
    }

    @Override
    public Component getUI() {
        return this.ui;
    }

    @Override
    public void reset() {
        this.optionalControl.reset();
        this.booleanControl.reset();
    }

    @Override
    public void enableUI(boolean bl) {
        this.booleanControl.enableUI(bl);
        this.enableUI(this.booleanControl.getValue());
    }

    public void enableUI(ActionControl.Value value) {
        boolean bl = this.isUIEnabled() && !this.isOptional(value);
        this.optionalControl.enableUI(bl);
        this.cardLayout.show(this.cardPanel, bl ? Show.CONTROL.toString() : Show.LABEL.toString());
        this.booleanControl.setToolTipText(this.optionalType.getSelectionTooltip(bl));
    }

    @Override
    public boolean isUIEnabled() {
        return this.booleanControl.isUIEnabled();
    }

    public void set(boolean bl) {
        this.booleanControl.set(bl);
    }

    @Override
    public List<ActionControl> getChildControls() {
        return this.childControls;
    }

    public ActionControl getOptionalControl() {
        return this.optionalControl;
    }

    public BooleanCheckBoxActionControl getBooleanActionControl() {
        return this.booleanControl;
    }

    private static enum ColorMap {
        WHITE(Color.WHITE),
        LIGHT_GRAY(Color.LIGHT_GRAY),
        GRAY(Color.GRAY),
        DARK_GRAY(Color.DARK_GRAY),
        BLACK(Color.BLACK),
        RED(Color.RED),
        PINK(Color.PINK),
        ORANGE(Color.ORANGE),
        YELLOW(Color.YELLOW),
        GREEN(Color.GREEN),
        MAGENTA(Color.MAGENTA),
        CYAN(Color.CYAN),
        BLUE(Color.BLUE);

        private Color color;

        private ColorMap(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }
    }

    protected static enum Show {
        CONTROL,
        LABEL;

    }

    public static enum OptionalType {
        NULL,
        DEFAULT;


        public String toString() {
            switch (this) {
                case DEFAULT: {
                    return UiResources.getString("USE_DEFAULT_LABEL");
                }
            }
            return DBConfig.getInstance().getString("NULLDISPLAY");
        }

        public String getSelectionTooltip(boolean bl) {
            if (bl) {
                switch (this) {
                    case DEFAULT: {
                        return UiResources.getString("USE_DEFAULT_DESELECT_TOOLTIP");
                    }
                }
                return UiResources.getString("NULL_DESELECT_TOOLTIP");
            }
            switch (this) {
                case DEFAULT: {
                    return UiResources.getString("USE_DEFAULT_SELECT_TOOLTIP");
                }
            }
            return UiResources.getString("NULL_SELECT_TOOLTIP");
        }
    }
}

