/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v12;

import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import oracle.security.xmlsec.dsig.SigningException;
import oracle.security.xmlsec.dsig.VerifyException;
import oracle.security.xmlsec.liberty.v12.LibDSigUtils;
import oracle.security.xmlsec.liberty.v12.LibertyInitializer;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.samlp.Status;
import oracle.security.xmlsec.samlp.StatusCode;
import oracle.security.xmlsec.util.Base64;
import oracle.security.xmlsec.util.URIManager;

public class LibQueryUtils {
    public static Properties parseQueryString(String queryString) throws MalformedURLException {
        Properties props = new Properties();
        StringTokenizer st = new StringTokenizer(queryString, "&");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int eqIndex = token.indexOf(61);
            if (eqIndex < 0) {
                throw new MalformedURLException("Malformed query string: " + queryString);
            }
            String key = token.substring(0, eqIndex);
            String val = null;
            if (eqIndex < token.length() - 1) {
                try {
                    val = URLDecoder.decode(token.substring(eqIndex + 1, token.length()));
                }
                catch (Exception ex) {
                    throw new MalformedURLException(ex.toString());
                }
            }
            if (val == null) continue;
            props.setProperty(key, val);
        }
        return props;
    }

    public static List parseMultiValueParam(String param) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(param, " ");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list;
    }

    public static String urlEncodeMultiValueParam(List values) {
        StringBuffer buf = new StringBuffer();
        int n = values.size();
        for (int i = 0; i < n; ++i) {
            buf.append((String)values.get(i));
            if (i == n - 1) continue;
            buf.append(" ");
        }
        return URLEncoder.encode(buf.toString());
    }

    public static List getStatusCodeValues(Status s) {
        ArrayList<String> values = new ArrayList<String>();
        for (StatusCode sc = s.getStatusCode(); sc != null; sc = sc.getStatusCode()) {
            String val = sc.getValue();
            if (val == null) continue;
            values.add(val);
        }
        return values;
    }

    public static String signQueryString(String queryString, PrivateKey privKey) throws SigningException {
        if (queryString == null || queryString.length() == 0) {
            throw new SigningException("Nothing to sign");
        }
        StringBuffer sb = new StringBuffer(queryString);
        String sigAlgURI = null;
        String keyAlg = privKey.getAlgorithm();
        sb.append('&');
        sb.append("SigAlg");
        sb.append('=');
        if ("RSA".equals(keyAlg)) {
            sigAlgURI = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            sb.append(URLEncoder.encode(sigAlgURI));
        } else if ("DSA".equals(keyAlg)) {
            sigAlgURI = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
            sb.append(URLEncoder.encode(sigAlgURI));
        } else {
            throw new SigningException("Signing not supported for key algorithm '" + keyAlg + "'");
        }
        String sigValue = LibDSigUtils.signURL(sb.toString(), privKey, sigAlgURI);
        sb.append('&');
        sb.append("Signature");
        sb.append('=');
        sb.append(sigValue);
        return sb.toString();
    }

    public static boolean verifyQueryStringSignature(String queryString, PublicKey pubKey) throws VerifyException {
        try {
            String sigName = "&Signature=";
            int sigIndex = queryString.indexOf(sigName);
            if (sigIndex < 0) {
                throw new VerifyException("Signature not found in query string");
            }
            byte[] sigBytes = Base64.fromBase64((String)URLDecoder.decode(queryString.substring(sigIndex + sigName.length())));
            String sigAlgName = "&SigAlg=";
            int algIndex = queryString.indexOf(sigAlgName);
            if (algIndex < 0) {
                throw new VerifyException("SigAlg not found in query string");
            }
            String sigAlgURI = URLDecoder.decode(queryString.substring(algIndex + sigAlgName.length(), sigIndex));
            String jceAlg = URIManager.getURIManager().getJCEAlgorithm(sigAlgURI);
            if (jceAlg == null) {
                throw new NoSuchAlgorithmException("Unknown signature algorithm " + sigAlgURI);
            }
            byte[] docBytes = queryString.substring(0, sigIndex).getBytes("UTF8");
            Signature sig = Signature.getInstance(jceAlg);
            sig.initVerify(pubKey);
            sig.update(docBytes);
            return sig.verify(sigBytes);
        }
        catch (Exception ex) {
            throw new VerifyException(ex.toString());
        }
    }

    private LibQueryUtils() {
    }

    static {
        SAMLInitializer.initialize((int)1, (int)1);
        LibertyInitializer.initialize();
    }
}

