/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.svg.batik;

import ice.debug.Debug;
import ice.storm.ContentLoader;
import ice.storm.Pilot;
import java.awt.Component;
import java.awt.Cursor;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.swing.svg.SVGDocumentLoaderAdapter;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderListener;

public class ThePilot
extends Pilot {
    private static final Cursor WAIT_CURSOR = new Cursor(3);
    private static final Cursor NORMAL_CURSOR = new Cursor(0);
    protected JSVGCanvas svgCanvas;
    protected String currLocation;

    private static final void testForBatik() throws RuntimeException {
        String className = "org.apache.batik.swing.JSVGCanvas";
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            String msg = "Required class '" + className + "' not found. Required Batik SVG library jars may not be on the classpath - SVG Pilot disabled.";
            Debug.trace(msg);
            throw new RuntimeException(msg);
        }
    }

    public void init(String toolkitName) {
        super.init(toolkitName);
        this.svgCanvas = new JSVGCanvas();
        this.svgCanvas.addSVGDocumentLoaderListener((SVGDocumentLoaderListener)new SVGDocumentLoaderAdapter(){

            public void documentLoadingStarted(SVGDocumentLoaderEvent event) {
                ThePilot.this.firePropertyChange("statusLine", null, "Opening diagram " + ThePilot.this.currLocation + "...");
                ThePilot.this.setCursor(WAIT_CURSOR);
            }

            public void documentLoadingCompleted(SVGDocumentLoaderEvent e) {
                ThePilot.this.firePropertyChange("contentLoading", null, "end");
                String title = e.getSVGDocument().getTitle();
                if (title != null && !title.equals("")) {
                    ThePilot.this.firePropertyChange("title", null, e.getSVGDocument().getTitle());
                }
            }

            public void documentLoadingCancelled(SVGDocumentLoaderEvent event) {
                ThePilot.this.setCursor(NORMAL_CURSOR);
            }

            public void documentLoadingFailed(SVGDocumentLoaderEvent e) {
                ThePilot.this.setCursor(NORMAL_CURSOR);
                String errMsg = "Batik SVG Pilot failed to load " + ThePilot.this.currLocation;
                ThePilot.this.firePropertyChange("contentLoading", errMsg, "error");
            }
        });
        this.svgCanvas.addGVTTreeRendererListener((GVTTreeRendererListener)new GVTTreeRendererAdapter(){

            public void gvtRenderingPrepare(GVTTreeRendererEvent e) {
                ThePilot.this.setCursor(WAIT_CURSOR);
                ThePilot.this.firePropertyChange("statusLine", null, "Rendering...");
            }

            public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
                ThePilot.this.setCursor(NORMAL_CURSOR);
                ThePilot.this.firePropertyChange("statusLine", null, "Done");
            }

            public void gvtRenderingCancelled(GVTTreeRendererEvent event) {
                ThePilot.this.setCursor(NORMAL_CURSOR);
                ThePilot.this.firePropertyChange("statusLine", null, "Cancelled");
            }

            public void gvtRenderingFailed(GVTTreeRendererEvent event) {
                ThePilot.this.setCursor(NORMAL_CURSOR);
                ThePilot.this.firePropertyChange("statusLine", null, "Error");
            }
        });
    }

    public Component createComponent() {
        return this.svgCanvas;
    }

    public void clear(String contentType) {
    }

    public void parse(ContentLoader cl) throws IOException {
        try {
            this.firePropertyChange("location", null, cl.getLocation());
            this.firePropertyChange("title", null, "Displaying " + cl.getLocation());
            this.currLocation = cl.getURL().toString();
            this.svgCanvas.setURI(this.currLocation);
        }
        catch (Exception ex) {
            String errMsg = "Batik SVG Pilot: Failed to load " + cl.getLocation();
            this.firePropertyChange("contentLoading", errMsg, "error");
            if (Debug.ex) {
                Debug.ex(ex);
            }
            throw new IOException(errMsg);
        }
    }

    public void dispose() {
        this.svgCanvas = null;
        super.dispose();
    }

    private void setCursor(Cursor theCursor) {
        final Cursor cursor = theCursor;
        if (SwingUtilities.isEventDispatchThread()) {
            this.svgCanvas.setCursor(cursor);
        } else {
            Runnable doWorkRunnable = new Runnable(){

                public void run() {
                    ThePilot.this.svgCanvas.setCursor(cursor);
                }
            };
            SwingUtilities.invokeLater(doWorkRunnable);
        }
    }

    static {
        ThePilot.testForBatik();
    }
}

