/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.adapter;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import oracle.dbtools.connections.StringReferencePair;
import oracle.dbtools.connections.db.ConnectionCreator;
import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.dbtools.connections.db.DatabaseProviderHelper;
import oracle.dbtools.connections.security.ReferenceWorker;
import oracle.dbtools.connections.security.SecureReferencePair;

public class DatabaseProviderFactory1212
implements ObjectFactory {
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        if (object instanceof Reference) {
            ConnectionCreator connectionCreator;
            Reference reference = (Reference)object;
            String string = name != null && name.size() > 0 ? name.toString() : null;
            DatabaseProvider.Builder builder = DatabaseProvider.builder(string);
            ReferenceWorker referenceWorker = this.getReferenceWorker(true, hashtable);
            builder.worker(referenceWorker);
            RefAddr refAddr = reference.get("subtype");
            String string2 = refAddr == null ? null : (String)refAddr.getContent();
            builder.property("subtype", string2);
            try {
                connectionCreator = DatabaseProvider.getCreator((String)string2);
            }
            catch (SQLException sQLException) {
                connectionCreator = null;
            }
            Enumeration<RefAddr> enumeration = reference.getAll();
            while (enumeration.hasMoreElements()) {
                Object object2;
                RefAddr refAddr2 = enumeration.nextElement();
                String string3 = refAddr2.getType();
                if (connectionCreator != null && connectionCreator.shouldEncrypt(string3)) {
                    ReferenceWorker referenceWorker2 = this.getReferenceWorker(false, hashtable);
                    if (referenceWorker2 == null) {
                        DatabaseProviderHelper.getLogger().warning("Cannot decrypt password, don't know how.");
                        object2 = null;
                    } else {
                        object2 = refAddr2 instanceof StringRefAddr ? referenceWorker2.decrypt(SecureReferencePair.convertToSecureReference((StringReferencePair)new StringReferencePair(string3, (String)refAddr2.getContent())), string) : null;
                    }
                } else {
                    object2 = refAddr2.getContent();
                }
                if (object2 instanceof String) {
                    builder.property(string3, (String)object2);
                    continue;
                }
                if (object2 instanceof char[]) {
                    builder.credential(string3, (char[])object2);
                    continue;
                }
                if (object2 == null) continue;
                DatabaseProviderHelper.getLogger().warning(string + ": invalid value for property " + string3);
            }
            return builder.build();
        }
        return null;
    }

    protected ReferenceWorker getReferenceWorker(boolean bl, Hashtable hashtable) {
        Object v;
        ReferenceWorker referenceWorker = null;
        if (hashtable != null && (v = hashtable.get(ReferenceWorker.KEY)) instanceof ReferenceWorker) {
            referenceWorker = (ReferenceWorker)v;
        }
        if (referenceWorker == null) {
            referenceWorker = DatabaseProviderHelper.getDefaultWorker();
        }
        return referenceWorker;
    }
}

