/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.interaction;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewDecoration;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.event.InteractorChangedEvent;
import ilog.views.event.InteractorListener;
import ilog.views.event.ManagerContentChangedEvent;
import ilog.views.event.ManagerContentChangedListener;
import ilog.views.event.ObjectBBoxChangedEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Iterator;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.framework.graphic.FakeNode;
import oracle.diagram.framework.interaction.AlignmentRulersPlugin;
import oracle.diagram.framework.interaction.MoveGraphicsEvent;
import oracle.diagram.framework.interaction.MoveGraphicsListener;
import oracle.diagram.framework.interaction.SelectInteractorMoveSelection;
import oracle.diagram.framework.manager.ManagerUtil;

public class DefaultAlignmentRulersPlugin
extends AbstractPlugin
implements AlignmentRulersPlugin {
    private DiagramContext _context;
    private boolean _showRulers;
    private Color _color;
    private Listener _listener;
    private AlignmentRulerOverlay _overlay;
    private HashSet<IlvGraphic> _movingObjects;
    private boolean _storeCoordinatesRequired;
    private HashSet<Float> _xAll;
    private HashSet<Float> _yAll;
    private HashSet<Float> _xCurrent;
    private HashSet<Float> _yCurrent;

    public DefaultAlignmentRulersPlugin(DiagramContext context) {
        this._context = context;
        this._listener = new Listener();
        this._overlay = new AlignmentRulerOverlay();
        this._movingObjects = new HashSet();
        this._xAll = new HashSet();
        this._yAll = new HashSet();
        this._xCurrent = new HashSet();
        this._yCurrent = new HashSet();
        this._storeCoordinatesRequired = false;
        this._showRulers = false;
        this._color = new Color(153, 217, 234);
        IlvManagerView view = this._context.getManagerView();
        view.addInteractorListener((InteractorListener)this._listener);
    }

    @Override
    public void setAlignmentRulersShown(boolean showRulers) {
        this._showRulers = showRulers;
        IlvManagerViewInteractor i = this._context.getManagerView().getInteractor();
        if (i instanceof SelectInteractorMoveSelection) {
            if (this._showRulers) {
                ((SelectInteractorMoveSelection)i).addMoveGraphicsListener(this._listener);
            } else {
                ((SelectInteractorMoveSelection)i).removeMoveGraphicsListener(this._listener);
            }
        }
    }

    @Override
    public boolean getAlignmentRulersShown() {
        return this._showRulers;
    }

    @Override
    public void setAlignmentRulerColor(Color c) {
        this._color = c;
    }

    @Override
    public Color getAlignmentRulerColor() {
        return this._color;
    }

    private void checkAndShowRuler() {
        IlvManager topMgr = this._context.getManagerView().getManager();
        Iterator<IlvGraphic> i = this._movingObjects.iterator();
        if (!i.hasNext()) {
            return;
        }
        IlvGraphic g = i.next();
        IlvTransformer t = ManagerUtil.getConversionTransformer(topMgr, ManagerUtil.getManager(g));
        IlvRect tmp = new IlvRect(g.boundingBox(t));
        while (i.hasNext()) {
            g = i.next();
            t = ManagerUtil.getConversionTransformer(topMgr, ManagerUtil.getManager(g));
            tmp.add(g.boundingBox(t));
        }
        if (this._storeCoordinatesRequired) {
            this.storeCoordinates();
        }
        if (this._xAll.contains(Float.valueOf(tmp.x))) {
            this._xCurrent.add(Float.valueOf(tmp.x));
        }
        if (this._xAll.contains(Float.valueOf(tmp.x + tmp.width))) {
            this._xCurrent.add(Float.valueOf(tmp.x + tmp.width));
        }
        if (this._yAll.contains(Float.valueOf(tmp.y))) {
            this._yCurrent.add(Float.valueOf(tmp.y));
        }
        if (this._yAll.contains(Float.valueOf(tmp.y + tmp.height))) {
            this._yCurrent.add(Float.valueOf(tmp.y + tmp.height));
        }
        this.invalidateView();
        this.redrawViewImmediately();
    }

    private void storeCoordinates() {
        IlvRect tmp = new IlvRect();
        IlvManager topMgr = this._context.getManagerView().getManager();
        IlvTransformer t = null;
        IlvGraphic g = null;
        this._xAll.clear();
        this._yAll.clear();
        IlvGraphicEnumeration e = topMgr.getObjects(true);
        while (e.hasMoreElements()) {
            g = e.nextElement();
            Object prop = g.getProperty("ParentSelection");
            if (prop != null && ((Boolean)prop).booleanValue() || this._movingObjects.contains(g) || g instanceof FakeNode || g instanceof IlvLinkImage) continue;
            t = ManagerUtil.getConversionTransformer(topMgr, ManagerUtil.getManager(g));
            tmp.setFrame((Rectangle2D)g.boundingBox(t));
            this._xAll.add(Float.valueOf(tmp.x));
            this._xAll.add(Float.valueOf(tmp.x + tmp.width));
            this._yAll.add(Float.valueOf(tmp.y));
            this._yAll.add(Float.valueOf(tmp.y + tmp.height));
        }
        this._storeCoordinatesRequired = false;
    }

    private void redrawViewImmediately() {
        IlvManagerView view = this._context.getManagerView();
        int mode = view.getRedrawMode();
        try {
            view.setRedrawMode(1);
            view.reDrawViews();
        }
        finally {
            view.setRedrawMode(mode);
        }
    }

    private void invalidateView() {
        if (this._xCurrent.isEmpty() && this._yCurrent.isEmpty()) {
            return;
        }
        IlvManagerView view = this._context.getManagerView();
        IlvRect viewRect = new IlvRect(0.0f, 0.0f, (float)view.getWidth(), (float)view.getHeight());
        IlvTransformer t = view.getTransformer();
        t.inverse(viewRect);
        IlvRect r = new IlvRect();
        for (float x : this._xCurrent) {
            r.setRect(x, viewRect.y, 1.0f, viewRect.height);
            t.apply(r);
            r.x -= 1.0f;
            r.width = 3.0f;
            view.invalidateRect(r);
        }
        for (float y : this._yCurrent) {
            r.setRect(viewRect.x, y, viewRect.width, 1.0f);
            t.apply(r);
            r.y -= 1.0f;
            r.height = 3.0f;
            view.invalidateRect(r);
        }
    }

    private class AlignmentRulerOverlay
    implements IlvManagerViewDecoration {
        private AlignmentRulerOverlay() {
        }

        public void paint(Graphics g, IlvManagerView view) {
            if (DefaultAlignmentRulersPlugin.this._xCurrent.isEmpty() && DefaultAlignmentRulersPlugin.this._yCurrent.isEmpty()) {
                return;
            }
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setColor(DefaultAlignmentRulersPlugin.this._color);
            g2d.setStroke(new BasicStroke(1.0f));
            float width = view.getWidth();
            float height = view.getHeight();
            IlvRect viewRect = new IlvRect(0.0f, 0.0f, width, height);
            IlvTransformer t = view.getTransformer();
            t.inverse(viewRect);
            IlvPoint p = new IlvPoint();
            Iterator i = DefaultAlignmentRulersPlugin.this._xCurrent.iterator();
            while (i.hasNext()) {
                float x = ((Float)i.next()).floatValue();
                if (!(x >= viewRect.x) || !(x <= viewRect.x + viewRect.width)) continue;
                p.x = x;
                t.apply(p);
                g2d.drawLine((int)p.x, 0, (int)p.x, (int)height);
            }
            i = DefaultAlignmentRulersPlugin.this._yCurrent.iterator();
            while (i.hasNext()) {
                float y = ((Float)i.next()).floatValue();
                if (!(y >= viewRect.y) || !(y <= viewRect.y + viewRect.height)) continue;
                p.y = y;
                t.apply(p);
                g2d.drawLine(0, (int)p.y, (int)width, (int)p.y);
            }
            g2d.dispose();
        }
    }

    private class Listener
    implements ManagerContentChangedListener,
    InteractorListener,
    MoveGraphicsListener {
        private Listener() {
        }

        public void contentsChanged(ManagerContentChangedEvent evt) {
            if (evt.getType() == 4 && !DefaultAlignmentRulersPlugin.this._storeCoordinatesRequired && !DefaultAlignmentRulersPlugin.this._movingObjects.isEmpty()) {
                IlvGraphic g = ((ObjectBBoxChangedEvent)evt).getGraphicObject();
                if (!DefaultAlignmentRulersPlugin.this._movingObjects.contains(g)) {
                    DefaultAlignmentRulersPlugin.this._storeCoordinatesRequired = true;
                }
            }
        }

        @Override
        public void graphicsMoving(MoveGraphicsEvent evt) {
            DefaultAlignmentRulersPlugin.this.invalidateView();
            DefaultAlignmentRulersPlugin.this._xCurrent.clear();
            DefaultAlignmentRulersPlugin.this._yCurrent.clear();
            if (evt.getType() == 0) {
                DefaultAlignmentRulersPlugin.this._movingObjects.clear();
                for (IlvGraphic g : evt.getGraphics()) {
                    if (g instanceof FakeNode || g instanceof IlvLinkImage) continue;
                    DefaultAlignmentRulersPlugin.this._movingObjects.add(g);
                }
                DefaultAlignmentRulersPlugin.this.storeCoordinates();
                IlvManagerView view = DefaultAlignmentRulersPlugin.this._context.getManagerView();
                view.removeViewDecoration((IlvManagerViewDecoration)DefaultAlignmentRulersPlugin.this._overlay);
                view.addViewDecoration((IlvManagerViewDecoration)DefaultAlignmentRulersPlugin.this._overlay);
                view.getManager().removeManagerContentChangedListener((ManagerContentChangedListener)DefaultAlignmentRulersPlugin.this._listener);
                view.getManager().addManagerContentChangedListener((ManagerContentChangedListener)DefaultAlignmentRulersPlugin.this._listener);
                DefaultAlignmentRulersPlugin.this.checkAndShowRuler();
            } else if (evt.getType() == 1) {
                DefaultAlignmentRulersPlugin.this.checkAndShowRuler();
            } else if (evt.getType() == 2) {
                DefaultAlignmentRulersPlugin.this._storeCoordinatesRequired = false;
                DefaultAlignmentRulersPlugin.this._movingObjects.clear();
                DefaultAlignmentRulersPlugin.this._xAll.clear();
                DefaultAlignmentRulersPlugin.this._yAll.clear();
                IlvManagerView view = DefaultAlignmentRulersPlugin.this._context.getManagerView();
                view.removeViewDecoration((IlvManagerViewDecoration)DefaultAlignmentRulersPlugin.this._overlay);
                view.getManager().removeManagerContentChangedListener((ManagerContentChangedListener)DefaultAlignmentRulersPlugin.this._listener);
                DefaultAlignmentRulersPlugin.this.redrawViewImmediately();
            }
        }

        public void interactorChanged(InteractorChangedEvent evt) {
            if (evt.getNewValue() instanceof SelectInteractorMoveSelection && DefaultAlignmentRulersPlugin.this._showRulers) {
                ((SelectInteractorMoveSelection)evt.getNewValue()).addMoveGraphicsListener(this);
            } else if (evt.getOldValue() instanceof SelectInteractorMoveSelection) {
                ((SelectInteractorMoveSelection)evt.getOldValue()).removeMoveGraphicsListener(this);
            }
        }
    }
}

