/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.oppparse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.diagram.oppparse.OPPContainer;
import oracle.diagram.oppparse.OPPDimension;
import oracle.diagram.oppparse.OPPInsets;
import oracle.diagram.oppparse.OPPParseConstants;
import oracle.diagram.oppparse.OPPParseUtil;
import oracle.diagram.oppparse.OPPShapeState;
import oracle.diagram.oppparse.OPPTopLevelShape;
import oracle.diagram.oppparse.OPPXMLElementAdapter;
import oracle.xml.parser.v2.XMLElement;

public final class OPPShapeStateData
extends OPPXMLElementAdapter
implements OPPParseConstants {
    private static final List<OPPTopLevelShape> EMPTY_SHAPES = Collections.unmodifiableList(new ArrayList(0));
    private final OPPContainer _parent;
    private final OPPShapeState _type;
    private OPPInsets _insets;
    private OPPDimension _size;
    private List<OPPTopLevelShape> _shapesUsed = null;

    OPPShapeStateData(OPPContainer parent, OPPShapeState type, XMLElement xmlSource) {
        super(xmlSource);
        this._parent = parent;
        this._type = type;
        XMLElement insets = OPPParseUtil.getNamedChild(xmlSource, "insets", "containerInsets");
        this._insets = insets != null ? (OPPInsets)OPPParseUtil.parseTypedProperty(insets) : new OPPInsets(0.0f, 0.0f, 0.0f, 0.0f);
        XMLElement size = OPPParseUtil.getNamedChild(xmlSource, "dimension", "elementSize");
        this._size = size != null ? (OPPDimension)OPPParseUtil.parseTypedProperty(size) : null;
        XMLElement shapesUsed = OPPParseUtil.getNamedChild(xmlSource, "infoList", "shapesUsed");
        this._shapesUsed = shapesUsed != null && OPPShapeState.EXPANDED.equals((Object)type) ? Collections.unmodifiableList(OPPParseUtil.getShapesUsed(parent, shapesUsed)) : EMPTY_SHAPES;
    }

    public final OPPContainer getParent() {
        return this._parent;
    }

    public final OPPShapeState getType() {
        return this._type;
    }

    public final OPPDimension getShapeSize() {
        return this._size;
    }

    public final OPPInsets getInsets() {
        return this._insets;
    }

    public final List<OPPTopLevelShape> getChildShapes() {
        if (this._shapesUsed.isEmpty()) {
            return this._shapesUsed;
        }
        ArrayList<OPPTopLevelShape> filtered = new ArrayList<OPPTopLevelShape>(this._shapesUsed.size());
        for (OPPTopLevelShape s : this._shapesUsed) {
            if (s.isDeleted()) continue;
            filtered.add(s);
        }
        return Collections.unmodifiableList(filtered);
    }
}

