/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.cmd.SaveAllCommand;
import oracle.ide.compiler.BuildLog;
import oracle.ide.compiler.BuildSystemListener;
import oracle.ide.compiler.BuildSystemListener2;
import oracle.ide.compiler.BuildSystemVetoException;
import oracle.ide.compiler.CompileArguments;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.EditorUtil;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.index.QueryCriteria;
import oracle.ide.log.LogPage;
import oracle.ide.model.Attributes;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Folder;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLKey;
import oracle.ide.net.URLPath;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.util.Assert;
import oracle.ide.util.IntersectedFilters;
import oracle.ide.util.PatternFilters;
import oracle.ide.vcs.VCSManager;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.GraphicsUtils;
import oracle.javatools.util.Log;
import oracle.jdeveloper.cm.dt.CmJavaUtil;
import oracle.jdeveloper.compiler.BuildGraph;
import oracle.jdeveloper.compiler.BuildSystemConfiguration;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.CompilerContext;
import oracle.jdeveloper.compiler.Helpers;
import oracle.jdeveloper.compiler.IdeLog;
import oracle.jdeveloper.compiler.IdeStorage;
import oracle.jdeveloper.compiler.JCompiler;
import oracle.jdeveloper.compiler.Translator;
import oracle.jdeveloper.compiler.Translator2;
import oracle.jdeveloper.deploy.DeployCommandFactory;
import oracle.jdeveloper.deploy.DeploymentOptions;
import oracle.jdeveloper.deploy.Profile;
import oracle.jdeveloper.deploy.cmd.DeployCommand;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdevimpl.build.BuildAfterSave;
import oracle.jdevimpl.build.RefreshApplicationController;
import oracle.jdevimpl.compiler.BuildSystemHook;
import oracle.jdevimpl.compiler.BuildSystemUtilities;
import oracle.jdevimpl.compiler.JCompilerMenuItems;
import oracle.jdevimpl.compiler.TranslatorDefinition;
import oracle.ojc.interfaces.Storage;

public class UnifiedBuildSystem {
    public static final Log logger;
    private static final Log STATISTICS_LOGGER;
    private static final Log TRANSLATOR_LOGGER;
    public static final IdeLog ideLog;
    public static boolean showCompileProgress;
    private static final String PREPROCESSOR_GENERATED_PROPERTY = "preprocessor_generated_file";
    private static final int CLEANED = 1;
    private static final int NOT_CLEANED = 2;
    public static final String ELEMENTS_TO_CLEAN_PROPERTY = "buildsystem.elements.to.clean";
    public static final String ELEMENTS_TO_BUILD_PROPERTY = "buildsystem.elements.to.build";
    private final Map<String, Set<TranslatorDefinition>> extensionToTranslatorDefinitionMap = new HashMap<String, Set<TranslatorDefinition>>(19);
    private final Set<TranslatorDefinition> registeredTranslatorDefinitions = new LinkedHashSet<TranslatorDefinition>(19);
    BuildGraph buildGraph = new BuildGraph();
    CompileThread compileThread = null;
    boolean locked = false;
    boolean buildingOnUIThread = false;
    private final Object lockedLock = new Object();
    private int lastFilesBuilt;
    private int lastBuildStatus;
    private long lastBuildTime;
    private final BuildAfterSave buildAfterSave = BuildAfterSave.getInstance();
    private static final Set<String> recognizedExtensions;
    private static UnifiedBuildSystem instance;
    private final Object markingLock = new Object();
    private final Map<Workspace, Map<Project, Set<Storage>>> translatedWorkspaces = new LinkedHashMap<Workspace, Map<Project, Set<Storage>>>();
    private final Map<Workspace, Map<Project, Set<Storage>>> consideredFiles = new LinkedHashMap<Workspace, Map<Project, Set<Storage>>>();
    private final Map<Workspace, Map<Project, List<String>>> compiledWorkspaces = new LinkedHashMap<Workspace, Map<Project, List<String>>>();
    private IOException failedDeleteException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanAfterBuild(Context context) {
        Object object = this.markingLock;
        synchronized (object) {
            this.translatedWorkspaces.clear();
            this.compiledWorkspaces.clear();
            this.consideredFiles.clear();
        }
        if (context != null) {
            context.removeProperty(ELEMENTS_TO_CLEAN_PROPERTY);
            context.removeProperty(ELEMENTS_TO_BUILD_PROPERTY);
        }
    }

    private synchronized void initThread(CompileArguments compileArguments, boolean cleanAll, boolean autoClean, boolean stopOnFailedDelete, BuildLog buildLog, boolean refreshApplication) {
        this.compileThread = new CompileThread(compileArguments, this.buildGraph, cleanAll, autoClean, stopOnFailedDelete, buildLog, refreshApplication);
        if (this.compileThread.getPriority() > 1) {
            this.compileThread.setPriority(this.compileThread.getPriority() - 1);
        }
        this.compileThread.start();
    }

    synchronized boolean initializeBuild(CompileArguments compileArguments, BuildLog buildLog) {
        if (!this.isAlive()) {
            this.initThread(compileArguments, false, false, false, buildLog, false);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean buildOnUIThread(CompileArguments compileArguments, BuildLog buildLog) {
        if (!this.isAlive()) {
            try {
                this.compileThread = new CompileThread(compileArguments, this.buildGraph, false, false, false, buildLog, false);
                this.buildingOnUIThread = true;
                this.compileThread.run();
                boolean bl = true;
                return bl;
            }
            finally {
                this.compileThread = null;
                this.buildingOnUIThread = false;
            }
        }
        return false;
    }

    synchronized boolean initCleanAll(Context context, boolean autoClean, boolean stopOnFailedDelete, BuildLog buildLog, boolean refreshApplication) {
        if (this.isAlive()) {
            return false;
        }
        CompileArguments compileArguments = new CompileArguments(context);
        compileArguments.setRebuildAllSources(false);
        this.initThread(compileArguments, true, autoClean, stopOnFailedDelete, buildLog, refreshApplication);
        return true;
    }

    public boolean isAlive() {
        CompileThread currentCompileThread = this.compileThread;
        return currentCompileThread != null && currentCompileThread.isAlive();
    }

    public void join(long millis) throws InterruptedException {
        CompileThread currentCompileThread = this.compileThread;
        if (currentCompileThread != null) {
            currentCompileThread.join(millis);
        }
    }

    public void stopBuildSystem() {
        CompileThread currentCompileThread = this.compileThread;
        if (currentCompileThread != null) {
            ((Thread)currentCompileThread).interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocked(Context context) {
        Object object = this.lockedLock;
        synchronized (object) {
            return this.locked;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lock(Context context) {
        Object object = this.lockedLock;
        synchronized (object) {
            if (this.isAlive()) {
                return false;
            }
            this.locked = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlock() {
        Object object = this.lockedLock;
        synchronized (object) {
            if (this.locked) {
                this.locked = false;
                return true;
            }
            return false;
        }
    }

    synchronized int compileInThread(Thread thread, Project prj, ArrayList<Storage> files, boolean rebuild) throws IllegalArgumentException {
        if (!(thread instanceof CompileThread || this.buildingOnUIThread && SwingUtilities.isEventDispatchThread())) {
            throw new IllegalArgumentException("thread");
        }
        int fileCnt = files.size();
        if (files == null) {
            throw new IllegalArgumentException("files");
        }
        for (int i = 0; i < fileCnt; ++i) {
            if (files.get(i) instanceof Storage) continue;
            throw new IllegalArgumentException("files[" + i + "]");
        }
        return this.compileThread.buildFilesInThread(prj, files, rebuild);
    }

    public int getLastErrorCount() {
        IdeLog currentLog = ideLog;
        return currentLog != null ? currentLog.nerrors() : 0;
    }

    int getLastFilesBuilt() {
        return this.lastFilesBuilt;
    }

    long getLastBuildTime() {
        return this.lastBuildTime;
    }

    int getLastBuildStatus() {
        return this.lastBuildStatus;
    }

    private synchronized List<TranslatorDefinition> getRegisteredTranslatorDefinitions() {
        return new ArrayList<TranslatorDefinition>(this.registeredTranslatorDefinitions);
    }

    private TranslatorDefinition findIncompatibleTranslator(Set<TranslatorDefinition> al, TranslatorDefinition translator) {
        if (translator.isPreprocessor()) {
            return null;
        }
        for (TranslatorDefinition translatorDefinition : al) {
            if (translatorDefinition.isPreprocessor()) continue;
            return translatorDefinition;
        }
        return null;
    }

    public synchronized void registerTranslator(Translator translator) {
        TranslatorDefinition translatorDefinition = new TranslatorDefinition(translator);
        this.registerTranslatorDefinition(translatorDefinition);
        Set<String> extensions = translatorDefinition.getOutputExtensions();
        BuildSystemHook.addRegisteredTranslatorExtensions(extensions);
    }

    private Set<String> getRegistrationInputExtensions(TranslatorDefinition translatorDefinition) {
        Set<String> extensions = translatorDefinition.getInputExtensions();
        if (extensions.isEmpty()) {
            extensions.add("");
        }
        return extensions;
    }

    private synchronized void registerTranslatorDefinition(TranslatorDefinition translatorDefinition) {
        Set<String> extensions = this.getRegistrationInputExtensions(translatorDefinition);
        for (String extension : extensions) {
            Set<TranslatorDefinition> al = this.extensionToTranslatorDefinitionMap.get(extension);
            if (al == null) {
                al = new LinkedHashSet<TranslatorDefinition>(1);
                al.add(translatorDefinition);
                this.extensionToTranslatorDefinitionMap.put(extension, al);
                continue;
            }
            if (extension.length() == 0) {
                al.add(translatorDefinition);
                continue;
            }
            if (al.contains((Object)translatorDefinition)) continue;
            TranslatorDefinition incompatibleTranslator = this.findIncompatibleTranslator(al, translatorDefinition);
            if (incompatibleTranslator == null) {
                al.add(translatorDefinition);
                continue;
            }
            String msg = CompArb.format(119, new String[]{translatorDefinition.getName(), incompatibleTranslator.getName(), extension});
            ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, msg);
        }
        try {
            this.buildGraph.rebuild(this.extensionToTranslatorDefinitionMap);
            this.registeredTranslatorDefinitions.add(translatorDefinition);
        }
        catch (IllegalStateException e) {
            this.unregisterTranslator((Translator)translatorDefinition.retrieveBuildTool());
            String msg = CompArb.format(174, translatorDefinition.getName(), e.getMessage());
            ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, msg);
        }
    }

    public synchronized void unregisterTranslator(Translator translator) {
        Set<String> extensions = this.getRegistrationInputExtensions(new TranslatorDefinition(translator));
        for (String ext : extensions) {
            Set<TranslatorDefinition> defs = this.extensionToTranslatorDefinitionMap.get(ext);
            if (defs != null) {
                for (TranslatorDefinition translatorDefinition : defs) {
                    if (!translatorDefinition.definesTranslator(translator)) continue;
                    defs.remove((Object)translatorDefinition);
                    this.registeredTranslatorDefinitions.remove((Object)translatorDefinition);
                    break;
                }
            }
            if (defs != null && defs.size() != 0) continue;
            this.extensionToTranslatorDefinitionMap.remove(ext);
        }
        try {
            this.buildGraph.rebuild(this.extensionToTranslatorDefinitionMap);
        }
        catch (IllegalStateException e) {
            String msg = CompArb.format(175, translator.getName(), e.getMessage());
            ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, msg);
        }
    }

    synchronized Translator getJavaTranslator(Workspace ws, Project project) {
        HashSet<String> extensions = new HashSet<String>(1);
        extensions.add(".java");
        this.primeTranslators(extensions, ws, project);
        for (TranslatorDefinition def : this.getRegisteredTranslatorDefinitions()) {
            if (!"Ojc".equals(def.getName()) && (!def.getInputExtensions().contains(".java") || !def.getOutputExtensions().contains(".class"))) continue;
            return (Translator)def.retrieveBuildTool();
        }
        return null;
    }

    private synchronized void primeTranslators(Set<String> extensions, Workspace ws, Project project) {
        List<TranslatorDefinition> newTranslatorDefinitions = BuildSystemHook.getNewTranslators(extensions, ws, project);
        for (TranslatorDefinition translatorDefinition : newTranslatorDefinitions) {
            this.registerTranslatorDefinition(translatorDefinition);
        }
    }

    public static synchronized UnifiedBuildSystem getInstance() {
        if (instance == null) {
            instance = new UnifiedBuildSystem();
        }
        return instance;
    }

    private UnifiedBuildSystem() {
    }

    public void beginMarking(Translator translator) {
        CompileThread currentCompileThread = this.compileThread;
        if (currentCompileThread != null) {
            currentCompileThread.beginMarking(translator);
        }
    }

    public void markTranslated(Translator translator, Storage source) {
        CompileThread currentCompileThread = this.compileThread;
        if (currentCompileThread != null) {
            currentCompileThread.markTranslated(translator, source);
        }
    }

    void addCopyListenerTime(String name, long time) {
        CompileThread currentCompileThread = this.compileThread;
        if (currentCompileThread != null) {
            currentCompileThread.addCopyListenerTime(name, time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Workspace, Map<Project, Set<Storage>>> getTranslatedSources() {
        Object object = this.markingLock;
        synchronized (object) {
            LinkedHashMap<Workspace, Map<Project, Set<Storage>>> newTranslatedWorkspaces = new LinkedHashMap<Workspace, Map<Project, Set<Storage>>>(this.translatedWorkspaces.size());
            for (Map.Entry<Workspace, Map<Project, Set<Storage>>> workspaceEntry : this.translatedWorkspaces.entrySet()) {
                Map<Project, Set<Storage>> oldProjectMap = workspaceEntry.getValue();
                LinkedHashMap newProjectMap = new LinkedHashMap(oldProjectMap.size());
                for (Map.Entry<Project, Set<Storage>> projectEntry : oldProjectMap.entrySet()) {
                    LinkedHashSet files = new LinkedHashSet(projectEntry.getValue());
                    newProjectMap.put(projectEntry.getKey(), files);
                }
                newTranslatedWorkspaces.put(workspaceEntry.getKey(), newProjectMap);
            }
            assert (this.assertTranslatedSourcesCopy(newTranslatedWorkspaces));
            return newTranslatedWorkspaces;
        }
    }

    private boolean assertTranslatedSourcesCopy(Map<Workspace, Map<Project, Set<Storage>>> newTranslatedWorkspaces) {
        assert (newTranslatedWorkspaces.size() == this.translatedWorkspaces.size());
        for (Workspace workspace : this.translatedWorkspaces.keySet()) {
            Map<Project, Set<Storage>> oldMap = this.translatedWorkspaces.get(workspace);
            Map<Project, Set<Storage>> newMap = newTranslatedWorkspaces.get(workspace);
            assert (oldMap != null);
            assert (newMap != null);
            assert (oldMap != newMap);
            assert (oldMap.size() == newMap.size());
            for (Project project : oldMap.keySet()) {
                Set<Storage> oldSet = oldMap.get(project);
                Set<Storage> newSet = newMap.get(project);
                assert (oldSet != null);
                assert (newSet != null);
                assert (oldSet != newSet);
                assert (oldSet.size() == newSet.size());
                ArrayList<Storage> oldList = new ArrayList<Storage>(oldSet);
                ArrayList<Storage> newList = new ArrayList<Storage>(newSet);
                for (int x = 0; x < oldList.size(); ++x) {
                    assert (oldList.get(x) == newList.get(x));
                }
            }
        }
        return true;
    }

    public void markCompiled(String path) {
        CompileThread currentCompileThread = this.compileThread;
        if (currentCompileThread != null) {
            currentCompileThread.markCompiled(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Workspace, Map<Project, List<String>>> getCompiledClasses() {
        Object object = this.markingLock;
        synchronized (object) {
            LinkedHashMap<Workspace, Map<Project, List<String>>> newCompiledWorkspaces = new LinkedHashMap<Workspace, Map<Project, List<String>>>(this.compiledWorkspaces.size());
            for (Map.Entry<Workspace, Map<Project, List<String>>> workspaceEntry : this.compiledWorkspaces.entrySet()) {
                Map<Project, List<String>> oldProjectMap = workspaceEntry.getValue();
                LinkedHashMap newProjectMap = new LinkedHashMap(oldProjectMap.size());
                for (Map.Entry<Project, List<String>> projectEntry : oldProjectMap.entrySet()) {
                    ArrayList projectNames = new ArrayList(projectEntry.getValue());
                    newProjectMap.put(projectEntry.getKey(), projectNames);
                }
                newCompiledWorkspaces.put(workspaceEntry.getKey(), newProjectMap);
            }
            assert (this.assertCompiledWorkspacesCopy(newCompiledWorkspaces));
            return newCompiledWorkspaces;
        }
    }

    private boolean assertCompiledWorkspacesCopy(Map<Workspace, Map<Project, List<String>>> newCompiledWorkspaces) {
        assert (newCompiledWorkspaces.size() == this.compiledWorkspaces.size());
        for (Workspace workspace : this.compiledWorkspaces.keySet()) {
            Map<Project, List<String>> oldWorkspaces = this.compiledWorkspaces.get(workspace);
            Map<Project, List<String>> newWorkspaces = newCompiledWorkspaces.get(workspace);
            assert (oldWorkspaces != null);
            assert (newWorkspaces != null);
            assert (oldWorkspaces != newWorkspaces);
            assert (oldWorkspaces.size() == newWorkspaces.size());
            for (Project project : oldWorkspaces.keySet()) {
                List<String> oldList = oldWorkspaces.get(project);
                List<String> newList = newWorkspaces.get(project);
                assert (oldList != null);
                assert (newList != null);
                assert (oldList != newList);
                assert (oldList.size() == newList.size());
                for (int x = 0; x < oldList.size(); ++x) {
                    assert (oldList.get(x) == newList.get(x));
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Workspace, Map<Project, Set<Storage>>> getConsideredFiles() {
        Object object = this.markingLock;
        synchronized (object) {
            LinkedHashMap<Workspace, Map<Project, Set<Storage>>> newConsideredFiles = new LinkedHashMap<Workspace, Map<Project, Set<Storage>>>(this.consideredFiles.size());
            for (Map.Entry<Workspace, Map<Project, Set<Storage>>> workspaceEntry : this.consideredFiles.entrySet()) {
                Map<Project, Set<Storage>> oldProjectMap = workspaceEntry.getValue();
                LinkedHashMap newProjectMap = new LinkedHashMap(oldProjectMap.size());
                for (Map.Entry<Project, Set<Storage>> projectEntry : oldProjectMap.entrySet()) {
                    LinkedHashSet files = new LinkedHashSet(projectEntry.getValue());
                    newProjectMap.put(projectEntry.getKey(), files);
                }
                newConsideredFiles.put(workspaceEntry.getKey(), newProjectMap);
            }
            assert (this.assertConsideredFilesCopy(newConsideredFiles));
            return newConsideredFiles;
        }
    }

    private boolean assertConsideredFilesCopy(Map<Workspace, Map<Project, Set<Storage>>> newConsideredFiles) {
        assert (newConsideredFiles.size() == this.consideredFiles.size());
        for (Workspace workspace : this.consideredFiles.keySet()) {
            Map<Project, Set<Storage>> oldMap = this.consideredFiles.get(workspace);
            Map<Project, Set<Storage>> newMap = newConsideredFiles.get(workspace);
            assert (oldMap != null);
            assert (newMap != null);
            assert (oldMap != newMap);
            assert (oldMap.size() == newMap.size());
            for (Project project : oldMap.keySet()) {
                Set<Storage> oldSet = oldMap.get(project);
                Set<Storage> newSet = newMap.get(project);
                assert (oldSet != null);
                assert (newSet != null);
                assert (oldSet != newSet);
                assert (oldSet.size() == newSet.size());
                ArrayList<Storage> oldList = new ArrayList<Storage>(oldSet);
                ArrayList<Storage> newList = new ArrayList<Storage>(newSet);
                for (int x = 0; x < oldList.size(); ++x) {
                    assert (oldList.get(x) == newList.get(x));
                }
            }
        }
        return true;
    }

    private static IdeLog createIdeLog() {
        IdeLog ideLog = new IdeLog(){

            @Override
            public void warning(Storage source, int line, int column, int number, String message) {
                super.warning(source, line, column, number, message);
                JCompiler.getInstance().getBuildSystemListeners().forEach(listener -> {
                    if (listener instanceof BuildSystemListener2) {
                        ((BuildSystemListener2)listener).warningLogged(source, line, column, number, message);
                    }
                });
            }

            @Override
            public void error(Storage source, int line, int column, int number, String message) {
                super.error(source, line, column, number, message);
                JCompiler.getInstance().getBuildSystemListeners().forEach(listener -> {
                    if (listener instanceof BuildSystemListener2) {
                        ((BuildSystemListener2)listener).errorLogged(source, line, column, number, message);
                    }
                });
            }

            @Override
            public void reinit() {
                super.reinit();
                JCompiler jCompiler = JCompiler.getInstance();
                jCompiler.getNewBuildSystemListeners(null, null, null);
                jCompiler.getBuildSystemListeners().forEach(listener -> {
                    if (listener instanceof BuildSystemListener2) {
                        ((BuildSystemListener2)listener).logReset();
                    }
                });
            }
        };
        return ideLog;
    }

    IOException getFailedDeleteException() {
        return this.failedDeleteException;
    }

    static /* synthetic */ BuildAfterSave access$1600(UnifiedBuildSystem x0) {
        return x0.buildAfterSave;
    }

    static /* synthetic */ IOException access$000(UnifiedBuildSystem x0) {
        return x0.failedDeleteException;
    }

    static /* synthetic */ long access$300(UnifiedBuildSystem x0) {
        return x0.lastBuildTime;
    }

    static {
        String[] extensions;
        logger = new Log("build-system");
        STATISTICS_LOGGER = new Log("jdev-build-statistics");
        TRANSLATOR_LOGGER = new Log("translator");
        ideLog = UnifiedBuildSystem.createIdeLog();
        showCompileProgress = false;
        recognizedExtensions = new HashSet<String>();
        recognizedExtensions.add(".java");
        for (String extension : extensions = GraphicsUtils.getImageExtensions()) {
            recognizedExtensions.add(extension);
        }
    }

    private static class ExcludedUrlChecker {
        Set<URLKey> fileUrls;
        List<URL> dirUrls;
        boolean logExcludedUrls;

        private ExcludedUrlChecker(List<URL> excludedUrls, boolean log) {
            this.fileUrls = new HashSet<URLKey>(excludedUrls.size());
            this.dirUrls = new ArrayList<URL>(excludedUrls.size());
            for (URL url : excludedUrls) {
                if (URLFileSystem.isDirectory((URL)url)) {
                    this.dirUrls.add(url);
                    continue;
                }
                this.fileUrls.add(URLKey.getInstance((URL)url));
            }
            this.logExcludedUrls = log;
        }

        static ExcludedUrlChecker getInstance(Project project) {
            BuildSystemConfiguration config = BuildSystemConfiguration.getInstance((PropertyStorage)project);
            List excludedUrls = config.getExcludedUrls(project);
            if (excludedUrls.isEmpty()) {
                return null;
            }
            return new ExcludedUrlChecker(excludedUrls, config.getCompilerOption("-verbose") != null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean excludeUrl(URL url) {
            boolean result = false;
            try {
                if (this.fileUrls.contains(URLKey.getInstance((URL)url))) {
                    result = true;
                } else {
                    for (URL dirUrl : this.dirUrls) {
                        if (!URLFileSystem.isBaseURLFor((URL)dirUrl, (URL)url)) continue;
                        result = true;
                        break;
                    }
                }
                boolean bl = result;
                return bl;
            }
            finally {
                if (result && this.logExcludedUrls) {
                    String str = CompArb.format(160, URLFileSystem.getPlatformPathName((URL)url));
                    JCompiler.getInstance().logOutMsg(str + "\n");
                }
            }
        }
    }

    private class CompileThread
    extends Thread {
        private boolean APPS_OJC_BUILD_LOGGER;
        boolean cleanAll;
        BuildGraph buildGraph;
        Context context;
        HashSet<Project> projectsBuilt;
        int filesBuilt;
        boolean warnOnSourceNotInProject;
        boolean saveBeforeCompile;
        private boolean cleanProjectBeforeRebuild;
        private boolean autoClean;
        private boolean stopOnFailedDelete;
        private boolean currentProjectHasEmptyTechScope;
        HashMap<Profile, DataContainer> deploymentProfileBuilt;
        public static final String THREAD_NAME = "CompileThread";
        private boolean buildCanceled;
        private BuildLog buildLog;
        private CompileArguments compileArguments;
        private boolean refreshApplication;
        private Set<BuildSystemListener> listenersStarted;
        private Set<Storage> translatedSources;
        private Set<Storage> suppressedSources;
        private HashMap<Integer, Set<Storage>> translateableSources;
        private List<String> compiledClasses;
        private long translatorStartingTime;
        private HashMap<String, Long> translatorTimes;
        private HashMap<Integer, Boolean> marking;
        private HashMap<String, Long> copyListenerTimes;
        private final Map<Workspace, Map<Project, Set<Storage>>> suppressedWorkspaces;

        private CompileThread(CompileArguments compileArguments, BuildGraph buildGraph, boolean cleanAll, boolean autoClean, boolean stopOnFailedDelete, BuildLog buildLog, boolean refreshApplication) {
            URL root;
            URL file;
            super(THREAD_NAME);
            this.APPS_OJC_BUILD_LOGGER = System.getProperty("APPS_OJC_BUILD_LOGGER") != null;
            this.listenersStarted = new HashSet<BuildSystemListener>();
            this.translateableSources = new HashMap();
            this.translatorTimes = new LinkedHashMap<String, Long>();
            this.marking = new HashMap();
            this.copyListenerTimes = new LinkedHashMap<String, Long>();
            this.suppressedWorkspaces = new HashMap<Workspace, Map<Project, Set<Storage>>>();
            this.compileArguments = compileArguments;
            this.cleanAll = cleanAll;
            this.autoClean = autoClean;
            this.stopOnFailedDelete = stopOnFailedDelete;
            this.context = compileArguments.getContext();
            Workspace workspace = this.context.getWorkspace();
            if (workspace != null && "jdevadf.jws".equals(URLFileSystem.getFileName((URL)workspace.getURL())) && URLFileSystem.exists((URL)(file = URLFactory.newURL((URL)(root = URLFileSystem.getParent((URL)URLFileSystem.getParent((URL)workspace.getURL()))), (String)"oracle/jdeveloper/netbeans/bridge/.lastModified")))) {
                URLFileSystem.setLastModified((URL)file, (long)System.currentTimeMillis());
            }
            this.buildGraph = buildGraph;
            this.deploymentProfileBuilt = new HashMap();
            this.filesBuilt = 0;
            this.warnOnSourceNotInProject = false;
            EnvironOptions opt = Ide.getEnvironOptions();
            showCompileProgress = !compileArguments.isQuiet();
            this.saveBeforeCompile = compileArguments.isSaveBeforeCompiling() & opt.getSaveBeforeCompile();
            this.cleanProjectBeforeRebuild = opt.getCleanProjectBeforeRebuild();
            this.projectsBuilt = new HashSet();
            UnifiedBuildSystem.this.failedDeleteException = null;
            UnifiedBuildSystem.this.lastFilesBuilt = 0;
            UnifiedBuildSystem.this.lastBuildStatus = 0;
            UnifiedBuildSystem.this.lastBuildTime = 0L;
            this.buildLog = buildLog;
            this.refreshApplication = refreshApplication;
        }

        private void checkForCanceledBuild() {
            if (this.buildCanceled) {
                Collection<BuildSystemListener> buildSystemListeners = JCompiler.getInstance().getBuildSystemListeners();
                for (BuildSystemListener listener : buildSystemListeners) {
                    if (!(listener instanceof BuildSystemListener2)) continue;
                    ((BuildSystemListener2)listener).buildCanceled(this.context);
                }
                throw new RuntimeException(CompArb.getString(76));
            }
        }

        private void cancelBuild() {
            this.buildCanceled = true;
            this.checkForCanceledBuild();
        }

        private Storage getStorageForNode(URL url) {
            IdeStorage stor;
            Node node;
            if (url == null) {
                return null;
            }
            if (url.getRef() != null) {
                return null;
            }
            Node node2 = node = this.saveBeforeCompile ? null : NodeFactory.find((URL)url);
            if (node != null && node.isDirty() || !"file".equals(url.getProtocol())) {
                if (node == null) {
                    try {
                        node = NodeFactory.findOrCreate((URL)url);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                stor = new IdeStorage(node);
            } else {
                int dotIndex;
                String urlPath = url.getPath();
                if (this.currentProjectHasEmptyTechScope && node == null && (dotIndex = urlPath.lastIndexOf(46)) > 0 && !recognizedExtensions.contains(urlPath.substring(dotIndex))) {
                    NodeFactory.recognizeUrl((URL)url);
                }
                stor = Helpers.createFileStorage(urlPath);
            }
            if (node != null) {
                stor.setProperty("nodeClassObject", node.getClass());
            }
            return stor;
        }

        private void processElement(URL url, ArrayList<Storage> result, HashMap<String, Storage> dupCache, ExcludedUrlChecker excludedUrlChecker) {
            String path;
            if (excludedUrlChecker != null && excludedUrlChecker.excludeUrl(url)) {
                return;
            }
            Storage store = this.getStorageForNode(url);
            if (store != null && dupCache.get(path = store.getPath()) == null) {
                result.add(store);
                dupCache.put(path, store);
            }
        }

        private void getProjectFileList(URL dirUrl, ArrayList<Storage> result, HashMap<String, Storage> dupCache, ExcludedUrlChecker excludedUrlChecker) {
            if (excludedUrlChecker != null && excludedUrlChecker.excludeUrl(dirUrl)) {
                return;
            }
            URL[] children = URLFileSystem.list((URL)dirUrl);
            if (children != null) {
                for (URL url : children) {
                    if (GlobalIgnoreList.isGloballyIgnored((URL)url)) continue;
                    if (URLFileSystem.isDirectory((URL)url)) {
                        this.getProjectFileList(url, result, dupCache, excludedUrlChecker);
                        continue;
                    }
                    if (!URLFileSystem.exists((URL)url)) continue;
                    this.processElement(url, result, dupCache, excludedUrlChecker);
                }
            }
        }

        private void getProjectFileList(Project prj, String relPath, IntersectedFilters filters, ArrayList<Storage> result, HashMap<String, Storage> dupCache, ExcludedUrlChecker excludedUrlChecker) {
            assert (logger.trace("getProjectFileList(Project, ...)"));
            Iterator iter = ProjectContent.getInstance((PropertyStorage)prj).getAllContents().urlIterator(relPath, filters);
            while (iter.hasNext()) {
                URL file = (URL)iter.next();
                assert (logger.trace("   project file: " + URLFileSystem.getPath((URL)file)));
                this.checkForCanceledBuild();
                this.processElement(file, result, dupCache, excludedUrlChecker);
            }
        }

        private void getProjectFileList(Workspace ws, Project prj, ArrayList<Storage> result, HashMap<String, Storage> dupCache, ExcludedUrlChecker excludedUrlChecker) {
            URL[] urls;
            assert (logger.trace("getProjectFileList(Workspace, ...)"));
            QueryCriteria criteria = new QueryCriteria();
            criteria.put((Object)"file.all", (Object)"");
            for (URL url : urls = Helpers.getUrlsThroughIndexer(ws, prj, criteria, this.buildLog)) {
                assert (logger.trace("   project file: " + URLFileSystem.getPath((URL)url)));
                this.checkForCanceledBuild();
                this.processElement(url, result, dupCache, excludedUrlChecker);
            }
        }

        private void getFolderFileList(Folder folder, ArrayList<Storage> result, HashMap<String, Storage> dupCache, ExcludedUrlChecker excludedUrlChecker) {
            Iterator iter = folder.getChildren();
            while (iter.hasNext()) {
                Element elem = (Element)iter.next();
                this.checkForCanceledBuild();
                if (elem instanceof Locatable) {
                    this.processElement(((Locatable)elem).getURL(), result, dupCache, excludedUrlChecker);
                }
                if (!(elem instanceof Folder)) continue;
                this.getFolderFileList((Folder)elem, result, dupCache, excludedUrlChecker);
            }
        }

        private boolean makeSureResultsAreStorageInstances(List<Storage> al) {
            if (al == null) {
                return true;
            }
            for (int i = 0; i < al.size(); ++i) {
                if (al.get(i) instanceof Storage) continue;
                return false;
            }
            return true;
        }

        private void delete(boolean bypassNodeCreationsDuringDelete, Callable<Boolean> call) throws Exception {
            try {
                if (bypassNodeCreationsDuringDelete) {
                    Node.bypassNodeCreationsDuringDelete(call);
                } else {
                    call.call();
                }
            }
            catch (IOException ioe) {
                if (this.stopOnFailedDelete) {
                    UnifiedBuildSystem.this.failedDeleteException = ioe;
                    throw new FailedDeleteException();
                }
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(CompArb.getString(76));
            }
        }

        private void delete(URL url, boolean bypassNodeCreationsDuringDelete) throws Exception {
            if (URLFileSystem.exists((URL)url)) {
                this.delete(bypassNodeCreationsDuringDelete, () -> {
                    VCSManager.getVCSManager().deleteRecursively(url, null, !this.stopOnFailedDelete);
                    return true;
                });
            }
        }

        private void recursivelyDeleteDir(URL dir, boolean bypassNodeCreationsDuringDelete) throws Exception {
            this.delete(bypassNodeCreationsDuringDelete, () -> {
                URLFilter filter = new URLFilter(){

                    public final boolean accept(URL url) {
                        return !GlobalIgnoreList.isGloballyIgnored((URL)url) || ".cdi".equals(URLFileSystem.getSuffix((URL)url));
                    }
                };
                VCSManager.getVCSManager().deleteRecursively(dir, filter, !this.stopOnFailedDelete);
                return true;
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int cleanProject(Workspace ws, Project prj, boolean projectAutoClean, boolean addCancelOption) throws Exception {
            long beginTime = System.currentTimeMillis();
            JCompiler jCompiler = JCompiler.getInstance();
            Ide.getStatusBar().setText(CompArb.format(163, prj.getShortLabel()));
            this.getNewListeners(ws, prj);
            Context localContext = new Context();
            localContext.setWorkspace(ws);
            localContext.setProject(prj);
            this.invokeListenersBegin(jCompiler.getBuildSystemListeners(), localContext, ideLog, JCompiler.QueueAction.PROJECT_CLEAN_WILL_START, JCompiler.QueueAction.PROJECT_CLEAN_FINISHED);
            try {
                int n = this.cleanProjectImpl(ws, prj, projectAutoClean, addCancelOption);
                return n;
            }
            finally {
                this.invokeListenersFinish(jCompiler.getBuildSystemListeners(), localContext, ideLog, JCompiler.QueueAction.PROJECT_CLEAN_FINISHED, false);
                assert (STATISTICS_LOGGER.trace("Time to clean project " + prj.getShortLabel() + ": " + (System.currentTimeMillis() - beginTime) + " msec"));
            }
        }

        private int cleanProjectImpl(Workspace ws, Project prj, boolean projectAutoClean, boolean addCancelOption) throws Exception {
            URL absoluteDeployDir;
            this.checkForCanceledBuild();
            String title = CompArb.format(70, prj.getShortLabel());
            URL outputDir = JavaProject.getInstance((Project)prj).getOutputDirectory();
            if (outputDir == null) {
                String message = CompArb.getString(71);
                if (!projectAutoClean) {
                    ideLog.error(null, 0, 0, 0, message);
                    this.cancelBuild();
                } else {
                    JCompiler.getInstance().logOutMsg(message + "\n");
                }
                return 2;
            }
            if (URLFileSystem.exists((URL)outputDir)) {
                if (!URLFileSystem.isDirectory((URL)outputDir)) {
                    String message = CompArb.getString(74);
                    if (!projectAutoClean) {
                        ideLog.error(null, 0, 0, 0, message);
                        this.cancelBuild();
                    } else {
                        JCompiler.getInstance().logOutMsg(message + "\n");
                    }
                    return 2;
                }
                if (URLFileSystem.isBaseURLFor((URL)outputDir, (URL)prj.getURL())) {
                    String message = CompArb.format(176, URLFileSystem.getPlatformPathName((URL)prj.getURL()), URLFileSystem.getPlatformPathName((URL)outputDir));
                    if (!projectAutoClean) {
                        ideLog.error(null, 0, 0, 0, message);
                        this.cancelBuild();
                    } else {
                        JCompiler.getInstance().logOutMsg(message + "\n");
                    }
                    return 2;
                }
                if (URLFileSystem.getParent((URL)outputDir) == null) {
                    if (projectAutoClean) {
                        String message = CompArb.format(177, URLFileSystem.getPlatformPathName((URL)outputDir));
                        JCompiler.getInstance().logOutMsg(message + "\n");
                        return 2;
                    }
                    String cleanProjectOutputID = "cleanProject-outputToRootDir";
                    if (addCancelOption) {
                        int result = MessageDialog.optionalConfirmOrCancel((String)"cleanProject-outputToRootDir", (Component)Ide.getMainWindow(), (Object)CompArb.getString(72), (String)title, (String)"f1_com_dcleantarget_html");
                        if (result != 1) {
                            MessageDialog.getPersistence().setConfirmed("cleanProject-outputToRootDir", null);
                            if (result == -1) {
                                this.cancelBuild();
                            }
                            return 2;
                        }
                    } else if (!MessageDialog.optionalConfirm((String)"cleanProject-outputToRootDir", (Component)Ide.getMainWindow(), (Object)CompArb.getString(72), (String)title, (String)"f1_com_dcleantarget_html")) {
                        MessageDialog.getPersistence().setConfirmed("cleanProject-outputToRootDir", null);
                        this.cancelBuild();
                    }
                }
            } else {
                outputDir = null;
            }
            URL relativeDeployDir = null;
            DeploymentOptions deploymentOptions = DeploymentOptions.getDefault(DeploymentOptions.class);
            String relativeOutputFolder = deploymentOptions.getProjectRelativeOutputFolder();
            URL projectDir = URLFileSystem.getParent((URL)prj.getURL());
            if (projectDir != null && relativeOutputFolder != null && (relativeDeployDir = URLFactory.newDirURL((URL)projectDir, (String)relativeOutputFolder)) != null && !URLFileSystem.isDirectory((URL)relativeDeployDir)) {
                relativeDeployDir = null;
            }
            if ((absoluteDeployDir = deploymentOptions.getProjectAbsoluteOutputURL()) != null && !URLFileSystem.isDirectory((URL)absoluteDeployDir)) {
                absoluteDeployDir = null;
            }
            if (outputDir == null && relativeDeployDir == null && absoluteDeployDir == null) {
                return 1;
            }
            if (!projectAutoClean) {
                StringBuilder buf = new StringBuilder();
                if (outputDir != null) {
                    buf.append(URLFileSystem.getPlatformPathName((URL)outputDir));
                }
                if (relativeDeployDir != null) {
                    if (outputDir != null) {
                        buf.append(", ");
                    }
                    buf.append(URLFileSystem.getPlatformPathName((URL)relativeDeployDir));
                }
                if (absoluteDeployDir != null) {
                    if (outputDir != null) {
                        buf.append(", ");
                    }
                    buf.append(URLFileSystem.getPlatformPathName((URL)absoluteDeployDir));
                }
                String cleanProjectNormalID = "cleanProject-normal";
                if (addCancelOption) {
                    int result = MessageDialog.optionalConfirmOrCancel((String)"cleanProject-normal", (Component)Ide.getMainWindow(), (Object)CompArb.format(73, buf.toString()), (String)title, (String)"f1_com_dcleantarget_html");
                    if (result != 1) {
                        MessageDialog.getPersistence().setConfirmed("cleanProject-normal", null);
                        if (result == -1) {
                            this.cancelBuild();
                        }
                        return 2;
                    }
                } else if (!MessageDialog.optionalConfirm((String)"cleanProject-normal", (Component)Ide.getMainWindow(), (Object)CompArb.format(73, buf.toString()), (String)title, (String)"f1_com_dcleantarget_html")) {
                    MessageDialog.getPersistence().setConfirmed("cleanProject-normal", null);
                    this.cancelBuild();
                }
            }
            boolean wsBypassNodeCreationsDuringDelete = ws == null ? false : BuildSystemConfiguration.getInstance((PropertyStorage)ws).isBypassNodeCreationsDuringDelete();
            boolean prjBypassNodeCreationsDuringDelete = wsBypassNodeCreationsDuringDelete ? true : BuildSystemConfiguration.getInstance((PropertyStorage)prj).isBypassNodeCreationsDuringDelete();
            File cdiFile = BuildSystemUtilities.getCdiFile(prj);
            if (cdiFile != null) {
                URL javacCdiUrl = URLFactory.newFileURL((File)cdiFile);
                this.delete(javacCdiUrl, prjBypassNodeCreationsDuringDelete);
            }
            if (outputDir != null) {
                this.recursivelyDeleteDir(outputDir, prjBypassNodeCreationsDuringDelete);
            }
            if (relativeDeployDir != null) {
                this.recursivelyDeleteDir(relativeDeployDir, prjBypassNodeCreationsDuringDelete);
            }
            if (absoluteDeployDir != null) {
                this.recursivelyDeleteDir(absoluteDeployDir, prjBypassNodeCreationsDuringDelete);
            }
            return 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean cleanWorkspace(Workspace workSpace) throws Exception {
            if (workSpace == null || workSpace.getBaseDirectory() == null) {
                return false;
            }
            long beginTime = System.currentTimeMillis();
            this.getNewListeners(workSpace, null);
            JCompiler jCompiler = JCompiler.getInstance();
            Context localContext = new Context();
            localContext.setWorkspace(workSpace);
            this.invokeListenersBegin(jCompiler.getBuildSystemListeners(), localContext, ideLog, JCompiler.QueueAction.WORKSPACE_CLEAN_WILL_START, JCompiler.QueueAction.WORKSPACE_CLEAN_FINISHED);
            try {
                boolean bl = this.cleanWorkspaceImpl(workSpace);
                return bl;
            }
            finally {
                this.invokeListenersFinish(jCompiler.getBuildSystemListeners(), localContext, ideLog, JCompiler.QueueAction.WORKSPACE_CLEAN_FINISHED, false);
                assert (STATISTICS_LOGGER.trace("Time to clean workspace " + workSpace.getShortLabel() + ": " + (System.currentTimeMillis() - beginTime) + " msec"));
            }
        }

        private boolean cleanWorkspaceImpl(Workspace workSpace) throws Exception {
            URL absoluteDeployDir;
            URL relativeDeployDir;
            if (!this.autoClean) {
                String helpID;
                String cleanApplicationID = this.refreshApplication ? "cleanAndRefreshApplication" : "cleanApplication";
                String title = this.refreshApplication ? CompArb.format(148, workSpace.getShortLabel()) : CompArb.format(70, workSpace.getShortLabel());
                String message = this.refreshApplication ? CompArb.format(145, workSpace.getLongLabel()) : CompArb.format(95, workSpace.getLongLabel());
                String string = helpID = this.refreshApplication ? "f1_com_cleanallrefreshapp_html" : "f1_com_dcleantarget_html";
                if (!MessageDialog.optionalConfirm((String)cleanApplicationID, (Component)Ide.getMainWindow(), (Object)message, (String)title, (String)helpID)) {
                    MessageDialog.getPersistence().setConfirmed(cleanApplicationID, null);
                    return false;
                }
            }
            Iterator childIter = workSpace.getChildren();
            while (childIter.hasNext()) {
                this.checkForCanceledBuild();
                Element element = (Element)childIter.next();
                if (!(element instanceof Project)) continue;
                this.cleanProject(workSpace, (Project)element, true, false);
            }
            boolean bypassNodeCreationsDuringDelete = BuildSystemConfiguration.getInstance((PropertyStorage)workSpace).isBypassNodeCreationsDuringDelete();
            DeploymentOptions deploymentOptions = DeploymentOptions.getDefault(DeploymentOptions.class);
            String relativeOutputFolder = deploymentOptions.getApplicationRelativeOutputFolder();
            URL workSpaceDir = URLFileSystem.getParent((URL)workSpace.getURL());
            if (workSpaceDir != null && relativeOutputFolder != null && (relativeDeployDir = URLFactory.newDirURL((URL)workSpaceDir, (String)relativeOutputFolder)) != null && URLFileSystem.isDirectory((URL)relativeDeployDir)) {
                this.recursivelyDeleteDir(relativeDeployDir, bypassNodeCreationsDuringDelete);
            }
            if ((absoluteDeployDir = deploymentOptions.getApplicationAbsoluteOutputURL()) != null && URLFileSystem.isDirectory((URL)absoluteDeployDir)) {
                this.recursivelyDeleteDir(absoluteDeployDir, bypassNodeCreationsDuringDelete);
            }
            if (this.refreshApplication) {
                try {
                    RefreshApplicationController.refreshApplication(this.context);
                }
                catch (Exception e) {
                    throw new RuntimeException(CompArb.format(144, e.getMessage()));
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void buildGraph(ArrayList<Storage> files, Project prj, boolean rebuild) {
            if (files == null || files.size() <= 0 || prj == null) {
                return;
            }
            ArrayList<TranslatorDefinition> translatorDefinitions = this.buildGraph.getOrderedTranslatorList();
            assert (TRANSLATOR_LOGGER.trace("Ordered list of translators:"));
            for (TranslatorDefinition translatorDefinition : translatorDefinitions) {
                assert (TRANSLATOR_LOGGER.trace("    translator: {0}", (Object)translatorDefinition.getName()));
            }
            for (TranslatorDefinition translatorDefinition : UnifiedBuildSystem.this.getRegisteredTranslatorDefinitions()) {
                if (translatorDefinitions.indexOf((Object)translatorDefinition) != -1) continue;
                assert (TRANSLATOR_LOGGER.trace("Append {0} to ordered list of translators", (Object)translatorDefinition.getName()));
                translatorDefinitions.add(translatorDefinition);
            }
            HashMap<Storage, Storage> generatedFiles = new HashMap<Storage, Storage>();
            try {
                Workspace workspace = ideLog.getWorkspace();
                Project project = ideLog.getProject();
                Iterator<TranslatorDefinition> iterator = UnifiedBuildSystem.this.markingLock;
                synchronized (iterator) {
                    LinkedHashMap<Project, List<String>> compiledProjects;
                    Map<Project, Set<Storage>> suppressedProjects;
                    LinkedHashMap<Project, Set<Storage>> translatedProjects = (LinkedHashMap<Project, Set<Storage>>)UnifiedBuildSystem.this.translatedWorkspaces.get(workspace);
                    if (translatedProjects == null) {
                        translatedProjects = new LinkedHashMap<Project, Set<Storage>>();
                        UnifiedBuildSystem.this.translatedWorkspaces.put(workspace, translatedProjects);
                    }
                    if ((suppressedProjects = this.suppressedWorkspaces.get(workspace)) == null) {
                        suppressedProjects = new LinkedHashMap<Project, Set<Storage>>();
                        this.suppressedWorkspaces.put(workspace, suppressedProjects);
                    }
                    if ((compiledProjects = (LinkedHashMap<Project, List<String>>)UnifiedBuildSystem.this.compiledWorkspaces.get(workspace)) == null) {
                        compiledProjects = new LinkedHashMap<Project, List<String>>();
                        UnifiedBuildSystem.this.compiledWorkspaces.put(workspace, compiledProjects);
                    }
                    this.translatedSources = (Set)translatedProjects.get(project);
                    if (this.translatedSources == null) {
                        this.translatedSources = new LinkedHashSet<Storage>();
                        translatedProjects.put(project, this.translatedSources);
                    }
                    this.suppressedSources = suppressedProjects.get(project);
                    if (this.suppressedSources == null) {
                        this.suppressedSources = new LinkedHashSet<Storage>();
                        suppressedProjects.put(project, this.suppressedSources);
                    }
                    this.compiledClasses = (List)compiledProjects.get(project);
                    if (this.compiledClasses == null) {
                        this.compiledClasses = new ArrayList<String>();
                        compiledProjects.put(project, this.compiledClasses);
                    }
                }
                for (TranslatorDefinition translatorDefinition : translatorDefinitions) {
                    Translator translator;
                    this.checkForCanceledBuild();
                    if (!translatorDefinition.conditionsSatisfied(workspace, prj) || (translator = (Translator)translatorDefinition.retrieveBuildTool()) == null) continue;
                    try {
                        URL url;
                        this.beginTranslator(translator);
                        translator.setProject(prj);
                        if (translator instanceof Translator2) {
                            ((Translator2)translator).setWorkspace(workspace);
                        }
                        translator.setLog(ideLog);
                        ArrayList<Storage> inputFiles = new ArrayList<Storage>();
                        for (int j = 0; j < files.size(); ++j) {
                            Storage s = files.get(j);
                            if (translator.canBuild(s)) {
                                inputFiles.add(s);
                                this.markTranslateable(translator, s);
                                continue;
                            }
                            if (!translator.needToBuild(s)) continue;
                            inputFiles.add(s);
                        }
                        if (inputFiles.size() <= 0) continue;
                        int errCnt = ideLog.nerrors();
                        ArrayList<Storage> results = new ArrayList<Storage>();
                        Map javaOptions = this.compileArguments.getJavaCompilerOptions();
                        if (!javaOptions.isEmpty() && UnifiedBuildSystem.this.getJavaTranslator(workspace, prj) == translator) {
                            Set entrySet = javaOptions.entrySet();
                            for (Map.Entry entry : entrySet) {
                                translator.setParameter("JavacOption:" + (String)entry.getKey(), (String)entry.getValue());
                            }
                        }
                        translator.translate(prj, rebuild, inputFiles, results);
                        Assert.check((boolean)this.makeSureResultsAreStorageInstances(results));
                        int nerrors = ideLog.nerrors() - errCnt;
                        if (nerrors <= 0 && results.size() > 0) {
                            if (translatorDefinition.isPreprocessor()) {
                                for (Storage inputFile : inputFiles) {
                                    if (!translator.canBuild(inputFile)) continue;
                                    if (results.contains(inputFile)) {
                                        results.remove(inputFile);
                                        continue;
                                    }
                                    files.remove(inputFile);
                                }
                            }
                            for (Storage s : results) {
                                assert (TRANSLATOR_LOGGER.trace("preprocess created {0}", (Object)s));
                                s.setProperty(UnifiedBuildSystem.PREPROCESSOR_GENERATED_PROPERTY, (Object)Boolean.TRUE);
                                files.add(s);
                                generatedFiles.put(s, s);
                            }
                        }
                        if (nerrors <= 0) continue;
                        for (Storage s : inputFiles) {
                            if (generatedFiles.get(s) != s) continue;
                            url = URLFactory.newFileURL((String)s.getPath());
                            URLFileSystem.delete((URL)url);
                            generatedFiles.remove(s);
                        }
                        for (Storage s : results) {
                            url = URLFactory.newFileURL((String)s.getPath());
                            URLFileSystem.delete((URL)url);
                        }
                    }
                    finally {
                        translator.setProject(null);
                        if (translator instanceof Translator2) {
                            ((Translator2)translator).setWorkspace(null);
                        }
                        translator.setLog(null);
                        this.endTranslator(translator);
                    }
                }
            }
            finally {
                Object object = UnifiedBuildSystem.this.markingLock;
                synchronized (object) {
                    this.translatedSources = null;
                    this.suppressedSources = null;
                    this.compiledClasses = null;
                    this.translateableSources.clear();
                    this.marking.clear();
                }
            }
        }

        int buildFilesInThread(Project prj, ArrayList<Storage> files, boolean rebuild) {
            int errCnt = ideLog.nerrors();
            this.buildGraph(files, prj, rebuild);
            return ideLog.nerrors() - errCnt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void buildProjectFiles(Workspace wsp, Project prj, Element[] elements) throws Exception {
            if (elements == null) {
                Ide.getStatusBar().setText(CompArb.format(151, prj.getShortLabel()));
            }
            long beginTime = System.currentTimeMillis();
            this.getNewListeners(wsp, prj);
            JCompiler jCompiler = JCompiler.getInstance();
            Context localContext = new Context();
            localContext.setWorkspace(wsp);
            localContext.setProject(prj);
            this.invokeListenersBegin(jCompiler.getBuildSystemListeners(), localContext, ideLog, JCompiler.QueueAction.PROJECT_BUILD_WILL_START, JCompiler.QueueAction.PROJECT_BUILD_FINISHED);
            try {
                this.buildProjectFilesImpl(wsp, prj, elements);
            }
            finally {
                this.invokeListenersFinish(jCompiler.getBuildSystemListeners(), localContext, ideLog, JCompiler.QueueAction.PROJECT_BUILD_FINISHED, false);
                assert (STATISTICS_LOGGER.trace("Time to build project " + prj.getShortLabel() + ": " + (System.currentTimeMillis() - beginTime) + " msec"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void buildProjectFilesImpl(Workspace wsp, Project prj, Element[] elements) throws Exception {
            boolean rebuild;
            this.checkForCanceledBuild();
            if (prj == null) {
                ideLog.error(null, 0, 0, 0, CompArb.getString(120));
                return;
            }
            if (this.projectsBuilt.contains(prj)) {
                return;
            }
            if (elements == null) {
                this.projectsBuilt.add(prj);
            }
            TechnologyScopeConfiguration techScopeConfig = TechnologyScopeConfiguration.getInstance((PropertyStorage)prj);
            TechnologyScope techScope = techScopeConfig.getTechnologyScope();
            this.currentProjectHasEmptyTechScope = techScope.isEmpty();
            prj.getTransientProperties().put("rebuild", this.compileArguments.isRebuildAllSources() && elements == null);
            boolean forceRebuild = this.compileArguments.isForceRebuildOnProjectChanges() && JCompiler.getInstance().forceRebuildOnProject(prj);
            boolean bl = rebuild = forceRebuild || this.compileArguments.isRebuildAllSources();
            if (rebuild && elements == null && this.cleanProjectBeforeRebuild && !this.autoClean && !this.compileArguments.isNoCleanBeforeRebuild()) {
                if (showCompileProgress) {
                    String cleanStr = CompArb.format(70, prj.getShortLabel());
                    JCompiler.getInstance().logOutMsg(cleanStr + "\n");
                }
                this.cleanProject(wsp, prj, true, false);
                Ide.getStatusBar().setText(CompArb.format(151, prj.getShortLabel()));
            }
            Workspace prevWsp = ideLog.getWorkspace();
            Project prevPrj = ideLog.getProject();
            try {
                Object p;
                ideLog.setWorkspace(wsp);
                ideLog.setProject(prj);
                ArrayList<Storage> files = new ArrayList<Storage>(64);
                ExcludedUrlChecker excludedUrlChecker = ExcludedUrlChecker.getInstance(prj);
                try {
                    PerformanceLogger.get().startTiming(this.getClass().getName());
                    HashMap<String, Storage> dupCache = new HashMap<String, Storage>();
                    if (elements != null) {
                        for (int i = 0; i < elements.length; ++i) {
                            Element element = elements[i];
                            if (element instanceof WorkingSetNode) {
                                WorkingSetNode n = (WorkingSetNode)element;
                                this.getProjectFileList(prj, null, n.getFilters(), files, dupCache, excludedUrlChecker);
                                continue;
                            }
                            if (element instanceof RelativeDirectoryContextFolder) {
                                RelativeDirectoryContextFolder rd = (RelativeDirectoryContextFolder)element;
                                String relativePath = rd.getRelativePath();
                                URLPath urlPath = rd.getRootDirectories();
                                for (URL urlDir : urlPath.asList()) {
                                    urlDir = URLFactory.newDirURL((URL)urlDir, (String)relativePath);
                                    this.getProjectFileList(urlDir, files, dupCache, excludedUrlChecker);
                                }
                                continue;
                            }
                            if (element instanceof Locatable) {
                                this.processElement(((Locatable)element).getURL(), files, dupCache, excludedUrlChecker);
                            }
                            if (!(element instanceof Folder)) continue;
                            this.getFolderFileList((Folder)element, files, dupCache, excludedUrlChecker);
                        }
                    } else {
                        this.getProjectFileList(wsp, prj, files, dupCache, excludedUrlChecker);
                    }
                    dupCache.clear();
                    this.filesBuilt += files.size();
                    if (files.size() <= 0) {
                        return;
                    }
                }
                finally {
                    PerformanceLogger.get().stopTiming(this.getClass().getName(), "Build System --> " + files.size() + " files to process");
                }
                this.checkForCanceledBuild();
                if (elements == null) {
                    ideLog.clear(null);
                } else {
                    for (int i = 0; i < files.size(); ++i) {
                        Storage stor = files.get(i);
                        if (stor.getPath().endsWith(".java")) continue;
                        ideLog.clear(files.get(i));
                    }
                }
                URL outputDirUrl = JavaProject.getInstance((Project)prj).getOutputDirectory();
                if (outputDirUrl == null) {
                    ideLog.error(null, 0, 0, 0, CompArb.getString(61));
                    this.cancelBuild();
                }
                if (URLFileSystem.exists((URL)outputDirUrl) && !URLFileSystem.isDirectory((URL)outputDirUrl)) {
                    ideLog.error(null, 0, 0, 0, CompArb.getString(74));
                    this.cancelBuild();
                }
                if (this.warnOnSourceNotInProject && files.size() == 1 && ((p = this.context.getProperty("disableFileNotInProjectWarning")) == null || p == Boolean.FALSE)) {
                    ideLog.warning(null, 0, 0, 0, CompArb.format(79, files.get(0).getPath(), prj.getShortLabel()));
                }
                ArrayList<Storage> uixFiles = new ArrayList<Storage>(64);
                HashSet<String> extensions = new HashSet<String>(64);
                for (int i = files.size() - 1; i >= 0; --i) {
                    Storage f = files.get(i);
                    String n = f.getName();
                    int dotIndex = n.lastIndexOf(46);
                    if (dotIndex > 0) {
                        extensions.add(n.substring(dotIndex));
                    } else {
                        extensions.add(".unknown");
                    }
                    if (!n.endsWith(".uix") && !n.endsWith(".uit")) continue;
                    uixFiles.add(f);
                    files.remove(i);
                }
                UnifiedBuildSystem.this.primeTranslators(extensions, wsp, prj);
                this.buildGraph(files, prj, rebuild);
                this.buildGraph(uixFiles, prj, rebuild);
                files.addAll(uixFiles);
                Object object = UnifiedBuildSystem.this.markingLock;
                synchronized (object) {
                    LinkedHashMap<Project, LinkedHashSet<Storage>> projectFiles = (LinkedHashMap<Project, LinkedHashSet<Storage>>)UnifiedBuildSystem.this.consideredFiles.get(wsp);
                    if (projectFiles == null) {
                        projectFiles = new LinkedHashMap<Project, LinkedHashSet<Storage>>();
                    }
                    projectFiles.put(prj, new LinkedHashSet<Storage>(files));
                    UnifiedBuildSystem.this.consideredFiles.put(wsp, projectFiles);
                }
            }
            finally {
                ideLog.setWorkspace(prevWsp);
                ideLog.setProject(prevPrj);
            }
        }

        private void buildDepProfile(Profile prf) throws Exception {
            this.checkForCanceledBuild();
            DataContainer prj = prf.getDataContainer();
            if (this.deploymentProfileBuilt.get(prf) == prj) {
                return;
            }
            this.deploymentProfileBuilt.put(prf, prj);
            Iterator dependenciesIter = prf.getDependencies();
            int errCnt = ideLog.nerrors();
            while (dependenciesIter.hasNext()) {
                Dependable d = (Dependable)dependenciesIter.next();
                Element e = d.getSource();
                if (e instanceof Project) {
                    this.buildProjectFiles(null, (Project)e, null);
                    continue;
                }
                if (!(e instanceof Profile)) continue;
                this.buildDepProfile((Profile)e);
            }
            if (prj instanceof Project && ideLog.nerrors() <= errCnt) {
                this.buildProjectFiles(null, (Project)prj, null);
            }
            if (ideLog.nerrors() <= errCnt) {
                try {
                    DeployCommandFactory dcf = DeployCommandFactory.getInstance();
                    DeployCommand cmd = dcf.create((Element)prf, this.context);
                    DeploymentOptions options = cmd.getDeploymentOptions(DeploymentOptions.class);
                    options.setCompileBeforeDeploy(false);
                    cmd.setSynchronous(true);
                    cmd.doit();
                }
                catch (Exception e) {
                    JCompiler.getInstance().logOutMsg(e.getMessage());
                    Assert.printStackTrace((Throwable)e);
                }
            }
        }

        private void buildProject(Workspace wsp, Project prj) throws Exception {
            boolean onlyThisProject;
            boolean bl = onlyThisProject = !this.compileArguments.isCompileDependencies() || this.context.getBoolean("buildsystem.dont.compile.dependencies") || this.context.getBoolean("buildsystem.dont.compile.dependent.projects");
            if (!onlyThisProject) {
                for (Dependable dependable : DependencyConfiguration.getInstance((Project)prj).getAllDependenciesList()) {
                    Element source = dependable.getSource();
                    Folder owner = dependable.getSourceOwner();
                    if (source instanceof Project) {
                        Workspace w = owner instanceof Workspace ? (Workspace)owner : null;
                        this.buildProjectFiles(w, (Project)source, null);
                        continue;
                    }
                    if (!(source instanceof Profile) || !(owner instanceof Project)) continue;
                    this.buildDepProfile((Profile)source);
                }
            }
            this.buildProjectFiles(wsp, prj, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void buildWorkspace(Workspace wsp) throws Exception {
            long beginTime = System.currentTimeMillis();
            this.getNewListeners(wsp, null);
            JCompiler jCompiler = JCompiler.getInstance();
            Context localContext = new Context();
            localContext.setWorkspace(wsp);
            this.invokeListenersBegin(jCompiler.getBuildSystemListeners(), localContext, ideLog, JCompiler.QueueAction.WORKSPACE_BUILD_WILL_START, JCompiler.QueueAction.WORKSPACE_BUILD_FINISHED);
            try {
                this.buildWorkspaceImpl(wsp);
            }
            finally {
                this.invokeListenersFinish(jCompiler.getBuildSystemListeners(), localContext, ideLog, JCompiler.QueueAction.WORKSPACE_BUILD_FINISHED, false);
                assert (STATISTICS_LOGGER.trace("Time to build workspace " + wsp.getShortLabel() + ": " + (System.currentTimeMillis() - beginTime) + " msec"));
            }
        }

        private void buildWorkspaceImpl(Workspace wsp) throws Exception {
            ideLog.setWorkspace(wsp);
            Iterator childIter = wsp.getChildren();
            while (childIter.hasNext()) {
                Element element = (Element)childIter.next();
                if (!(element instanceof Project)) continue;
                this.buildProject(wsp, (Project)element);
            }
        }

        private void buildAll(Element[] elements) throws Exception {
            if (elements[0] instanceof Workspaces) {
                Iterator childIter = elements[0].getChildren();
                while (childIter.hasNext()) {
                    Element element = (Element)childIter.next();
                    if (!(element instanceof Workspace)) continue;
                    this.buildWorkspace((Workspace)element);
                }
            } else if (elements[0] instanceof Workspace) {
                for (int i = 0; i < elements.length; ++i) {
                    Element element = elements[i];
                    Assert.check((boolean)(element instanceof Workspace), (String)"not all elements in selection are Workspaces, they must be");
                    if (!(element instanceof Workspace)) continue;
                    this.buildWorkspace((Workspace)element);
                }
            } else if (elements[0] instanceof Project) {
                for (int i = 0; i < elements.length; ++i) {
                    Element element = elements[i];
                    Assert.check((boolean)(element instanceof Project), (String)"not all elements in selection are Projects, they must be");
                    if (!(element instanceof Project)) continue;
                    Workspace workspace = this.context.getWorkspace();
                    if (!(workspace != null && workspace.containsChild(element) || (workspace = Ide.getActiveWorkspace()) != null && workspace.containsChild(element))) {
                        workspace = null;
                    }
                    this.buildProject(workspace, (Project)element);
                }
            } else if (elements[0] instanceof WorkingSetNode) {
                for (int x = 0; x < elements.length; ++x) {
                    WorkingSetNode workingSetNode = (WorkingSetNode)elements[x];
                    this.buildProjectFiles(workingSetNode.wsp, workingSetNode.project, new Element[]{workingSetNode});
                }
            } else {
                if (elements.length == 1 && elements[0] instanceof Locatable && !elements[0].mayHaveChildren() && !CmJavaUtil.isCMUrl((URL)((Locatable)elements[0]).getURL())) {
                    Context c = EditorUtil.findNodeInContext((Element)elements[0], (Context)this.context);
                    boolean bl = this.warnOnSourceNotInProject = c == null;
                    if (!this.warnOnSourceNotInProject) {
                        Context newContext = new Context(this.context);
                        newContext.setNode(c.getNode());
                        newContext.setProject(c.getProject());
                        newContext.setWorkspace(c.getWorkspace());
                        newContext.setElement((Element)c.getNode());
                        this.context = newContext;
                    }
                }
                Project prj = this.context.getProject();
                Workspace wsp = this.context.getWorkspace();
                if (prj == null) {
                    prj = Ide.getActiveProject();
                    wsp = Ide.getActiveWorkspace();
                }
                if (prj == null) {
                    prj = Ide.getDefaultProject();
                    wsp = Ide.getDefaultWorkspace();
                }
                this.buildProjectFiles(wsp, prj, elements);
                this.warnOnSourceNotInProject = false;
            }
        }

        private boolean cleanAll(Element[] elements) throws Exception {
            boolean res = true;
            if (elements[0] instanceof Workspaces) {
                Iterator childIter = elements[0].getChildren();
                while (childIter.hasNext()) {
                    res &= this.cleanAll(new Element[]{(Element)childIter.next()});
                }
            } else if (elements[0] instanceof Workspace) {
                for (int i = 0; i < elements.length; ++i) {
                    Assert.check((boolean)(elements[i] instanceof Workspace), (String)"not all elements in selection are Workspaces, they must be");
                    if (!(elements[i] instanceof Workspace)) continue;
                    res &= this.cleanWorkspace((Workspace)elements[i]);
                }
            } else if (elements[0] instanceof Project) {
                for (int i = 0; i < elements.length; ++i) {
                    Element element = elements[i];
                    Assert.check((boolean)(element instanceof Project), (String)"not all elements in selection are Projects, they must be");
                    if (!(element instanceof Project)) continue;
                    Workspace workspace = this.context.getWorkspace();
                    if (!(workspace != null && workspace.containsChild(element) || (workspace = Ide.getActiveWorkspace()) != null && workspace.containsChild(element))) {
                        workspace = null;
                    }
                    int result = this.cleanProject(workspace, (Project)element, this.autoClean, elements.length > 1);
                    res &= result == 1;
                }
            } else {
                Project prj = this.context.getProject();
                if (prj == null) {
                    prj = Ide.getActiveProject();
                }
                if (prj != null) {
                    int result;
                    Workspace ws = this.context.getWorkspace();
                    if (ws == null) {
                        ws = Ide.getActiveWorkspace();
                    }
                    res &= (result = this.cleanProject(ws, prj, this.autoClean, false)) == 1;
                }
            }
            return res;
        }

        private void getNewListeners(Workspace ws, Project prj) throws BuildSystemVetoException {
            JCompiler jCompiler = JCompiler.getInstance();
            Collection<BuildSystemListener> newListeners = jCompiler.getNewBuildSystemListeners(ws, prj, this.buildLog);
            if (this.cleanAll) {
                this.invokeListenersBegin(newListeners, this.context, ideLog, JCompiler.QueueAction.CLEAN_WILL_START, JCompiler.QueueAction.CLEAN_FINISHED);
            } else {
                this.invokeListenersBegin(newListeners, this.context, ideLog, JCompiler.QueueAction.BUILD_WILL_START, JCompiler.QueueAction.BUILD_FINISHED);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void invokeListenersBegin(Collection<BuildSystemListener> listeners, Context context, IdeLog ideLog, JCompiler.QueueAction actionBefore, JCompiler.QueueAction actionAfter) throws BuildSystemVetoException {
            BuildSystemListener[] listenerArray = listeners.toArray(new BuildSystemListener[listeners.size()]);
            boolean currentClearLogBeforeCompile = Ide.getEnvironOptions().getClearCompilerLogBeforeCompile();
            if (actionBefore == JCompiler.QueueAction.BUILD_WILL_START && !this.compileArguments.isClearLogBeforeCompile()) {
                Ide.getEnvironOptions().setClearCompilerLogBeforeCompile(false);
            }
            try {
                for (int i = 0; i < listenerArray.length; ++i) {
                    try {
                        String title = "";
                        long startTime = System.nanoTime();
                        switch (actionBefore) {
                            case BUILD_WILL_START: {
                                this.listenersStarted.add(listenerArray[i]);
                                listenerArray[i].buildWillStart(context);
                                title = "BuildSystemListener.buildWillStart()";
                                break;
                            }
                            case WORKSPACE_BUILD_WILL_START: {
                                if (!(listenerArray[i] instanceof BuildSystemListener2)) break;
                                ((BuildSystemListener2)listenerArray[i]).workspaceBuildWillStart(context.getWorkspace());
                                title = "BuildSystemListener.workspaceBuildWillStart()";
                                break;
                            }
                            case PROJECT_BUILD_WILL_START: {
                                if (!(listenerArray[i] instanceof BuildSystemListener2)) break;
                                ((BuildSystemListener2)listenerArray[i]).projectBuildWillStart(context.getWorkspace(), context.getProject());
                                title = "BuildSystemListener.projectBuildWillStart()";
                                break;
                            }
                            case CLEAN_WILL_START: {
                                this.listenersStarted.add(listenerArray[i]);
                                listenerArray[i].cleanWillStart(context);
                                title = "BuildSystemListener.cleanWillStart()";
                                break;
                            }
                            case WORKSPACE_CLEAN_WILL_START: {
                                if (!(listenerArray[i] instanceof BuildSystemListener2)) break;
                                ((BuildSystemListener2)listenerArray[i]).workspaceCleanWillStart(context.getWorkspace());
                                title = "BuildSystemListener.workspaceCleanWillStart()";
                                break;
                            }
                            case PROJECT_CLEAN_WILL_START: {
                                if (!(listenerArray[i] instanceof BuildSystemListener2)) break;
                                ((BuildSystemListener2)listenerArray[i]).projectCleanWillStart(context.getWorkspace(), context.getProject());
                                title = "BuildSystemListener.projectCleanWillStart()";
                            }
                        }
                        long endTime = System.nanoTime();
                        PerformanceLogger.get().log(title, listenerArray[i].getClass().getName(), endTime - startTime);
                        continue;
                    }
                    catch (BuildSystemVetoException ex) {
                        ideLog.error(null, 0, 0, 0, "Build System veto exception: " + ex.getMessage());
                        if (actionBefore != JCompiler.QueueAction.BUILD_WILL_START && actionBefore != JCompiler.QueueAction.CLEAN_WILL_START) {
                            JCompiler jCompiler = JCompiler.getInstance();
                            for (int j = 0; j <= i; ++j) {
                                jCompiler.queueBuildSystemListener(listenerArray[j], context, ideLog, actionAfter);
                            }
                        }
                        throw ex;
                    }
                }
            }
            finally {
                if (actionBefore == JCompiler.QueueAction.BUILD_WILL_START) {
                    Ide.getEnvironOptions().setClearCompilerLogBeforeCompile(currentClearLogBeforeCompile);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void invokeListenersFinish(Collection<BuildSystemListener> listeners, Context context, IdeLog ideLog, JCompiler.QueueAction action, boolean queue) throws BuildSystemVetoException {
            Collection<BuildSystemListener> collection = listeners;
            synchronized (collection) {
                BuildSystemVetoException exception = null;
                JCompiler jCompiler = JCompiler.getInstance();
                for (BuildSystemListener listener : listeners) {
                    try {
                        if (queue) {
                            jCompiler.queueBuildSystemListener(listener, context, ideLog, action);
                            continue;
                        }
                        JCompiler.finishBuildSystemListener(action, listener, context, ideLog);
                    }
                    catch (BuildSystemVetoException bve) {
                        exception = bve;
                    }
                }
                if (exception != null) {
                    throw exception;
                }
            }
        }

        private Element[] getElementsToBuild() {
            IdeAction compileAction;
            Element[] elements = this.context.getSelection();
            boolean nonBuildableElements = elements == null || elements.length == 0;
            for (int i = 0; !nonBuildableElements && i < elements.length; ++i) {
                Element element = elements[i];
                if (element == null) {
                    nonBuildableElements = true;
                    continue;
                }
                Attributes attributes = element.getAttributes();
                if (attributes.isSet(ElementAttributes.BUILDABLE)) continue;
                nonBuildableElements = true;
            }
            if (nonBuildableElements && this.context.getNode() != null) {
                elements = new Element[]{this.context.getNode()};
            }
            if ((compileAction = CompilerContext.getCompileAction(this.context)) != null) {
                int cmdId = compileAction.getCommandId();
                Workspace wsp = Ide.getActiveWorkspace();
                Project prj = Ide.getActiveProject();
                if (wsp != null && (cmdId == JCompiler.MAKE_WORKSPACE_CMD_ID || cmdId == JCompiler.BUILD_WORKSPACE_CMD_ID || cmdId == JCompiler.CLEAN_WORKSPACE_CMD_ID || cmdId == JCompiler.CLEAN_AND_REFRESH_WORKSPACE_CMD_ID)) {
                    elements = new Element[]{wsp};
                } else if (prj != null && (cmdId == JCompiler.MAKE_PROJECT_CMD_ID || cmdId == JCompiler.MAKE_PROJECT_AND_DEPENDENCIES_CMD_ID || cmdId == JCompiler.BUILD_PROJECT_CMD_ID || cmdId == JCompiler.BUILD_PROJECT_AND_DEPENDENCIES_CMD_ID || cmdId == JCompiler.CLEAN_PROJECT_CMD_ID)) {
                    elements = new Element[]{prj};
                } else if (wsp != null && (cmdId == JCompiler.MAKE_WORKINGSET_CMD_ID || cmdId == JCompiler.BUILD_WORKINGSET_CMD_ID)) {
                    WorkingSets workingSets = WorkingSets.getInstance((Workspace)wsp);
                    WorkingSet workingSet = workingSets.getCurrentWorkingSet();
                    ArrayList<Project> workingSetProjects = new ArrayList<Project>();
                    Iterator iter = wsp.getChildren();
                    while (iter.hasNext()) {
                        Element child = (Element)iter.next();
                        if (!(child instanceof Project) || workingSet == null || !workingSet.isIncluded((Project)child)) continue;
                        workingSetProjects.add((Project)child);
                    }
                    elements = new Element[workingSetProjects.size()];
                    for (int x = 0; x < elements.length; ++x) {
                        elements[x] = new WorkingSetNode(wsp, (Project)workingSetProjects.get(x));
                    }
                }
            }
            return elements;
        }

        @Override
        public void interrupt() {
            this.buildCanceled = true;
            super.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void saveAllEditorBuffers(JCompiler jcompiler) {
            boolean oldValue = jcompiler.getDisableProjectUpdates();
            jcompiler.setDisableProjectUpdates(true);
            try {
                SaveAllCommand.saveAll((boolean)false);
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
            finally {
                jcompiler.setDisableProjectUpdates(oldValue);
            }
        }

        private boolean printCopyListenerTimes() {
            return this.printTranslatorAndListenerTimes(this.copyListenerTimes, "Total copy listener times:");
        }

        private boolean printTranslatorAndListenerTimes(Map<String, Long> map, String title) {
            if (!map.isEmpty() && (TRANSLATOR_LOGGER.isEnabled() || this.APPS_OJC_BUILD_LOGGER)) {
                if (TRANSLATOR_LOGGER.isEnabled()) {
                    TRANSLATOR_LOGGER.trace("");
                    TRANSLATOR_LOGGER.trace(title);
                    for (Map.Entry<String, Long> entry : map.entrySet()) {
                        TRANSLATOR_LOGGER.trace("  " + entry.getKey() + ": " + entry.getValue() + " msec");
                    }
                    TRANSLATOR_LOGGER.trace("");
                }
                if (this.APPS_OJC_BUILD_LOGGER) {
                    LogPage log = JCompiler.getInstance().getOutputLog();
                    log.log((Object)"\n");
                    log.log((Object)title);
                    log.log((Object)"\n");
                    for (Map.Entry<String, Long> entry : map.entrySet()) {
                        log.log((Object)("  " + entry.getKey() + ": " + entry.getValue() + " msec\n"));
                    }
                    log.log((Object)"\n");
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void beginTranslator(Translator translator) {
            Object object = UnifiedBuildSystem.this.markingLock;
            synchronized (object) {
                if (this.APPS_OJC_BUILD_LOGGER) {
                    LogPage log = JCompiler.getInstance().getOutputLog();
                    log.log((Object)("Begin translator " + translator.getName() + "\n"));
                }
                assert (TRANSLATOR_LOGGER.trace("begin translator {0}", (Object)translator.getName()));
                this.translatorStartingTime = System.currentTimeMillis();
                int uniqueID = System.identityHashCode(translator);
                this.marking.put(uniqueID, Boolean.FALSE);
                this.translateableSources.put(uniqueID, new HashSet());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void endTranslator(Translator translator) {
            Object object = UnifiedBuildSystem.this.markingLock;
            synchronized (object) {
                int uniqueID = System.identityHashCode(translator);
                String name = translator.getName();
                Boolean mark = this.marking.remove(uniqueID);
                Set<Storage> translateable = this.translateableSources.remove(uniqueID);
                if (mark != null && mark.booleanValue()) {
                    assert (TRANSLATOR_LOGGER.trace("end translator, suppressed {0}, {1}", translateable, (Object)name));
                    if (translateable != null) {
                        this.suppressedSources.addAll(translateable);
                        this.translatedSources.removeAll(translateable);
                        translateable.clear();
                    }
                } else {
                    assert (TRANSLATOR_LOGGER.trace("end translator, translated {0}", translateable));
                    if (translateable != null) {
                        this.translatedSources.addAll(translateable);
                        translateable.clear();
                    }
                }
                long translatorTime = System.currentTimeMillis() - this.translatorStartingTime;
                if (this.APPS_OJC_BUILD_LOGGER) {
                    LogPage log = JCompiler.getInstance().getOutputLog();
                    log.log((Object)("End translator " + name + ", translation time " + translatorTime + " msec\n"));
                }
                assert (TRANSLATOR_LOGGER.trace("Translation time in msec: " + translatorTime));
                assert (STATISTICS_LOGGER.trace("Time to use translator " + name + ": " + translatorTime + " msec"));
                Long totalTranslatorTime = this.translatorTimes.get(name);
                if (totalTranslatorTime == null) {
                    totalTranslatorTime = 0L;
                }
                totalTranslatorTime = totalTranslatorTime + translatorTime;
                this.translatorTimes.put(name, totalTranslatorTime);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block52: {
                this.translatorTimes.clear();
                this.copyListenerTimes.clear();
                startBuildTime = System.currentTimeMillis();
                ci = JCompiler.getInstance();
                cleanAllResult = false;
                try {
                    block53: {
                        if (this.saveBeforeCompile && Ide.getIdeArgs().getCreateUI()) {
                            UnifiedBuildSystem.access$1600(UnifiedBuildSystem.this).setBuildContext(this.context);
                            try {
                                this.saveAllEditorBuffers(ci);
                            }
                            finally {
                                UnifiedBuildSystem.access$1600(UnifiedBuildSystem.this).setBuildContext(null);
                            }
                        }
                        var5_5 = UnifiedBuildSystem.access$900(UnifiedBuildSystem.this);
                        synchronized (var5_5) {
                            UnifiedBuildSystem.access$1000(UnifiedBuildSystem.this).clear();
                            UnifiedBuildSystem.access$1100(UnifiedBuildSystem.this).clear();
                            UnifiedBuildSystem.access$1300(UnifiedBuildSystem.this).clear();
                        }
                        elements = this.getElementsToBuild();
                        if (elements == null || elements.length == 0) {
                            Assert.println((String)"Nothing to build or clean, elements is null");
                            break block52;
                        }
                        UnifiedBuildSystem.ideLog.reinit();
                        if (Ide.getIdeArgs().getCreateUI()) {
                            JCompilerMenuItems.getInstance().enableCancelBuild(true);
                        }
                        if (!this.cleanAll) {
                            ci.logOutStartBuild(this.compileArguments);
                        }
                        ci.getNewBuildSystemListeners(null, null, null);
                        for (BuildSystemListener listener : ci.getBuildSystemListeners()) {
                            if (!(listener instanceof BuildSystemListener2)) continue;
                            ((BuildSystemListener2)listener).setBuildLog(this.buildLog);
                        }
                        try {
                            if (this.cleanAll) {
                                if (this.context != null) {
                                    this.context.setProperty("buildsystem.elements.to.clean", elements.clone());
                                }
                                this.invokeListenersBegin(ci.getBuildSystemListeners(), this.context, UnifiedBuildSystem.ideLog, JCompiler.QueueAction.CLEAN_WILL_START, JCompiler.QueueAction.CLEAN_FINISHED);
                                try {
                                    cleanAllResult = this.cleanAll(elements);
                                }
                                catch (FailedDeleteException e) {
                                    message = UnifiedBuildSystem.access$000(UnifiedBuildSystem.this).getMessage();
                                    ci.logOutMsg(message + "\n");
                                    message = CompArb.getString(37);
                                    ci.logOutMsg(message + "\n");
                                }
                            } else {
                                if (this.context != null) {
                                    this.context.setProperty("buildsystem.elements.to.build", elements.clone());
                                }
                                this.invokeListenersBegin(ci.getBuildSystemListeners(), this.context, UnifiedBuildSystem.ideLog, JCompiler.QueueAction.BUILD_WILL_START, JCompiler.QueueAction.BUILD_FINISHED);
                                this.buildAll(elements);
                            }
                            this.checkForCanceledBuild();
                        }
                        catch (BuildSystemVetoException e) {
                        }
                        catch (RuntimeException e) {
                            if (CompArb.getString(76).equals(e.getMessage())) {
                                UnifiedBuildSystem.ideLog.error(null, 0, 0, 0, e.getMessage());
                                break block53;
                            }
                            throw e;
                        }
                        finally {
                            this.deploymentProfileBuilt.clear();
                            this.projectsBuilt.clear();
                        }
                    }
                    if (this.cleanAll) {
                        this.invokeListenersFinish(this.listenersStarted, this.context, UnifiedBuildSystem.ideLog, JCompiler.QueueAction.CLEAN_FINISHED, true);
                        break block52;
                    }
                    this.invokeListenersFinish(this.listenersStarted, this.context, UnifiedBuildSystem.ideLog, JCompiler.QueueAction.BUILD_FINISHED, true);
                }
                catch (Throwable t) {
                    try {
                        t.printStackTrace();
                        ci.logOutMsg(CompArb.getString(46) + "\n");
                        UnifiedBuildSystem.ideLog.error(null, 0, 0, 0, CompArb.getString(46));
                        message = "Fatal exception during " + (this.cleanAll != false ? "cleaning" : "compiling") + " of project files";
                        FeedbackManager.reportException((String)message, (Throwable)t);
                    }
                    catch (Throwable var9_15) {
                        UnifiedBuildSystem.access$102(UnifiedBuildSystem.this, this.filesBuilt);
                        if (this.cleanAll) {
                            if (this.refreshApplication) {
                                UnifiedBuildSystem.access$202(UnifiedBuildSystem.this, cleanAllResult != false ? 3 : 4);
                            } else {
                                UnifiedBuildSystem.access$202(UnifiedBuildSystem.this, cleanAllResult != false ? 1 : 2);
                            }
                        } else {
                            UnifiedBuildSystem.access$202(UnifiedBuildSystem.this, 0);
                        }
                        UnifiedBuildSystem.access$302(UnifiedBuildSystem.this, System.currentTimeMillis() - startBuildTime);
                        this.printTranslatorTimes();
                        this.printCopyListenerTimes();
                        this.translatorTimes.clear();
                        this.copyListenerTimes.clear();
                        this.suppressedWorkspaces.clear();
                        this.APPS_OJC_BUILD_LOGGER = false;
                        Assert.println((String)"{0} completed [{1}ms]", (Object)(this.cleanAll != false ? "Clean All" : "Make"), (Object)Long.toString(UnifiedBuildSystem.access$300(UnifiedBuildSystem.this)));
                        if (!CompileThread.$assertionsDisabled && !UnifiedBuildSystem.access$700().trace("Build time in msec: " + UnifiedBuildSystem.access$300(UnifiedBuildSystem.this))) {
                            throw new AssertionError();
                        }
                        if (!CompileThread.$assertionsDisabled && !UnifiedBuildSystem.logger.trace("Build time in msec: " + UnifiedBuildSystem.access$300(UnifiedBuildSystem.this))) {
                            throw new AssertionError();
                        }
                        if (!CompileThread.$assertionsDisabled && !UnifiedBuildSystem.access$600().trace("Time to " + (this.cleanAll != false ? "clean" : "build") + ": " + UnifiedBuildSystem.access$300(UnifiedBuildSystem.this) + " msec")) {
                            throw new AssertionError();
                        }
                        throw var9_15;
                    }
                    UnifiedBuildSystem.access$102(UnifiedBuildSystem.this, this.filesBuilt);
                    if (this.cleanAll) {
                        if (this.refreshApplication) {
                            UnifiedBuildSystem.access$202(UnifiedBuildSystem.this, cleanAllResult != false ? 3 : 4);
                        } else {
                            UnifiedBuildSystem.access$202(UnifiedBuildSystem.this, cleanAllResult != false ? 1 : 2);
                        }
                    } else {
                        UnifiedBuildSystem.access$202(UnifiedBuildSystem.this, 0);
                    }
                    UnifiedBuildSystem.access$302(UnifiedBuildSystem.this, System.currentTimeMillis() - startBuildTime);
                    this.printTranslatorTimes();
                    this.printCopyListenerTimes();
                    this.translatorTimes.clear();
                    this.copyListenerTimes.clear();
                    this.suppressedWorkspaces.clear();
                    this.APPS_OJC_BUILD_LOGGER = false;
                    Assert.println((String)"{0} completed [{1}ms]", (Object)(this.cleanAll != false ? "Clean All" : "Make"), (Object)Long.toString(UnifiedBuildSystem.access$300(UnifiedBuildSystem.this)));
                    if (!CompileThread.$assertionsDisabled && !UnifiedBuildSystem.access$700().trace("Build time in msec: " + UnifiedBuildSystem.access$300(UnifiedBuildSystem.this))) {
                        throw new AssertionError();
                    }
                    if (!CompileThread.$assertionsDisabled && !UnifiedBuildSystem.logger.trace("Build time in msec: " + UnifiedBuildSystem.access$300(UnifiedBuildSystem.this))) {
                        throw new AssertionError();
                    }
                    if (!CompileThread.$assertionsDisabled && !UnifiedBuildSystem.access$600().trace("Time to " + (this.cleanAll != false ? "clean" : "build") + ": " + UnifiedBuildSystem.access$300(UnifiedBuildSystem.this) + " msec")) {
                        throw new AssertionError();
                    } else {
                        ** GOTO lbl175
                    }
                }
            }
            UnifiedBuildSystem.access$102(UnifiedBuildSystem.this, this.filesBuilt);
            if (this.cleanAll) {
                if (this.refreshApplication) {
                    UnifiedBuildSystem.access$202(UnifiedBuildSystem.this, cleanAllResult != false ? 3 : 4);
                } else {
                    UnifiedBuildSystem.access$202(UnifiedBuildSystem.this, cleanAllResult != false ? 1 : 2);
                }
            } else {
                UnifiedBuildSystem.access$202(UnifiedBuildSystem.this, 0);
            }
            UnifiedBuildSystem.access$302(UnifiedBuildSystem.this, System.currentTimeMillis() - startBuildTime);
            this.printTranslatorTimes();
            this.printCopyListenerTimes();
            this.translatorTimes.clear();
            this.copyListenerTimes.clear();
            this.suppressedWorkspaces.clear();
            this.APPS_OJC_BUILD_LOGGER = false;
            Assert.println((String)"{0} completed [{1}ms]", (Object)(this.cleanAll != false ? "Clean All" : "Make"), (Object)Long.toString(UnifiedBuildSystem.access$300(UnifiedBuildSystem.this)));
            if (!CompileThread.$assertionsDisabled && !UnifiedBuildSystem.access$700().trace("Build time in msec: " + UnifiedBuildSystem.access$300(UnifiedBuildSystem.this))) {
                throw new AssertionError();
            }
            if (!CompileThread.$assertionsDisabled && !UnifiedBuildSystem.logger.trace("Build time in msec: " + UnifiedBuildSystem.access$300(UnifiedBuildSystem.this))) {
                throw new AssertionError();
            }
            if (!CompileThread.$assertionsDisabled && !UnifiedBuildSystem.access$600().trace("Time to " + (this.cleanAll != false ? "clean" : "build") + ": " + UnifiedBuildSystem.access$300(UnifiedBuildSystem.this) + " msec")) {
                throw new AssertionError();
            }
            this.context = null;
            this.buildCanceled = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void markTranslateable(Translator translator, Storage source) {
            Object object = UnifiedBuildSystem.this.markingLock;
            synchronized (object) {
                if (this.suppressedSources != null) {
                    assert (TRANSLATOR_LOGGER.trace("mark {0} translateable, translator {1}", (Object)source, (Object)translator.getName()));
                    if (this.suppressedSources.contains(source)) {
                        assert (TRANSLATOR_LOGGER.trace("mark {0} suppressed for translation, translator {1}", (Object)source, (Object)translator.getName()));
                        return;
                    }
                    if (Boolean.TRUE.equals(source.getProperty(UnifiedBuildSystem.PREPROCESSOR_GENERATED_PROPERTY))) {
                        return;
                    }
                    Set<Storage> translateableSet = this.translateableSources.get(System.identityHashCode(translator));
                    if (translateableSet != null) {
                        translateableSet.add(source);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void markTranslated(Translator translator, Storage source) {
            Object object = UnifiedBuildSystem.this.markingLock;
            synchronized (object) {
                if (this.suppressedSources != null && this.translatedSources != null) {
                    Set<Storage> set;
                    boolean suppressed;
                    boolean bl = suppressed = this.suppressedSources.contains(source) || Boolean.TRUE.equals(source.getProperty(UnifiedBuildSystem.PREPROCESSOR_GENERATED_PROPERTY));
                    assert (TRANSLATOR_LOGGER.trace("mark {1} translated, suppressed {0}, {2}", (Object)suppressed, (Object)source, (Object)translator.getName()));
                    if (!suppressed) {
                        this.translatedSources.add(source);
                    }
                    if ((set = this.translateableSources.get(System.identityHashCode(translator))) != null) {
                        set.remove(source);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void markCompiled(String path) {
            Object object = UnifiedBuildSystem.this.markingLock;
            synchronized (object) {
                if (this.compiledClasses != null) {
                    this.compiledClasses.add(path);
                }
            }
        }

        private boolean printTranslatorTimes() {
            return this.printTranslatorAndListenerTimes(this.translatorTimes, "Total translator times:");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void beginMarking(Translator translator) {
            Object object = UnifiedBuildSystem.this.markingLock;
            synchronized (object) {
                assert (TRANSLATOR_LOGGER.trace("begin marking {0}", (Object)translator.getName()));
                int uniqueID = System.identityHashCode(translator);
                this.marking.put(uniqueID, Boolean.TRUE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addCopyListenerTime(String name, long time) {
            Object object = UnifiedBuildSystem.this.markingLock;
            synchronized (object) {
                Long totalTime = this.copyListenerTimes.get(name);
                if (totalTime == null) {
                    totalTime = 0L;
                }
                totalTime = totalTime + time;
                this.copyListenerTimes.put(name, totalTime);
            }
        }

        private class FailedDeleteException
        extends RuntimeException {
            private FailedDeleteException() {
            }
        }

        private final class WorkingSetNode
        extends Node {
            private Workspace wsp;
            private Project project;

            WorkingSetNode(Workspace wsp, Project project) {
                this.wsp = wsp;
                this.project = project;
            }

            IntersectedFilters getFilters() {
                PatternFilters filters;
                WorkingSets workingSets = WorkingSets.getInstance((Workspace)this.wsp);
                WorkingSet curWorkingSet = workingSets.getCurrentWorkingSet();
                if (curWorkingSet != null && (filters = curWorkingSet.getPatternFilters(this.project)) != null) {
                    return new IntersectedFilters(filters);
                }
                return new IntersectedFilters(new PatternFilters[0]);
            }
        }
    }
}

