/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compiler;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import oracle.jdevimpl.resource.JdevBuildExtensionManifest;

public class NativeToAscii {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean convert(String encoding, String inputFileName, String outputFileName) throws IOException {
        char[] lineBreak = System.getProperty("line.separator").toCharArray();
        File tempFile = null;
        try {
            File outputFile = new File(outputFileName);
            if (outputFile.exists() && !outputFile.canWrite()) {
                throw new IOException(JdevBuildExtensionManifest.format("CANNOT_WRITE_TO_OUTPUT_FILE", outputFileName));
            }
            File inputFile = new File(inputFileName);
            if (!inputFile.canRead()) {
                throw new IOException(JdevBuildExtensionManifest.format("CANNOT_READ_FROM_INPUT_FILE", inputFileName));
            }
            File tempDir = outputFile.getParentFile();
            if (tempDir == null) {
                tempDir = new File(System.getProperty("user.dir"));
            }
            tempFile = File.createTempFile("_N2A", ".TMP", tempDir);
            try (BufferedReader in = encoding != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), encoding)) : new BufferedReader(new InputStreamReader(new FileInputStream(inputFile)));
                 BufferedWriter out = new BufferedWriter(new N2AFilter(new FileWriter(tempFile)));){
                String inLine;
                while ((inLine = in.readLine()) != null) {
                    out.write(inLine.toCharArray());
                    out.write(lineBreak);
                    if (outputFileName != null) continue;
                    out.flush();
                }
            }
            if (outputFile.exists()) {
                outputFile.delete();
            }
            tempFile.renameTo(outputFile);
            tempFile = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (tempFile != null && !tempFile.delete()) {
                tempFile.deleteOnExit();
            }
        }
        return true;
    }

    private static class N2AFilter
    extends FilterWriter {
        public N2AFilter(Writer out) {
            super(out);
        }

        @Override
        public void write(char[] buf, int off, int len) throws IOException {
            for (int i = 0; i < len; ++i) {
                if (buf[i] > '\u007f') {
                    int j;
                    this.out.write(92);
                    this.out.write(117);
                    String hex = Integer.toHexString(buf[i]);
                    StringBuffer hex4 = new StringBuffer(hex);
                    hex4.reverse();
                    int length = 4 - hex4.length();
                    for (j = 0; j < length; ++j) {
                        hex4.append('0');
                    }
                    for (j = 0; j < 4; ++j) {
                        this.out.write(hex4.charAt(3 - j));
                    }
                    continue;
                }
                this.out.write(buf[i]);
            }
        }
    }
}

