/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.msaccess;

import oracle.dbtools.migration.parser.defaults.DefaultVariabletNameTranslator;
import oracle.dbtools.migration.workbench.core.preferences.ConfigurationData;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

public class MSAccessVariableNameTranslator
extends DefaultVariabletNameTranslator {
    public static final String IDENTIFIER_SEPARATOR = ".";
    public static final String VARIABLE_PREFIX = "@";
    public static final String BRACKET_DELIMITER = "[]";
    public static final String ORACLE_QUOTED_DELIMITER = "\"";
    public static final String PREPEND_VAR = "v_";

    public String translateVariableName(String string) {
        return string.trim().startsWith(VARIABLE_PREFIX) ? PREPEND_VAR + string.substring(1) : PREPEND_VAR + string;
    }

    public String translateAliasName(String string) {
        return string;
    }

    public String prefixVarName(String string) {
        Preferences preferences = null;
        try {
            preferences = Preferences.getPreferences();
        }
        catch (Exception exception) {
            return null;
        }
        ConfigurationData configurationData = ConfigurationData.getInstance((PropertyStorage)preferences);
        return configurationData.getVarPrefix() + string;
    }

    public String prefixInParamName(String string) {
        Preferences preferences = null;
        try {
            preferences = Preferences.getPreferences();
        }
        catch (Exception exception) {
            return null;
        }
        ConfigurationData configurationData = ConfigurationData.getInstance((PropertyStorage)preferences);
        return string;
    }

    public String translateInParamName(String string) {
        string = this.translateToVarFormat(string);
        return this.prefixInParamName(string);
    }

    private String translateToVarFormat(String object) {
        Object object2 = object = ((String)object).trim().startsWith(VARIABLE_PREFIX) ? ((String)object).trim().substring(1) : ((String)object).trim();
        if (((String)object).length() > 28) {
            object = ((String)object).substring(0, 24) + ((String)object).substring(((String)object).length() - 4);
        }
        return object;
    }
}

