/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.cmdtranslator.commands;

import java.util.ArrayList;
import java.util.List;
import model.BaseClass;
import model.common.AbstractBaseTarget;
import model.common.Host;
import model.common.OracleHome;
import model.db_crs.RACDBInstance;
import model.db_crs.RACDatabase;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.LifecycleAction;
import oracle.opatch.system.automation.jaxb.PatchingPhase;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.db.engine.CRSContextPopulator;
import oracle.oplan.sdk.ExecutionMode;
import oracle.oplan.sdk.cmdtranslator.Command;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.cmdtranslator.CommandUtils;
import oracle.oplan.sdk.exec.api.ExecutionStep;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.oplan.OPlan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleHomeRACOneLifecycle
extends Command {
    protected String type = "relocateout";
    protected Strategy s = Strategy.MANUAL;
    private RACDBInstance activeRACDBInst = null;
    List<String> processed = new ArrayList<String>();

    public OracleHomeRACOneLifecycle(ActionType automationAction, String type, Strategy s) {
        super(automationAction);
        this.type = type;
        this.s = s;
    }

    private boolean skipStepForRACAndInActiveRACOneDB(CommandContext context) {
        OracleHome oh = (OracleHome)context.getTarget(OracleHome.class);
        Host host = (Host)context.getTarget(Host.class);
        RACDatabase racDB = null;
        this.activeRACDBInst = null;
        block0: for (BaseClass bc : OPlan.getInstance().getConfigGraph().getSystemInstance().getEntities()) {
            if (!(bc instanceof RACDatabase)) continue;
            racDB = (RACDatabase)bc;
            for (RACDBInstance racDBInst : racDB.getDbInstances()) {
                if (!racDBInst.getRuns_from().getPath().equals(oh.getPath()) || !racDBInst.getHost().getHostName().equals(host.getName())) continue;
                this.activeRACDBInst = racDBInst;
                continue block0;
            }
        }
        return this.activeRACDBInst == null || this.activeRACDBInst.getDbRAC().getDatabaseType() == null || this.activeRACDBInst.getDbRAC().getDatabaseType().equals("rac") || this.activeRACDBInst.getDbRAC().getDatabaseType().equals("racone") && this.activeRACDBInst.getIsRunning().equals("no");
    }

    public List<String> getShellCommands(CommandContext context) {
        OracleHome oh = (OracleHome)context.getTarget(OracleHome.class);
        Host host = (Host)context.getTarget(Host.class);
        ArrayList<String> cmds = new ArrayList<String>();
        if ("relocateout".equalsIgnoreCase(this.type)) {
            for (RACDBInstance inActiveRACOneDBInst : this.activeRACDBInst.getDbRAC().getDbInstances()) {
                if (!"no".equals(inActiveRACOneDBInst.getIsRunning())) continue;
                host = inActiveRACOneDBInst.getHost();
                break;
            }
        }
        String relocateCmd = "ORACLE_HOME=" + oh.getPath() + " " + oh.getPath() + "/bin/srvctl relocate database -d " + this.activeRACDBInst.getDbRAC().getDatabaseName() + " -n " + host.getHostName() + " -w 30 -v";
        cmds.add(relocateCmd);
        return cmds;
    }

    public ExecutionStep getExecutionStep(CommandContext context) {
        ExecutionStep executionStep = CommandUtils.getBasicExecutionStep((ActionType)this.automationAction, (CommandContext)context, null);
        for (String cmd : this.getShellCommands(context)) {
            executionStep.getCommand().add(new ExecutionStep.Command(cmd));
        }
        return executionStep;
    }

    public List<ExecutionStep> generateExecutionSteps(ConfigGraph g, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        ArrayList<ExecutionStep> steps = new ArrayList<ExecutionStep>();
        CRSContextPopulator contextPopulator = new CRSContextPopulator();
        if (CommandUtils.shouldShutdownRACInstance((PatchingPhase)this.getPatchingPhase())) {
            List<? extends AbstractBaseTarget> ohs = actsOnlyOnTargets;
            for (OracleHome oracleHome : ohs) {
                CommandContext context = contextPopulator.populateContext(g, (AbstractBaseTarget)oracleHome);
                if (this.skipStepForRACAndInActiveRACOneDB(context)) continue;
                if (this.automationAction.isActsOnClone()) {
                    contextPopulator.fixCloneContext(context);
                    OracleHome oh = (OracleHome)context.getFirstTarget(OracleHome.class);
                    if (oh.getOriginalOracleHome() != null && oh.getOriginalOracleHome().getPath().equals(oh.getPath())) continue;
                }
                ExecutionStep step = this.getExecutionStep(context);
                if (this.s.equals((Object)Strategy.DCLI)) {
                    step.setHost(g.getLocalHost());
                }
                steps.add(step);
            }
        }
        return steps;
    }

    protected List<? extends AbstractBaseTarget> getApplicableTargets(ConfigGraph g) {
        return g.getTargets(OracleHome.class, this.automationAction.getStripe());
    }

    protected boolean includeTargetByVersion(ConfigGraph configGraph, AbstractBaseTarget abstractBaseTarget, ExecutionMode executionMode) {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements CommandBuilder<OracleHomeRACOneLifecycle> {
        public OracleHomeRACOneLifecycle getCommand(ActionType a, Strategy s) {
            if (!(a instanceof LifecycleAction) || a.getActsOn() == null || !a.getActsOn().equals("OracleHomeRACOne")) {
                return null;
            }
            OracleHomeRACOneLifecycle com = new OracleHomeRACOneLifecycle(a, a.getType(), s);
            return com;
        }
    }
}

