/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.validation.rules;

import java.util.ArrayList;
import java.util.List;
import model.SystemInstance;
import model.common.OracleHome;
import model.db_crs.CRSCluster;
import oracle.oplan.db.validation.causes.NoCRS;
import oracle.osysmodel.validation.BundleUtils;
import oracle.osysmodel.validation.ConfigValidationException;
import oracle.osysmodel.validation.Rule;
import oracle.osysmodel.validation.RuleResult;
import oracle.osysmodel.validation.causes.MissingHome;
import oracle.osysmodel.validation.causes.MissingHost;
import oracle.osysmodel.validation.causes.NonSharedHomes;
import oracle.osysmodel.validation.rules.BaseRule;

public class CRSGIhomeShared
extends BaseRule {
    public CRSGIhomeShared(SystemInstance config) {
        super(config);
        this.successMessage = " GIhome is shared ";
    }

    public RuleResult invoke() throws ConfigValidationException {
        ArrayList<NoCRS> nullCauses = new ArrayList<NoCRS>();
        if (this.config.getTop() == null || !(this.config.getTop() instanceof CRSCluster)) {
            nullCauses.add(new NoCRS(null, BundleUtils.getMessage(CRSGIhomeShared.class, (String)"NO_CRS", (Object[])new Object[0])));
            return new RuleResult((Rule)this, null, nullCauses);
        }
        CRSCluster crs = (CRSCluster)this.config.getTop();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(crs);
        OracleHome home = crs.getGIHome();
        if (home == null) {
            nullCauses.add((NoCRS)new MissingHome(list, BundleUtils.getMessage(CRSGIhomeShared.class, (String)"CRS_MISSING_GI_HOME", (Object[])new Object[]{BundleUtils.makeStringOutOfList(list)})));
            return new RuleResult((Rule)this, null, nullCauses);
        }
        List hosts = home.getHosts();
        list = new ArrayList();
        list.add(home);
        if (hosts == null || hosts.isEmpty()) {
            nullCauses.add((NoCRS)new MissingHost(list, BundleUtils.getMessage(CRSGIhomeShared.class, (String)"MISSING_HOST", (Object[])new Object[]{BundleUtils.makeStringOutOfList(list)})));
            return new RuleResult((Rule)this, null, nullCauses);
        }
        if (hosts.size() > 1) {
            return new RuleResult((Rule)this);
        }
        ArrayList<NonSharedHomes> failureCauses = new ArrayList<NonSharedHomes>();
        failureCauses.add(new NonSharedHomes(list));
        return new RuleResult((Rule)this, new Boolean(false), failureCauses);
    }
}

