/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.validation.rules;

import java.util.ArrayList;
import java.util.List;
import model.SystemInstance;
import model.common.OracleHome;
import model.db_crs.CRSCluster;
import model.db_crs.RACDBInstance;
import model.db_crs.RACDatabase;
import oracle.oplan.db.validation.causes.NoCRS;
import oracle.oplan.db.validation.causes.NoRAC;
import oracle.osysmodel.validation.BundleUtils;
import oracle.osysmodel.validation.ConfigValidationException;
import oracle.osysmodel.validation.Rule;
import oracle.osysmodel.validation.RuleResult;
import oracle.osysmodel.validation.causes.MissingHome;
import oracle.osysmodel.validation.causes.MissingHost;
import oracle.osysmodel.validation.causes.NonSharedHomes;
import oracle.osysmodel.validation.rules.BaseRule;

public class CRSRAChomeShared
extends BaseRule {
    public CRSRAChomeShared(SystemInstance config) {
        super(config);
        this.successMessage = " all RAC run from shared homes";
    }

    public RuleResult invoke() throws ConfigValidationException {
        ArrayList<Object> nullCauses = new ArrayList<Object>();
        if (this.config.getTop() == null || !(this.config.getTop() instanceof CRSCluster)) {
            nullCauses.add((Object)new NoCRS(null, BundleUtils.getMessage(CRSRAChomeShared.class, (String)"NO_CRS", (Object[])new Object[0])));
            return new RuleResult((Rule)this, null, nullCauses);
        }
        CRSCluster crs = (CRSCluster)this.config.getTop();
        ArrayList<CRSCluster> list = new ArrayList<CRSCluster>();
        list.add(crs);
        ArrayList<NonSharedHomes> failureCauses = new ArrayList<NonSharedHomes>();
        List racs = crs.getDbRAC();
        if (racs == null || racs.isEmpty()) {
            nullCauses.add((Object)new NoRAC(list, BundleUtils.getMessage(CRSRAChomeShared.class, (String)"NO_RAC", (Object[])new Object[]{BundleUtils.makeStringOutOfList(list)})));
            return new RuleResult((Rule)this, null, nullCauses);
        }
        ArrayList<RACDBInstance> missingHome = new ArrayList<RACDBInstance>();
        ArrayList<RACDBInstance> missingHost = new ArrayList<RACDBInstance>();
        ArrayList<OracleHome> shared = new ArrayList<OracleHome>();
        ArrayList<OracleHome> nonshared = new ArrayList<OracleHome>();
        for (RACDatabase rac : racs) {
            for (RACDBInstance instance : rac.getDbInstances()) {
                List hosts;
                OracleHome home = instance.getRuns_from();
                if (home == null) {
                    missingHome.add(instance);
                }
                if ((hosts = home.getHosts()) == null || hosts.isEmpty()) {
                    missingHost.add(instance);
                }
                if (hosts.size() > 1) {
                    shared.add(home);
                    continue;
                }
                nonshared.add(home);
            }
        }
        if (!missingHome.isEmpty()) {
            nullCauses.add(new MissingHome(missingHome, BundleUtils.getMessage(CRSRAChomeShared.class, (String)"RACINSTANCE_MISSING_HOME", (Object[])new Object[]{BundleUtils.makeStringOutOfList(missingHome)})));
        }
        if (!missingHost.isEmpty()) {
            nullCauses.add(new MissingHost(missingHost, BundleUtils.getMessage(CRSRAChomeShared.class, (String)"MISSING_HOST", (Object[])new Object[]{BundleUtils.makeStringOutOfList(missingHost)})));
        }
        if (!nullCauses.isEmpty()) {
            return new RuleResult((Rule)this, null, nullCauses);
        }
        if (!nonshared.isEmpty()) {
            failureCauses.add(new NonSharedHomes(nonshared));
            return new RuleResult((Rule)this, new Boolean(false), failureCauses);
        }
        return new RuleResult((Rule)this);
    }
}

