/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.validation.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.SystemInstance;
import model.common.AbstractBaseTarget;
import model.db_crs.CRSCluster;
import oracle.oplan.db.validation.causes.MultipleCRSObject;
import oracle.oplan.db.validation.causes.NoCRS;
import oracle.osysmodel.validation.BundleUtils;
import oracle.osysmodel.validation.ConfigValidationException;
import oracle.osysmodel.validation.Rule;
import oracle.osysmodel.validation.RuleResult;
import oracle.osysmodel.validation.causes.MissingVersion;
import oracle.osysmodel.validation.rules.BaseRule;

public class CRSobjectValid
extends BaseRule {
    Logger logger = Logger.getLogger(CRSobjectValid.class.getName());

    public CRSobjectValid(SystemInstance config) {
        super(config);
        this.successMessage = " CRS object is valid, no associated object is validated by this rule";
    }

    public RuleResult invoke() throws ConfigValidationException {
        this.logger.log(Level.FINE, "Invoking rule to check if the CRS object exists and includes the version.");
        ArrayList<Object> failureCauses = new ArrayList<Object>();
        if (this.config.getTop() == null) {
            this.logger.log(Level.FINE, "System Instance top was found to be null. Ensuring if no crs object exists.");
            List crsList = this.config.getTargetsOfType(CRSCluster.class);
            if (crsList == null || crsList.isEmpty()) {
                this.logger.log(Level.FINE, "CRSCluster does not exist.");
                failureCauses.add((Object)new NoCRS(null, BundleUtils.getMessage(CRSobjectValid.class, (String)"NO_CRS", (Object[])new Object[0])));
                return new RuleResult((Rule)this, new Boolean(false), failureCauses);
            }
            if (crsList.size() != 1) {
                this.logger.log(Level.FINE, "More than one CRS object recognized. Set top to the CRSObject");
                failureCauses.add((Object)new MultipleCRSObject(null, BundleUtils.getMessage(CRSobjectValid.class, (String)"MULTIPLE_CRS_OBJECT", (Object[])new Object[0])));
                return new RuleResult((Rule)this, new Boolean(false), failureCauses);
            }
            this.logger.log(Level.INFO, "Setting the top to the CRSObject");
            this.config.setTop((AbstractBaseTarget)crsList.get(0));
        } else if (!(this.config.getTop() instanceof CRSCluster)) {
            this.logger.log(Level.FINE, "SystemInstance top is not CRSCluster object");
            failureCauses.add((Object)new NoCRS(null, BundleUtils.getMessage(CRSobjectValid.class, (String)"TOP_NOT_CRS", (Object[])new Object[0])));
            return new RuleResult((Rule)this, new Boolean(false), failureCauses);
        }
        CRSCluster crs = (CRSCluster)this.config.getTop();
        ArrayList<CRSCluster> list = new ArrayList<CRSCluster>();
        String verCRS = crs.getVersion();
        if (verCRS == null || verCRS.length() == 0) {
            this.logger.log(Level.FINE, "CRS Version is not set");
            list.add(crs);
            failureCauses.add(new MissingVersion(list, BundleUtils.getMessage(CRSobjectValid.class, (String)"MISSING_VERSION", (Object[])new Object[]{BundleUtils.makeStringOutOfList(list)})));
            return new RuleResult((Rule)this, new Boolean(false), failureCauses);
        }
        return new RuleResult((Rule)this);
    }
}

