/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.validation.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.SystemInstance;
import model.common.AbstractBaseTarget;
import model.common.Host;
import model.common.OracleHome;
import model.db_crs.CRSCluster;
import oracle.oplan.db.validation.causes.MultipleCRSObject;
import oracle.oplan.db.validation.causes.NoCRS;
import oracle.oplan.db.validation.rules.CRSplatformValid;
import oracle.osysmodel.validation.BundleUtils;
import oracle.osysmodel.validation.ConfigValidationException;
import oracle.osysmodel.validation.Rule;
import oracle.osysmodel.validation.RuleResult;
import oracle.osysmodel.validation.causes.BaseCause;
import oracle.osysmodel.validation.causes.WrongPlatform;
import oracle.osysmodel.validation.rules.BaseRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRSplatformAsRequested
extends BaseRule {
    Logger logger = Logger.getLogger(CRSplatformAsRequested.class.getName());
    private Set<String> values = null;

    public CRSplatformAsRequested(SystemInstance config, Set<String> values) {
        super(config);
        this.values = values;
        this.successMessage = " CRS platform (ARUid) value is in the set of values" + values;
    }

    public RuleResult invoke() throws ConfigValidationException {
        this.logger.log(Level.FINE, "Invoking rule to ensure that all the homes have the platform as one of the supported platforms.");
        ArrayList<BaseCause> nullCauses = new ArrayList<BaseCause>();
        if (this.config.getTop() == null) {
            this.logger.log(Level.FINE, "System Instance top was found to be null. Ensuring if no crs object exists.");
            List crsList = this.config.getTargetsOfType(CRSCluster.class);
            if (crsList == null || crsList.isEmpty()) {
                this.logger.log(Level.FINE, "CRSCluster does not exist.");
                nullCauses.add(new NoCRS(null, BundleUtils.getMessage(CRSplatformAsRequested.class, (String)"NO_CRS", (Object[])new Object[0])));
                return new RuleResult((Rule)this, null, nullCauses);
            }
            if (crsList.size() != 1) {
                this.logger.log(Level.FINE, "More than one CRS object recognized. Set top to the CRSObject");
                nullCauses.add(new MultipleCRSObject(null, BundleUtils.getMessage(CRSplatformAsRequested.class, (String)"MULTIPLE_CRS_OBJECT", (Object[])new Object[0])));
                return new RuleResult((Rule)this, null, nullCauses);
            }
            this.logger.log(Level.INFO, "Setting the top to the CRSObject");
            this.config.setTop((AbstractBaseTarget)crsList.get(0));
        } else if (!(this.config.getTop() instanceof CRSCluster)) {
            this.logger.log(Level.FINE, "SystemInstance top is not CRSCluster object");
            nullCauses.add(new NoCRS(null, BundleUtils.getMessage(CRSplatformAsRequested.class, (String)"TOP_NOT_CRS", (Object[])new Object[0])));
            return new RuleResult((Rule)this, null, nullCauses);
        }
        CRSplatformValid rule = new CRSplatformValid(this.config);
        RuleResult result = rule.invoke();
        this.logger.log(Level.FINE, " CRSplatformValid result =" + result);
        if (result.failureCauses != null && !result.failureCauses.isEmpty()) {
            return result;
        }
        if (result.nullCauses != null && !result.nullCauses.isEmpty()) {
            return result;
        }
        ArrayList<Host> list = new ArrayList<Host>();
        List homes = this.config.getAllHomes();
        String platform = null;
        for (OracleHome home : homes) {
            platform = home.getARUId();
            if (this.values.contains(platform)) continue;
            this.logger.log(Level.FINE, " The following home has a platform that is not supported ");
            for (Host host : home.getHosts()) {
                if (list.contains(host)) continue;
                list.add(host);
            }
        }
        if (!list.isEmpty()) {
            ArrayList<WrongPlatform> failureCauses = new ArrayList<WrongPlatform>();
            failureCauses.add(new WrongPlatform(list, BundleUtils.getMessage(CRSplatformAsRequested.class, (String)"PLATFORM_NOT_SUPPORTED", (Object[])new Object[]{BundleUtils.makeStringOutOfList(list)})));
            return new RuleResult((Rule)this, new Boolean(false), failureCauses);
        }
        return new RuleResult((Rule)this);
    }
}

