/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import model.fafmw.WLAdminServer;
import model.fafmw.WLDomain;
import oracle.opatch.opatchsdk.OPatchBIPDeployAction;
import oracle.opatch.opatchsdk.OPatchExecutionStep;
import oracle.opatch.opatchsdk.OPatchFAAutomationAction;
import oracle.opatch.opatchsdk.OPatchFAOperation;
import oracle.opatch.opatchsdk.OPatchJEELifecycleAction;
import oracle.opatch.opatchsdk.OPatchMultipleBIPDeploy;
import oracle.opatch.opatchsdk.OPatchSOACompositeLifecycleAction;
import oracle.opatch.opatchsdk.OPatchSOADeployAction;
import oracle.opatch.opatchsdk.OPatchSOARbDeployAction;
import oracle.opatch.opatchsdk.OPatchStandAloneSOADeployAction;
import oracle.opatch.opatchsdk.OPatchUtils;

public class OPatchExecutedArtifact {
    private OPatchFAAutomationAction artifactAction = null;
    private OPatchFAOperation operationObject = null;
    private ArrayList<OPatchExecutionStep> executionSteps = null;
    private String addedTime = "";
    private String operatedLogFile = "";

    public OPatchFAAutomationAction getArtifactAction() {
        return this.artifactAction;
    }

    public String getOperatedLogFile() {
        return this.operatedLogFile;
    }

    public OPatchFAOperation getFAOperation() {
        return this.operationObject;
    }

    public OPatchExecutionStep[] getExecutionSteps() {
        if (this.executionSteps == null) {
            return new OPatchExecutionStep[0];
        }
        OPatchExecutionStep[] step = new OPatchExecutionStep[this.executionSteps.size()];
        this.executionSteps.toArray(step);
        return step;
    }

    protected void setTime() {
        this.addedTime = new GregorianCalendar().getTime().toString();
    }

    protected void setArtifactAction(OPatchFAAutomationAction artifactAction) {
        this.artifactAction = artifactAction;
    }

    protected void setFAOperation(OPatchFAOperation operationObject) {
        this.operationObject = operationObject;
    }

    protected void setExecutionSteps(ArrayList executionSteps) {
        this.executionSteps = executionSteps;
    }

    protected void setOperatedLogFile(String operatedLogFile) {
        this.operatedLogFile = operatedLogFile;
    }

    private String getDomainStr(WLDomain domain) {
        if (domain == null) {
            return "";
        }
        String domainName = OPatchUtils.norm(domain.getName());
        String adminURL = "";
        int adminPort = -1;
        WLAdminServer adminServer = domain.getWLAdminServer();
        if (adminServer != null) {
            adminURL = adminServer.getURL();
            adminPort = adminServer.getPort();
        }
        String domainStr = "   \n[Domain Name = \"" + domainName + "\", AdminServerURL = \"" + adminURL + "\"," + " AdminPort = \"" + new Integer(adminPort).toString() + "\"]";
        return domainStr;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("\n\n");
        OPatchFAAutomationAction faAction = this.artifactAction;
        if (faAction == null) {
            buff.append("[No artifact defined]");
            return buff.toString();
        }
        if (faAction instanceof OPatchSOADeployAction) {
            OPatchSOADeployAction soaDeploy = (OPatchSOADeployAction)faAction;
            buff.append(soaDeploy.toString());
            buff.append(this.getDomainStr(soaDeploy.getBoundDomain()));
        } else if (faAction instanceof OPatchStandAloneSOADeployAction) {
            OPatchStandAloneSOADeployAction standAloneSOADeploy = (OPatchStandAloneSOADeployAction)faAction;
            buff.append(standAloneSOADeploy.toString());
            buff.append(this.getDomainStr(standAloneSOADeploy.getBoundDomain()));
        } else if (faAction instanceof OPatchBIPDeployAction) {
            OPatchBIPDeployAction bipDeploy = (OPatchBIPDeployAction)faAction;
            buff.append(bipDeploy.toString());
        } else if (faAction instanceof OPatchSOARbDeployAction) {
            OPatchSOARbDeployAction soaRbDeploy = (OPatchSOARbDeployAction)faAction;
            buff.append(soaRbDeploy.toString());
            buff.append(this.getDomainStr(soaRbDeploy.getBoundDomain()));
        } else if (faAction instanceof OPatchJEELifecycleAction) {
            OPatchJEELifecycleAction jeeAction = (OPatchJEELifecycleAction)faAction;
            buff.append(jeeAction.toString());
        } else if (faAction instanceof OPatchSOACompositeLifecycleAction) {
            OPatchSOACompositeLifecycleAction soaCompositeAction = (OPatchSOACompositeLifecycleAction)faAction;
            buff.append(soaCompositeAction.toString());
        } else if (faAction instanceof OPatchMultipleBIPDeploy) {
            OPatchMultipleBIPDeploy multipleBIP = (OPatchMultipleBIPDeploy)faAction;
            buff.append(multipleBIP.toString());
        } else {
            buff.append("[No supported artifacts available]");
            return buff.toString();
        }
        buff.append("   \n[OracleHomePath (%ORACLE_HOME%) : \"" + faAction.getOracleHome() + "\"]");
        buff.append("   \n[Recorded time :\"" + this.addedTime + "\"]");
        buff.append("   \n[Log file for this artifact operation is : \"" + this.getOperatedLogFile() + "\"]");
        if (this.operationObject == null) {
            buff.append("\n   [No FA operation defined]]");
            return buff.toString();
        }
        buff.append("\n   [FAOperation is " + this.operationObject.toString() + "]");
        if (this.executionSteps == null || this.executionSteps.size() == 0) {
            buff.append("\n   [No execution steps available]]\n\n");
            return buff.toString();
        }
        buff.append("\n");
        for (int i = 0; i < this.executionSteps.size(); ++i) {
            OPatchExecutionStep step = this.executionSteps.get(i);
            buff.append("   [Execution step " + i + ":\n" + "   " + step.toString());
            if (i == this.executionSteps.size()) continue;
            buff.append("   ]\n");
        }
        buff.append("]");
        buff.append("\n\n");
        return buff.toString();
    }
}

