/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.ext.panel;

import com.oracle.cie.common.ui.gui.GUIUtilities;
import com.oracle.cie.common.util.ResourceBundleManager;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.wizard.ext.ComponentOption;
import com.oracle.cie.wizard.ext.GUICustomPanelHelper;
import com.oracle.cie.wizard.ext.panel.CheckboxComponentWrapper;
import com.oracle.cie.wizard.ext.panel.ComboboxWrapper;
import com.oracle.cie.wizard.ext.panel.ComponentWrapper;
import com.oracle.cie.wizard.ext.panel.FileTypeComponent;
import com.oracle.cie.wizard.ext.panel.FileTypeComponentWrapper;
import com.oracle.cie.wizard.ext.panel.RadioButtonWrapper;
import com.oracle.cie.wizard.ext.panel.xml.CheckboxInputType;
import com.oracle.cie.wizard.ext.panel.xml.ChoiceType;
import com.oracle.cie.wizard.ext.panel.xml.DisplayType;
import com.oracle.cie.wizard.ext.panel.xml.EditableChoiceType;
import com.oracle.cie.wizard.ext.panel.xml.FileType;
import com.oracle.cie.wizard.ext.panel.xml.OptionType;
import com.oracle.cie.wizard.ext.panel.xml.TextInputType;
import com.oracle.cie.wizard.ext.panel.xml.TextType;
import com.oracle.cie.wizard.ext.panel.xml.UIType;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class CustomComponentFactory {
    private GUICustomPanelHelper _helper;
    private String _namespace;
    public static final String LABEL_SUFFIX = "_label";

    public CustomComponentFactory(String namespace, GUICustomPanelHelper helper) {
        this._helper = helper;
        this._namespace = namespace;
    }

    public List<ComponentWrapper> getComponents(UIType type) {
        ArrayList<ComponentWrapper> compWrapList = new ArrayList<ComponentWrapper>();
        ComponentWrapper componentWrapper = null;
        if (type instanceof DisplayType) {
            componentWrapper = this.getDisplayComponent((DisplayType)type);
        } else if (type instanceof ChoiceType) {
            ChoiceType cType = (ChoiceType)type;
            String labelName = this.getI18nString(cType.getLabelNameKey());
            this.addLabel(compWrapList, labelName, cType.getId());
            if (cType instanceof EditableChoiceType) {
                componentWrapper = this.getEditableChoiceComponent((EditableChoiceType)cType, labelName);
            } else {
                this.addRadioChoiceComponents(cType, compWrapList, labelName);
            }
        } else if (type instanceof TextInputType) {
            TextInputType tType = (TextInputType)type;
            String labelName = this.getI18nString(tType.getLabelNameKey());
            this.addLabel(compWrapList, labelName, tType.getId());
            switch (tType.getType()) {
                case TEXTFIELD: {
                    JTextField textField = new JTextField();
                    textField.setEnabled(!tType.isDisable());
                    this.setComponentDimension(textField, tType.getWidth(), tType.getHeight());
                    componentWrapper = new ComponentWrapper(labelName, tType.getId(), textField);
                    break;
                }
                case PASSWORD: {
                    JPasswordField pass = new JPasswordField();
                    pass.setEnabled(!tType.isDisable());
                    this.setComponentDimension(pass, tType.getWidth(), tType.getHeight());
                    componentWrapper = new ComponentWrapper(labelName, tType.getId(), pass);
                    break;
                }
                case TEXTAREA: {
                    JTextArea area = new JTextArea();
                    area.setEnabled(!tType.isDisable());
                    this.setComponentDimension(area, tType.getWidth(), tType.getHeight());
                    componentWrapper = new ComponentWrapper(labelName, tType.getId(), area);
                    break;
                }
            }
        } else if (type instanceof FileType) {
            FileType fType = (FileType)type;
            String labelName = this.getI18nString(fType.getLabelNameKey());
            this.addLabel(compWrapList, labelName, fType.getId());
            FileTypeComponent fTypeComponent = new FileTypeComponent(this._namespace, fType.getWidth());
            fTypeComponent.setEnabled(!fType.isDisable());
            componentWrapper = new FileTypeComponentWrapper(labelName, fType.getId(), fTypeComponent);
        } else if (type instanceof CheckboxInputType) {
            CheckboxInputType cType = (CheckboxInputType)type;
            JCheckBox checkBox = new JCheckBox();
            checkBox.setEnabled(!cType.isDisable());
            String labelName = this.getI18nString(cType.getLabelNameKey());
            GUIUtilities.configureButton((AbstractButton)checkBox, (String)labelName);
            componentWrapper = new CheckboxComponentWrapper(labelName, cType.getId(), checkBox, cType.getWorkflowProperty(), cType.isNotify());
        }
        if (componentWrapper != null) {
            compWrapList.add(componentWrapper);
        }
        return compWrapList;
    }

    private void addRadioChoiceComponents(ChoiceType cType, List<ComponentWrapper> compWrapList, String labelName) {
        block3: {
            ButtonGroup bGroup;
            RadioButtonWrapper componentWrapper;
            block2: {
                componentWrapper = null;
                bGroup = new ButtonGroup();
                RadioButtonWrapper.cleanOldButtonGroup(cType.getId());
                if (cType.getOption().isEmpty()) break block2;
                for (OptionType oType : cType.getOption()) {
                    JRadioButton rButton = new JRadioButton();
                    rButton.setEnabled(!cType.isDisable());
                    GUIUtilities.configureButton((AbstractButton)rButton, (String)this.getI18nString(oType.getNameKey()));
                    componentWrapper = new RadioButtonWrapper(labelName, cType.getId(), rButton, oType.getValue(), cType.getWorkflowProperty(), cType.isNotify());
                    compWrapList.add(componentWrapper);
                    bGroup.add(rButton);
                }
                break block3;
            }
            List<ComponentOption> options = this._helper.getOptions(cType.getId());
            if (options == null || options.isEmpty()) break block3;
            for (ComponentOption option : options) {
                JRadioButton rButton = new JRadioButton();
                rButton.setEnabled(!cType.isDisable());
                GUIUtilities.configureButton((AbstractButton)rButton, (String)this.getDisplayName(option));
                componentWrapper = new RadioButtonWrapper(labelName, cType.getId(), rButton, option.getValue(), cType.getWorkflowProperty(), cType.isNotify());
                compWrapList.add(componentWrapper);
                bGroup.add(rButton);
            }
        }
    }

    private ComponentWrapper getEditableChoiceComponent(EditableChoiceType eChoiceType, String labelName) {
        JComboBox comboBox = new JComboBox();
        comboBox.setEnabled(!eChoiceType.isDisable());
        comboBox.setEditable(eChoiceType.isEditable());
        ComboboxWrapper combBoxWrapper = new ComboboxWrapper(labelName, eChoiceType.getId(), comboBox, eChoiceType.getWorkflowProperty(), eChoiceType.isNotify());
        if (!eChoiceType.getOption().isEmpty()) {
            for (OptionType optionType : eChoiceType.getOption()) {
                combBoxWrapper.addItem(this.getI18nString(optionType.getNameKey()), optionType.getValue());
            }
        } else {
            List<ComponentOption> options = this._helper.getOptions(eChoiceType.getId());
            if (options != null && !options.isEmpty()) {
                for (ComponentOption option : options) {
                    combBoxWrapper.addItem(this.getDisplayName(option), option.getValue());
                }
            }
        }
        int w = eChoiceType.getWidth();
        int n = eChoiceType.getHeight();
        this.setComponentDimension(comboBox, w, n);
        if (eChoiceType.getMaxRows() > 0) {
            comboBox.setMaximumRowCount(eChoiceType.getMaxRows());
        }
        return combBoxWrapper;
    }

    private ComponentWrapper getDisplayComponent(DisplayType type) {
        JComponent component;
        if (type instanceof TextType) {
            TextType tType = (TextType)type;
            JTextPane textPane = new JTextPane();
            this.setComponentDimension(textPane, type.getWidth(), type.getHeight());
            textPane.setEditorKit(GUIUtilities.getHTMLEditorKit((boolean)tType.isBold()));
            textPane.setEditable(false);
            textPane.setOpaque(false);
            textPane.setText(this.getI18nString(type.getLabelNameKey()));
            component = textPane;
        } else {
            component = new JLabel(this.getI18nString(type.getLabelNameKey()));
            this.setComponentDimension(component, type.getWidth(), type.getHeight());
        }
        return new ComponentWrapper(null, null, component);
    }

    private void addLabel(List<ComponentWrapper> compWrapList, String labelText, String ID) {
        if (!StringUtil.isNullOrEmpty((String)labelText, (boolean)true)) {
            compWrapList.add(new ComponentWrapper(null, ID.concat(LABEL_SUFFIX), new JLabel(labelText)));
        }
    }

    private String getDisplayName(ComponentOption option) {
        return StringUtil.isNullOrEmpty((String)option.getLocalizeName(), (boolean)true) ? this.getI18nString(option.getNameKey()) : option.getLocalizeName();
    }

    private String getI18nString(String key) {
        String value = ResourceBundleManager.getString((String)this._namespace, (String)key);
        return value == null ? key : value;
    }

    private void setComponentDimension(JComponent c, int width, int height) {
        if (height != 0 && width != 0) {
            c.setPreferredSize(new Dimension(width, height));
        }
    }
}

