/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.gui.components;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class CheckBoxList
extends JList<JCheckBox> {
    protected static Border noFocusBorder = new EmptyBorder(1, 5, 1, 5);

    public CheckBoxList() {
        this.setCellRenderer(new CellRenderer());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int index = CheckBoxList.this.locationToIndex(e.getPoint());
                if (index != -1) {
                    JCheckBox checkbox;
                    checkbox.setSelected(!(checkbox = (JCheckBox)CheckBoxList.this.getModel().getElementAt(index)).isSelected());
                    CheckBoxList.this.repaint();
                }
            }
        });
        this.setSelectionMode(0);
    }

    public CheckBoxList(ListModel<JCheckBox> model) {
        this();
        this.setModel(model);
    }

    protected class CellRenderer
    implements ListCellRenderer<JCheckBox> {
        protected CellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends JCheckBox> list, JCheckBox value, int index, boolean isSelected, boolean cellHasFocus) {
            JCheckBox checkbox = value;
            checkbox.setBackground(isSelected ? CheckBoxList.this.getSelectionBackground() : CheckBoxList.this.getBackground());
            checkbox.setEnabled(CheckBoxList.this.isEnabled());
            checkbox.setFocusPainted(false);
            checkbox.setBorderPainted(true);
            checkbox.setBorder(noFocusBorder);
            return checkbox;
        }
    }
}

