/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.gui.tasks;

import com.oracle.cie.wizard.gui.GUITaskContext;
import com.oracle.cie.wizard.gui.tasks.AbstractGUIConfigTask;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskCachingPolicy;
import com.oracle.cie.wizard.tasks.TaskDescription;
import java.awt.Toolkit;
import java.net.URL;
import java.util.logging.Level;

@TaskDescription(name="configureContext", cachingPolicy=TaskCachingPolicy.REUSE)
public class ConfigureContextGUITask
extends AbstractGUIConfigTask {
    private String _width;
    private String _height;
    private Boolean _resizable;
    private Boolean _showRoadmap;
    private Boolean _allowRoadmapInteraction;
    private String _icon;
    private String _title;
    private String _titleLogo;
    private Boolean _helpButtonVisible;
    private Boolean _nextButtonVisible;
    private Boolean _backButtonVisible;
    private Boolean _finishButtonVisible;
    private boolean _enableFastFinish;

    @TaskAttribute(type=TaskAttributeType.LITERAL)
    public void setWidth(String value) {
        this._width = value;
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL)
    public void setHeight(String value) {
        this._height = value;
    }

    @TaskAttribute(type=TaskAttributeType.BOOLEAN, defaultValue="true")
    public void setResizable(String value) {
        this._resizable = Boolean.valueOf(value);
    }

    @TaskAttribute(type=TaskAttributeType.RESOURCE)
    public void setIcon(String value) {
        this._icon = value;
    }

    @TaskAttribute(type=TaskAttributeType.RESOURCE_KEY)
    public void setTitle(String value) {
        this._title = value;
    }

    @TaskAttribute(type=TaskAttributeType.RESOURCE)
    public void setTitleLogo(String value) {
        this._titleLogo = value;
    }

    @TaskAttribute(type=TaskAttributeType.BOOLEAN, defaultValue="true")
    public void setShowRoadmap(String value) {
        this._showRoadmap = Boolean.valueOf(value);
    }

    @TaskAttribute(type=TaskAttributeType.BOOLEAN, defaultValue="true")
    public void setAllowRoadmapInteraction(String value) {
        this._allowRoadmapInteraction = Boolean.valueOf(value);
    }

    @TaskAttribute(type=TaskAttributeType.BOOLEAN, defaultValue="true")
    public void setHelpButtonVisible(String value) {
        this._helpButtonVisible = Boolean.valueOf(value);
    }

    @TaskAttribute(type=TaskAttributeType.BOOLEAN, defaultValue="true")
    public void setNextButtonVisible(String value) {
        this._nextButtonVisible = Boolean.valueOf(value);
    }

    @TaskAttribute(type=TaskAttributeType.BOOLEAN, defaultValue="true")
    public void setBackButtonVisible(String value) {
        this._backButtonVisible = Boolean.valueOf(value);
    }

    @TaskAttribute(type=TaskAttributeType.BOOLEAN, defaultValue="true")
    public void setFinishButtonVisible(String value) {
        this._finishButtonVisible = Boolean.valueOf(value);
    }

    @TaskAttribute(type=TaskAttributeType.BOOLEAN, defaultValue="false")
    public void setEnableFastFinish(String value) {
        this._enableFastFinish = Boolean.valueOf(value);
    }

    @Override
    public void postConfigureUI() {
        URL imageUrl;
        if (this._width != null && this._height != null) {
            try {
                ((GUITaskContext)this._context).setSize(Integer.parseInt(this._width), Integer.parseInt(this._height));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this._resizable != null) {
            ((GUITaskContext)this._context).setResizable(this._resizable);
        }
        if (this._icon != null) {
            try {
                imageUrl = this.getClass().getClassLoader().getResource(this._icon);
                if (imageUrl != null) {
                    ((GUITaskContext)this._context).setIcon(Toolkit.getDefaultToolkit().getImage(imageUrl));
                }
            }
            catch (Exception x) {
                this._logger.log(Level.SEVERE, "Error loading image " + this._icon, x);
            }
        }
        if (this._title != null) {
            String title = ((GUITaskContext)this._context).getI18nString(this._namespace, this._title);
            ((GUITaskContext)this._context).setFrameTitle(title == null || title.isEmpty() ? this._title : title);
        }
        if (this._titleLogo != null) {
            try {
                imageUrl = this.getClass().getClassLoader().getResource(this._titleLogo);
                if (imageUrl != null) {
                    ((GUITaskContext)this._context).getTitlePanel().setLogoImage(Toolkit.getDefaultToolkit().getImage(imageUrl));
                }
            }
            catch (Exception x) {
                this._logger.log(Level.SEVERE, "Error loading image " + this._titleLogo, x);
            }
        }
        if (this._showRoadmap != null) {
            ((GUITaskContext)this._context).setRoadmapVisible(this._showRoadmap);
        }
        if (this._allowRoadmapInteraction != null) {
            ((GUITaskContext)this._context).allowUserInteractionForRoadmap(this._allowRoadmapInteraction);
        }
        if (this._helpButtonVisible != null) {
            ((GUITaskContext)this._context).setVisibleButtonState(GUITaskContext.ButtonType.HELP, this._helpButtonVisible);
        }
        if (this._nextButtonVisible != null) {
            ((GUITaskContext)this._context).setVisibleButtonState(GUITaskContext.ButtonType.NEXT, this._nextButtonVisible);
        }
        if (this._backButtonVisible != null) {
            ((GUITaskContext)this._context).setVisibleButtonState(GUITaskContext.ButtonType.BACK, this._backButtonVisible);
        }
        if (this._finishButtonVisible != null) {
            ((GUITaskContext)this._context).setVisibleButtonState(GUITaskContext.ButtonType.FINISH, this._finishButtonVisible);
        }
        ((GUITaskContext)this._context).setEnableFastFinish(this._enableFastFinish);
    }

    @Override
    public void unconfigure() {
        this._width = null;
        this._height = null;
        this._resizable = null;
        this._icon = null;
        this._title = null;
        this._titleLogo = null;
        this._showRoadmap = true;
        this._allowRoadmapInteraction = null;
        this._helpButtonVisible = null;
        this._nextButtonVisible = null;
        this._backButtonVisible = null;
        this._finishButtonVisible = null;
    }
}

