/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.gui.tasks;

import com.oracle.cie.common.comdev.ComdevHelper;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.wizard.gui.GUITaskContext;
import com.oracle.cie.wizard.gui.tasks.AbstractGUIConfigTask;
import com.oracle.cie.wizard.help.HelpProvider;
import com.oracle.cie.wizard.help.HelpProviderException;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskCachingPolicy;
import com.oracle.cie.wizard.tasks.TaskDescription;
import java.util.logging.Level;

@TaskDescription(name="help", cachingPolicy=TaskCachingPolicy.REUSE)
public class ConfigureHelpTask
extends AbstractGUIConfigTask {
    public static final String DEFAULT_PROVIDER = "com.oracle.cie.wizard.help.DefaultHelpProvider";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    protected String _helpSetName;
    protected String _helpJarName;
    protected String _classname;
    protected String _helpjarLoc;

    @TaskAttribute(type=TaskAttributeType.CLASS, typeConstraints={"com.oracle.cie.wizard.help.HelpProvider"}, defaultValue="com.oracle.cie.wizard.help.DefaultHelpProvider")
    public void setHelpClass(String classname) {
        this._classname = classname;
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL)
    public void setHelpSetName(String helpSetName) {
        this._helpSetName = helpSetName;
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL)
    public void setHelpJarName(String helpJarName) {
        this._helpJarName = helpJarName;
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL)
    public void setHelpJarLoc(String helpjarLoc) {
        this._helpjarLoc = helpjarLoc;
    }

    @Override
    public void postConfigureUI() {
        if (this._classname == null) {
            this._classname = DEFAULT_PROVIDER;
        }
        try {
            this._logger.finer("Base Help Jar Location:" + this._helpjarLoc);
            String baseHelpJarLoc = ((GUITaskContext)this._context).substitute(this._namespace, this._helpjarLoc);
            this._helpJarName = ((GUITaskContext)this._context).substitute(this._namespace, this._helpJarName);
            this._helpSetName = ((GUITaskContext)this._context).substitute(this._namespace, this._helpSetName);
            if (StringUtil.isNullOrEmpty((String)this._helpJarName) && StringUtil.isNullOrEmpty((String)baseHelpJarLoc) && StringUtil.isNullOrEmpty((String)this._helpSetName)) {
                this._logger.log(Level.INFO, "The necessary parameters (helpJarLoc: '" + baseHelpJarLoc + "', helpJarName:'" + this._helpJarName + "', helpSetName:'" + this._helpSetName + "') to enable help are not provided");
                return;
            }
            if (StringUtil.isNullOrEmpty((String)this._helpJarName) || StringUtil.isNullOrEmpty((String)baseHelpJarLoc) || StringUtil.isNullOrEmpty((String)this._helpSetName)) {
                this._logger.log(Level.WARNING, "The necessary parameters (helpJarLoc: '" + baseHelpJarLoc + "', helpJarName:'" + this._helpJarName + "', helpSetName:'" + this._helpSetName + "') to enable help are not provided");
                return;
            }
            baseHelpJarLoc = ((GUITaskContext)this._context).substitute(this._namespace, baseHelpJarLoc);
            String urlChunk = "jar:file:/";
            if ("/".equals(FILE_SEPARATOR) || ComdevHelper.isWindows() && baseHelpJarLoc.trim().startsWith(FILE_SEPARATOR)) {
                urlChunk = urlChunk + "/";
            }
            String helpJarLoc = urlChunk + baseHelpJarLoc + FILE_SEPARATOR;
            Class<?> clazz = Class.forName(this._classname);
            HelpProvider help_ohj = (HelpProvider)clazz.newInstance();
            help_ohj.init(this._helpJarName, this._helpSetName, helpJarLoc);
            ((GUITaskContext)this._context).setHelpProvider(help_ohj);
        }
        catch (NoClassDefFoundError e) {
            this._logger.log(Level.SEVERE, "Referenced classes not found in classPath when loading " + this._classname, e);
        }
        catch (HelpProviderException e) {
            this._logger.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (Throwable e) {
            this._logger.log(Level.SEVERE, "Not able to load the " + this._classname + "class", e);
        }
    }
}

