/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.gui.tasks;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.wizard.ext.progress.Phase;
import com.oracle.cie.wizard.ext.progress.PostProgressOperator;
import com.oracle.cie.wizard.ext.progress.ProgressListener;
import com.oracle.cie.wizard.ext.progress.ProgressOperationException;
import com.oracle.cie.wizard.ext.progress.ProgressOperator;
import com.oracle.cie.wizard.gui.GUITaskContext;
import com.oracle.cie.wizard.gui.components.ProgressStatusTableCellRenderer;
import com.oracle.cie.wizard.gui.msgpanel.MessageType;
import com.oracle.cie.wizard.gui.tasks.AbstractGUITask;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

@TaskDescription(name="operation_progress_gui_task")
public class ProgressGUITask
extends AbstractGUITask {
    private PhaseTableModel _model;
    private ProgressOperator _progressOperator;
    private JProgressBar _progressBar = null;
    private String _progressOperatorClass = null;
    private boolean _continueOnError = false;
    private boolean _disableCancelOnSuccess = false;
    private String _postProgressOperatorClass = null;
    protected PostProgressOperator _postProgressOperator;

    @TaskAttribute(type=TaskAttributeType.BOOLEAN, defaultValue="false")
    public void setContinueOnError(String continueOnError) {
        this._continueOnError = Boolean.parseBoolean(continueOnError);
    }

    @TaskAttribute(type=TaskAttributeType.BOOLEAN, required=false, defaultValue="false")
    public void setDisableCancelOnSuccess(String disableCancelOnSuccess) {
        this._disableCancelOnSuccess = Boolean.parseBoolean(disableCancelOnSuccess);
    }

    @TaskAttribute(type=TaskAttributeType.CLASS, typeConstraints={"com.oracle.cie.wizard.ext.progress.ProgressOperator"})
    public void setProgressOperatorClass(String clazz) {
        this._progressOperatorClass = clazz;
    }

    @TaskAttribute(type=TaskAttributeType.CLASS, typeConstraints={"com.oracle.cie.wizard.ext.progress.PostProgressOperator"})
    public void setPostProgressOperatorClass(String clazz) {
        this._postProgressOperatorClass = clazz;
    }

    @Override
    public void configure(GUITaskContext context) throws TaskExecutionException {
        super.configure(context);
        Object obj = ((GUITaskContext)this._context).retrieveObject(this._namespace, "PROGRESS_OPERATOR_CLASS_NAME");
        try {
            if (!StringUtil.isNullOrEmpty((String)this._progressOperatorClass)) {
                this._progressOperatorClass = ((GUITaskContext)this._context).substitute(this._namespace, this._progressOperatorClass);
                ClassLoader classLoader = ProgressGUITask.class.getClassLoader();
                Class<?> loaderClass = classLoader.loadClass(this._progressOperatorClass);
                this._progressOperator = (ProgressOperator)loaderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (this._progressOperator == null) {
                    throw new TaskExecutionException(this, "Unable to initialze progress operator class :: " + this._progressOperatorClass);
                }
            } else if (obj != null && obj instanceof ProgressOperator) {
                this._progressOperator = (ProgressOperator)obj;
            } else {
                throw new TaskExecutionException(this, "Unable to retrieve ProgressOperator class.");
            }
            if (!StringUtil.isNullOrEmpty((String)this._postProgressOperatorClass)) {
                Class<?> loaderClass = ProgressGUITask.class.getClassLoader().loadClass(this._postProgressOperatorClass);
                this._postProgressOperator = (PostProgressOperator)loaderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (this._postProgressOperator == null) {
                    throw new TaskExecutionException(this, "Unable to initialze post progress operator class :: " + this._postProgressOperatorClass);
                }
            }
            this._progressOperator.init();
            this._progressOperator.addProgressListener(new OperationProgressListener());
        }
        catch (Exception e) {
            throw new TaskExecutionException(this, "Unable to retrieve ProgressOperation instance", e);
        }
    }

    @Override
    public JComponent createUI() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        this._progressBar = new JProgressBar();
        this._progressBar.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(16, 10, 16, 10), this._progressBar.getBorder()));
        this._progressBar.setStringPainted(true);
        this._progressBar.setMinimum(0);
        this._progressBar.setMaximum(this._progressOperator.getLength());
        this._progressBar.setValue(0);
        mainPanel.add((Component)this._progressBar, "North");
        this._model = new PhaseTableModel(this._progressOperator.getOperationPhases());
        JTable table = new JTable(this._model);
        TableColumn statusColumn = table.getColumnModel().getColumn(0);
        int testColumnWidth = 25;
        statusColumn.setMaxWidth(testColumnWidth);
        statusColumn.setMinWidth(testColumnWidth);
        table.setDefaultRenderer(Object.class, new ProgressStatusTableCellRenderer());
        table.setTableHeader(null);
        table.setOpaque(false);
        table.setRowSelectionAllowed(false);
        table.setColumnSelectionAllowed(false);
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setWheelScrollingEnabled(true);
        final JTable jtableRef = table;
        table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Point p = e.getPoint();
                int row = jtableRef.rowAtPoint(p);
                int col = jtableRef.columnAtPoint(p);
                if (col == 0) {
                    jtableRef.setToolTipText(String.valueOf(jtableRef.getValueAt(row, 1)) + " " + String.valueOf(jtableRef.getValueAt(row, 0)));
                }
                if (col == 1) {
                    jtableRef.setToolTipText(String.valueOf(jtableRef.getValueAt(row, 1)));
                }
            }
        });
        mainPanel.add((Component)scrollPane, "Center");
        return mainPanel;
    }

    @Override
    public void startBackgroundProcess() {
        new Thread(this._progressOperator).start();
    }

    @Override
    public void postConfigureUI() {
        ((GUITaskContext)this._context).enableFlowActions(false);
    }

    @Override
    public boolean okPrev() {
        return false;
    }

    @Override
    public boolean okNext() {
        boolean enableNext = true;
        if (this._progressOperator.hasFailure()) {
            for (ProgressOperationException exception : this._progressOperator.getFailures()) {
                ((GUITaskContext)this._context).addPanelValidationMessage(exception.getPublishedMessage());
            }
            if (this._progressOperator.getLength() >= this._progressBar.getValue()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProgressGUITask.this._progressBar.setValue(ProgressGUITask.this._progressBar.getValue() - 1);
                    }
                });
            }
            if (!this._continueOnError) {
                enableNext = false;
            }
        }
        if (this._progressOperator.hasWarnings()) {
            for (String warning : this._progressOperator.getWarnings()) {
                ((GUITaskContext)this._context).addPanelValidationMessage(MessageType.WARNING, warning, "");
            }
        }
        return enableNext;
    }

    private String getI18nValue(String key) {
        String value = ((GUITaskContext)this._context).getI18nString(this._namespace, key);
        return StringUtil.isNullOrEmpty((String)value) ? key : value;
    }

    private class PhaseTableModel
    extends AbstractTableModel {
        private LinkedHashMap<Phase, Phase.Status> _phaseStatusMap;
        private List<? extends Phase> _phases;

        PhaseTableModel(List<? extends Phase> phases) {
            this._phases = phases;
            this._phaseStatusMap = new LinkedHashMap(phases.size(), 1.0f);
            for (Phase phase : phases) {
                this._phaseStatusMap.put(phase, Phase.Status.PENDING);
            }
        }

        @Override
        public int getRowCount() {
            return this._phases != null ? this._phases.size() : 0;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            super.setValueAt(aValue, rowIndex, columnIndex);
            if (this._phases == null || this._phases.isEmpty()) {
                return;
            }
            Phase phase = this._phases.get(rowIndex);
            if (columnIndex == 0 && aValue instanceof Phase.Status) {
                this._phaseStatusMap.put(phase, (Phase.Status)((Object)aValue));
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this._phases == null || this._phases.size() <= 0) {
                return null;
            }
            Phase phase = this._phases.get(rowIndex);
            Object result = null;
            switch (columnIndex) {
                case 0: {
                    result = this._phaseStatusMap.get(phase);
                    break;
                }
                case 1: {
                    result = ProgressGUITask.this.getI18nValue(phase.getNameKey());
                }
            }
            return result;
        }

        public void updatePhaseStatus(Phase phase, Phase.Status status) {
            int i = 0;
            for (Phase phase2 : this._phases) {
                if (phase2.getID() == phase.getID()) {
                    this.setValueAt((Object)status, i, 0);
                    if (!Phase.Status.DISABLED.equals((Object)status)) break;
                    this.setValueAt(phase, i, 1);
                    break;
                }
                ++i;
            }
        }
    }

    private class OperationProgressListener
    implements ProgressListener {
        private OperationProgressListener() {
        }

        @Override
        public void started(ProgressOperator operation) {
        }

        @Override
        public void updateTotalProgress(ProgressOperator operation, final int length) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressGUITask.this._progressBar.setValue(length);
                }
            });
        }

        @Override
        public void updateProgress(ProgressOperator operation, Phase phase, final int length) {
            if (length > phase.getLength()) {
                ProgressGUITask.this._logger.log(Level.WARNING, "Progress bar not updated as the given length '" + length + "' is more than phase " + ProgressGUITask.this.getI18nValue(phase.getNameKey()) + " length");
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressGUITask.this._progressBar.setValue(ProgressGUITask.this._progressBar.getValue() + length);
                }
            });
        }

        @Override
        public void updatePhaseStatus(final Phase phase, final Phase.Status status) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressGUITask.this._model.updatePhaseStatus(phase, status);
                    if (ProgressGUITask.this._progressOperator.hasFailure()) {
                        for (ProgressOperationException exception : ProgressGUITask.this._progressOperator.getFailures()) {
                            ((GUITaskContext)ProgressGUITask.this._context).addPanelValidationMessage(exception.getPublishedMessage());
                        }
                        ((GUITaskContext)ProgressGUITask.this._context).enableFlowActions(true);
                        if (ProgressGUITask.this._continueOnError) {
                            ((GUITaskContext)ProgressGUITask.this._context).setEnabledButtonState(GUITaskContext.ButtonType.NEXT, true);
                        }
                        if (ProgressGUITask.this._postProgressOperator != null && !ProgressGUITask.this._continueOnError) {
                            ProgressGUITask.this._postProgressOperator.postProgressOperation(ProgressGUITask.this);
                        }
                    }
                    if (ProgressGUITask.this._progressOperator.hasWarnings()) {
                        for (String warning : ProgressGUITask.this._progressOperator.getWarnings()) {
                            ((GUITaskContext)ProgressGUITask.this._context).addPanelValidationMessage(MessageType.WARNING, warning, "");
                        }
                    }
                }
            });
        }

        @Override
        public void completed(ProgressOperator operation) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ProgressGUITask.this._postProgressOperator != null) {
                        ProgressGUITask.this._postProgressOperator.postProgressOperation(ProgressGUITask.this);
                    }
                    ((GUITaskContext)ProgressGUITask.this._context).enableFlowActions(true);
                    if (ProgressGUITask.this._disableCancelOnSuccess && !ProgressGUITask.this._progressOperator.hasFailure()) {
                        ((GUITaskContext)ProgressGUITask.this._context).setEnabledButtonState(GUITaskContext.ButtonType.CANCEL, false);
                    }
                }
            });
        }
    }
}

