/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.internal.cont;

import com.oracle.cie.common.util.ObjectStoreManager;
import com.oracle.cie.common.util.PublishedMessage;
import com.oracle.cie.common.util.ResourceBundleManager;
import com.oracle.cie.wizard.ControllerProxy;
import com.oracle.cie.wizard.WizardConfiguration;
import com.oracle.cie.wizard.tasks.TaskContext;
import com.oracle.cie.wizard.tasks.TraversalMode;
import java.io.FileNotFoundException;
import java.util.Locale;
import java.util.Map;

class DefaultTaskContext
implements TaskContext {
    protected ControllerProxy _proxy;

    DefaultTaskContext(ControllerProxy proxy) {
        this._proxy = proxy;
    }

    @Override
    public WizardConfiguration getConfiguration() {
        return this._proxy.getConfiguration();
    }

    @Override
    public String getWorkflowProperty(String name) {
        return this._proxy.getWorkflowProperty(name);
    }

    @Override
    public void setWorkflowProperty(String name, String value) {
        this._proxy.setWorkflowProperty(name, value);
    }

    @Override
    public Object storeObject(Object key, Object value) {
        return ObjectStoreManager.getObjectStore().storeObject(key, value);
    }

    @Override
    public Object storeObject(String namespace, Object key, Object value) {
        return ObjectStoreManager.getObjectStore((String)namespace).storeObject(key, value);
    }

    @Override
    public void storeAll(Map<?, ?> map) {
        ObjectStoreManager.getObjectStore().storeAll(map);
    }

    @Override
    public void storeAll(String namespace, Map<?, ?> map) {
        ObjectStoreManager.getObjectStore((String)namespace).storeAll(map);
    }

    @Override
    public void storeAll(String filename) throws FileNotFoundException {
        this.storeAll(null, filename);
    }

    @Override
    public void storeAll(String namespace, String filename) throws FileNotFoundException {
        if (filename == null) {
            throw new IllegalArgumentException("Filename must be non-null!");
        }
        ObjectStoreManager.loadNamespace((String)namespace, (String)filename, (boolean)true);
    }

    @Override
    public void storeNew(Map<?, ?> map) {
        ObjectStoreManager.getObjectStore().storeNew(map);
    }

    @Override
    public void storeNew(String namespace, Map<?, ?> map) {
        ObjectStoreManager.getObjectStore((String)namespace).storeNew(map);
    }

    @Override
    public void storeNew(String filename) throws FileNotFoundException {
        this.storeNew(null, filename);
    }

    @Override
    public void storeNew(String namespace, String filename) throws FileNotFoundException {
        if (filename == null) {
            throw new IllegalArgumentException("Filename must be non-null!");
        }
        ObjectStoreManager.loadNamespace((String)namespace, (String)filename, (boolean)false);
    }

    @Override
    public Object retrieveObject(Object key) {
        return this.retrieve(null, key);
    }

    @Override
    public Object retrieveObject(String namespace, Object key) {
        return this.retrieve(namespace, key);
    }

    @Override
    public Object removeObject(Object key) {
        return ObjectStoreManager.getObjectStore().removeObject(key);
    }

    @Override
    public Object removeObject(String namespace, Object key) {
        return ObjectStoreManager.getObjectStore((String)namespace).removeObject(key);
    }

    @Override
    public String getString(String key) {
        return this.get(null, key);
    }

    @Override
    public String getString(String namespace, String key) {
        return this.get(namespace, key);
    }

    @Override
    public String substitute(String var) {
        return ObjectStoreManager.getObjectStore().substitute(var);
    }

    @Override
    public String substitute(String namespace, String var) {
        return ObjectStoreManager.getObjectStore((String)namespace).substitute(var);
    }

    @Override
    public void setLocale(Locale locale) {
        ResourceBundleManager.setLocale((Locale)locale);
        Locale.setDefault(locale);
    }

    @Override
    public Locale getLocale() {
        return ResourceBundleManager.getLocale();
    }

    @Override
    public String getI18nString(String key) {
        String value = ResourceBundleManager.getString((String)key);
        return value == null ? "" : value;
    }

    @Override
    public String getI18nString(String namespace, String key) {
        String value = ResourceBundleManager.getString((String)namespace, (String)key);
        return value == null ? "" : value;
    }

    @Override
    public PublishedMessage getPublishedMessage(String code, Object ... causeParams) {
        return ResourceBundleManager.getPublishedMessage((String)code, (Object[])causeParams);
    }

    @Override
    public PublishedMessage getPublishedMessage(String namespace, String code, Object ... causeParams) {
        return ResourceBundleManager.getPublishedMessage((String)namespace, (String)code, (Object[])causeParams);
    }

    @Override
    public String i18nSubstitute(String key) {
        return ResourceBundleManager.substitute((String)key);
    }

    @Override
    public String i18nSubstitute(String namespace, String key) {
        return ResourceBundleManager.substitute((String)namespace, (String)key);
    }

    @Override
    public String subI18nString(String key) {
        String value = ResourceBundleManager.getString((String)key);
        return value == null ? "" : this.substitute(value);
    }

    @Override
    public String subI18nString(String namespace, String key) {
        String value = ResourceBundleManager.getString((String)namespace, (String)key);
        return value == null ? "" : this.substitute(namespace, value);
    }

    @Override
    public void setReturnCode(int code) {
        this._proxy.setReturnCode(code);
    }

    @Override
    public TraversalMode getTraversalMode() {
        return this._proxy.getTraversalMode();
    }

    @Override
    public Object storeLocalObject(Object key, Object value) {
        return this._proxy.setLocalObject(key, value);
    }

    @Override
    public Object removeLocalObject(Object key) {
        return this._proxy.removeLocalObject(key);
    }

    private String get(String namespace, String key) {
        if (this._proxy.hasDefinedLocalObject(key)) {
            Object value = this._proxy.retrieveLocalObject(key);
            return value == null ? "" : value.toString();
        }
        return namespace == null ? ObjectStoreManager.getObjectStore().getString(key) : ObjectStoreManager.getObjectStore((String)namespace).getString(key);
    }

    private Object retrieve(String namespace, Object key) {
        if (this._proxy.hasDefinedLocalObject(key)) {
            return this._proxy.retrieveLocalObject(key);
        }
        return namespace == null ? ObjectStoreManager.getObjectStore().retrieveObject(key) : ObjectStoreManager.getObjectStore((String)namespace).retrieveObject(key);
    }

    static {
        ResourceBundleManager.manageBundle((String)"wizard", (String)"resources/wizard/wizard_tasks");
    }
}

