/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.internal.cont;

import com.oracle.cie.wizard.ControllerProxy;
import com.oracle.cie.wizard.WizardCompletionInfo;
import com.oracle.cie.wizard.WizardException;
import com.oracle.cie.wizard.internal.cont.AbstractTaskContainer;
import com.oracle.cie.wizard.internal.cont.DefaultTaskContext;
import com.oracle.cie.wizard.silent.tasks.SilentTask;
import com.oracle.cie.wizard.tasks.TaskContext;
import com.oracle.cie.wizard.tasks.TraversalMode;

public class SilentTaskContainer
extends AbstractTaskContainer<TaskContext, SilentTask, DefaultTaskContext> {
    protected Thread _taskThread;
    protected TaskRunner _runner;

    @Override
    public void init(ControllerProxy proxy) {
        super.init(proxy);
        this._runner = new TaskRunner();
    }

    @Override
    public boolean isSupported(Class<?> taskClass) {
        return taskClass != null && SilentTask.class.isAssignableFrom(taskClass);
    }

    @Override
    public boolean bypassTask() throws WizardException {
        this.doExecuteTask(false);
        return this.isTaskComplete(this._traversalMode);
    }

    @Override
    public void executeTask() {
        this.doExecuteTask(true);
    }

    @Override
    public boolean isTaskComplete(TraversalMode direction) {
        Thread t = this._taskThread;
        if (t != null && this._taskThread.isAlive()) {
            while (true) {
                try {
                    t.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        return true;
    }

    @Override
    protected DefaultTaskContext createTaskContext() {
        return new DefaultTaskContext(this._proxy);
    }

    protected void doExecuteTask(boolean requestProxyAction) {
        this._runner.setRequestProxyAction(requestProxyAction);
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        this._taskThread = tg != null && tg.getName().startsWith("ParalledEmbeddedEngineGroup_") ? new Thread((Runnable)this._runner, Thread.currentThread().getName()) : new Thread((Runnable)this._runner, ((SilentTask)this._task).getEntry().getTaskDefinition().getName());
        this._taskThread.start();
    }

    protected class TaskRunner
    implements Runnable {
        boolean _requestProxyAction;

        protected TaskRunner() {
        }

        public void setRequestProxyAction(boolean requestProxyAction) {
            this._requestProxyAction = requestProxyAction;
        }

        @Override
        public void run() {
            try {
                ((SilentTask)SilentTaskContainer.this._task).execute();
            }
            catch (Throwable t) {
                SilentTaskContainer.this._proxy.error(WizardCompletionInfo.getInstance().getFatalErrorCode(), t);
            }
            if (this._requestProxyAction) {
                if (SilentTaskContainer.this._traversalMode == TraversalMode.FORWARD) {
                    SilentTaskContainer.this._proxy.goNext();
                } else {
                    SilentTaskContainer.this._proxy.goPrevious();
                }
            }
        }
    }
}

