/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.internal.engine;

import com.oracle.cie.wizard.ControllerProxy;
import com.oracle.cie.wizard.WizardConfiguration;
import com.oracle.cie.wizard.WizardMode;
import com.oracle.cie.wizard.WizardState;
import com.oracle.cie.wizard.event.WizardStateChangeListener;
import com.oracle.cie.wizard.event.WizardTaskActionListener;
import com.oracle.cie.wizard.event.WizardWorkflowListener;
import com.oracle.cie.wizard.internal.engine.EmbeddedEngine;
import com.oracle.cie.wizard.internal.engine.UpdatableURLClassLoader;
import com.oracle.cie.wizard.internal.engine.WizardCommandAction;
import com.oracle.cie.wizard.internal.engine.WizardControllerEngine;
import com.oracle.cie.wizard.tasks.TraversalMode;
import com.oracle.cie.wizard.wcf.TaskEntry;
import java.net.URL;
import java.util.List;

class WizardControllerProxy
implements ControllerProxy {
    private EmbeddedEngine _controller = null;

    WizardControllerProxy(EmbeddedEngine controller) {
        this._controller = controller;
    }

    @Override
    public WizardConfiguration getConfiguration() {
        return this._controller.getConfiguration();
    }

    @Override
    public WizardMode getMode() {
        return this._controller.getMode();
    }

    @Override
    public WizardState getState() {
        return this._controller.getState();
    }

    @Override
    public Throwable getErrorCause() {
        return this._controller.getErrorCause();
    }

    @Override
    public Integer getReturnCode() {
        return this._controller instanceof WizardControllerEngine ? ((WizardControllerEngine)this._controller).getReturnCode() : null;
    }

    @Override
    public void setReturnCode(int code) {
        if (this._controller instanceof WizardControllerEngine) {
            ((WizardControllerEngine)this._controller).setReturnCode(code);
        }
    }

    @Override
    public List<TaskEntry> getWorkflowEntries() {
        return this._controller.getWorkflow().getEntries();
    }

    @Override
    public TaskEntry getWorkflowEntryAt(int index) {
        return this._controller.getWorkflow().getEntryAt(index);
    }

    @Override
    public TaskEntry getCurrentWorkflowEntry() {
        return this._controller.getWorkflow().getCurrentEntry();
    }

    @Override
    public int getWorkflowSize() {
        return this._controller.getWorkflow().getSize();
    }

    @Override
    public int getCurrentWorkflowIndex() {
        return this._controller.getWorkflow().getCurrentIndex();
    }

    @Override
    public int getTaskIndex(TaskEntry task) {
        return this._controller.getWorkflow().getIndex(task);
    }

    @Override
    public String getWorkflowProperty(String name) {
        return this._controller.getWorkflow().getFlowProperty(name);
    }

    @Override
    public void setWorkflowProperty(String name, String value) {
        this._controller.getWorkflow().setFlowProperty(name, value);
    }

    @Override
    public void goNext() {
        this._controller.requestWizardAction(new WizardCommandAction(WizardCommandAction.WizardCommand.NEXT, new Object[0]));
    }

    @Override
    public void goPrevious() {
        this._controller.requestWizardAction(new WizardCommandAction(WizardCommandAction.WizardCommand.PREV, new Object[0]));
    }

    @Override
    public void goToTaskEntry(TaskEntry task) {
        this._controller.requestWizardAction(new WizardCommandAction(WizardCommandAction.WizardCommand.GOTO, task));
    }

    @Override
    public void suspend() {
        this._controller.requestWizardAction(new WizardCommandAction(WizardCommandAction.WizardCommand.SUSPEND, new Object[0]));
    }

    @Override
    public void resume() {
        this._controller.requestWizardAction(new WizardCommandAction(WizardCommandAction.WizardCommand.RESUME, new Object[0]));
    }

    @Override
    public void finish() {
        this._controller.requestWizardAction(new WizardCommandAction(WizardCommandAction.WizardCommand.FAST_FINISH, new Object[0]));
    }

    @Override
    public void error(int returnCode, Throwable ex) {
        this._controller.requestWizardAction(new WizardCommandAction(WizardCommandAction.WizardCommand.ERROR, returnCode, ex));
    }

    @Override
    public void cancel() {
        this._controller.requestWizardAction(new WizardCommandAction(WizardCommandAction.WizardCommand.CANCEL, new Object[0]));
    }

    @Override
    public void cancel(int returnCode) {
        this._controller.requestWizardAction(new WizardCommandAction(WizardCommandAction.WizardCommand.CANCEL, returnCode));
    }

    @Override
    public void addWizardStateChangeListener(WizardStateChangeListener listener) {
        this._controller.addWizardStateChangeListener(listener);
    }

    @Override
    public void removeWizardStateChangeListener(WizardStateChangeListener listener) {
        this._controller.removeWizardStateChangeListener(listener);
    }

    @Override
    public void addWizardWorkflowListener(WizardWorkflowListener listener) {
        this._controller.getWorkflow().addWizardWorkflowListener(listener);
    }

    @Override
    public void removeWizardWorkflowListener(WizardWorkflowListener listener) {
        this._controller.getWorkflow().removeWizardWorkflowListener(listener);
    }

    @Override
    public void addWizardTaskActionListener(WizardTaskActionListener listener) {
        this._controller.addWizardTaskActionListener(listener);
    }

    @Override
    public void removeWizardTaskActionListener(WizardTaskActionListener listener) {
        this._controller.removeWizardTaskActionListener(listener);
    }

    @Override
    public UpdatableURLClassLoader getTaskClassLoader() {
        return this._controller.getTaskClassLoader();
    }

    @Override
    public void addJarToClassPath(URL jarUrl) {
        this._controller.getTaskClassLoader().addURL(jarUrl);
    }

    @Override
    public TraversalMode getTraversalMode() {
        return this._controller.getTraversalMode();
    }

    @Override
    public boolean isEmbeddedProcess() {
        return this._controller.isEmbeddedProcess();
    }

    @Override
    public boolean hasDefinedLocalObject(Object key) {
        return this._controller.hasDefinedLocalObject(key);
    }

    @Override
    public Object retrieveLocalObject(Object key) {
        return this._controller.retrieveLocalObject(key);
    }

    @Override
    public Object setLocalObject(Object key, Object value) {
        return this._controller.setLocalObject(key, value);
    }

    @Override
    public Object removeLocalObject(Object key) {
        return this._controller.removeLocalObject(key);
    }
}

