/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.internal.tasks;

import com.oracle.cie.wizard.internal.cont.InternalTaskContext;
import com.oracle.cie.wizard.internal.tasks.AbstractInternalTask;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskCachingPolicy;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import java.util.logging.Level;

@TaskDescription(name="invokeMethod", cachingPolicy=TaskCachingPolicy.REUSE)
public class InvokeMethodTask
extends AbstractInternalTask {
    protected String _storageKey = null;
    protected String _invocationTargetKey = null;
    protected String _methodName = null;
    protected String _parameter1Key = null;
    protected String _parameter2Key = null;
    protected String _parameter3Key = null;
    protected String _parameter1Type = null;
    protected String _parameter2Type = null;
    protected String _parameter3Type = null;

    @TaskAttribute(type=TaskAttributeType.OBJECT_STORE_KEY, required=true)
    public void setInvocationTargetKey(String key) {
        this._invocationTargetKey = key;
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL, required=true)
    public void setMethodName(String methodName) {
        this._methodName = methodName;
    }

    @TaskAttribute(type=TaskAttributeType.OBJECT_STORE_KEY)
    public void setParameter1Key(String parameter1Key) {
        this._parameter1Key = parameter1Key;
    }

    @TaskAttribute(type=TaskAttributeType.OBJECT_STORE_KEY)
    public void setParameter2Key(String parameter2Key) {
        this._parameter2Key = parameter2Key;
    }

    @TaskAttribute(type=TaskAttributeType.OBJECT_STORE_KEY)
    public void setParameter3Key(String parameter3Key) {
        this._parameter3Key = parameter3Key;
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL)
    public void setParameter1Type(String parameter1Type) {
        this._parameter1Type = parameter1Type;
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL)
    public void setParameter2Type(String parameter2Type) {
        this._parameter2Type = parameter2Type;
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL)
    public void setParameter3Type(String parameter3Type) {
        this._parameter3Type = parameter3Type;
    }

    @TaskAttribute(type=TaskAttributeType.OBJECT_STORE_KEY)
    public void setStorageKey(String key) {
        this._storageKey = key;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void execute() throws TaskExecutionException {
        size = this._parameter1Key != null ? (this._parameter2Key != null ? (this._parameter3Key != null ? 3 : 2) : 1) : 0;
        parameterTypes = new Class[size];
        parameterValues = new Object[size];
        switch (size) {
            case 3: {
                parameterValues[2] = ((InternalTaskContext)this._context).retrieveObject(this._namespace, this._parameter3Key);
                if (this._parameter3Type == null) ** GOTO lbl15
                try {
                    loader = ((InternalTaskContext)this._context).getProxy().getTaskClassLoader();
                    parameterTypes[2] = clazz = loader.loadClass(this._parameter3Type);
                    ** GOTO lbl16
                }
                catch (ClassNotFoundException cnfx) {
                    this._logger.log(Level.SEVERE, cnfx.toString(), cnfx);
                    throw new TaskExecutionException(this, "Can't find class: " + this._parameter3Type, cnfx);
                }
lbl15:
                // 1 sources

                parameterTypes[2] = parameterValues[2].getClass();
            }
lbl16:
            // 3 sources

            case 2: {
                parameterValues[1] = ((InternalTaskContext)this._context).retrieveObject(this._namespace, this._parameter2Key);
                if (this._parameter2Type == null) ** GOTO lbl25
                try {
                    parameterTypes[1] = clazz = Class.forName(this._parameter2Type);
                    ** GOTO lbl26
                }
                catch (ClassNotFoundException cnfx) {
                    this._logger.log(Level.SEVERE, cnfx.toString(), cnfx);
                    throw new TaskExecutionException(this, "Can't find class: " + this._parameter2Type, cnfx);
                }
lbl25:
                // 1 sources

                parameterTypes[1] = parameterValues[1].getClass();
            }
lbl26:
            // 3 sources

            case 1: {
                parameterValues[0] = ((InternalTaskContext)this._context).retrieveObject(this._namespace, this._parameter1Key);
                if (this._parameter1Type != null) {
                    try {
                        parameterTypes[0] = clazz = Class.forName(this._parameter1Type);
                        break;
                    }
                    catch (ClassNotFoundException cnfx) {
                        this._logger.log(Level.SEVERE, cnfx.toString(), cnfx);
                        throw new TaskExecutionException(this, "Can't find class: " + this._parameter1Type, cnfx);
                    }
                }
                parameterTypes[0] = parameterValues[0].getClass();
            }
        }
        target = ((InternalTaskContext)this._context).retrieveObject(this._namespace, this._invocationTargetKey);
        if (target == null) {
            this._logger.severe("Invocation Object not provided!");
            throw new TaskExecutionException(this, "Unable to locate invocation object " + this._invocationTargetKey + " in InvokeMethodTask");
        }
        try {
            method = target.getClass().getMethod(this._methodName, parameterTypes.length == 0 ? null : parameterTypes);
            result = method.invoke(target, parameterValues.length == 0 ? null : parameterValues);
            this._logger.finer("Successfully invoked " + method.getName() + " with result <" + result + ">");
            if (this._storageKey != null) {
                ((InternalTaskContext)this._context).storeObject(this._namespace, this._storageKey, result);
            }
        }
        catch (Exception x) {
            this._logger.log(Level.SEVERE, "Unable to invoke " + this._methodName + " on class <" + target.getClass() + ">", x);
            throw new TaskExecutionException(this, "Unable to invoke " + this._methodName + " in InvokeMethodTask", x);
        }
    }

    @Override
    public void unconfigure() {
        this._invocationTargetKey = null;
        this._methodName = null;
        this._storageKey = null;
        this._parameter1Key = null;
        this._parameter2Key = null;
        this._parameter3Key = null;
        this._parameter1Type = null;
        this._parameter2Type = null;
        this._parameter3Type = null;
    }
}

