/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.internal.wcf;

import com.oracle.cie.wizard.internal.wcf.EntryElem;
import com.oracle.cie.wizard.internal.wcf.GenericTaskEntryElem;
import com.oracle.cie.wizard.internal.wcf.IncludeElem;
import com.oracle.cie.wizard.internal.wcf.LoopElem;
import com.oracle.cie.wizard.internal.wcf.LoopRefElem;
import com.oracle.cie.wizard.internal.wcf.Subflow;
import com.oracle.cie.wizard.internal.wcf.SwitchElem;
import com.oracle.cie.wizard.internal.wcf.UITaskEntryElem;
import com.oracle.cie.wizard.internal.wcf.xml.BreakType;
import com.oracle.cie.wizard.internal.wcf.xml.ContinueType;
import com.oracle.cie.wizard.internal.wcf.xml.EntryType;
import com.oracle.cie.wizard.internal.wcf.xml.GenericTaskType;
import com.oracle.cie.wizard.internal.wcf.xml.IncludeType;
import com.oracle.cie.wizard.internal.wcf.xml.LoopStatementType;
import com.oracle.cie.wizard.internal.wcf.xml.LoopType;
import com.oracle.cie.wizard.internal.wcf.xml.SwitchType;
import com.oracle.cie.wizard.internal.wcf.xml.UITaskType;
import com.oracle.cie.wizard.wcf.ExecPlanException;

class EntryElemFactory {
    private static EntryElemFactory s_factory = new EntryElemFactory();

    EntryElemFactory() {
    }

    public static EntryElemFactory getFactory() {
        return s_factory;
    }

    public EntryElem<?> createEntry(Subflow<?> parent, EntryType entry) throws ExecPlanException {
        if (UITaskType.class.isAssignableFrom(entry.getClass())) {
            return new UITaskEntryElem(parent, (UITaskType)UITaskType.class.cast(entry));
        }
        if (GenericTaskType.class.isAssignableFrom(entry.getClass())) {
            return new GenericTaskEntryElem(parent, (GenericTaskType)GenericTaskType.class.cast(entry));
        }
        if (IncludeType.class.isAssignableFrom(entry.getClass())) {
            return new IncludeElem(parent, (IncludeType)IncludeType.class.cast(entry));
        }
        if (LoopType.class.isAssignableFrom(entry.getClass())) {
            return new LoopElem(parent, (LoopType)LoopType.class.cast(entry));
        }
        if (BreakType.class.isAssignableFrom(entry.getClass())) {
            return new LoopRefElem<LoopStatementType>(parent, (LoopStatementType)BreakType.class.cast(entry));
        }
        if (ContinueType.class.isAssignableFrom(entry.getClass())) {
            return new LoopRefElem<LoopStatementType>(parent, (LoopStatementType)ContinueType.class.cast(entry));
        }
        if (SwitchType.class.isAssignableFrom(entry.getClass())) {
            return new SwitchElem(parent, (SwitchType)SwitchType.class.cast(entry));
        }
        throw new ExecPlanException("Unsupported entry type: " + entry.getClass());
    }
}

