/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.internal.wcf;

import com.oracle.cie.wizard.internal.wcf.TaskPropertyWrapper;
import com.oracle.cie.wizard.internal.wcf.xml.TaskDefinitionType;
import com.oracle.cie.wizard.internal.wcf.xml.TaskPropertyType;
import com.oracle.cie.wizard.tasks.TaskCachingPolicy;
import com.oracle.cie.wizard.wcf.TaskDefinition;
import com.oracle.cie.wizard.wcf.TaskProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class TaskDefinitionWrapper
implements TaskDefinition {
    private static Logger _log = Logger.getLogger(TaskDefinitionWrapper.class.getName());
    private TaskDefinitionType _xmlPeer;
    protected Map<String, TaskPropertyWrapper> _propsMap = new LinkedHashMap<String, TaskPropertyWrapper>();

    TaskDefinitionWrapper(TaskDefinitionType xmlPeer) {
        if (xmlPeer == null) {
            throw new IllegalArgumentException("Task definition cannot be null!");
        }
        this._xmlPeer = xmlPeer;
        for (TaskPropertyType prop : xmlPeer.getProperties()) {
            if (this._propsMap.containsKey(prop.getName())) {
                _log.severe("Task definition for '" + this._xmlPeer.getName() + "'. Found duplicate property defintion: " + prop.getName());
                continue;
            }
            this._propsMap.put(prop.getName(), new TaskPropertyWrapper(prop));
        }
    }

    @Override
    public String getName() {
        return this._xmlPeer.getName();
    }

    @Override
    public String getClassName() {
        return this._xmlPeer.getClazz();
    }

    @Override
    public TaskCachingPolicy getCachingPolicy() {
        try {
            return TaskCachingPolicy.valueOf(String.valueOf((Object)this._xmlPeer.getCachingPolicy()));
        }
        catch (IllegalArgumentException ex) {
            _log.log(Level.WARNING, "Invalid caching-policy", ex);
            return TaskCachingPolicy.NONE;
        }
    }

    @Override
    public boolean hasProperties() {
        return !this._xmlPeer.getProperties().isEmpty();
    }

    @Override
    public Collection<String> getPropertyNames() {
        return Collections.unmodifiableCollection(this._propsMap.keySet());
    }

    @Override
    public Collection<? extends TaskProperty> getProperties() {
        return Collections.unmodifiableCollection(this._propsMap.values());
    }

    @Override
    public TaskProperty getProperty(String name) {
        return this._propsMap.get(name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(500);
        sb.append("[").append(super.toString());
        sb.append(" name='").append(this.getName()).append("'");
        sb.append(" class='").append(this.getClassName()).append("'");
        sb.append(" cachingPolicy='").append((Object)this.getCachingPolicy()).append("'");
        if (this.hasProperties()) {
            sb.append(" ");
            for (String propName : this.getPropertyNames()) {
                sb.append(this.getProperty(propName));
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

