/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.internal.wcf;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.wizard.ControllerProxy;
import com.oracle.cie.wizard.event.WizardWorkflowEvent;
import com.oracle.cie.wizard.event.WizardWorkflowListener;
import com.oracle.cie.wizard.internal.wcf.FlowPropertyListener;
import com.oracle.cie.wizard.internal.wcf.Subflow;
import com.oracle.cie.wizard.internal.wcf.Target;
import com.oracle.cie.wizard.internal.wcf.TaskEntryElem;
import com.oracle.cie.wizard.internal.wcf.WCFElement;
import com.oracle.cie.wizard.internal.wcf.WCFElementExecutionState;
import com.oracle.cie.wizard.internal.wcf.WCFParser;
import com.oracle.cie.wizard.internal.wcf.WCFWrapper;
import com.oracle.cie.wizard.wcf.ExecPlanException;
import com.oracle.cie.wizard.wcf.TaskEntry;
import com.oracle.cie.wizard.wcf.Workflow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.ValidationEventHandler;

public class WCFWorkflow
implements Workflow {
    private static Logger _log = Logger.getLogger(WCFWorkflow.class.getName());
    private ControllerProxy _proxy;
    private WCFParser _wcfParser;
    private Map<String, WCFWrapper> _wcfMap = new HashMap<String, WCFWrapper>();
    private LinkedList<WCFElement> _entryList = new LinkedList();
    private Map<String, Object> _stateMap = new HashMap<String, Object>();
    private Map<String, String> _flowProperties = Collections.synchronizedMap(new HashMap());
    private int _idx = -1;
    protected List<WizardWorkflowListener> _flowListeners = new ArrayList<WizardWorkflowListener>();
    protected List<FlowPropertyListener> _flagListeners = new ArrayList<FlowPropertyListener>();

    @Override
    public void init(ControllerProxy proxy, String wcfResPath, String targetName, ClassLoader cl, ValidationEventHandler xmlValidationHandler) throws ExecPlanException {
        this._proxy = proxy;
        this._wcfParser = new WCFParser(xmlValidationHandler);
        wcfResPath = StringUtil.isNullOrEmpty((String)wcfResPath) ? "wizard.xml" : wcfResPath;
        WCFWrapper wcf = this.getWCF(wcfResPath, cl);
        String tName = StringUtil.isNullOrEmpty((String)targetName) ? wcf.getWCFile().getDefaultTarget() : targetName;
        _log.finer("Retrieving target " + tName + " from " + wcfResPath + ".");
        Target target = wcf.createTargetWrapper(tName);
        if (target == null) {
            throw new ExecPlanException("Undefined target: " + tName);
        }
        this.addSubflow(null, target);
        _log.finer("Executing " + wcf.getWCFile().getName() + " " + wcf.getWCFile().getVersion() + " under namespace \"" + wcf.getWCFile().getNamespace() + "\"");
    }

    public ControllerProxy getProxy() {
        return this._proxy;
    }

    @Override
    public void addWizardWorkflowListener(WizardWorkflowListener listener) {
        if (listener != null && !this._flowListeners.contains(listener)) {
            this._flowListeners.add(listener);
        }
    }

    @Override
    public void removeWizardWorkflowListener(WizardWorkflowListener listener) {
        this._flowListeners.remove(listener);
    }

    @Override
    public TaskEntry getEntryAt(int index) {
        int taskIdx = -1;
        for (WCFElement e : this._entryList) {
            if (!this.isTaskEntry(e) || ++taskIdx != index) continue;
            return (TaskEntry)((Object)e);
        }
        return null;
    }

    @Override
    public TaskEntry getCurrentEntry() {
        WCFElement entry = this._entryList.get(this._idx);
        return this.isTaskEntry(entry) ? (TaskEntry)((Object)entry) : null;
    }

    @Override
    public int getCurrentIndex() {
        return this.convertToTaskIndex(this._idx);
    }

    @Override
    public List<TaskEntry> getEntries() {
        ArrayList<TaskEntry> tasks = new ArrayList<TaskEntry>();
        for (WCFElement e : this._entryList) {
            if (!this.isTaskEntry(e)) continue;
            tasks.add((TaskEntry)((Object)e));
        }
        return tasks;
    }

    @Override
    public int getIndex(TaskEntry entry) {
        return this.convertToTaskIndex(this._entryList.indexOf(entry));
    }

    @Override
    public int getSize() {
        return this.getEntries().size();
    }

    @Override
    public TaskEntry next() throws ExecPlanException {
        if (this._idx >= this._entryList.size()) {
            _log.warning("Request for next entry was made after flow completion [idx = " + this._idx + "].");
            return null;
        }
        if (this._idx < -1) {
            _log.warning("Current index is below the allowable lower bound [idx = " + this._idx + "].");
            this._idx = -1;
        }
        WCFElement entry = null;
        while (++this._idx < this._entryList.size()) {
            entry = this._entryList.get(this._idx);
            entry.selectedOnNext();
            if (!this.isTaskEntry(entry)) continue;
        }
        if (this._idx >= this._entryList.size()) {
            _log.fine("Reached the end of the flow.");
            entry = null;
        }
        return (TaskEntryElem)entry;
    }

    @Override
    public TaskEntry previous() throws ExecPlanException {
        if (this._idx <= -1) {
            _log.warning("Request for previous entry was made before the flow was started [idx = " + this._idx + "].");
            return null;
        }
        if (this._idx >= this._entryList.size()) {
            _log.warning("Request for previous entry was made after flow completion [idx = " + this._idx + "].");
            return null;
        }
        WCFElement entry = null;
        while (--this._idx >= 0) {
            entry = this._entryList.get(this._idx);
            entry.selectedOnPrev();
            if (!this.isTaskEntry(entry)) continue;
        }
        if (this._idx < 0) {
            _log.fine("Reached the beginning of the flow.");
            entry = null;
        }
        return (TaskEntryElem)entry;
    }

    @Override
    public String getFlowProperty(String name) {
        return this._flowProperties.get(name);
    }

    @Override
    public void setFlowProperty(String name, String value) {
        String oldValue = this._flowProperties.put(name, value);
        if (oldValue == null && value != null || oldValue != null && !oldValue.equals(value)) {
            for (int i = this._flagListeners.size() - 1; i >= 0; --i) {
                this._flagListeners.get(i).propertyValueChanged(name, oldValue, value);
            }
        }
    }

    Collection<WCFWrapper> getLoadedWCFs() {
        return this._wcfMap.values();
    }

    WCFWrapper getWCF(String filename, ClassLoader cl) throws ExecPlanException {
        WCFWrapper wcf = this._wcfMap.get(filename);
        if (wcf == null) {
            wcf = new WCFWrapper(this, this._wcfParser, filename, cl);
            this._wcfMap.put(filename, wcf);
        }
        return wcf;
    }

    WCFElement getElementAfter(WCFElement elem) {
        int i = this._entryList.indexOf(elem);
        return i >= 0 && i < this._entryList.size() - 1 ? this._entryList.get(i + 1) : null;
    }

    void moveIndexTo(WCFElement elem) {
        int i = this._entryList.indexOf(elem);
        if (i >= 0) {
            this._idx = i;
        }
    }

    void moveIndexBefore(WCFElement elem) {
        int i = this._entryList.indexOf(elem);
        if (i >= 0) {
            this._idx = i - 1;
        }
    }

    void addSubflow(WCFElement elem, Subflow<?> subflow) throws ExecPlanException {
        int insIdx = -1;
        if (elem != null && (insIdx = this._entryList.indexOf(elem)) == -1) {
            throw new ExecPlanException("The given element is not part of the flow " + elem);
        }
        ++insIdx;
        ArrayList<TaskEntry> addedTasks = new ArrayList<TaskEntry>();
        List<WCFElement> entries = subflow.getDefaultElementList();
        for (WCFElement entry : entries) {
            entry.addingToWorkflow();
            if (!this.isTaskEntry(entry)) continue;
            addedTasks.add((TaskEntry)((Object)entry));
        }
        this._entryList.addAll(insIdx, entries);
        if (_log.isLoggable(Level.FINEST)) {
            _log.finest(this.dumpFlow("Flow after adding [" + addedTasks.size() + "] tasks from subflow [" + subflow + "] at index " + insIdx, true));
        }
        if (addedTasks.size() > 0) {
            int taskStartIdx = this.convertToTaskIndex(insIdx);
            this.fireEntriesAddedEvent(taskStartIdx, addedTasks);
        }
    }

    void removeSubflow(Subflow<?> subflow) throws ExecPlanException {
        int rmIdx = this._entryList.indexOf(subflow);
        if (rmIdx == -1) {
            throw new ExecPlanException("The given subflow is not part of the flow " + subflow);
        }
        ArrayList<TaskEntry> removedTasks = new ArrayList<TaskEntry>();
        ListIterator<WCFElement> lit = this._entryList.listIterator(rmIdx);
        while (lit.hasNext()) {
            WCFElement entry = lit.next();
            lit.remove();
            entry.removedFromWorkflow();
            if (this.isTaskEntry(entry)) {
                removedTasks.add((TaskEntry)((Object)entry));
            }
            if (entry != subflow.getEndOfSequence()) continue;
            break;
        }
        if (_log.isLoggable(Level.FINEST)) {
            _log.finest(this.dumpFlow("Flow after removing [" + removedTasks.size() + "] tasks from subflow [" + subflow + "] at index " + rmIdx, true));
        }
        if (removedTasks.size() > 0) {
            int taskStartIdx = this.convertToTaskIndex(rmIdx);
            this.fireEntriesRemovedEvent(taskStartIdx, removedTasks);
        }
    }

    Object getState(String id) {
        return this._stateMap.get(id);
    }

    Object setState(String id, Object value) {
        return this._stateMap.put(id, value);
    }

    Object removeState(String id) {
        return this._stateMap.remove(id);
    }

    void addFlowPropertyListener(FlowPropertyListener listener) {
        if (listener != null && !this._flagListeners.contains(listener)) {
            this._flagListeners.add(listener);
        }
    }

    void removeFlowPropertyListener(FlowPropertyListener listener) {
        this._flagListeners.remove(listener);
    }

    private boolean isTaskEntry(WCFElement entry) {
        return TaskEntryElem.class.isAssignableFrom(entry.getClass());
    }

    private int convertToTaskIndex(int idx) {
        if (idx < 0 || idx >= this._entryList.size()) {
            return -1;
        }
        int taskIdx = idx;
        for (int i = 0; i < idx; ++i) {
            if (this.isTaskEntry(this._entryList.get(i))) continue;
            --taskIdx;
        }
        return taskIdx;
    }

    private void fireEntriesAddedEvent(int startIdx, List<TaskEntry> tasks) {
        if (this._flowListeners.size() > 0) {
            WizardWorkflowEvent e = new WizardWorkflowEvent(this._proxy, WizardWorkflowEvent.Type.TASKS_ADDED, startIdx, Collections.unmodifiableList(tasks));
            for (int i = this._flowListeners.size() - 1; i >= 0; --i) {
                try {
                    this._flowListeners.get(i).entriesAdded(e);
                    continue;
                }
                catch (Throwable ex) {
                    _log.log(Level.SEVERE, "WizardWorkflowListener thrown unexpected exception.", ex);
                }
            }
        }
    }

    private void fireEntriesRemovedEvent(int startIdx, List<TaskEntry> tasks) {
        if (this._flowListeners.size() > 0) {
            WizardWorkflowEvent e = new WizardWorkflowEvent(this._proxy, WizardWorkflowEvent.Type.TASKS_REMOVED, startIdx, Collections.unmodifiableList(tasks));
            for (int i = this._flowListeners.size() - 1; i >= 0; --i) {
                try {
                    this._flowListeners.get(i).entriesRemoved(e);
                    continue;
                }
                catch (Throwable ex) {
                    _log.log(Level.SEVERE, "WizardWorkflowListener thrown unexpected exception.", ex);
                }
            }
        }
    }

    public String dumpFlow(String msg, boolean tasksOnly) {
        int i;
        StringBuilder sb = new StringBuilder(msg);
        Formatter f = new Formatter(sb);
        ArrayList<WCFElement> _tasks = new ArrayList<WCFElement>();
        if (!tasksOnly) {
            sb.append("\n=========== COMPLETE FLOW =============\n");
        }
        int _lastTaskExecuted = -1;
        for (i = 0; i < this._entryList.size(); ++i) {
            WCFElement elem = this._entryList.get(i);
            if (this.isTaskEntry(elem)) {
                _tasks.add(elem);
                if (i <= this._idx) {
                    _lastTaskExecuted = _tasks.size() - 1;
                }
            }
            if (tasksOnly) continue;
            f.format("%s [%3d] %s%n", i == this._idx ? ">" : " ", i, elem);
        }
        sb.append("=========== TASKS =============\n");
        for (i = 0; i < _tasks.size(); ++i) {
            f.format("%s [%3d] %s%n", i == _lastTaskExecuted ? ">" : " ", i, _tasks.get(i));
        }
        return sb.toString();
    }

    WCFElementExecutionState getExecutionState(WCFElement element) {
        for (int i = 0; i < this._entryList.size(); ++i) {
            if (!this._entryList.get(i).equals(element)) continue;
            if (this._idx == i) {
                return WCFElementExecutionState.CURRENTLY_EXECUTING;
            }
            return this._idx < i ? WCFElementExecutionState.WAITING_FOR_EXECUTION : WCFElementExecutionState.PREVIOUSLY_EXECUTED;
        }
        return WCFElementExecutionState.ELEMENT_NOT_PRESENT;
    }
}

