/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.silent.tasks;

import com.oracle.cie.wizard.silent.tasks.AbstractSilentTask;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import java.io.File;
import java.util.logging.Level;

@TaskDescription(name="detectJDK")
public class DetectJdkTask
extends AbstractSilentTask {
    @Override
    public void execute() throws TaskExecutionException {
        String javaVersion = System.getProperty("java.version");
        String javaHome = System.getProperty("java.home");
        String javaVendor = System.getProperty("java.vendor");
        if (javaVendor.indexOf(32) != -1) {
            javaVendor = javaVendor.substring(0, javaVendor.indexOf(32));
        }
        if (javaVendor.equals("Hewlett-Packard")) {
            javaVendor = "HP";
        }
        if (javaHome.substring(javaHome.length() - 3).equalsIgnoreCase("jre")) {
            javaHome = javaHome.substring(0, javaHome.lastIndexOf(File.separator));
        }
        String javaDirectory = javaHome.substring(javaHome.lastIndexOf(File.separator) + 1);
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.finer("Setting Java Variables:");
            this._logger.finer("JAVA_HOME=" + javaHome);
            this._logger.finer("JDKDirectory=" + javaDirectory);
            this._logger.finer("JDKVersion=" + javaVersion);
            this._logger.finer("JAVA_VENDOR=" + javaVendor);
        }
        this._context.storeObject(this._namespace, "JAVA_HOME", javaHome);
        this._context.storeObject(this._namespace, "JDKDirectory", javaDirectory);
        this._context.storeObject(this._namespace, "JDKVersion", javaVersion);
        this._context.storeObject(this._namespace, "JAVA_VENDOR", javaVendor);
    }
}

