/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.silent.tasks;

import com.oracle.cie.wizard.silent.tasks.AbstractSilentTask;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskCachingPolicy;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.Level;

@TaskDescription(name="storeFile", cachingPolicy=TaskCachingPolicy.REUSE)
public class StoreFileTask
extends AbstractSilentTask {
    private String _fileName = "";
    private String _storageKey = "StoreFileTask.file";

    @TaskAttribute(type=TaskAttributeType.LITERAL, defaultValue="StoreFileTask.file")
    public void setFileName(String filename) {
        this._fileName = filename;
    }

    @TaskAttribute(type=TaskAttributeType.OBJECT_STORE_KEY, required=true)
    public void setStorageKey(String key) {
        this._storageKey = key;
    }

    @Override
    public void execute() throws TaskExecutionException {
        this._fileName = this._context.substitute(this._namespace, this._fileName);
        File f = new File(this._fileName);
        if (f.exists() && f.isFile()) {
            int buffSize = (int)f.length();
            byte[] fileByteArray = new byte[buffSize];
            BufferedInputStream bis = null;
            try {
                bis = new BufferedInputStream(new FileInputStream(f));
                while (bis.read(fileByteArray, 0, buffSize) != -1) {
                }
            }
            catch (IOException iox) {
                String msg;
                this._logger.log(Level.SEVERE, "Unable to store file: " + this._fileName, iox);
                try {
                    msg = MessageFormat.format(this._context.getI18nString("wizard", "StoreFileTask.error.msg"), this._fileName);
                }
                catch (Exception ignore) {
                    msg = "Unable to store file: " + this._fileName;
                }
                throw new TaskExecutionException(this, msg, iox);
            }
            finally {
                try {
                    if (bis != null) {
                        bis.close();
                    }
                }
                catch (Exception exception) {}
            }
            this._context.storeObject(this._namespace, this._storageKey, fileByteArray);
        }
    }

    @Override
    public void unconfigure() {
        this._fileName = "";
        this._storageKey = "StoreFileTask.file";
    }
}

