/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.helper.remote.exec;

import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.cie.remote.RemoteConnectionHost;
import com.oracle.cie.remote.RemoteConnectionManager;
import com.oracle.cie.remote.SshRemoteConnectionHost;
import com.oracle.glcm.patch.auto.topology.HostImpl;
import com.oracle.helper.remote.exec.RemoteOPerationExecutor;
import com.oracle.helper.remote.exec.RemoteRequestResultListener;
import com.oracle.helper.remote.exec.model.OPeration;
import com.oracle.helper.remote.exec.model.Request;
import com.oracle.helper.remote.exec.model.Response;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;

public class RemoteRequestHandler {
    private static final int FAILED_TO_READ_REQUEST = 110;
    private static final int FAILED_TO_WRITE_RESPONSE = 111;
    private static final int FAILED_IN_REMOTE_OPERATION = 112;
    private Request request = null;
    private String responseFileLoc;
    private RemoteRequestResultListener listener;
    private static final Logger logger = Logger.getLogger(RemoteRequestHandler.class.getName());
    private static int status = 0;

    public static void main(String[] args) {
        ArrayList<String> argsList = new ArrayList<String>();
        if (args != null) {
            argsList.addAll(Arrays.asList(args));
        }
        String objlocation = null;
        String responseObjlocation = null;
        for (int i = 0; i < argsList.size(); ++i) {
            if (((String)argsList.get(i)).equalsIgnoreCase("-OBJECTLOC")) {
                objlocation = (String)argsList.get(++i);
            } else if (((String)argsList.get(i)).equalsIgnoreCase("-RESPONSEOBJECTLOC")) {
                responseObjlocation = (String)argsList.get(++i);
            }
            if (responseObjlocation != null && objlocation != null) break;
        }
        RemoteRequestHandler handle = new RemoteRequestHandler();
        try {
            handle.processRequest(objlocation, responseObjlocation);
        }
        catch (Exception e) {
            try {
                if (handle.request != null) {
                    handle.markAllOperationFailed();
                    handle.writeResponseToFile();
                }
            }
            catch (IOException e1) {
                System.exit(111);
            }
            System.exit(110);
        }
        System.exit(status);
    }

    public void processRequest(Request request, RemoteRequestResultListener listener) throws Exception {
        this.listener = listener;
        this.connect(request);
    }

    private void markAllOperationFailed() {
        for (OPeration op : this.request.getOperations()) {
            op.setStatus(OPeration.Status.FAILED);
        }
    }

    private void processRequest(String objLocation, String reponseFileLocation) throws Exception {
        logger.info("Request location::" + objLocation);
        logger.info(" Response  location::" + reponseFileLocation);
        this.responseFileLoc = reponseFileLocation;
        File requestFile = new File(objLocation);
        this.request = this.readRequestObj(requestFile);
        logger.info("Request Extracted for host :" + this.request.getHost());
        this.connect(this.request);
    }

    private void connect(Request request) throws IOException, RemoteConnectionException {
        try {
            this.execute(request);
        }
        catch (RemoteConnectionException e) {
            logger.warning("Remote connection failed due to " + e.getMessage());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(Request request) throws RemoteConnectionException {
        try (RemoteConnectionHandler handler = null;){
            SshRemoteConnectionHost connectionHost = this.createHostObj(request.getHost());
            handler = RemoteConnectionManager.getRemoteConnectionManager().getRemoteConnectionHandler((RemoteConnectionHost)connectionHost);
            logger.info("Creating request for host :" + request.getHost());
            handler.connect();
            RemoteOPerationExecutor executor = null;
            RemoteOperationListener remoteOPerationListener = new RemoteOperationListener(request.getOperations().size());
            for (OPeration op : request.getOperations()) {
                logger.info("Preparing operation :" + (Object)((Object)op.getType()));
                if (executor == null) {
                    executor = new RemoteOPerationExecutor(handler, remoteOPerationListener);
                }
                executor.execute(op);
            }
        }
    }

    private SshRemoteConnectionHost createHostObj(String nodeName) {
        HostImpl hostImpl = new HostImpl();
        hostImpl.setHost(nodeName);
        hostImpl.setRemoteConnectionType("linuxclisshuserequivalence");
        return hostImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Request readRequestObj(File requestParamLocation) throws ClassNotFoundException, IOException {
        Request request = null;
        FileInputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            inputStream = new FileInputStream(requestParamLocation);
            objectInputStream = new ObjectInputStream(inputStream);
            request = (Request)objectInputStream.readObject();
        }
        finally {
            if (objectInputStream != null) {
                objectInputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponseToFile() throws IOException {
        logger.info("Writting response file @ ::" + this.responseFileLoc);
        Response response = new Response(this.request);
        FileOutputStream outputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            outputStream = new FileOutputStream(this.responseFileLoc);
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(response);
            logger.info("Writting response file completed @ ::" + this.responseFileLoc);
        }
        finally {
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    private void notifyResultListener() {
        this.listener.notify(new Response(this.request));
    }

    public class RemoteOperationListener {
        private int operationCount;

        public RemoteOperationListener(int operationCount) {
            this.operationCount = operationCount;
        }

        public void notifyOperationResult(OPeration op) {
            logger.info("Received notification for operation ::" + (Object)((Object)op.getType()) + " Status :: " + (Object)((Object)op.getStatus()));
            if (op.getStatus() == OPeration.Status.FAILED) {
                status = 112;
            }
            --this.operationCount;
            if (this.operationCount == 0) {
                if (RemoteRequestHandler.this.responseFileLoc != null) {
                    try {
                        RemoteRequestHandler.this.writeResponseToFile();
                    }
                    catch (IOException e) {
                        System.exit(111);
                    }
                } else {
                    RemoteRequestHandler.this.notifyResultListener();
                }
            }
        }
    }
}

