/*
 * Decompiled with CFR 0.152.
 */
package oracle.osysmodel.driver.sdk.emrepo;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import model.BaseClass;
import model.SystemInstance;
import oracle.osysmodel.validation.ConfigValidationException;
import oracle.osysmodel.validation.PublishedRuleSet;
import oracle.osysmodel.validation.RuleSetFactory;
import oracle.osysmodel.validation.ValidationResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validator {
    private static Logger logger = Logger.getLogger(Validator.class.getName());

    public static Map<BaseClass, List<Method>> validateRequestedAttributes(SystemInstance systemInstance, Map<Class, List<Method>> map) {
        if (systemInstance == null) {
            return null;
        }
        HashMap<BaseClass, List<Method>> hashMap = new HashMap<BaseClass, List<Method>>();
        for (BaseClass baseClass : systemInstance.getEntities()) {
            if (!map.containsKey(baseClass.getClass())) continue;
            ArrayList<Method> arrayList = new ArrayList<Method>();
            hashMap.put(baseClass, arrayList);
            List<Method> list = map.get(baseClass.getClass());
            if (list == null || list.isEmpty()) continue;
            for (Method method : list) {
                try {
                    if (method.invoke((Object)baseClass, null) != null) continue;
                    logger.fine(" requested attribute is not set! " + baseClass.toString() + method.getName());
                    arrayList.add(method);
                }
                catch (Exception exception) {
                    logger.severe(" Failed to invoke " + baseClass.toString() + method.getName() + exception.getMessage());
                    exception.printStackTrace();
                    arrayList.add(method);
                }
            }
        }
        return hashMap;
    }

    public static Map<BaseClass, Map<String, Method>> validateRequestedProperties(SystemInstance systemInstance, Map<Class, Map<String, Method>> map) {
        if (systemInstance == null) {
            return null;
        }
        HashMap<BaseClass, Map<String, Method>> hashMap = new HashMap<BaseClass, Map<String, Method>>();
        for (BaseClass baseClass : systemInstance.getEntities()) {
            if (!map.containsKey(baseClass.getClass())) continue;
            Map<String, Method> map2 = map.get(baseClass.getClass());
            HashMap<String, Method> hashMap2 = new HashMap<String, Method>();
            hashMap.put(baseClass, hashMap2);
            if (map2 == null) continue;
            for (Map.Entry<String, Method> entry : map2.entrySet()) {
                Method method = baseClass.getGetter(entry.getValue());
                try {
                    if (method.invoke((Object)baseClass, null) != null) continue;
                    logger.fine(" requested property is not set! " + baseClass.toString() + method.getName());
                    hashMap2.put(entry.getKey(), method);
                }
                catch (Exception exception) {
                    logger.severe(" Failed to invoke " + baseClass.toString() + method.getName() + exception.getMessage());
                    exception.printStackTrace();
                    hashMap2.put(entry.getKey(), method);
                }
            }
        }
        return hashMap;
    }

    public static Map<BaseClass, Map<Method, List<BaseClass>>> validateRequestedAssociations(SystemInstance systemInstance, Map<Class, Map<Method, List<BaseClass>>> map) {
        if (systemInstance == null) {
            return null;
        }
        HashMap<BaseClass, Map<Method, List<BaseClass>>> hashMap = new HashMap<BaseClass, Map<Method, List<BaseClass>>>();
        for (BaseClass baseClass : systemInstance.getEntities()) {
            Map<Method, List<BaseClass>> map2 = map.get(baseClass.getClass());
            if (map2 == null || map2.isEmpty()) continue;
            for (Map.Entry<Method, List<BaseClass>> entry : map2.entrySet()) {
                Method method = baseClass.getGetter(entry.getKey());
                List<BaseClass> list = entry.getValue();
                HashMap<Method, List<BaseClass>> hashMap2 = new HashMap<Method, List<BaseClass>>();
                hashMap.put(baseClass, hashMap2);
                Object object = null;
                if (method != null) {
                    try {
                        object = method.invoke((Object)baseClass, null);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        logger.severe(illegalAccessException.getMessage());
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        logger.severe(invocationTargetException.getMessage());
                    }
                }
                if (object != null && (!(object instanceof List) || !((List)object).isEmpty())) continue;
                logger.fine(" Requested association " + method.getName() + "(" + list + ") is not set on " + baseClass.toString());
                hashMap2.put(method, list);
            }
        }
        return hashMap;
    }

    public static void validate(SystemInstance systemInstance, Map<Class, Map<Method, List<BaseClass>>> map) {
        if (systemInstance == null) {
            return;
        }
        HashMap hashMap = new HashMap();
        boolean bl = false;
        for (BaseClass baseClass : systemInstance.getEntities()) {
            Map<Method, List<BaseClass>> map2 = map.get(baseClass.getClass());
            if (map2 == null || map2.isEmpty()) continue;
            for (Map.Entry<Method, List<BaseClass>> entry : map2.entrySet()) {
                Method method = baseClass.getGetter(entry.getKey());
                List<BaseClass> list = entry.getValue();
                HashMap<Method, List<BaseClass>> hashMap2 = new HashMap<Method, List<BaseClass>>();
                hashMap.put(baseClass, hashMap2);
                Object object = null;
                if (method != null) {
                    try {
                        object = method.invoke((Object)baseClass, null);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        logger.severe(illegalAccessException.getMessage());
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        logger.severe(invocationTargetException.getMessage());
                    }
                }
                if (object != null && (!(object instanceof List) || !((List)object).isEmpty())) continue;
                logger.fine(" Requested " + method.getName() + "(" + list + ") is not set on " + baseClass.toString());
                bl = true;
                hashMap2.put(method, list);
            }
        }
        if (bl) {
            throw new RuntimeException("INVALID CONFIGURATION: " + ((Object)hashMap).toString() + "is not set ");
        }
    }

    public static ValidationResult isCRSconfigValid(SystemInstance systemInstance) throws ConfigValidationException {
        logger.finer(" ******** Validating ********** ");
        ValidationResult validationResult = null;
        try {
            validationResult = RuleSetFactory.getRuleSet((PublishedRuleSet.EnumRuleSet)PublishedRuleSet.EnumRuleSet.OPlanSupportsExadata, (SystemInstance)systemInstance).invoke();
            logger.finer(validationResult.toString());
            validationResult = RuleSetFactory.getRuleSet((PublishedRuleSet.EnumRuleSet)PublishedRuleSet.EnumRuleSet.CRSvalid, (SystemInstance)systemInstance).invoke();
            logger.finer(validationResult.toString());
            logger.finer(" ******** ********** ");
        }
        catch (ConfigValidationException configValidationException) {
            logger.finer(" ConfigValidationException = " + configValidationException.getMessage());
        }
        return validationResult;
    }
}

