/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss.kerberos;

import java.io.IOException;
import java.util.ArrayList;
import javax.crypto.SecretKey;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.util.Utils;
import oracle.security.xmlsec.wss.WSSBinarySecurityToken;
import oracle.security.xmlsec.wss.WSSException;
import oracle.security.xmlsec.wss.impl.KrbParser;
import oracle.security.xmlsec.wss.kerberos.KerberosKeyRetriever;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KerberosBinarySecurityToken
extends WSSBinarySecurityToken {
    private static ArrayList<KerberosKeyRetriever> kerberosRetrieverList = new ArrayList();

    public KerberosBinarySecurityToken(Element kbdv5APREQElement) {
        super(kbdv5APREQElement);
    }

    public KerberosBinarySecurityToken(Element kbdv5APREQElement, String systemId) {
        super(kbdv5APREQElement, systemId);
    }

    public KerberosBinarySecurityToken(Document owner) {
        super(owner, "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ");
    }

    public KerberosBinarySecurityToken(Document owner, String encType) {
        super(owner, "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ", encType);
    }

    public KerberosBinarySecurityToken(Document owner, String valType, String encType) {
        super(owner, valType, encType);
    }

    @Override
    public void setToken(Object apreqBytes) {
        if (!(apreqBytes instanceof byte[])) {
            throw new IllegalArgumentException("Unexpected object type for KBD_AP_REQ: " + apreqBytes.getClass().getName());
        }
        this.setValue((byte[])apreqBytes);
    }

    @Override
    public Object getToken() throws WSSException {
        return this.getValue();
    }

    public boolean equals(byte[] apreqBytes) {
        return Utils.areEqual((byte[])this.getValue(), (byte[])apreqBytes);
    }

    public static void addKerberosKeyRetriever(KerberosKeyRetriever resolver) {
        kerberosRetrieverList.add(resolver);
    }

    public static void removeKerberosKeyRetriever(KerberosKeyRetriever resolver) {
        kerberosRetrieverList.remove(resolver);
    }

    public SecretKey getKey() {
        byte[] apReq = this.getValue();
        String sname = null;
        int etype = 0;
        try {
            ASN1GenericConstructed obj = KrbParser.GSSUnwrap(apReq);
            KrbParser.ApReq apReqObj = new KrbParser.ApReq(obj, null, null);
            sname = apReqObj.ticket.sname.toString();
            etype = apReqObj.ticket.edata.etype;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (KerberosKeyRetriever ret : kerberosRetrieverList) {
            SecretKey key = ret.getKey(this, apReq, sname, etype);
            if (key == null) continue;
            return key;
        }
        return null;
    }
}

