/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss.username;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.xmlsec.util.Base64;
import oracle.security.xmlsec.util.QName;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.wss.WSSElement;
import oracle.security.xmlsec.wss.WSSException;
import oracle.security.xmlsec.wss.WSSURI;
import oracle.security.xmlsec.wss.WSSecurityToken;
import oracle.security.xmlsec.wss.WSUCreated;
import oracle.security.xmlsec.wss.username.KeyDerivationException;
import oracle.security.xmlsec.wss.username.KeyDerivator;
import oracle.security.xmlsec.wss.username.PasswordRetrievalException;
import oracle.security.xmlsec.wss.username.PasswordRetriever;
import oracle.security.xmlsec.wss.util.WSSUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UsernameToken
extends WSSElement
implements WSSecurityToken {
    private static final String[] nsURIs = new String[]{"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd"};
    private static final String[] localNames = new String[]{"Username", "Password", "Nonce", "Created", "Salt", "Iteration"};
    public static final String PASSWORD_TEXT = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText";
    public static final String PASSWORD_DIGEST = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest";
    private static final String DEFAULT_NONCE_ENCODING_TYPE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
    private static final String DEFAULT_PASSWORD_TYPE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText";
    private static ArrayList passwordRetrieverList = new ArrayList();
    private static ArrayList keyDerivatorList = new ArrayList();

    public UsernameToken(Element element) {
        super(element);
    }

    public UsernameToken(Element element, String systemId) {
        super(element, systemId);
    }

    public UsernameToken(Document owner) {
        super(owner, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UsernameToken");
    }

    public void setUsername(String userName) {
        WSSUtils.insertChildElementWithText(this, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Username", nsURIs, localNames, userName, true);
    }

    public String getUsername() {
        return WSSUtils.collectTextFromChild(this, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Username");
    }

    public void setNonce(byte[] nonce) {
        this.setNonce(nonce, null);
    }

    public void setNonce(byte[] nonce, String encType) {
        if (encType == null || encType.length() == 0) {
            encType = DEFAULT_NONCE_ENCODING_TYPE;
        }
        Element child = WSSUtils.insertChildElementWithText(this, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Nonce", nsURIs, localNames, WSSUtils.encodeBinary(nonce, encType), true);
        WSSUtils.setTypeAttribute(child, "EncodingType", encType);
    }

    public byte[] getNonce() {
        NodeList list = XMLElement.getChildElementsByTagNameNS((Element)((Element)this.getNode()), (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", (String)"Nonce");
        if (list.getLength() > 0) {
            Element nonce = (Element)list.item(0);
            String encType = WSSUtils.getTypeAttribute(nonce, "EncodingType");
            if (encType == null || encType.length() == 0) {
                encType = DEFAULT_NONCE_ENCODING_TYPE;
            }
            return WSSUtils.decodeBinary(XMLUtils.collectText((Node)nonce), encType);
        }
        return null;
    }

    public void setCreatedDate(Date created) {
        WSUCreated createdElem = new WSUCreated(this.getOwnerDocument());
        createdElem.setValue(created);
        WSSUtils.setChildElement(this, createdElem, nsURIs, localNames);
    }

    public void setCreated(WSUCreated created) {
        WSSUtils.setChildElement(this, created, nsURIs, localNames);
    }

    public WSUCreated getCreated() {
        return (WSUCreated)WSSUtils.getChildElement(this, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Created");
    }

    public Date getCreatedDate() {
        WSUCreated createdElem = (WSUCreated)WSSUtils.getChildElement(this, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Created");
        return createdElem == null ? null : createdElem.getValue();
    }

    public void setPassword(char[] passwd) {
        this.setPassword(passwd, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
    }

    public void setPasswordDigest(char[] passwd) {
        this.setPassword(passwd, PASSWORD_DIGEST);
    }

    public void setPassword(char[] password, String passwordType) {
        char[] passwd = password;
        if (passwd == null) {
            passwd = this.retrievePassword(this.getUsername());
        }
        if (passwordType != null && passwordType.equals(PASSWORD_DIGEST)) {
            byte[] digest = this.computePasswordDigest(this.getNonce(), this.getCreated(), passwd);
            Element child = WSSUtils.insertChildElementWithText(this, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Password", nsURIs, localNames, Base64.toBase64((byte[])digest, (boolean)false), true);
            WSSUtils.setTypeAttribute(child, "Type", passwordType);
        } else {
            Element child = WSSUtils.insertChildElementWithText(this, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Password", nsURIs, localNames, new String(passwd), true);
            WSSUtils.setTypeAttribute(child, "Type", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
        }
    }

    public String getPasswordType() {
        Element password = null;
        String passwdType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText";
        NodeList nList = this.getChildElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Password");
        if (nList.getLength() != 0) {
            password = (Element)nList.item(0);
        }
        if (password != null && ((passwdType = WSSUtils.getTypeAttribute(password, "Type")) == null || passwdType.length() == 0)) {
            passwdType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText";
        }
        return passwdType;
    }

    public char[] getPassword() {
        if (PASSWORD_DIGEST.equals(this.getPasswordType())) {
            return null;
        }
        String password = WSSUtils.collectTextFromChild(this, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Password");
        if (password != null) {
            return password.toCharArray();
        }
        return null;
    }

    public byte[] getPasswordDigest() {
        if (PASSWORD_DIGEST.equals(this.getPasswordType())) {
            return Base64.fromBase64((String)WSSUtils.collectTextFromChild(this, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Password"));
        }
        return null;
    }

    public boolean isValid() {
        char[] passwd = this.retrievePassword(this.getUsername());
        byte[] passwdDigest = this.getPasswordDigest();
        if (passwdDigest != null) {
            return Utils.areEqual((byte[])passwdDigest, (byte[])this.computePasswordDigest(this.getNonce(), this.getCreated(), passwd));
        }
        char[] passd = this.getPassword();
        if (passd != null) {
            if (passd.length != passwd.length) {
                return false;
            }
            for (int i = 0; i < passd.length; ++i) {
                if (passd[i] == passwd[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isValid(String userName, char[] passwd) {
        byte[] passwdDigest;
        if (!userName.equals(this.getUsername())) {
            return false;
        }
        char[] password = passwd;
        if (password == null) {
            password = this.retrievePassword(userName);
        }
        if ((passwdDigest = this.getPasswordDigest()) != null) {
            return Utils.areEqual((byte[])passwdDigest, (byte[])this.computePasswordDigest(this.getNonce(), this.getCreated(), password));
        }
        char[] passd = this.getPassword();
        if (passd != null) {
            if (passd.length != password.length) {
                return false;
            }
            for (int i = 0; i < passd.length; ++i) {
                if (passd[i] == password[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public byte[] getSalt() {
        String salt = WSSUtils.collectTextFromChild(this, "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "Salt");
        if (salt == null) {
            return null;
        }
        return Base64.fromBase64((String)salt);
    }

    public void setSalt(byte[] salt) {
        if (salt == null || salt.length != 16) {
            throw new IllegalArgumentException("Salt must be 128 bits");
        }
        if (salt[0] != 1 && salt[0] != 2) {
            throw new IllegalArgumentException("Salt first byte must be 1 or 2");
        }
        Element saltElem = WSSUtils.insertChildElementWithText(this, "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "Salt", nsURIs, localNames, new String(Base64.toBase64((byte[])salt, (boolean)false)), true);
        if (saltElem.getPrefix() == null) {
            String prefix = XMLElement.getDefaultNSPrefix((String)"http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd");
            saltElem.setPrefix(prefix);
            saltElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd");
        }
    }

    public void setSalt(byte type, byte[] salt) {
        if (salt == null || salt.length != 15) {
            throw new IllegalArgumentException("Salt must be 120 bits");
        }
        if (type != 1 && type != 2) {
            throw new IllegalArgumentException("Type must be 1 or 2");
        }
        byte[] salt2 = new byte[16];
        salt2[0] = type;
        System.arraycopy(salt, 0, salt2, 1, 15);
        this.setSalt(salt2);
    }

    public int getIteration() {
        String iteration = WSSUtils.collectTextFromChild(this, "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "Iteration");
        if (iteration == null) {
            return 1000;
        }
        return Integer.parseInt(iteration);
    }

    public void setIteration(int iteration) {
        Element iterationElem = WSSUtils.insertChildElementWithText(this, "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "Iteration", nsURIs, localNames, Integer.toString(iteration), true);
        if (iterationElem.getPrefix() == null) {
            String prefix = XMLElement.getDefaultNSPrefix((String)"http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd");
            iterationElem.setPrefix(prefix);
            iterationElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd");
        }
    }

    private char[] retrievePassword(String username) {
        char[] password = null;
        int n = passwordRetrieverList.size();
        for (int i = 0; i < n && password == null; ++i) {
            PasswordRetriever r = (PasswordRetriever)passwordRetrieverList.get(i);
            try {
                password = r.getPassword(username);
                continue;
            }
            catch (PasswordRetrievalException ex) {
                password = null;
            }
        }
        return password;
    }

    public byte[] createSecretKey() {
        String passwdType = this.getPasswordType();
        if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText".equals(passwdType)) {
            return this.computePasswordDigest(this.getNonce(), this.getCreated(), this.getPassword());
        }
        if (PASSWORD_DIGEST.equals(passwdType)) {
            return this.getPasswordDigest();
        }
        return null;
    }

    public byte[] createSecretKey(char[] passwd) {
        char[] password = passwd;
        if (password == null) {
            password = this.retrievePassword(this.getUsername());
        }
        return this.computePasswordDigest(this.getNonce(), this.getCreated(), password);
    }

    public byte[] computePasswordDigest(byte[] nonce, WSUCreated created, char[] passwd) {
        try {
            char[] password = passwd;
            if (password == null) {
                password = this.retrievePassword(this.getUsername());
            }
            UnsyncByteArrayOutputStream bos = new UnsyncByteArrayOutputStream();
            OutputStreamWriter os = new OutputStreamWriter((OutputStream)bos, "UTF8");
            os.write(password);
            os.close();
            byte[] passwdBytes = bos.toByteArray();
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            if (nonce != null) {
                md.update(nonce);
            }
            if (created != null) {
                md.update(XMLUtils.collectText((Node)created.getNode()).getBytes("UTF8"));
            }
            md.update(passwdBytes);
            return md.digest();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException(ex.toString());
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex.toString());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
    }

    @Override
    public QName getTokenName() {
        return WSSURI.st_USERNAME;
    }

    @Override
    public Object getToken() {
        return this.getUsername();
    }

    public SecretKey getKey() throws WSSException {
        SecretKey secret = null;
        if (secret == null) {
            int n = keyDerivatorList.size();
            for (int i = 0; i < n && secret == null; ++i) {
                KeyDerivator r = (KeyDerivator)keyDerivatorList.get(i);
                try {
                    secret = r.resolve(this, null);
                    continue;
                }
                catch (KeyDerivationException ex) {
                    secret = null;
                }
            }
        }
        if (secret == null) {
            throw new WSSException(WSSException.SECURITY_TOKEN_UNAVAILABLE);
        }
        return secret;
    }

    public static void addPasswordRetriever(PasswordRetriever resolver) {
        passwordRetrieverList.add(resolver);
    }

    public static void addKeyDerivator(KeyDerivator resolver) {
        keyDerivatorList.add(resolver);
    }

    public static SecretKey deriveKey(char[] passwd, byte[] salt, int iteration) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(new String(passwd).getBytes("UTF8"));
            md.update(salt);
            byte[] digest = md.digest();
            for (int i = 2; i <= iteration; ++i) {
                md = MessageDigest.getInstance("SHA-1");
                md.update(digest);
                digest = md.digest();
            }
            return new SecretKeySpec(digest, "Hmac");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e.toString());
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex.toString());
        }
    }

    public SecretKey deriveKey(char[] passwd) {
        if (passwd == null) {
            passwd = this.retrievePassword(this.getUsername());
        }
        return UsernameToken.deriveKey(passwd, this.getSalt(), this.getIteration());
    }

    public SecretKey deriveKey() {
        return this.deriveKey(null);
    }
}

