/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core.binary.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import oracle.opatch.opatchsdk.FailedPrereqException;
import oracle.opatch.opatchsdk.IAnalysisReport;
import oracle.opatch.opatchsdk.OPatchContext;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchNApplyOptions;
import oracle.opatch.opatchsdk.OPatchNRollbackOptions;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdk.OPatchPatchPrereq;
import oracle.opatch.opatchsdk.OPatchTarget;
import oracle.opatchauto.core.binary.OACLogger;
import oracle.opatchauto.core.binary.OPatchAutoBinaryUtil;
import oracle.opatchauto.core.binary.PatchResult;
import oracle.opatchauto.core.binary.PatchingSessionOptions;
import oracle.opatchauto.core.binary.action.ActionResult;

public class AnalyzeReportGenerator {
    private final OPatchTarget _target;
    private final PatchingSessionOptions _sessionOptions;
    private OPatchContext _context;
    private IAnalysisReport _analysisResult = null;

    public AnalyzeReportGenerator(OPatchTarget target, PatchingSessionOptions sessionOptions) {
        this._target = target;
        this._context = this._target.getContext();
        this._sessionOptions = sessionOptions;
    }

    public ActionResult execute(PatchResult patchResult, boolean rollback) {
        ActionResult actionResult = new ActionResult();
        this._analysisResult = null;
        List<OPatchPatch> allPatchesList = null;
        PatchResult patchAnalysisResult = null;
        try {
            if (rollback && patchResult.isPatchIDbased()) {
                String patchId = patchResult.getPatchID();
                OPatchPatch patch = this._context.getInstalledActivePatch(patchId);
                if (patch == null) {
                    patchAnalysisResult = OPatchAutoBinaryUtil.buildSkippedPRwithID(patchId, "This Patch does not exist in the home, it cannot be rolled back.");
                    actionResult.addPatchResult(patchAnalysisResult);
                    actionResult.setAnalysisReport(this._analysisResult);
                    OACLogger.info("Patch " + patchId + " doesn't exist at home, so skipping.");
                    return actionResult;
                }
                OACLogger.console("Analyzing before rolling back " + patchId + " ...");
                allPatchesList = new ArrayList<OPatchPatch>();
                allPatchesList.add(patch);
            } else {
                String patchLocation = patchResult.getPatchLocn();
                boolean isComposite = OPatchAutoBinaryUtil.isComposite(patchLocation);
                if (rollback) {
                    allPatchesList = OPatchAutoBinaryUtil.getPatchListFromPatchLocnForRollback(this._target, patchLocation, isComposite);
                    if (allPatchesList.isEmpty()) {
                        patchAnalysisResult = OPatchAutoBinaryUtil.buildSkippedPR(patchLocation, "This Patch does not exist in the home, it cannot be rolled back.");
                        actionResult.addPatchResult(patchAnalysisResult);
                        actionResult.setAnalysisReport(this._analysisResult);
                        OACLogger.info("Patch " + patchLocation + " doesn't exist at home, so skipping.");
                        return actionResult;
                    }
                    OACLogger.console("Analyzing before rolling back " + patchLocation + " ...");
                } else {
                    OPatchPatch[] allPatchArray;
                    allPatchesList = OPatchAutoBinaryUtil.getPatchListFromPatchLocnForApply(this._target, patchLocation, isComposite);
                    if (allPatchesList.size() < 1) {
                        patchAnalysisResult = OPatchAutoBinaryUtil.buildSkippedPR(patchLocation, "This patch is already been applied, so not going to apply again.");
                        actionResult.addPatchResult(patchAnalysisResult);
                        actionResult.setAnalysisReport(this._analysisResult);
                        OACLogger.info("Patch " + patchLocation + " already exist at home, so skipping.");
                        return actionResult;
                    }
                    if (isComposite) {
                        allPatchArray = OPatchPatch.getPatches((String)patchLocation);
                    } else {
                        OPatchPatch patch = new OPatchPatch(patchLocation);
                        allPatchArray = new OPatchPatch[]{patch};
                    }
                    allPatchesList = Arrays.asList(allPatchArray);
                    OACLogger.console("Analyzing before applying " + patchLocation + " ...");
                }
            }
        }
        catch (OPatchException e) {
            OACLogger.console("Patch " + (patchResult.isPatchIDbased() ? patchResult.getPatchID() : patchResult.getPatchLocn()) + " failed due to analyze failure.");
            OACLogger.printStackTrace(e);
            patchAnalysisResult = OPatchAutoBinaryUtil.buildFailedPR(patchResult.getPatchLocn(), patchResult.getPatchID(), "Failed during Patching: ", (Exception)((Object)e), "");
            actionResult.addPatchResult(patchAnalysisResult);
            actionResult.setAnalysisReport(this._analysisResult);
            return actionResult;
        }
        patchAnalysisResult = this.analyzePatch(allPatchesList, patchResult, rollback);
        actionResult.addPatchResult(patchAnalysisResult);
        actionResult.setAnalysisReport(this._analysisResult);
        return actionResult;
    }

    private PatchResult analyzePatch(List<OPatchPatch> allPatchesList, PatchResult patchResult, boolean isRollback) {
        PatchResult analyzedResult = patchResult;
        IAnalysisReport report = null;
        String log = "";
        try {
            if (isRollback) {
                OPatchNRollbackOptions nRollbackOptions = new OPatchNRollbackOptions();
                nRollbackOptions.ohInstanceUp(this._sessionOptions.isOhInstanceRunning()).noRelink(this._sessionOptions.isNoRelink()).noPatchgen(this._sessionOptions.isNoPatchgen());
                report = this._target.NRollbackReportForAllPrereqs(allPatchesList.toArray(new OPatchPatch[allPatchesList.size()]), nRollbackOptions);
            } else {
                OPatchNApplyOptions nApplyOptions = new OPatchNApplyOptions();
                nApplyOptions.ohInstanceUp(this._sessionOptions.isOhInstanceRunning()).forceConflict(this._sessionOptions.isForceConflict()).skipConflict(this._sessionOptions.isSkipConflict()).noRelink(this._sessionOptions.isNoRelink()).noPatchgen(this._sessionOptions.isNoPatchgen());
                report = this._target.NApplyReportForAllPrereqs(allPatchesList.toArray(new OPatchPatch[allPatchesList.size()]), nApplyOptions);
            }
            log = this._target.getLastSessionLogFile();
            analyzedResult = this.processAnalyzeResults(report, patchResult, log);
            if (analyzedResult.getResult() != "FAILED") {
                this._analysisResult = report;
            }
        }
        catch (FailedPrereqException | OPatchException e) {
            OACLogger.console("Patch " + (patchResult.isPatchIDbased() ? patchResult.getPatchID() : patchResult.getPatchLocn()) + " failed due to analyze failure.");
            OACLogger.printStackTrace(e);
            log = this._target.getLastSessionLogFile();
            analyzedResult = OPatchAutoBinaryUtil.buildFailedPR(patchResult.getPatchLocn(), patchResult.getPatchID(), "Failed during Patching: ", (Exception)e, log);
        }
        return analyzedResult;
    }

    private PatchResult processAnalyzeResults(IAnalysisReport report, PatchResult patchResult, String log) {
        PatchResult patchAnalyzeResult = patchResult;
        HashMap prereqResults = report.getPrereqResults();
        Set patchPrereqs = prereqResults.keySet();
        for (OPatchPatchPrereq patchPrereq : patchPrereqs) {
            OPatchTarget.StatusCheck status = (OPatchTarget.StatusCheck)prereqResults.get(patchPrereq);
            if (status.getStatusCode() != 1) continue;
            StringBuffer reason = new StringBuffer();
            reason.append("Failed during Analysis: ").append(patchPrereq.toString() + " Failed, " + status.toString());
            patchAnalyzeResult = OPatchAutoBinaryUtil.buildFailedPR(patchResult.getPatchLocn(), patchResult.getPatchID(), reason.toString(), log);
            break;
        }
        return patchAnalyzeResult;
    }
}

