/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core.patchanalyzer.systempatch.engsystempatch;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.logging.Logger;
import oracle.opatchauto.core.patchanalyzer.PatchPackageException;
import oracle.opatchauto.core.patchanalyzer.systempatch.SystemPatchBundleXML;

public abstract class HashComputeFunction {
    static Logger logger = Logger.getLogger(HashComputeFunction.class.getName());

    protected abstract List<String> fileList(String var1, SystemPatchBundleXML var2);

    protected abstract String getHashFunction();

    protected String computeHash(List<String> metaList) throws PatchPackageException {
        if (metaList.isEmpty()) {
            return new String();
        }
        try {
            MessageDigest md = MessageDigest.getInstance(this.getHashFunction());
            Collections.sort(metaList);
            for (int j = 0; j < metaList.size(); ++j) {
                String[] filterWords = new String[]{"unique_patch_id", "fvalue"};
                String metaContents = this.getContentWithFilter(new FileInputStream(new File(metaList.get(j))), filterWords).toString();
                byte[] buffHash = metaContents.getBytes();
                md.update(buffHash);
            }
            byte[] b = md.digest();
            String HEXES = "0123456789ABCDEF";
            StringBuilder hex = new StringBuilder(2 * b.length);
            for (int j = 0; j < b.length; ++j) {
                byte bit = b[j];
                hex.append(HEXES.charAt((bit & 0xF0) >> 4)).append(HEXES.charAt(bit & 0xF));
            }
            String valueComp = hex.toString();
            return valueComp.toLowerCase();
        }
        catch (NumberFormatException e) {
            throw new PatchPackageException("The function value \"" + this.getHashFunction() + "\" of tag <fvalue> is invalid.");
        }
        catch (NoSuchAlgorithmException e) {
            PatchPackageException ppe = new PatchPackageException(e.getMessage());
            ppe.setStackTrace(e.getStackTrace());
            throw ppe;
        }
        catch (Exception e) {
            PatchPackageException ppe = new PatchPackageException(e.getMessage());
            ppe.setStackTrace(e.getStackTrace());
            throw ppe;
        }
    }

    protected String computeHash(HashMap<String, byte[]> metaMap) throws PatchPackageException {
        if (metaMap.isEmpty()) {
            return new String();
        }
        try {
            MessageDigest md = MessageDigest.getInstance(this.getHashFunction());
            ArrayList<String> keyList = new ArrayList<String>();
            Set<String> keySet = metaMap.keySet();
            Iterator<String> iterator = keySet.iterator();
            while (iterator.hasNext()) {
                keyList.add(iterator.next());
            }
            Collections.sort(keyList);
            for (String key : keyList) {
                String[] filterWords = new String[]{"unique_patch_id", "fvalue"};
                String metaContents = this.getContentWithFilter(new ByteArrayInputStream(metaMap.get(key)), filterWords).toString();
                byte[] buffHash = metaContents.getBytes();
                md.update(buffHash);
            }
            byte[] b = md.digest();
            String HEXES = "0123456789ABCDEF";
            StringBuilder hex = new StringBuilder(2 * b.length);
            for (int j = 0; j < b.length; ++j) {
                byte bit = b[j];
                hex.append(HEXES.charAt((bit & 0xF0) >> 4)).append(HEXES.charAt(bit & 0xF));
            }
            String valueComp = hex.toString();
            return valueComp.toLowerCase();
        }
        catch (NumberFormatException e) {
            throw new PatchPackageException("The function value \"" + this.getHashFunction() + "\" of tag <fvalue> is invalid.");
        }
        catch (NoSuchAlgorithmException e) {
            PatchPackageException ppe = new PatchPackageException(e.getMessage());
            ppe.setStackTrace(e.getStackTrace());
            throw ppe;
        }
        catch (Exception e) {
            PatchPackageException ppe = new PatchPackageException(e.getMessage());
            ppe.setStackTrace(e.getStackTrace());
            throw ppe;
        }
    }

    public StringBuffer getContentWithFilter(InputStream is, String[] filterWords) throws IOException {
        Scanner sc = new Scanner(is);
        sc.useDelimiter("\n");
        StringWriter sw = new StringWriter();
        String line = null;
        String tempLine = null;
        while (sc.hasNext()) {
            if (tempLine != null) {
                sw.write(line);
                sw.write(10);
            }
            line = sc.next();
            boolean isFilter = false;
            for (int i = 0; i < filterWords.length; ++i) {
                if (line.trim().length() != 0 && !line.contains(filterWords[i])) continue;
                isFilter = true;
                break;
            }
            if (!isFilter) {
                tempLine = line;
                continue;
            }
            tempLine = null;
        }
        if (tempLine != null) {
            sw.write(tempLine.trim());
        }
        sw.close();
        sc.close();
        return sw.getBuffer();
    }
}

