/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core.utility.operation;

import java.util.ArrayList;
import java.util.List;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatchauto.core.binary.OPatchAutoException;
import oracle.opatchauto.core.binary.OPatchBinarySessionResult;
import oracle.opatchauto.core.binary.OPatchPatchInfo;
import oracle.opatchauto.core.binary.PatchMetadataSessionResult;
import oracle.opatchauto.core.utility.OPatchCoreUtilParam;
import oracle.opatchauto.core.utility.operation.OPatchAutoCoreUtilOperation;

public class PatchMetadataQueryOperation
implements OPatchAutoCoreUtilOperation {
    @Override
    public OPatchBinarySessionResult execute(OPatchCoreUtilParam params) throws OPatchAutoException {
        List<String> patchLocationList = params.getPatchLocation();
        if (patchLocationList.isEmpty()) {
            throw new OPatchAutoException("No patch location provided");
        }
        ArrayList<OPatchPatchInfo> patchMetaDataList = new ArrayList<OPatchPatchInfo>();
        for (String loc : patchLocationList) {
            OPatchPatchInfo patchInfo = this.getPatchInfo(loc);
            patchMetaDataList.add(patchInfo);
        }
        PatchMetadataSessionResult sessionResult = new PatchMetadataSessionResult();
        sessionResult.setPatchMetaDataList(patchMetaDataList);
        return sessionResult;
    }

    private OPatchPatchInfo getPatchInfo(String patchLocation) throws OPatchAutoException {
        OPatchPatchInfo patchInfo = null;
        try {
            OPatchPatch[] opatchPatches = OPatchPatch.getPatchesNoSymbolResolve((String)patchLocation);
            OPatchPatch opatchPatch = opatchPatches[0];
            patchInfo = new OPatchPatchInfo(opatchPatch);
            patchInfo.setPatchLocation(patchLocation);
        }
        catch (OPatchException e) {
            throw new OPatchAutoException("Failed to read patch information due to " + e.getLocalizedMessage());
        }
        return patchInfo;
    }
}

