/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;
import oracle.glcm.opatch.common.api.Result;
import oracle.opatch.Applicable;
import oracle.opatch.ArchiveAction;
import oracle.opatch.BackupFailureException;
import oracle.opatch.Bug;
import oracle.opatch.CompositePatchObject;
import oracle.opatch.CopyAction;
import oracle.opatch.DeleteJarAction;
import oracle.opatch.DiscoverOHState;
import oracle.opatch.ExitOPatchException;
import oracle.opatch.Help;
import oracle.opatch.InitReadMeAction;
import oracle.opatch.InitScriptAction;
import oracle.opatch.JarAction;
import oracle.opatch.MakeAction;
import oracle.opatch.MergedPatchObject;
import oracle.opatch.OCMException;
import oracle.opatch.OPatchActionExecutor;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchExternalFactory;
import oracle.opatch.OPatchSession;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.OUIReplacer;
import oracle.opatch.OneOffEntry;
import oracle.opatch.OnlinePatchProcessor;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchComponentCheckResult;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.PatchingModel;
import oracle.opatch.PatchmdXml;
import oracle.opatch.Platform;
import oracle.opatch.PostReadMeAction;
import oracle.opatch.PostScriptAction;
import oracle.opatch.PreReadMeAction;
import oracle.opatch.PreScriptAction;
import oracle.opatch.PrereqFailedException;
import oracle.opatch.Rac;
import oracle.opatch.RacFileCreator;
import oracle.opatch.RacProcessor;
import oracle.opatch.RacTypeDetectState;
import oracle.opatch.RollbackSession;
import oracle.opatch.Rollbackable;
import oracle.opatch.Rules;
import oracle.opatch.SQLUtilities;
import oracle.opatch.StringResource;
import oracle.opatch.SystemCall;
import oracle.opatch.UtilSession;
import oracle.opatch.Verifiable;
import oracle.opatch.ioc.IOC;
import oracle.opatch.ioc.IOCHelper;
import oracle.opatch.ipm.IIPMRWServices;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.IPM;
import oracle.opatch.ipm.IPMUtil;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.ConflictMatrixOutput;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.opatch.opatchprereq.PrereqSet;
import oracle.opatch.opatchutil.OPatchUtilHelper;
import oracle.opatch.util.perfmonitor.MethodTracker;
import oracle.opatch.util.perfmonitor.MethodTrackerObj;
import oracle.opatch.util.perfmonitor.TrackerTags;
import oracle.opatch.wrappers.WrapperFactory;

public class ApplySession
extends OPatchSession
implements Help {
    private static String sessionName = "ApplySession";
    private static boolean calledFromUtil = false;
    IIPMRWServices rwServices = IPM.INSTANCE.getRWServices();
    private PatchObject[] rolledBackPatcheObjects = new PatchObject[0];
    private PatchObject APPLY_PATCHOBJECT = null;
    private PatchObject NAPPLY_PATCHOBJECT = null;
    private static HashSet COMPOSITE_FILTEREDPATCHACTIONS = new HashSet();

    protected ApplySession(String name, boolean readOnly) {
        super(name, readOnly);
    }

    public static void printPrereqSet(PrereqSet set) {
        OneOffEntry[] entries = set.getAllElements();
        System.out.println("printPrereqSet");
        for (int i2 = 0; i2 < entries.length; ++i2) {
            System.out.println("entry is: " + entries[i2]);
        }
    }

    protected PatchObject getActivePatchObject() {
        return this.APPLY_PATCHOBJECT;
    }

    private PatchObject[] getAutoRolledBackPatchObjects() {
        return this.rolledBackPatcheObjects;
    }

    public static void resetCompositeFilteredActions() {
        COMPOSITE_FILTEREDPATCHACTIONS = new HashSet();
    }

    private void createRollbackFile(String oracleHomePath, String cookedPatchID, PatchAction[] patchActions) throws IOException {
        StringBuffer buff = new StringBuffer("ApplySession::createRollbackFile()");
        OLogger.debug(buff);
        try {
            OPatchSessionHelper.checkArrayForNull("PatchAction", patchActions);
        }
        catch (NullPointerException e2) {
            IOException ioe = new IOException(e2.getMessage(), e2);
            ioe.setStackTrace(e2.getStackTrace());
            throw ioe;
        }
        boolean isWindow = OPatchEnv.isWindows();
        String rbFileLoc = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID);
        StringBuffer rbFilePath = new StringBuffer(rbFileLoc);
        rbFilePath.append(File.separator);
        if (isWindow) {
            rbFilePath.append("rollback.bat");
        } else {
            rbFilePath.append("rollback.sh");
        }
        buff = new StringBuffer("Creating script \"");
        buff.append(rbFilePath.toString());
        buff.append("\"...");
        OLogger.log(OLogger.FINE, buff.toString());
        Path rbFile = WrapperFactory.getNioServiceWrapper().getPath(rbFilePath.toString(), new String[0]);
        BufferedWriter fw = Files.newBufferedWriter(rbFile, Charset.forName("UTF-8"), new OpenOption[0]);
        if (isWindow) {
            buff = new StringBuffer("@echo off\n");
            buff.append("REM ");
            buff.append(OLogger.getString("OUI-67213", new Object[]{StringResource.COPY_RIGHT_YEAR}));
            buff.append("\n\n");
            buff.append("echo This script is going to rollback the changes made to system files on\necho this Oracle Home only. It does not perform any of the following:\necho - Inventory update\necho - Running init/pre/post scripts\necho - Customized steps performed manually by user\necho Please use this script with supervision from Oracle Technical Support.\necho To rollback a patch, please use 'opatch rollback'.\n\n echo NOTE: JDK should be present in the Oracle Home to rollback Java Archives.\n\n");
            buff.append("REM # Get ORACLE_HOME from environment variable \"ORACLE_HOME\"\nset OH=%ORACLE_HOME%\n\nREM # Error out if OH is not set\nif NOT \"$OH\" == \"\"  goto MODIFY_FILES\n    echo Oracle Home is not set.\n    echo Please set env. variable ORACLE_HOME and try again.\n    echo Script failed to proceed.\n    set %ERROR_LEVEL% = 1\n    exit %ERROR_LEVEL%\n\n:MODIFY_FILES\n\necho About to modify Oracle Home( %OH% )\necho Do you want to proceed? [Y/N]\nif \"%1\" == \"-silent\" goto PROCEED\nset /p response= ^>\n\nif \"%response%\" == \"Y\" goto PROCEED\nif \"%response%\" == \"y\" goto PROCEED\necho User responded with : %response%\nexit 0;\n\n:PROCEED\necho User responded with : Y\n\n");
        } else {
            buff = new StringBuffer("#!/bin/sh\n");
            buff.append("# ");
            buff.append(OLogger.getString("OUI-67213", new Object[]{StringResource.COPY_RIGHT_YEAR}));
            buff.append("\n\n");
            buff.append("echo This script is going to rollback the changes made to system files on\necho this Oracle Home only. It does not perform any of the following:\necho - Inventory update\necho - Oracle binary re-link\necho - Running init/pre/post scripts\necho - Customized steps performed manually by user\necho Please use this script with supervision from Oracle Technical Support.\necho To rollback a patch, please use \"'opatch rollback'\".\n echo NOTE: JDK should be present in the Oracle Home to rollback Java Archives.\n\n");
            buff.append("# Get ORACLE_HOME from environment variable \"ORACLE_HOME\"\nOH=${ORACLE_HOME}\n\n# Error out if OH is not set\nif [ \"$OH\" = \"\" ]; then\n    echo Oracle Home is not set.\n    echo Please set env. variable ORACLE_HOME and try again.\n    echo Script failed to proceed.\n    exit 1\nfi\n\necho \"About to modify Oracle Home( $OH )\"\necho \"Do you want to proceed? [Y/N]\"\nif [ \"$1\" = \"-silent\" ]; then\n   response=\"Y\"\nelse\n    read response;\nfi\n\nif [ $response = \"y\" ] || [ $response = \"Y\" ]; then\n    echo \"User responded with : Y\"\nelse\n    echo \"User responded with : $response\"\n    exit 0\nfi\n\n");
        }
        fw.write(buff.toString());
        String ohLiteral = "";
        StringBuffer dateAndTime = new StringBuffer("Date   Time : ");
        StringBuffer ohPath = new StringBuffer("Oracle Home : ");
        StringBuffer commandLine = new StringBuffer("Command     : ");
        if (OPatchEnv.isWindows()) {
            ohLiteral = "%OH%";
            ohPath.append(ohLiteral);
            commandLine.append("rollback.bat");
            dateAndTime.append("%date% %time%");
        } else {
            ohLiteral = "$OH";
            ohPath.append(ohLiteral);
            commandLine.append("rollback.sh");
            dateAndTime.append("`date`");
        }
        StringBuffer historyFilename = new StringBuffer();
        historyFilename.append(ohLiteral);
        historyFilename.append(File.separator);
        historyFilename.append(StringResource.CENTRAL_LOG_DIR);
        historyFilename.append(File.separator);
        historyFilename.append("opatch_history.txt");
        buff = new StringBuffer("\necho ");
        buff.append(dateAndTime);
        buff.append(" >> ");
        buff.append(historyFilename.toString());
        buff.append("\necho ");
        buff.append(ohPath);
        buff.append(" >> ");
        buff.append(historyFilename.toString());
        buff.append("\necho ");
        buff.append(commandLine);
        buff.append(" >> ");
        buff.append(historyFilename.toString());
        buff.append("\n\n");
        fw.write(buff.toString());
        for (int i2 = 0; i2 < patchActions.length; ++i2) {
            int index;
            PatchAction pa = patchActions[i2];
            if (!(pa instanceof Rollbackable) || !pa.isAppliedOK()) continue;
            Rollbackable ra = (Rollbackable)((Object)pa);
            StringBuffer rollbackEntry = new StringBuffer(ra.getRollbackScriptEntry(oracleHomePath, cookedPatchID));
            String varOH = null;
            varOH = isWindow ? "%OH%" : "$OH";
            if (oracleHomePath.endsWith("/") || oracleHomePath.endsWith("\\")) {
                oracleHomePath = oracleHomePath.substring(0, oracleHomePath.length() - 1);
            }
            if (!isWindow) {
                int dollarIndex = rollbackEntry.indexOf("$");
                while (dollarIndex != -1) {
                    rollbackEntry.insert(dollarIndex, "\\");
                    dollarIndex = rollbackEntry.indexOf("$", dollarIndex + 2);
                }
            }
            if ((index = rollbackEntry.indexOf(oracleHomePath)) != -1) {
                rollbackEntry.replace(index, index + oracleHomePath.length(), varOH);
                index = rollbackEntry.indexOf(oracleHomePath, index);
            }
            while (index != -1 && (rollbackEntry.charAt(index - 1) == ' ' || rollbackEntry.charAt(index - 1) == '\n')) {
                rollbackEntry.replace(index, index + oracleHomePath.length(), varOH);
                index = rollbackEntry.indexOf(oracleHomePath, index);
            }
            fw.write(rollbackEntry.toString());
            fw.flush();
        }
        fw.write("\necho Rollback script completed.\n");
        fw.flush();
        fw.close();
        OUIReplacer.changePermission(rbFilePath.toString(), 456);
    }

    protected IIPMRWServices loadInventory(String oracleHomePath) throws RuntimeException {
        RuntimeException re = null;
        IIPMRWServices rwServices = IPM.INSTANCE.getRWServices();
        try {
            rwServices.lock(oracleHomePath);
            rwServices.loadInventory(oracleHomePath);
        }
        catch (NullPointerException e2) {
            OPatchStateManagerFactory.getInstance().setErrorCode(22);
            OLogger.error("OUI-67064", new Object[]{oracleHomePath});
            re = new RuntimeException(e2.getMessage(), e2);
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        catch (IllegalArgumentException e3) {
            OPatchStateManagerFactory.getInstance().setErrorCode(22);
            OLogger.error("OUI-67064", new Object[]{oracleHomePath});
            re = new RuntimeException(e3.getMessage(), e3);
            re.setStackTrace(e3.getStackTrace());
            throw re;
        }
        catch (SecurityException e4) {
            OPatchStateManagerFactory.getInstance().setErrorCode(22);
            OLogger.error("OUI-67064", new Object[]{oracleHomePath});
            re = new RuntimeException(e4.getMessage(), e4);
            re.setStackTrace(e4.getStackTrace());
            throw re;
        }
        catch (Throwable t) {
            OPatchStateManagerFactory.getInstance().setErrorCode(22);
            OLogger.error("OUI-67064", new Object[]{oracleHomePath});
            re = new RuntimeException(t.getMessage(), t);
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        return rwServices;
    }

    private static void applyDelayedActions(PatchObject apPatchObject, String oracleHomePath) throws RuntimeException, Exception {
        StringBuffer errorBuff = new StringBuffer();
        StringBuffer msg = new StringBuffer();
        StringBuffer buff = new StringBuffer("ApplySession::applyDelayedActions()");
        OLogger.debug(buff);
        boolean errorFlag = false;
        String mode = "apply";
        try {
            if (apPatchObject == null) {
                throw new RuntimeException("Apply Patch Object is null");
            }
            ArrayList pActions = apPatchObject.getDelayedExecutionActions();
            String patchLocation = apPatchObject.getPatchLocation();
            if (pActions.size() != 0) {
                String printMsg = OLogger.getString("OUI-67269", new Object[]{mode});
                OLogger.println(printMsg);
            }
            for (int j2 = 0; j2 < pActions.size(); ++j2) {
                PatchAction pa = (PatchAction)pActions.get(j2);
                if (!(pa instanceof PatchAction) || !(pa instanceof Applicable)) continue;
                Applicable aa = (Applicable)((Object)pa);
                msg = new StringBuffer();
                msg.append(aa.getApplyDescription(oracleHomePath));
                OLogger.onlyLogInfo("OUI-67124", new Object[]{msg.toString()});
                try {
                    buff = new StringBuffer("   Process Delayed Action ");
                    buff.append(pa.toString());
                    OLogger.debug(buff);
                    aa.apply(oracleHomePath, patchLocation);
                    continue;
                }
                catch (RuntimeException e2) {
                    pa.setApplyFailed();
                    errorBuff.append(e2.getMessage());
                    errorBuff.append("\n");
                    errorFlag = true;
                }
            }
            if (errorFlag) {
                OLogger.println("\nThe following actions have failed:");
                OLogger.warn("OUI-67124", new Object[]{errorBuff.toString()});
                StringBuffer emptyBuff = new StringBuffer("");
                if (!OPatchEnv.proceedWithOperationDefaultNo(emptyBuff)) {
                    RuntimeException e3 = new RuntimeException(errorBuff.toString());
                    throw e3;
                }
            }
        }
        catch (Exception e4) {
            throw e4;
        }
        finally {
            OLogger.debug(new StringBuffer("Shutting down database after " + mode + " of delayed actions"));
            SQLUtilities.shutdownAllDB(oracleHomePath);
        }
    }

    private IIPMRWServices apply(String oracleHomePath, PatchObject patchObject, IIPMRWServices rwServices) throws RuntimeException {
        StringBuffer buff = new StringBuffer("ApplySession::apply()");
        OLogger.debug(buff);
        boolean cont = Rules.OUIWrite_continue();
        try {
            if (cont && !IOC.INSTANCE.isInventoryConverted()) {
                buff = new StringBuffer("ApplySession::apply() creates one-off entry");
                OLogger.debug(buff);
                buff = new StringBuffer("  calling IIPMRWServices::add()");
                rwServices.add(patchObject);
            } else {
                buff = new StringBuffer(" skip creating the oneOff entry");
                OLogger.debug(buff);
            }
            OLogger.debug("ApplySession::Apply(): starting system modification");
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Starting to modify the system for patch " + patchObject.getPatchID());
            this.modifySystem(oracleHomePath, patchObject);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Finished modifying the system for patch " + patchObject.getPatchID());
            if (!OPatchEnv.isCASFlow()) {
                ApplySession.runPatchgen(oracleHomePath, patchObject.getPatchID(), true, false);
            }
            if (cont) {
                OPatchStateManagerFactory.getInstance().setCurrentState("Update inventory for apply");
                OLogger.debug(new StringBuffer("ApplySession::Apply(): save one-off entry to inventory"));
                if (patchObject.getPatchInventory().isMiniPatchSet()) {
                    OLogger.info("OUI-67612", new Object[]{sessionName, patchObject.getPatchID()});
                } else {
                    OLogger.justlog(OLogger.INFO, OLogger.getString("OUI-67085", new Object[]{sessionName, patchObject.getPatchID()}));
                }
                String compsXMLEntry = patchObject.getOneOffEntryInCompsXML();
                StringBuffer msg = new StringBuffer("About to use OUI API to add the following entry to inventory:\n");
                msg.append(compsXMLEntry);
                OLogger.justlog(OLogger.FINEST, msg.toString());
                OPatchSessionHelper.runLibraryRegeneration(patchObject, oracleHomePath, false);
                if (!IOC.INSTANCE.isInventoryConverted()) {
                    OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Saving patch " + patchObject.getPatchID() + " to inventory");
                    MethodTrackerObj savePatchTracker = MethodTracker.getTracker(TrackerTags.SAVE_PATCH_TO_INVENTORY);
                    savePatchTracker.start();
                    rwServices.savePatch(patchObject);
                    savePatchTracker.end();
                    OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Patch " + patchObject.getPatchID() + " saved to inventory");
                }
            } else {
                buff = new StringBuffer(" skip saving oneOff entry to inventory");
                OLogger.debug(buff);
                OLogger.info("OUI-67165", new Object[]{sessionName});
            }
        }
        catch (Throwable t) {
            buff = new StringBuffer("ApplySession::apply failed");
            String msg = t.getMessage();
            if (msg != null) {
                buff.append(": ");
                buff.append(msg);
            } else {
                buff.append(" (no detail available).");
            }
            OLogger.debug(buff);
            if (Rules.shouldIgnoreErrorToContinue()) {
                OLogger.warn("OUI-67124", new Object[]{buff.toString()});
            }
            RuntimeException re = new RuntimeException(buff.toString(), t);
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        return rwServices;
    }

    private void modifySystem(String oracleHomePath, PatchObject patchObject) throws RuntimeException {
        MethodTrackerObj copyBitTrackerObj = MethodTracker.getTracker(TrackerTags.COPYBIT);
        copyBitTrackerObj.start();
        String patchLocation = patchObject.getPatchLocation();
        String patchID = patchObject.getPatchID();
        String cookedPatchID = patchObject.getCookedPatchID();
        StringBuffer buff = new StringBuffer("ApplySession::modifySystem(): ");
        OLogger.debug(buff);
        OPatchActionExecutor.getInstance().runApply(oracleHomePath, patchObject);
        if (patchObject.shouldInvokeMakeAction()) {
            if (OPatchEnv.isRunSql()) {
                SQLUtilities.shutdownAllDB(oracleHomePath);
            }
            PatchObject[] rbPObjs = this.getAutoRolledBackPatchObjects();
            PatchObject[] patchObjectsTouched = new PatchObject[rbPObjs.length + 1];
            int pIter = 0;
            for (pIter = 0; pIter < rbPObjs.length; ++pIter) {
                patchObjectsTouched[pIter] = rbPObjs[pIter];
            }
            patchObjectsTouched[pIter] = patchObject;
            ApplySession.runMake("ApplySession", oracleHomePath, patchObjectsTouched);
        }
        if (Rules.SystemWrite_continue()) {
            try {
                PatchAction[] applicablePatchActions = patchObject.getPatchActions();
                this.createRollbackFile(oracleHomePath, cookedPatchID, applicablePatchActions);
            }
            catch (IOException e2) {
                buff = new StringBuffer("ApplySession cannot create rollback file.  ");
                buff.append("You will have to use OPatch to roll back the patch ");
                buff.append(patchID);
                OLogger.warn("OUI-67124", new Object[]{buff.toString()});
            }
        }
        buff = new StringBuffer("ApplySession::modifySystem() returns");
        OLogger.debug(buff);
        copyBitTrackerObj.end();
    }

    protected void loadPatchObject(String patchLocation) {
        StringBuffer buff = new StringBuffer("ApplySession::loadPatchObject()");
        OLogger.debug(buff);
        this.APPLY_PATCHOBJECT = this.loadAndInitPatchObject(patchLocation);
    }

    private PatchObject loadAndInitPatchObject(String patchLocation) throws RuntimeException {
        StringBuffer buff = new StringBuffer("ApplySession::loadAndInitPatchObject()");
        OLogger.debug(buff);
        PatchObject patchObject = null;
        try {
            patchObject = PatchObjectUtil.loadPatch(patchLocation);
            Bug[] bugsToFix = patchObject.getBugsToFix();
            if (bugsToFix.length == 0) {
                String msg = OLogger.getString("OUI-67132");
                RuntimeException re = new RuntimeException(msg);
                throw re;
            }
            StringBuffer tBuf = new StringBuffer();
            for (int nBugs = 0; nBugs < bugsToFix.length; ++nBugs) {
                Bug b2 = bugsToFix[nBugs];
                tBuf.append("   ");
                tBuf.append(b2.getBugID());
                tBuf.append(": ");
                tBuf.append(b2.getDesc());
                tBuf.append("\n");
            }
            String msg = OLogger.getString("OUI-67216", new Object[]{patchObject.getPatchID(), tBuf.toString()});
            OLogger.verbose(this, new StringBuffer(msg));
            String patchLoc = patchObject.getPatchLocation();
            String preReadMeLoc = PatchObject.getPreReadMeFilePath(patchLoc);
            String postReadMeLoc = PatchObject.getPostReadMeFilePath(patchLoc);
            String initReadMeLoc = PatchObject.getInitReadMeFilePath(patchLoc);
            String initScriptLoc = PatchObject.getInitScriptFilePath(patchLoc);
            String preScriptLoc = PatchObject.getPreScriptFilePath(patchLoc);
            String postScriptLoc = PatchObject.getPostScriptFilePath(patchLoc);
            PreReadMeAction preRead = new PreReadMeAction(preReadMeLoc);
            PreScriptAction preScript = new PreScriptAction(preScriptLoc);
            PostReadMeAction postRead = new PostReadMeAction(postReadMeLoc);
            PostScriptAction postScript = new PostScriptAction(postScriptLoc);
            InitReadMeAction initRead = new InitReadMeAction(initReadMeLoc);
            InitScriptAction initScript = new InitScriptAction(initScriptLoc);
            patchObject.setPreReadMeAction(preRead);
            patchObject.setPreScriptAction(preScript);
            patchObject.setPostReadMeAction(postRead);
            patchObject.setPostScriptAction(postScript);
            patchObject.setInitReadMeAction(initRead);
            patchObject.setInitScriptAction(initScript);
        }
        catch (RuntimeException e2) {
            buff = new StringBuffer("ApplySession::process() cannot load PatchObject: ");
            buff.append(e2.getMessage());
            OLogger.debug(buff);
            throw e2;
        }
        return patchObject;
    }

    private void setupPatchStorage(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        StringBuffer buff = new StringBuffer("ApplySession::setupPatchStorage()");
        OLogger.debug(buff);
        String msg = "";
        OPatchEnv.initCookedPatchID(cookedPatchID);
        boolean patchStorageCreated = OPatchEnv.setupPatchStorage(oracleHomePath, cookedPatchID);
        if (!patchStorageCreated) {
            msg = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID);
            buff = new StringBuffer("ApplySession was not able to create the patch_storage area: ");
            buff.append(msg);
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
        boolean patchStoragePatchSaveArea = OPatchEnv.setupPatchBackup(oracleHomePath, cookedPatchID);
        if (!patchStoragePatchSaveArea) {
            msg = OPatchEnv.getPatchBackupDirectoryPath(oracleHomePath, cookedPatchID);
            buff = new StringBuffer("ApplySession was not able to create the patch_storage to save the org. patch: ");
            buff.append(msg);
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
        String makeFile = OPatchEnv.getManualMakeFile(oracleHomePath, cookedPatchID);
        Path tmpF = WrapperFactory.getNioServiceWrapper().getPath(makeFile, new String[0]);
        try {
            Files.deleteIfExists(tmpF);
        }
        catch (IOException e2) {
            OLogger.debug(e2.getMessage());
        }
    }

    private void saveOriginalPatch(String oracleHomePath, String cookedPatchID, String patchLocation) throws RuntimeException {
        StringBuffer buff = new StringBuffer("ApplySession::saveOriginalPatch()");
        OLogger.debug(buff);
        try {
            Path src = WrapperFactory.getNioServiceWrapper().getPath(patchLocation, new String[0]);
            String patchBackupDir = OPatchEnv.getPatchBackupDirectoryPath(oracleHomePath, cookedPatchID);
            Path dst = WrapperFactory.getNioServiceWrapper().getPath(patchBackupDir, new String[0]);
            boolean debug = true;
            if (Files.exists(dst, new LinkOption[0])) {
                SystemCall.deleteRecurse(oracleHomePath, cookedPatchID, dst, debug);
            }
            OPatchEnv.setupPatchBackup(oracleHomePath, cookedPatchID);
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(src);){
                for (Path originalFile : stream) {
                    if (originalFile.getFileName().toString().equalsIgnoreCase("files") || originalFile.getFileName().toString().equalsIgnoreCase("files_online")) continue;
                    StringBuffer dstPath = new StringBuffer(patchBackupDir);
                    dstPath.append(File.separator);
                    dstPath.append(originalFile.getFileName().toString());
                    Path tempDst = WrapperFactory.getNioServiceWrapper().getPath(dstPath.toString(), new String[0]);
                    if (Files.isDirectory(originalFile, new LinkOption[0])) {
                        Files.createDirectories(tempDst, new FileAttribute[0]);
                    }
                    if (originalFile.toString().endsWith("/custom")) {
                        this.customRecurse(originalFile, tempDst, debug);
                        continue;
                    }
                    SystemCall.copyRecurse(originalFile, tempDst, debug);
                }
            }
            catch (IOException e2) {
                OLogger.debug(e2.getMessage());
            }
        }
        catch (RuntimeException e3) {
            String msg = OPatchEnv.getPatchBackupDirectoryPath(oracleHomePath, cookedPatchID);
            buff = new StringBuffer("ApplySession was not able to save the orginal patch to ");
            buff.append(msg);
            buff.append(e3.getMessage());
            OLogger.debug(buff);
            throw e3;
        }
    }

    private void scriptsRecurse(Path scriptsDir, Path scriptsDst, boolean debug) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(scriptsDir);){
            for (Path scripts : stream) {
                if (Files.isDirectory(scripts, new LinkOption[0])) {
                    if (scripts.getFileName().toString().equals("bi")) continue;
                    this.scriptsRecurse(scripts, scriptsDst, debug);
                    continue;
                }
                if (scripts.getFileName().toString().endsWith(".diff")) continue;
                int pos = scripts.getParent().toString().indexOf("/scripts");
                String temDir = scripts.getParent().toString().substring(pos + 8);
                Path temScriptsDst = WrapperFactory.getNioServiceWrapper().getPath(scriptsDst.toString(), temDir);
                Files.createDirectories(temScriptsDst, new FileAttribute[0]);
                SystemCall.copyRecurse(scripts, temScriptsDst, debug);
            }
        }
        catch (IOException e2) {
            OLogger.debug(e2.getMessage());
        }
    }

    private void customRecurse(Path customDir, Path tempDst, boolean debug) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(customDir);){
            for (Path custom : stream) {
                if (Files.isDirectory(custom, new LinkOption[0])) {
                    if (custom.getFileName().toString().equals("scripts")) {
                        Path scriptsDst = WrapperFactory.getNioServiceWrapper().getPath(tempDst.toString() + File.separator + custom.getFileName().toString(), new String[0]);
                        Files.createDirectories(scriptsDst, new FileAttribute[0]);
                        this.scriptsRecurse(custom, scriptsDst, debug);
                        continue;
                    }
                    Path dst = WrapperFactory.getNioServiceWrapper().getPath(tempDst.toString() + File.separator + custom.getFileName().toString(), new String[0]);
                    Files.createDirectories(dst, new FileAttribute[0]);
                    SystemCall.copyRecurse(custom, dst, debug);
                    continue;
                }
                SystemCall.copyRecurse(custom, tempDst, debug);
            }
        }
        catch (IOException e2) {
            OLogger.debug(e2.getMessage());
        }
    }

    private void generateAutoRacFile(String oracleHomePath, PatchObject patchObject, PatchObject[] autorbPatches) throws IOException {
        boolean autoRB = true;
        StringBuffer buff = new StringBuffer("generateAutoRacFile() (there is auto-rb)");
        OLogger.debug(buff);
        if (patchObject == null || autorbPatches == null || autorbPatches.length == 0) {
            buff = new StringBuffer("generateAutoRacFile(auto-rb): null patch object, ");
            buff.append("null or empty auto-rollback patch object list.");
            OLogger.debug(buff);
            throw new IOException(buff.toString());
        }
        try {
            OPatchSessionHelper.checkArrayForNull("PatchObject", autorbPatches);
        }
        catch (NullPointerException e2) {
            IOException ioe = new IOException(e2.getMessage(), e2);
            ioe.setStackTrace(e2.getStackTrace());
            throw ioe;
        }
        boolean createRacFile = OPatchEnv.isCreateRacFile();
        if (!createRacFile) {
            buff = new StringBuffer("Users request no RAC file generation.  Do not create files.");
            OLogger.verbose(this, buff);
            return;
        }
        String applyPatchID = patchObject.getPatchID();
        String cookedPatchID = patchObject.getCookedPatchID();
        boolean apply = true;
        boolean rollback = false;
        boolean auto_rb = true;
        try {
            String compsXML = IPMUtil.getCompsXMLLocation(StringResource.getLiteralOracleHome());
            buff = new StringBuffer("ApplySession:: calling PatchObject to create the FP list: compsXML=\"");
            buff.append(compsXML);
            buff.append("\"");
            OLogger.debug(buff);
            patchObject.createFP(this, oracleHomePath, cookedPatchID, applyPatchID, compsXML);
        }
        catch (IOException e3) {
            OPatchStateManagerFactory.getInstance().setErrorCode(72);
            buff = new StringBuffer("   PatchObject::createFP() throws IOException: ");
            buff.append(e3.getMessage());
            OLogger.debug(buff);
            IOException ioe = new IOException(buff.toString(), e3);
            ioe.setStackTrace(e3.getStackTrace());
            throw ioe;
        }
        try {
            String oneOffs = OPatchEnv.getPatchFilemapInfoLoc(StringResource.getLiteralOracleHome(), applyPatchID);
            String patchStorage = OPatchEnv.getPatchStorageDirectoryPath(StringResource.getLiteralOracleHome(), cookedPatchID);
            buff = new StringBuffer("ApplySession:: calling PatchObject to create the DP list: oneOffs=\"");
            buff.append(oneOffs);
            buff.append("\", patchStorage=\"");
            buff.append(patchStorage);
            buff.append("\"");
            OLogger.debug(buff);
            patchObject.createDP(this, oracleHomePath, cookedPatchID, applyPatchID, oneOffs, patchStorage);
        }
        catch (IOException e4) {
            OPatchStateManagerFactory.getInstance().setErrorCode(75);
            buff = new StringBuffer("   PatchObject::createRacDP() throws IOException: ");
            buff.append(e4.getMessage());
            OLogger.debug(buff);
            IOException ioe = new IOException(buff.toString(), e4);
            ioe.setStackTrace(e4.getStackTrace());
            throw ioe;
        }
        try {
            patchObject.createRC(this, oracleHomePath, cookedPatchID, applyPatchID);
        }
        catch (IOException e5) {
            OPatchStateManagerFactory.getInstance().setErrorCode(75);
            buff = new StringBuffer("   PatchObject::createRC() throws IOException: ");
            buff.append(e5.getMessage());
            OLogger.debug(buff);
            IOException ioe = new IOException(buff.toString(), e5);
            ioe.setStackTrace(e5.getStackTrace());
            throw ioe;
        }
        catch (RuntimeException e6) {
            OPatchStateManagerFactory.getInstance().setErrorCode(75);
            buff = new StringBuffer("   PatchObject::createRC() throws RuntimeException: ");
            buff.append(e6.getMessage());
            OLogger.debug(buff);
            RuntimeException rte = new RuntimeException(buff.toString(), e6);
            rte.setStackTrace(e6.getStackTrace());
            throw rte;
        }
        buff = new StringBuffer(" Loop thru all auto-rb patches to generate prop. files");
        OLogger.debug(buff);
        for (int i2 = 0; i2 < autorbPatches.length; ++i2) {
            PatchObject eachPatch = autorbPatches[i2];
            String patchID = eachPatch.getPatchID();
            String patchBeingRollbackWithTimeStamp = eachPatch.getCookedPatchID();
            buff = new StringBuffer(" generate files for patch ");
            buff.append(patchID);
            OLogger.debug(buff);
            try {
                String oneOffs = OPatchEnv.getPatchFilemapInfoLoc(StringResource.getLiteralOracleHome(), patchID);
                buff = new StringBuffer("   generating autoFp");
                OLogger.debug(buff);
                eachPatch.createAutoFP(this, oracleHomePath, cookedPatchID, patchID, patchBeingRollbackWithTimeStamp, autoRB);
                buff = new StringBuffer("   generating autoFr");
                OLogger.debug(buff);
                eachPatch.createAutoFR(this, oracleHomePath, cookedPatchID, patchID, patchBeingRollbackWithTimeStamp, autoRB);
                buff = new StringBuffer("   generating autoDr");
                OLogger.debug(buff);
                eachPatch.createAutoDR(this, oracleHomePath, cookedPatchID, patchID, oneOffs, autoRB);
                buff = new StringBuffer("   generating autoRc");
                OLogger.debug(buff);
                eachPatch.createAutoRC(this, oracleHomePath, cookedPatchID, patchID, oneOffs, autoRB);
                continue;
            }
            catch (IOException e7) {
                OPatchStateManagerFactory.getInstance().setErrorCode(76);
                buff = new StringBuffer("  IOException during file generation for patch ");
                buff.append(patchID);
                buff.append(", detail: ");
                buff.append(e7.getMessage());
                OLogger.debug(buff);
                throw e7;
            }
            catch (Exception e8) {
                buff = new StringBuffer("  Exception during file generation for patch ");
                buff.append(patchID);
                buff.append(", detail: ");
                buff.append(e8.getMessage());
                OLogger.debug(buff);
                IOException ioe = new IOException(buff.toString(), e8);
                ioe.setStackTrace(e8.getStackTrace());
                throw ioe;
            }
        }
        buff = new StringBuffer("ApplySession:: merging all files into FP-final, DP-final, FR-final, DR-final, RC-final");
        OLogger.debug(buff);
        RacFileCreator.mergeToFpDpFrDrRcFinal(oracleHomePath, cookedPatchID, applyPatchID, autorbPatches);
        RacFileCreator.createRacModeFile(oracleHomePath, cookedPatchID, apply, rollback, auto_rb);
    }

    private void generateRacFiles(String oracleHomePath, PatchObject patchObject) throws IOException {
        StringBuffer buff = new StringBuffer("ApplySession::generateRacFiles()");
        OLogger.debug(buff);
        String cookedPatchID = patchObject.getCookedPatchID();
        String patchID = patchObject.getPatchID();
        boolean apply = true;
        boolean rollback = false;
        boolean auto_rb = false;
        boolean createRacFile = OPatchEnv.isCreateRacFile();
        if (!createRacFile) {
            buff = new StringBuffer("Users request no RAC file generation.  Do not create files.");
            OLogger.verbose(this, buff);
            return;
        }
        try {
            String compsXML = IPMUtil.getCompsXMLLocation(StringResource.getLiteralOracleHome());
            buff = new StringBuffer("ApplySession:: calling PatchObject to create the FP list: compsXML=\"");
            buff.append(compsXML);
            buff.append("\"");
            OLogger.debug(buff);
            patchObject.createFP(this, oracleHomePath, cookedPatchID, patchID, compsXML);
        }
        catch (IOException e2) {
            buff = new StringBuffer("   PatchObject::createFP() throws IOException: ");
            buff.append(e2.getMessage());
            OLogger.debug(buff);
            IOException ioe = new IOException(buff.toString(), e2);
            ioe.setStackTrace(e2.getStackTrace());
            throw ioe;
        }
        try {
            String oneOffs = OPatchEnv.getPatchFilemapInfoLoc(StringResource.getLiteralOracleHome(), patchID);
            String patchStorage = OPatchEnv.getPatchStorageDirectoryPath(StringResource.getLiteralOracleHome(), cookedPatchID);
            buff = new StringBuffer("ApplySession:: calling PatchObject to create the DP list: oneOffs=\"");
            buff.append(oneOffs);
            buff.append("\", patchStorage=\"");
            buff.append(patchStorage);
            buff.append("\"");
            OLogger.debug(buff);
            patchObject.createDP(this, oracleHomePath, cookedPatchID, patchID, oneOffs, patchStorage);
        }
        catch (IOException e3) {
            buff = new StringBuffer("   PatchObject::createRacDP() throws IOException: ");
            buff.append(e3.getMessage());
            OLogger.debug(buff);
            IOException ioe = new IOException(buff.toString(), e3);
            ioe.setStackTrace(e3.getStackTrace());
            throw ioe;
        }
        try {
            patchObject.createRC(this, oracleHomePath, cookedPatchID, patchID);
        }
        catch (IOException e4) {
            buff = new StringBuffer("   PatchObject::createRC() throws IOException: ");
            buff.append(e4.getMessage());
            OLogger.debug(buff);
            IOException ioe = new IOException(buff.toString(), e4);
            ioe.setStackTrace(e4.getStackTrace());
            throw ioe;
        }
        buff = new StringBuffer("ApplySession:: creating the FP, DP and RC final");
        OLogger.debug(buff);
        RacFileCreator.createFpDpRcFinal(oracleHomePath, cookedPatchID, patchID);
        RacFileCreator.createRacModeFile(oracleHomePath, cookedPatchID, apply, rollback, auto_rb);
    }

    private void backupPatchActionsAndCreateRestoreFile(String oracleHomePath, PatchObject patchObject) throws RuntimeException, IOException {
        block21: {
            StringBuffer buff = new StringBuffer("ApplySession::backupPatchActionsAndCreateRestoreFile()");
            OLogger.debug(buff);
            if (!patchObject.shouldCreateRestoreFile()) {
                buff = new StringBuffer("ApplySession skips creating the restore file ");
                buff.append("per PatchObject's request.");
                OLogger.debug(buff);
                this.patchObjectBackupRestore(oracleHomePath, sessionName, patchObject);
                return;
            }
            OLogger.onlyLogInfo("OUI-67116");
            String cookedPatchID = patchObject.getCookedPatchID();
            boolean ignoreBackupError = false;
            String backupPath = OPatchEnv.getBackupDirectoryPath(oracleHomePath, cookedPatchID);
            boolean debug = true;
            Path dir = WrapperFactory.getNioServiceWrapper().getPath(backupPath, new String[0]);
            if (Files.exists(dir, new LinkOption[0])) {
                SystemCall.deleteRecurse(oracleHomePath, cookedPatchID, dir, debug);
            }
            OPatchEnv.setupPatchRestore(oracleHomePath, cookedPatchID);
            boolean createRacFile = OPatchEnv.isCreateRacFile();
            if (!createRacFile) {
                buff = new StringBuffer("Users request no RAC file generation.  Do not clean up sub-dir 'rac'.");
                OLogger.verbose(this, buff);
            } else {
                String racPath = OPatchEnv.getPatchStorageRacDirectoryPath(oracleHomePath, cookedPatchID);
                dir = WrapperFactory.getNioServiceWrapper().getPath(racPath, new String[0]);
                if (Files.exists(dir, new LinkOption[0])) {
                    SystemCall.deleteRecurse(oracleHomePath, cookedPatchID, dir, debug);
                }
            }
            try {
                buff = new StringBuffer("ApplySession creates the restore file.");
                OLogger.debug(buff);
                OPatchEnv.createRestoreFile(oracleHomePath, cookedPatchID);
            }
            catch (IOException e2) {
                OLogger.warn("OUI-67066");
                RuntimeException re = new RuntimeException(e2.getMessage(), e2);
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
            if (Rules.OUIRead_continue()) {
                Path dstFile;
                Path srcFile;
                String contentsXMLDst;
                String contentsXMLSrc;
                block20: {
                    buff = new StringBuffer("ApplySession: back up Oracle Home inventory");
                    OLogger.verbose(this, buff);
                    String backupDir = OPatchEnv.getBackupDirectoryPath(oracleHomePath, cookedPatchID);
                    String oneOffsSrc = IPMUtil.getOneoffsLocation(oracleHomePath);
                    String oneOffsDst = IPMUtil.getOneoffsLocation(backupDir);
                    contentsXMLSrc = IPMUtil.getCompsXMLLocation(oracleHomePath);
                    contentsXMLDst = IPMUtil.getCompsXMLLocation(backupDir);
                    buff = new StringBuffer("ApplySession: back up OracleHome Inventory oneoffs");
                    OLogger.verbose(this, buff);
                    srcFile = WrapperFactory.getNioServiceWrapper().getPath(oneOffsSrc, new String[0]);
                    dstFile = WrapperFactory.getNioServiceWrapper().getPath(oneOffsDst, new String[0]);
                    if (Files.exists(srcFile, new LinkOption[0])) {
                        try {
                            if (!Files.exists(dstFile, new LinkOption[0])) {
                                buff = new StringBuffer("Creating directory \"");
                                buff.append(dstFile.toString());
                                buff.append("\"");
                                OLogger.log(OLogger.FINEST, buff.toString());
                                Files.createDirectories(dstFile, new FileAttribute[0]);
                            }
                            SystemCall.backupRecurse(srcFile, dstFile, debug);
                        }
                        catch (RuntimeException e3) {
                            OPatchStateManagerFactory.getInstance().setErrorCode(46);
                            OLogger.error("OUI-67083", new Object[]{sessionName, oneOffsSrc});
                            buff = new StringBuffer(OLogger.getString("OUI-67083", new Object[]{sessionName, oneOffsSrc}));
                            ignoreBackupError = OPatchEnv.proceedWithOperationDefaultNo(buff);
                            if (ignoreBackupError) break block20;
                            throw e3;
                        }
                    }
                }
                if (!OPatchEnv.isNextGen()) {
                    buff = new StringBuffer("ApplySession: back up Oracle Home Inventory comps.xml");
                    OLogger.verbose(this, buff);
                    Path srcPath = WrapperFactory.getNioServiceWrapper().getPath(contentsXMLSrc, new String[0]);
                    Path dstPath = WrapperFactory.getNioServiceWrapper().getPath(contentsXMLDst, new String[0]);
                    if (Files.exists(srcFile, new LinkOption[0])) {
                        try {
                            SystemCall.backupFile(srcFile, dstFile);
                        }
                        catch (RuntimeException e4) {
                            OPatchStateManagerFactory.getInstance().setErrorCode(47);
                            OLogger.error("OUI-67083", new Object[]{sessionName, contentsXMLSrc});
                            buff = new StringBuffer(OLogger.getString("OUI-67083", new Object[]{sessionName, contentsXMLSrc}));
                            ignoreBackupError = OPatchEnv.proceedWithOperationDefaultNo(buff);
                            if (ignoreBackupError) break block21;
                            throw e4;
                        }
                    }
                }
            }
        }
        try {
            this.patchObjectBackupRestore(oracleHomePath, sessionName, patchObject);
        }
        catch (RuntimeException e5) {
            OPatchStateManagerFactory.getInstance().setErrorCode(49);
            throw e5;
        }
    }

    private void patchObjectBackupRestore(String oracleHomePath, String sessionName, PatchObject patchObject) throws RuntimeException {
        if (Rules.SystemWrite_continue()) {
            try {
                StringBuffer buff = new StringBuffer("ApplySession: back up files for system restore");
                OLogger.verbose(this, buff);
                buff = new StringBuffer("ApplySession: calling PatchObject::backupForRestore()");
                OLogger.debug(buff);
                patchObject.backupForRestore(oracleHomePath, sessionName);
            }
            catch (RuntimeException e2) {
                StringBuffer buff = new StringBuffer("   PatchObject::backupForRestore() throws RuntimeException");
                OLogger.debug(buff);
                throw e2;
            }
        }
    }

    protected IIPMReadServices wasThisPatchApplied(IIPMReadServices readServices, String oracleHomePath, PatchObject[] pos) throws NoSuchElementException {
        StringBuffer buff = new StringBuffer("NApply: wasThisPatchApplied()");
        OLogger.debug(buff);
        if ((!OPatchEnv.isCUPSupported() || OPatchEnv.isSnowBall()) && Rules.OUIWrite_continue()) {
            try {
                readServices.reloadInventory();
            }
            catch (Exception e2) {
                NoSuchElementException ne = new NoSuchElementException(e2.getMessage());
                ne.initCause(e2);
                ne.setStackTrace(e2.getStackTrace());
                throw ne;
            }
        }
        return readServices;
    }

    private IIPMReadServices wasThisPatchApplied(IIPMReadServices readServices, String oracleHomePath, String patchLocation) throws NoSuchElementException {
        StringBuffer buff = new StringBuffer("wasThisPatchApplied()");
        OLogger.debug(buff);
        if ((!OPatchEnv.isCUPSupported() || OPatchEnv.isSnowBall()) && Rules.OUIWrite_continue()) {
            try {
                readServices.reloadInventory();
            }
            catch (Exception e2) {
                NoSuchElementException ne = new NoSuchElementException(e2.getMessage());
                ne.initCause(e2);
                ne.setStackTrace(e2.getStackTrace());
                throw ne;
            }
        }
        try {
            ApplySession.verify(readServices, oracleHomePath, patchLocation);
        }
        catch (Exception e3) {
            StringBuffer msg = new StringBuffer("Verification of patch failed: ");
            msg.append(e3.getMessage());
            NoSuchElementException ne = new NoSuchElementException(msg.toString());
            ne.initCause(e3);
            ne.setStackTrace(e3.getStackTrace());
            throw ne;
        }
        return readServices;
    }

    public static boolean verify(String oracleHomePath, String patchLoc) throws IOException, Exception {
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        try {
            if (!readServices.isInventoryLoaded()) {
                readServices.loadInventory(oracleHomePath);
            }
        }
        catch (Throwable t) {
            RuntimeException e2 = new RuntimeException(t.getMessage(), t);
            e2.setStackTrace(t.getStackTrace());
            throw e2;
        }
        return ApplySession.verify(readServices, oracleHomePath, patchLoc);
    }

    public static boolean verify(IIPMReadServices readServices, String oracleHomePath, String patchLoc) throws IOException, Exception {
        boolean patchOK;
        boolean patchFound;
        block32: {
            String patchID;
            PatchObject po;
            StringBuffer buff;
            block31: {
                buff = new StringBuffer("VerifyPatch::verify()");
                OLogger.debug(buff);
                patchFound = false;
                patchOK = false;
                if (OPatchEnv.isOPATCH_SKIP_VERIFY()) {
                    OLogger.warn("OUI-67124", new Object[]{"OPatch skips verification as per user's request."});
                    return true;
                }
                OLogger.println("\nVerifying the update...");
                if (oracleHomePath == null) {
                    buff = new StringBuffer("Path to ORACLE_HOME is null.");
                    throw new IOException(buff.toString());
                }
                if (patchLoc == null) {
                    buff = new StringBuffer("Patch location is null.");
                    throw new IOException(buff.toString());
                }
                Path f2 = WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath, new String[0]);
                if (!Files.exists(f2, new LinkOption[0])) {
                    buff = new StringBuffer("Path to ORACLE_HOME \"");
                    buff.append(oracleHomePath);
                    buff.append("\" does not exist.");
                    throw new IOException(buff.toString());
                }
                f2 = WrapperFactory.getNioServiceWrapper().getPath(patchLoc, new String[0]);
                if (!Files.exists(f2, new LinkOption[0])) {
                    buff = new StringBuffer("Path to Patch location \"");
                    buff.append(patchLoc);
                    buff.append("\" does not exist.");
                    throw new IOException(buff.toString());
                }
                boolean isReport = OPatchEnv.isReport();
                OLogger.log(OLogger.FINE, "Loading the patch from  \"" + patchLoc + "\".");
                po = PatchObjectUtil.loadPatch(patchLoc);
                patchID = po.getPatchID();
                if (!isReport) break block31;
                OLogger.println("Inventory and System verification is performed here.");
                boolean bl = true;
                return bl;
            }
            if (!readServices.isInventoryLoaded()) {
                buff = new StringBuffer("VerifyPatch() was not able to get a Session.");
                OLogger.log(OLogger.SEVERE, buff.toString());
                throw new RuntimeException(buff.toString());
            }
            OneOffEntry[] oneOffs = readServices.getAllInstalledPatches();
            for (int i2 = 0; i2 < oneOffs.length; ++i2) {
                OneOffEntry oneOff = oneOffs[i2];
                if (oneOff == null) continue;
                String id = oneOff.getID();
                buff = new StringBuffer("Comparing patch ID ");
                buff.append(patchID);
                buff.append(" against ");
                buff.append(id);
                OLogger.log(OLogger.FINE, buff.toString());
                if (!id.equalsIgnoreCase(patchID)) continue;
                patchFound = true;
                if (!OnlinePatchProcessor.isHybridOnlinePatch(patchLoc) || !oneOff.isOnlinePatch()) break;
                OnlinePatchProcessor.setHybridPatchPart(patchLoc, PatchObject.HybridPatchPart.ONLINE);
                po = PatchObjectUtil.loadPatch(patchLoc);
                po.setOneOffEntryObj(oneOff);
                break;
            }
            if (patchFound) {
                buff = new StringBuffer("Patch ID ");
                buff.append(patchID);
                buff.append(" is registered in Oracle Home inventory.");
                OLogger.log(OLogger.FINE, buff.toString());
                patchFound = false;
                String oneOffLoc = OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, po.getTripletPatchID());
                buff = new StringBuffer("Search for patch meta-data under \"");
                buff.append(oneOffLoc);
                buff.append("\".");
                OLogger.log(OLogger.FINE, buff.toString());
                try {
                    PatchObject tmpP = PatchObjectUtil.loadPatch(oracleHomePath, po.getTripletPatchID());
                    buff = new StringBuffer("Successfully loaded the patchobject from \"");
                    buff.append(oneOffLoc);
                    buff.append("\", so patch is found properly, its ID is ");
                    buff.append(tmpP.getPatchID());
                    OLogger.debug(buff);
                    patchFound = true;
                }
                catch (Exception e2) {
                    patchFound = false;
                }
                if (patchFound) {
                    buff = new StringBuffer("Inventory check OK: Patch ID ");
                    buff.append(patchID);
                    buff.append(" is registered in Oracle Home inventory with proper meta-data.");
                    OLogger.printlnOnLog(buff.toString());
                } else {
                    buff = new StringBuffer("Inventory check failed: Patch ID ");
                    buff.append(patchID);
                    buff.append(" is registered in Oracle Home inventory but OPatch can't load its meta-data.");
                    OLogger.warn("OUI-67124", new Object[]{buff.toString()});
                }
            } else {
                buff = new StringBuffer("Inventory check failed: Patch ID ");
                buff.append(patchID);
                buff.append(" is NOT registered in Oracle Home inventory.");
                OLogger.warn("OUI-67124", new Object[]{buff.toString()});
            }
            HashSet<PatchComponent> compsToVerify = new HashSet<PatchComponent>();
            OLogger.log(OLogger.FINE, "Add all required components and their actions to list to be verified. Optional components not present in Oracle Home will be filtered out.");
            Map<PatchComponent, PatchComponentCheckResult> analyzedPCs = readServices.analyzePatchComponents(po, OPatchEnv.isNRollback());
            for (Map.Entry<PatchComponent, PatchComponentCheckResult> entry : analyzedPCs.entrySet()) {
                PatchComponent pc = entry.getKey();
                Result pcCheckResult = entry.getValue().getResult();
                if (!pc.isRequired() && !pcCheckResult.isProcessComponent()) continue;
                compsToVerify.add(pc);
            }
            ArrayList<CopyAction> copyActionToVerify = new ArrayList<CopyAction>();
            ArrayList<JarAction> jarActionToVerify = new ArrayList<JarAction>();
            ArrayList<DeleteJarAction> deleteJarActionToVerify = new ArrayList<DeleteJarAction>();
            ArrayList<ArchiveAction> arActionToVerify = new ArrayList<ArchiveAction>();
            ArrayList<Verifiable> pluginActionToVerify = new ArrayList<Verifiable>();
            ArrayList<MakeAction> makeActionToVerify = new ArrayList<MakeAction>();
            boolean isRemovable = COMPOSITE_FILTEREDPATCHACTIONS.size() > 0;
            for (PatchComponent pc : compsToVerify) {
                int j2;
                LinkedList cList = pc.getCopyList();
                LinkedList jList = pc.getJarList();
                LinkedList djList = pc.getDeleteJarList();
                LinkedList aList = pc.getArchiveList();
                LinkedList mList = pc.getMakeList();
                LinkedList pList = pc.getPluginList();
                for (j2 = 0; j2 < cList.size(); ++j2) {
                    CopyAction ca = (CopyAction)cList.get(j2);
                    if (isRemovable && COMPOSITE_FILTEREDPATCHACTIONS.contains(ca)) continue;
                    copyActionToVerify.add(ca);
                }
                for (j2 = 0; j2 < jList.size(); ++j2) {
                    JarAction ja = (JarAction)jList.get(j2);
                    if (isRemovable && COMPOSITE_FILTEREDPATCHACTIONS.contains(ja)) continue;
                    jarActionToVerify.add(ja);
                }
                for (j2 = 0; j2 < djList.size(); ++j2) {
                    DeleteJarAction dja = (DeleteJarAction)jList.get(j2);
                    if (isRemovable && COMPOSITE_FILTEREDPATCHACTIONS.contains(dja)) continue;
                    deleteJarActionToVerify.add(dja);
                }
                for (j2 = 0; j2 < aList.size(); ++j2) {
                    ArchiveAction aa = (ArchiveAction)aList.get(j2);
                    if (isRemovable && COMPOSITE_FILTEREDPATCHACTIONS.contains(aa)) continue;
                    arActionToVerify.add(aa);
                }
                for (j2 = 0; j2 < pList.size(); ++j2) {
                    if (!(pList.get(j2) instanceof Verifiable)) continue;
                    Verifiable va = (Verifiable)pList.get(j2);
                    pluginActionToVerify.add(va);
                }
                for (j2 = 0; j2 < mList.size(); ++j2) {
                    MakeAction ma = (MakeAction)mList.get(j2);
                    if (isRemovable && COMPOSITE_FILTEREDPATCHACTIONS.contains(ma)) continue;
                    makeActionToVerify.add(ma);
                }
            }
            patchOK = OPatchSessionHelper.verifyPatchAction(oracleHomePath, patchLoc, copyActionToVerify, jarActionToVerify, arActionToVerify, pluginActionToVerify, makeActionToVerify, deleteJarActionToVerify, readServices);
            if (!patchOK) {
                buff = new StringBuffer("Files check failed: Some files under ORACLE_HOME are not patched. ");
                buff.append("Please see log file for details.");
                OLogger.warn("OUI-67124", new Object[]{buff.toString()});
            } else {
                buff = new StringBuffer("Files check OK: Files from Patch ID ");
                buff.append(patchID);
                buff.append(" are present in Oracle Home.");
                OLogger.printlnOnLog(buff.toString());
            }
            if (!patchFound || !patchOK) break block32;
            buff = new StringBuffer("Patch is found in the inventory and ");
            buff.append("of the patch are present in the system.");
            OLogger.debug(buff);
            boolean bl = true;
            return bl;
        }
        StringBuffer msg = new StringBuffer();
        if (!patchFound) {
            msg.append("Patch is not found in the Inventory. ");
        }
        if (!patchOK) {
            msg.append("Files are not updated completely.");
        }
        RuntimeException re = new RuntimeException(msg.toString());
        throw re;
    }

    protected OneOffEntry[] processConflict(String oracleHomePath, PatchObject patchObject) throws PrereqFailedException, ExitOPatchException {
        int i2;
        StringBuffer buff = new StringBuffer("ApplySession::processConflict()");
        OLogger.debug(buff);
        String patchType1 = "";
        String patchType2 = "";
        boolean isMiniPatchSet = patchObject.getPatchInventory().isMiniPatchSet();
        int modelCode = PatchingModel.returnModelCode(oracleHomePath);
        if (isMiniPatchSet) {
            patchType2 = patchType1 = "Patch Set Update";
        } else {
            patchType1 = "Interim patch";
            patchType2 = "Patch";
        }
        String patchID = patchObject.getPatchID();
        OneOffEntry[] patchToApply = new OneOffEntry[]{patchObject.toOneOffEntry(oracleHomePath)};
        ConflictMatrixOutput interOutput = PrereqAPI.checkConflictAgainstOHWithDetail_backup(oracleHomePath, patchToApply);
        PrereqResult.ExecuteStatus interStatus = interOutput.getResult();
        PrereqSet patchesToBeMerged = new PrereqSet();
        PrereqSet patchesNotNeeded = new PrereqSet();
        PrereqSet patchesThatCanGoNow = new PrereqSet();
        PrereqSet patchesToBeRolledBack = new PrereqSet();
        if (interStatus == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
            Vector detail = interOutput.getResultDetails();
            try {
                ApplySession.processPrereqNotExecuted(detail);
            }
            catch (RuntimeException e2) {
                PrereqFailedException pe = new PrereqFailedException(e2.getMessage(), e2);
                pe.setStackTrace(e2.getStackTrace());
                throw pe;
            }
        } else if (interStatus == PrereqResult.ExecuteStatus.FAILED) {
            patchesToBeMerged = new PrereqSet(interOutput.getListOfPatchesToBeMerged());
            patchesNotNeeded = new PrereqSet(interOutput.getListOfPatchesNotNeeded());
            patchesThatCanGoNow = new PrereqSet(interOutput.getListOfPatchesThatCanGoNow());
            patchesToBeRolledBack = new PrereqSet(interOutput.getListOfPatchesThatNeedToBeRollback());
            if (patchesToBeRolledBack.contains(patchToApply[0])) {
                patchesNotNeeded.add(patchToApply[0]);
            }
            patchesThatCanGoNow = patchesThatCanGoNow.add(patchesToBeMerged.delete(patchesToBeRolledBack));
            if (patchesToBeMerged.contains(patchToApply[0]) && patchesToBeRolledBack.contains(patchToApply[0])) {
                patchesThatCanGoNow.add(patchToApply[0]);
            }
            patchesToBeMerged.delete(patchToApply[0]);
            OLogger.println(interOutput.getConflictDetailsString());
        } else if (interStatus == PrereqResult.ExecuteStatus.PASSED) {
            patchesThatCanGoNow = new PrereqSet(patchToApply);
        }
        boolean needMergeRequest = patchesToBeMerged.size() != 0;
        boolean hasNotNeededPatch = patchesNotNeeded.size() != 0;
        boolean hasCanGoPatches = patchesThatCanGoNow.size() != 0;
        StringBuffer conflictPatches = new StringBuffer();
        StringBuffer subsetPatches = new StringBuffer();
        ConflictMatrixOutput interOutput2 = PrereqAPI.checkConflictAgainstOHWithDetail_backup(oracleHomePath, patchToApply);
        PrereqSet patchesToBeRolledBack2 = new PrereqSet(interOutput2.getListOfPatchesThatNeedToBeRollback());
        CompositePatchObject.isCompositeSubset(interOutput2, patchesToBeRolledBack2.getAllElements(), patchToApply[0], oracleHomePath, "apply");
        if (!hasCanGoPatches && patchesNotNeeded.contains(patchToApply[0])) {
            int ohOneOffs = interOutput.getColumnLength();
            StringBuffer supersetPatches = new StringBuffer();
            for (int i3 = 0; i3 < ohOneOffs; ++i3) {
                if (interOutput.getConflictType(0, i3) != ConflictMatrixOutput.ConflictType.BUG_SUBSET) continue;
                supersetPatches.append(" ");
                supersetPatches.append(interOutput.getColumnPatchID(0, i3));
            }
            OLogger.info("OUI-67072", new Object[]{patchID, supersetPatches.toString(), oracleHomePath});
            OPatchStateManagerFactory.getInstance().setErrorCode(56);
            PrereqFailedException re = new PrereqFailedException("The patch " + patchID + " you are trying to apply is a subset patch of patch(es) [ " + supersetPatches.toString() + " ] registered in Oracle Home.");
            throw re;
        }
        CompositePatchObject.isCompositeAutoRollbackable(patchID, patchesToBeRolledBack.getAllElements(), patchesNotNeeded.getAllElements(), oracleHomePath);
        if (needMergeRequest) {
            conflictPatches = new StringBuffer("");
            for (i2 = 0; i2 < patchesToBeMerged.size(); ++i2) {
                conflictPatches.append(" ");
                conflictPatches.append(patchesToBeMerged.getElement(i2).getID());
            }
            if (patchObject.getPatchType().equals("snowball") && modelCode == 2) {
                OLogger.warn("OUI-67627", new Object[]{patchID, conflictPatches.toString()});
            } else {
                OLogger.onlyLogInfo("OUI-67619", new Object[]{patchID, conflictPatches.toString(), oracleHomePath, patchType1});
                OPatchEnv.setOneOffToRoll(patchesToBeMerged.getAllElements());
            }
        }
        if (hasNotNeededPatch) {
            subsetPatches = new StringBuffer("");
            for (i2 = 0; i2 < patchesNotNeeded.size(); ++i2) {
                subsetPatches.append(" ");
                subsetPatches.append(patchesNotNeeded.getElement(i2).getID());
            }
            if (Rules.shouldSwitchONAutoRollback(oracleHomePath)) {
                OLogger.info("OUI-67620", new Object[]{patchID, subsetPatches.toString(), oracleHomePath, patchType1});
            } else {
                OLogger.info("OUI-67626", new Object[]{patchID, subsetPatches.toString(), oracleHomePath, patchType1});
            }
        }
        if (ApplySession.shouldConsiderNoBugSuperSet(patchesNotNeeded.getAllElements(), patchesToBeRolledBack.getAllElements()) && Rules.shouldErrorOnBugSuperset()) {
            OPatchStateManagerFactory.getInstance().setErrorCode(57);
            String msg = OLogger.getString("OUI-67078", new Object[]{patchID, subsetPatches.toString(), oracleHomePath});
            throw new ExitOPatchException(msg);
        }
        if (needMergeRequest) {
            if (OPatchSessionHelper.hasHotPatch(new PrereqSet(interOutput.getListOfPatchesToBeMerged()))) {
                OPatchStateManagerFactory.getInstance().setErrorCode(58);
                OLogger.warn("OUI-67281", new Object[]{OPatchSessionHelper.getHotPatchIDs(new PrereqSet(interOutput.getListOfPatchesToBeMerged()))});
                PrereqFailedException re = new PrereqFailedException("Some Online Patch(es) has conflicts.");
                throw re;
            }
            StringBuffer msg = new StringBuffer("");
            msg = needMergeRequest && hasNotNeededPatch ? (patchObject.getPatchType().equals("snowball") && modelCode == 2 ? new StringBuffer(OLogger.getString("OUI-67628", new Object[]{patchID, subsetPatches.toString(), conflictPatches.toString()})) : new StringBuffer(OLogger.getString("OUI-67618", new Object[]{patchID, subsetPatches.toString(), conflictPatches.toString(), patchType2}))) : (patchObject.getPatchType().equals("snowball") && modelCode == 2 ? new StringBuffer(OLogger.getString("OUI-67627", new Object[]{patchID, conflictPatches.toString()})) : new StringBuffer(OLogger.getString("OUI-67617", new Object[]{patchID, conflictPatches.toString(), patchType2})));
            if (Rules.shouldPromptInCaseOfConflict(oracleHomePath)) {
                if (patchObject.getPatchType().equals("snowball")) {
                    OPatchStateManagerFactory.getInstance().setErrorCode(59);
                    buff = new StringBuffer(OLogger.getString("OUI-67091", new Object[]{sessionName}));
                    throw new PrereqFailedException(buff.toString());
                }
                if (isMiniPatchSet) {
                    if (!OPatchEnv.proceedWithOperationDefaultYes(msg)) {
                        OPatchStateManagerFactory.getInstance().setErrorCode(60);
                        buff = new StringBuffer(OLogger.getString("OUI-67091", new Object[]{sessionName}));
                        throw new PrereqFailedException(buff.toString());
                    }
                } else if (!OPatchEnv.proceedWithOperationDefaultNo(msg)) {
                    OPatchStateManagerFactory.getInstance().setErrorCode(61);
                    buff = new StringBuffer(OLogger.getString("OUI-67091", new Object[]{sessionName}));
                    throw new PrereqFailedException(buff.toString());
                }
            } else if (patchObject.getPatchType().equals("singleton")) {
                if (!OPatchEnv.proceedWithOperationDefaultYes(msg)) {
                    OPatchStateManagerFactory.getInstance().setErrorCode(62);
                    buff = new StringBuffer(OLogger.getString("OUI-67091", new Object[]{sessionName}));
                    throw new PrereqFailedException(buff.toString());
                }
            } else {
                if (patchObject.getPatchType().equals("snowball")) {
                    OPatchStateManagerFactory.getInstance().setErrorCode(63);
                    buff = new StringBuffer(OLogger.getString("OUI-67091", new Object[]{sessionName}));
                    throw new PrereqFailedException(buff.toString());
                }
                if (!OPatchEnv.proceedWithOperationDefaultYes(msg)) {
                    OPatchStateManagerFactory.getInstance().setErrorCode(62);
                    buff = new StringBuffer(OLogger.getString("OUI-67091", new Object[]{sessionName}));
                    throw new PrereqFailedException(buff.toString());
                }
            }
        } else if (hasNotNeededPatch) {
            if (OPatchSessionHelper.hasHotPatch(patchesThatCanGoNow) && OPatchSessionHelper.hasNonHotPatch(patchesToBeRolledBack)) {
                OPatchStateManagerFactory.getInstance().setErrorCode(64);
                PrereqFailedException re = new PrereqFailedException(OLogger.getString("OUI-67280", new Object[]{OPatchSessionHelper.getPatchIDs(patchesToBeRolledBack), OPatchSessionHelper.getHotPatchIDs(patchesThatCanGoNow)}));
                throw re;
            }
            if (OPatchSessionHelper.hasNonHotPatch(patchesThatCanGoNow) && OPatchSessionHelper.hasHotPatch(patchesToBeRolledBack)) {
                OPatchStateManagerFactory.getInstance().setErrorCode(65);
                String msg = OLogger.getString("OUI-67279", new Object[]{OPatchSessionHelper.getHotPatchIDs(patchesToBeRolledBack), OPatchSessionHelper.getPatchIDs(patchesThatCanGoNow)});
                PrereqFailedException re = new PrereqFailedException(msg);
                throw re;
            }
        }
        if (!Rules.shouldSwitchONAutoRollback(oracleHomePath)) {
            boolean isPatchApplyPresent = false;
            if (patchesToBeRolledBack.contains(patchToApply[0]) && patchesNotNeeded.contains(patchToApply[0])) {
                isPatchApplyPresent = true;
            }
            patchesToBeRolledBack = patchesToBeRolledBack.delete(patchesNotNeeded);
            if (isPatchApplyPresent) {
                patchesToBeRolledBack.add(patchToApply[0]);
            }
        } else if (patchesToBeRolledBack.size() != 0) {
            OLogger.info("OUI-67013");
        }
        OPatchEnv.setConflictPatches(patchesToBeRolledBack.getAllElements());
        return patchesToBeRolledBack.getAllElements();
    }

    protected static boolean shouldConsiderNoBugSuperSet(OneOffEntry[] notNeededOneOffs, OneOffEntry[] autoRollbackOneOffs) {
        for (int i2 = 0; i2 < autoRollbackOneOffs.length; ++i2) {
            String autoRollbackID = autoRollbackOneOffs[i2].getID();
            for (int j2 = 0; j2 < notNeededOneOffs.length; ++j2) {
                if (!autoRollbackID.equals(notNeededOneOffs[j2].getID())) continue;
                return true;
            }
        }
        return false;
    }

    protected static void processPrereqNotExecuted(Vector detail) throws RuntimeException {
        int i2;
        StringBuffer buff = new StringBuffer("ApplySession::processPrereqNotExecuted()");
        OLogger.debug(buff);
        if (detail == null || detail.size() == 0) {
            buff = new StringBuffer("Prerequisite API is not executed but no detail is available.");
            OLogger.log(OLogger.SEVERE, buff.toString());
            throw new RuntimeException(buff.toString());
        }
        ArrayList<String> list = new ArrayList<String>();
        for (i2 = 0; i2 < detail.size(); ++i2) {
            Object obj = detail.get(i2);
            if (obj instanceof Exception) {
                Exception e2 = (Exception)obj;
                buff = new StringBuffer("An exception occured when calling Pre-req. API. Detail: ");
                buff.append(e2.getMessage());
                OLogger.log(OLogger.SEVERE, buff.toString());
                RuntimeException re = new RuntimeException(e2.getMessage());
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
            if (!(obj instanceof String)) continue;
            String s = (String)obj;
            list.add(s);
        }
        buff = new StringBuffer("Pre-req. API didn't execute.  Detail: ");
        for (i2 = 0; i2 < list.size(); ++i2) {
            String s = (String)list.get(i2);
            buff.append(s);
            buff.append(", ");
        }
        OLogger.log(OLogger.SEVERE, buff.toString());
        throw new RuntimeException(buff.toString());
    }

    protected OPatchSessionHelper.LocalInfo processLocal(String patchLocation, String oracleHomePath, PatchObject patchObject, boolean local, boolean minDowntime, boolean allNode, boolean silent, boolean createInterimInventoryFile) throws RuntimeException, Error {
        boolean shouldPromptForStartup;
        RuntimeException re2;
        Error er;
        String tmpS;
        int patchingModel;
        String msg = null;
        StringBuffer buff = new StringBuffer("ApplySession::processLocal()");
        OLogger.debug(buff);
        buff = new StringBuffer("OPatchEnv:\n");
        buff.append(OPatchEnv.getToString());
        OLogger.debug(buff);
        String patchID = "";
        String cookedPatchID = "";
        OneOffEntry[] oneOffsRollback = new OneOffEntry[]{};
        PatchObject[] arp = new PatchObject[]{};
        boolean invRead = Rules.OUIRead_continue();
        boolean invWrite = Rules.OUIWrite_continue();
        boolean systemWrite = Rules.SystemWrite_continue();
        boolean needRollback = false;
        boolean isShutdown = true;
        Rac rac = OPatchExternalFactory.getRac(oracleHomePath);
        if (calledFromUtil) {
            OPatchEnv.setPatchloc(patchLocation);
        }
        Rac.RacType racType = null;
        Rules.RacPatchOrder order = null;
        String[] remoteNodes = new String[]{};
        String localNode = "local system";
        boolean rolling = false;
        RacProcessor.MinDowntimeNodeSelection selects = null;
        if (!calledFromUtil) {
            OPatchSession.setSessionPatchObject(patchObject);
        }
        if ((patchingModel = PatchingModel.returnModelCode(oracleHomePath)) == 2) {
            OLogger.justlog(OLogger.INFO, "OPatch does not run init, pre and post script for snowball patch.");
        }
        MethodTrackerObj preReqTrackerObj = MethodTracker.getTracker(TrackerTags.PREREQ);
        preReqTrackerObj.start();
        try {
            boolean ok;
            if (!calledFromUtil) {
                OLogger.println(OLogger.getString("OUI-67910"));
                OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Running prerequisite checks");
                PatchObject[] objArr = new PatchObject[]{patchObject};
                OPatchSessionHelper.getWlsPatchProfile(objArr);
            }
            patchID = patchObject.getPatchID();
            cookedPatchID = patchObject.getCookedPatchID();
            isShutdown = patchObject.isShutdown();
            rolling = patchObject.isRolling();
            if (!calledFromUtil) {
                OPatchSessionHelper.performPatchApplicableProductPrereq(oracleHomePath, patchObject);
            }
            this.setupPatchStorage(oracleHomePath, cookedPatchID);
            if (patchObject.isSqlRelatedActions() && !(ok = OPatchEnv.setupSqlPropertyFile(oracleHomePath, cookedPatchID))) {
                buff = new StringBuffer("ApplySession::processLocal()->Problem in setting up sql property file");
                OLogger.debug(buff);
            }
            if (patchObject.isOnlinePatch() && !(ok = OPatchEnv.setupOnlinePropertyFile(oracleHomePath))) {
                OPatchStateManagerFactory.getInstance().setErrorCode(21);
                throw new RuntimeException("Unable to setup online patch properties file.");
            }
            if (invRead && !IOC.INSTANCE.isInventoryConverted()) {
                OLogger.debug(new StringBuffer("ApplySession::processLocal() load the inventory"));
                this.rwServices = this.loadInventory(oracleHomePath);
                if (!OPatchEnv.isFATwoPhase()) {
                    HashMap copyHash = OPatchSessionHelper.getCopyActionVer(this.rwServices);
                    CopyAction.setHashMap(copyHash);
                    CopyAction.setHashMapEnv(copyHash);
                }
                if (!calledFromUtil) {
                    try {
                        OPatchSessionHelper.validateOCMOption(oracleHomePath, this.rwServices);
                    }
                    catch (OCMException e2) {
                        OPatchStateManagerFactory.getInstance().setErrorCode(25);
                        throw e2;
                    }
                }
                OPatchEnv.setDesiredHome(this.rwServices.isDesiredHome());
                boolean islocal = OPatchEnv.isLocal();
                OPatchEnv.setLocal(false);
                Rac.RacType tempRacType = rac.getInstance(this.rwServices);
                localNode = tempRacType.getLocalNode();
                OPatchEnv.setLocal(islocal);
                racType = rac.getInstance(this.rwServices, true);
                if (racType != Rac.RacType.NO_RAC) {
                    OPatchStateManagerFactory.getInstance().setCurrentState(new RacTypeDetectState().getStateName());
                }
                order = Rules.getRacPatchOrder(racType, local, rolling, minDowntime, allNode, silent);
                remoteNodes = racType.getRemoteNodes();
                OPatchEnv.setLocalNode(localNode);
                OPatchStateManagerFactory.getInstance().setCurrentState(new DiscoverOHState().getStateName(), false);
            } else {
                OLogger.debug(new StringBuffer("ApplySession::processLocal(): no inventory load, no comp. pre-req. check, no conflict check."));
                buff = new StringBuffer("ApplySession::processLocal(): getting racType with null homeInfo...:\n");
                OLogger.debug(buff);
                racType = rac.getInstance(null);
                buff = new StringBuffer(racType.getDetail());
                OLogger.debug(buff);
            }
            if (!calledFromUtil) {
                ApplySession.validateConnectStringNodes(localNode, remoteNodes);
            }
            if (!calledFromUtil) {
                int rbIter;
                PatchObject[] applyPatch = new PatchObject[]{patchObject};
                try {
                    OPatchSessionHelper.checkIfSidAddition(oracleHomePath, applyPatch);
                }
                catch (RuntimeException e3) {
                    OPatchStateManagerFactory.getInstance().setErrorCode(26);
                    PrereqFailedException pre = new PrereqFailedException(e3.getMessage(), e3);
                    pre.setStackTrace(e3.getStackTrace());
                    throw pre;
                }
                OPatchStateManagerFactory.getInstance().setCurrentState("Init-script processing");
                buff = new StringBuffer("   Process InitReadMeAction() ");
                OLogger.debug(buff);
                patchObject.getInitReadMeAction().process();
                InitScriptAction initScript = patchObject.getInitScriptAction();
                StringBuffer tmpSb = new StringBuffer("-apply");
                tmpSb.append(" ");
                tmpSb.append(patchID);
                tmpSb.append(" ");
                tmpSb.append(OPatchEnv.getInitopt());
                OLogger.justlog(OLogger.INFO, "Processing initScript " + initScript.getActionName());
                int initReturnVal = initScript.process(tmpSb.toString(), "apply", patchID);
                OLogger.justlog(OLogger.INFO, "Init script " + initScript.getActionName() + " processed.");
                if (initReturnVal != 0) {
                    OLogger.error("OUI-67133", new Object[]{"INIT", Integer.toString(initReturnVal)});
                    RuntimeException preRe = new RuntimeException("Init Script failed.");
                    throw preRe;
                }
                try {
                    OPatchStateManagerFactory.getInstance().setCurrentState("Prerequisite for apply");
                    OPatchSessionHelper.runApplyPrereqs(oracleHomePath, new OneOffEntry[]{patchObject.toOneOffEntry(oracleHomePath)}, applyPatch, new String[]{patchLocation});
                    OPatchStateManagerFactory.getInstance().setCurrentState("Patch conflict detection for apply patch");
                    oneOffsRollback = this.processConflict(oracleHomePath, patchObject);
                }
                catch (ExitOPatchException e4) {
                    throw e4;
                }
                catch (PrereqFailedException e5) {
                    throw e5;
                }
                catch (Throwable t) {
                    PrereqFailedException pe = new PrereqFailedException(t);
                    pe.setStackTrace(t.getStackTrace());
                    throw pe;
                }
                if (oneOffsRollback.length > 0) {
                    needRollback = true;
                    OPatchEnv.setNeedToRollback(true);
                    OPatchEnv.setAutoRollbackList(oneOffsRollback);
                }
                OPatchStateManagerFactory.getInstance().printFollowingStates(oracleHomePath, new PatchObject[]{patchObject}, this.rwServices);
                OPatchStateManagerFactory.getInstance().setCurrentState("Prerequisite for auto rollback");
                PatchObject[] apPatchObjects = new PatchObject[1];
                PatchObject[] rbPatchObjects = new PatchObject[oneOffsRollback.length];
                OneOffEntry[] apOneOffs = new OneOffEntry[1];
                String[] apPatchLocs = new String[1];
                apPatchObjects[0] = patchObject;
                apOneOffs[0] = patchObject.toOneOffEntry(oracleHomePath);
                apPatchLocs[0] = patchLocation;
                for (rbIter = 0; rbIter < oneOffsRollback.length; ++rbIter) {
                    String r_patchID = oneOffsRollback[rbIter].getID();
                    rbPatchObjects[rbIter] = PatchObjectUtil.loadPatch(oracleHomePath, r_patchID);
                    rbPatchObjects[rbIter].setOneOffEntryObj(oneOffsRollback[rbIter]);
                }
                OPatchEnv.setArbPatchObjectsForRLib(rbPatchObjects);
                for (rbIter = 0; rbIter < oneOffsRollback.length; ++rbIter) {
                    PatchObject po = rbPatchObjects[rbIter];
                    String rollbackCookedPatchID = po.getCookedPatchID();
                    String prevAppliedPatchLocation = OPatchEnv.getPatchBackupDirectoryPath(oracleHomePath, rollbackCookedPatchID);
                    String initReadMeLoc = PatchObject.getInitReadMeFilePath(prevAppliedPatchLocation);
                    String initScriptLoc = PatchObject.getInitScriptFilePath(prevAppliedPatchLocation);
                    po.setInitReadMeAction(new InitReadMeAction(initReadMeLoc));
                    po.setInitScriptAction(new InitScriptAction(initScriptLoc));
                    po.getInitReadMeAction().process();
                    InitScriptAction rollbackInitScript = po.getInitScriptAction();
                    tmpSb = new StringBuffer("-rollback");
                    tmpSb.append(" ");
                    tmpSb.append(po.getPatchID());
                    tmpSb.append(" ");
                    tmpSb.append(OPatchEnv.getInitopt());
                    OLogger.justlog(OLogger.INFO, "Start the Rollback init script for Patch \"" + po.getPatchID());
                    initReturnVal = rollbackInitScript.process(tmpSb.toString(), "rollback", po.getPatchID());
                    OLogger.justlog(OLogger.INFO, "Finished the Rollback init script for Patch \"" + po.getPatchID());
                    if (initReturnVal == 0) continue;
                    OLogger.error("OUI-67133", new Object[]{"INIT", Integer.toString(initReturnVal)});
                    RuntimeException preRe = new RuntimeException("Init Script failed.");
                    throw preRe;
                }
                buff = new StringBuffer("Run all the prereqs related to apply.");
                OLogger.debug(buff);
                OPatchSessionHelper.runAutoRollbackPrereqs(oracleHomePath, oneOffsRollback, rbPatchObjects, apOneOffs);
            } else {
                buff = new StringBuffer("ApplySession::processLocal() component pre-req. checks");
                OLogger.debug(buff);
                if (!IOC.INSTANCE.isInventoryConverted()) {
                    this.rwServices = this.loadInventory(oracleHomePath);
                    patchObject = ApplySession.componentPrereqCheck(this.rwServices, patchObject);
                } else {
                    patchObject = ApplySession.componentPrereqCheckIOC(oracleHomePath, patchObject);
                }
                buff = new StringBuffer("Getting the autoRollback list from Utils");
                OLogger.debug(buff);
                OneOffEntry[] arOneOffs = UtilSession.getAutoRollbackList();
                if (arOneOffs != null && arOneOffs.length != 0) {
                    needRollback = true;
                    oneOffsRollback = arOneOffs;
                }
                if (!IOC.INSTANCE.isInventoryConverted()) {
                    CompositePatchObject.isCompositeAutoRollbackable(patchID, oneOffsRollback, oracleHomePath);
                }
            }
            OPatchSessionHelper.constructJarActionTree(patchObject, oracleHomePath, COMPOSITE_FILTEREDPATCHACTIONS);
            OPatchSessionHelper.clubArchiveActions(patchObject, COMPOSITE_FILTEREDPATCHACTIONS);
        }
        catch (PrereqFailedException e6) {
            throw e6;
        }
        catch (ExitOPatchException e7) {
            throw e7;
        }
        catch (UnsupportedOperationException e8) {
            buff = new StringBuffer("ApplySession failed to prepare the system. ");
            msg = e8.getMessage();
            if (msg != null) {
                buff.append(msg);
            }
            buff.append("\n");
            buff.append("OPatch detects Platform ID ");
            int aruID = -1;
            try {
                aruID = !IOC.INSTANCE.isInventoryConverted() ? PatchObjectUtil.getARU_ID(oracleHomePath, this.rwServices) : IOC.INSTANCE.getPlatformId();
            }
            catch (Throwable t) {
                buff.append("(cannot get ID)");
            }
            buff.append(aruID);
            buff.append(" while this patch supports the following platforms: [ ");
            Platform[] ps = patchObject.getPlatforms();
            for (int i2 = 0; i2 < ps.length; ++i2) {
                Platform p2 = ps[i2];
                String id = p2.getID();
                String desc = p2.getDesc();
                buff.append(id);
                buff.append(": ");
                buff.append(desc);
                buff.append(", ");
            }
            buff.append(" ]");
            OLogger.debug(buff);
            RuntimeException re1 = new RuntimeException(buff.toString(), e8);
            re1.setStackTrace(e8.getStackTrace());
            throw re1;
        }
        catch (Throwable t) {
            buff = new StringBuffer("ApplySession failed to prepare the system. ");
            msg = t.getMessage();
            if (msg != null) {
                buff.append(msg);
            } else {
                buff.append(" No detail available.");
            }
            OLogger.debug(buff);
            RuntimeException re22 = new RuntimeException(buff.toString(), t);
            re22.setStackTrace(t.getStackTrace());
            throw re22;
        }
        finally {
            preReqTrackerObj.end();
        }
        try {
            BackupFailureException b1;
            boolean shouldPromptForShutdown;
            if (!calledFromUtil && !IOC.INSTANCE.isInventoryConverted()) {
                OLogger.printlnOnConsole(OLogger.getString("OUI-67911"));
                OLogger.justlog(OLogger.INFO, "[OPSR-TIME] " + OLogger.getString("OUI-67911"));
                try {
                    OPatchSessionHelper.processOCM(this.rwServices, oracleHomePath);
                }
                catch (OCMException excep) {
                    throw excep;
                }
                catch (Exception e9) {
                    // empty catch block
                }
            }
            if (shouldPromptForShutdown = patchObject.shouldPromptForShutdown()) {
                buff = new StringBuffer("ApplySession: processes shutdown logics.");
                OLogger.debug(buff);
                selects = RacProcessor.shutDownLogicsForProcessLocal(sessionName, oracleHomePath, racType, order, localNode, remoteNodes, isShutdown, patchObject.getShutdownMsg());
            } else {
                buff = new StringBuffer("ApplySession: skips shutdown logics ");
                buff.append("per PatchObject's request or Oracle Home is Stand Alone Home");
                OLogger.debug(buff);
                String[] firstSet = new String[]{};
                String[] leftNodes = new String[]{};
                selects = new RacProcessor.MinDowntimeNodeSelection(firstSet, leftNodes);
            }
            if (systemWrite || invWrite) {
                String[] patchIDs = new String[]{patchID};
                String[] triggeredPatchIDs = new String[oneOffsRollback.length];
                for (int i3 = 0; i3 < oneOffsRollback.length; ++i3) {
                    triggeredPatchIDs[i3] = oneOffsRollback[i3].getID();
                }
                if (PatchingModel.returnModelCode(OPatchEnv.getOracleHome()) != 2) {
                    OPatchSessionHelper.createSessionProperties(oracleHomePath, this.getSessionName(), patchObject.getCookedPatchID(), patchIDs, triggeredPatchIDs);
                }
            }
            if (systemWrite) {
                OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Saving patch " + patchObject.getPatchID() + " in patch storage");
                if (PatchingModel.returnModelCode(OPatchEnv.getOracleHome()) != 2) {
                    this.saveOriginalPatch(oracleHomePath, cookedPatchID, patchLocation);
                }
                OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Finished saving patch " + patchObject.getPatchID() + " to patch storage");
            }
            OPatchStateManagerFactory.getInstance().setCurrentState("Back up for restore");
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Backing up patch " + patchID + " for restore");
            if (!calledFromUtil) {
                OLogger.println(OLogger.getString("OUI-67912"));
            }
            if (!calledFromUtil || patchObject.isSqlRelatedActions()) {
                try {
                    this.backupPatchActionsAndCreateRestoreFile(oracleHomePath, patchObject);
                }
                catch (Throwable t) {
                    b1 = new BackupFailureException("Backup for restore failed. No Actions", t.getCause());
                    b1.setStackTrace(t.getStackTrace());
                    b1.setRestoreFailure();
                    throw b1;
                }
                OPatchSessionHelper.setupRLibBackupDir(oracleHomePath, patchObject.getCookedPatchID());
            }
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Finished backing up patch " + patchID + " for restore");
            if (createInterimInventoryFile) {
                String sInterim = OPatchEnv.getInterimInventoryFileLoc(oracleHomePath);
                String rInterim = OPatchEnv.getRecordInventoryFileLoc(oracleHomePath);
                OLogger.printlnOnLog(OLogger.INFO, "******* create file " + sInterim);
                Path fInterim = null;
                fInterim = WrapperFactory.getNioServiceWrapper().getPath(sInterim, new String[0]);
                Files.deleteIfExists(fInterim);
                Path frInterim = null;
                frInterim = WrapperFactory.getNioServiceWrapper().getPath(rInterim, new String[0]);
                Files.deleteIfExists(frInterim);
                OutputStreamWriter fw = null;
                BufferedWriter interimWrite = null;
                try {
                    if (PatchingModel.returnModelCode(OPatchEnv.getOracleHome()) != 2) {
                        if (!IOC.INSTANCE.isInventoryConverted()) {
                            OPatchSessionHelper.writeRecordedEntries(fInterim, "apply", this.rwServices);
                            OPatchSessionHelper.writeRecordedEntries(frInterim, "apply", this.rwServices);
                        }
                        interimWrite = Files.newBufferedWriter(frInterim, Charset.forName("UTF-8"), new OpenOption[0]);
                        String comment = "# apply: the patch to be applied.\n";
                        interimWrite.write(comment);
                        StringBuffer line = new StringBuffer();
                        line.append(patchID).append(":apply:");
                        Bug[] bugs = patchObject.getBugsToFix();
                        for (int j2 = 0; j2 < bugs.length; ++j2) {
                            String bID = bugs[j2].getBugID();
                            line.append(bID);
                            if (j2 >= bugs.length - 1) continue;
                            line.append(",");
                        }
                        line.append("\n");
                        interimWrite.write(line.toString());
                        interimWrite.flush();
                        comment = "# apply: list of patches to be auto-rolled back.\n";
                        interimWrite.write(comment);
                        for (int i4 = 0; i4 < oneOffsRollback.length; ++i4) {
                            line = new StringBuffer();
                            OneOffEntry po = oneOffsRollback[i4];
                            String id = po.getID();
                            line.append(id).append(":rollback:");
                            String[] sBugs = po.getBugIDsFixed();
                            for (int j3 = 0; j3 < sBugs.length; ++j3) {
                                String bID = sBugs[j3];
                                line.append(bID);
                                if (j3 >= sBugs.length - 1) continue;
                                line.append(",");
                            }
                            line.append("\n");
                            interimWrite.write(line.toString());
                            interimWrite.flush();
                        }
                        interimWrite.close();
                        fw.close();
                    }
                }
                catch (Exception e10) {
                    // empty catch block
                }
            }
            if (needRollback) {
                int i5;
                OPatchStateManagerFactory.getInstance().setCurrentState("Patch conflict resolution for apply patch");
                int len = oneOffsRollback.length;
                this.rolledBackPatcheObjects = new PatchObject[len];
                StringBuffer tmpS2 = new StringBuffer("Following Patches will be rollbacked: ");
                StringBuffer bugList = new StringBuffer();
                for (int i6 = 0; i6 < oneOffsRollback.length; ++i6) {
                    bugList.append(" ");
                    bugList.append(oneOffsRollback[i6].getID());
                }
                tmpS2.append(bugList);
                OLogger.debug(tmpS2);
                if (OPatchEnv.isReport()) {
                    buff = new StringBuffer("\n[Report] The following patches ");
                    buff.append("will be rolled back: ");
                    buff.append(bugList.toString());
                    OLogger.println(buff.toString());
                }
                PatchObject[] r_patchObjectList = new PatchObject[len];
                if (systemWrite) {
                    OPatchEnv.setAutoRollbackBackup(true);
                }
                for (i5 = 0; i5 < len; ++i5) {
                    String r_patchID = oneOffsRollback[i5].getID();
                    PatchObject r_patchObject = PatchObjectUtil.loadPatch(oracleHomePath, r_patchID);
                    r_patchObject.setOneOffEntryObj(oneOffsRollback[i5]);
                    String prevAppliedPatchLocation = OPatchEnv.getPatchBackupDirectoryPath(oracleHomePath, r_patchObject.getCookedPatchID());
                    String preReadMeLoc = PatchObject.getPreReadMeFilePath(prevAppliedPatchLocation);
                    String postReadMeLoc = PatchObject.getPostReadMeFilePath(prevAppliedPatchLocation);
                    String initReadMeLoc = PatchObject.getInitReadMeFilePath(prevAppliedPatchLocation);
                    String preScriptLoc = PatchObject.getPreScriptFilePath(prevAppliedPatchLocation);
                    String postScriptLoc = PatchObject.getPostScriptFilePath(prevAppliedPatchLocation);
                    String initScriptLoc = PatchObject.getInitScriptFilePath(prevAppliedPatchLocation);
                    r_patchObject.setPreReadMeAction(new PreReadMeAction(preReadMeLoc));
                    r_patchObject.setPostReadMeAction(new PostReadMeAction(postReadMeLoc));
                    r_patchObject.setInitReadMeAction(new InitReadMeAction(initReadMeLoc));
                    r_patchObject.setPreScriptAction(new PreScriptAction(preScriptLoc));
                    r_patchObject.setPostScriptAction(new PostScriptAction(postScriptLoc));
                    r_patchObject.setInitScriptAction(new InitScriptAction(initScriptLoc));
                    if (calledFromUtil) {
                        r_patchObject.disableFuserCheck();
                        r_patchObject.disablePromptForShutdown();
                        r_patchObject.disablePromptForStartup();
                        r_patchObject.disableRestoreFileCreation();
                        r_patchObject.disableSystemCommandCheck();
                    }
                    r_patchObjectList[i5] = r_patchObject;
                    if (!systemWrite) continue;
                    boolean calledFromApply = true;
                    try {
                        RollbackSession.backupPatchActionsAndCreateRestoreFile(oracleHomePath, r_patchObject, calledFromApply, patchObject);
                        continue;
                    }
                    catch (Throwable t) {
                        OPatchStateManagerFactory.getInstance().setErrorCode(71);
                        BackupFailureException b12 = new BackupFailureException("Backup for restore failed. No Actions", t.getCause());
                        b12.setStackTrace(t.getStackTrace());
                        b12.setRestoreFailure();
                        OPatchEnv.setAutoRollbackBackup(false);
                        throw b12;
                    }
                }
                for (i5 = 0; i5 < r_patchObjectList.length; ++i5) {
                    OPatchSessionHelper.clubArchiveActions(r_patchObjectList[i5], COMPOSITE_FILTEREDPATCHACTIONS);
                }
                if (systemWrite) {
                    if (!calledFromUtil) {
                        OPatchSession.setTriggeredPatchObjects(r_patchObjectList);
                    } else {
                        MergedPatchObject.setTriggeredPatchObjects(Arrays.asList(r_patchObjectList));
                    }
                    OLogger.debug(new StringBuffer("Shutting down database after backup up for restore"));
                    SQLUtilities.shutdownAllDB(oracleHomePath);
                    OPatchEnv.setAutoRollbackBackup(false);
                    r_patchObjectList = OPatchSessionHelper.sortOnOverlay(r_patchObjectList, false);
                    try {
                        buff = new StringBuffer("  Creating autoFp, autoFr, and autoDr.");
                        OLogger.debug(buff);
                        this.generateAutoRacFile(oracleHomePath, patchObject, r_patchObjectList);
                        buff = new StringBuffer("  Creating Mp-final.");
                        OLogger.debug(buff);
                        int size = 1 + r_patchObjectList.length;
                        PatchObject[] allPatches = new PatchObject[size];
                        allPatches[0] = patchObject;
                        for (int r = 0; r < r_patchObjectList.length; ++r) {
                            allPatches[r + 1] = r_patchObjectList[r];
                        }
                        OPatchSessionHelper.createMPFinal(oracleHomePath, cookedPatchID, allPatches);
                    }
                    catch (IOException e11) {
                        buff = new StringBuffer("Failed to create auto-rollback file/dir/make list: ");
                        buff.append(e11.getMessage());
                        OLogger.debug(buff);
                        RuntimeException ex = new RuntimeException(buff.toString(), e11);
                        ex.setStackTrace(e11.getStackTrace());
                        throw ex;
                    }
                    for (i5 = 0; i5 < len; ++i5) {
                        PatchObject r_patchObject = r_patchObjectList[i5];
                        String r_patchID = r_patchObject.getPatchID();
                        RollbackSession r_session = new RollbackSession(r_patchID, false);
                        tmpS2 = new StringBuffer("RollingBack Patch ID: ");
                        tmpS2.append(r_patchObject.getPatchID());
                        OLogger.debug(tmpS2);
                        if (r_patchObject.getPatchInventory().isMiniPatchSet()) {
                            OLogger.info("OUI-67615", new Object[]{sessionName, r_patchObject.getPatchID(), oracleHomePath});
                        } else {
                            OLogger.onlyLogInfo("OUI-67087", new Object[]{sessionName, r_patchObject.getPatchID(), oracleHomePath});
                            OLogger.println(OLogger.getString("OUI-67914", new Object[]{r_patchObject.getPatchID(), oracleHomePath}));
                        }
                        boolean calledFromApply = true;
                        OLogger.justlog(OLogger.INFO, "Starting auto rollback of patch " + r_patchID);
                        OPatchSessionHelper.constructJarActionTree(r_patchObject, oracleHomePath, COMPOSITE_FILTEREDPATCHACTIONS);
                        if (!IOC.INSTANCE.isInventoryConverted()) {
                            r_session.autoRollback(oracleHomePath, this.rwServices, r_patchObject, localNode, calledFromApply, patchObject);
                            OLogger.justlog(OLogger.INFO, "Finished auto rollback of patch " + r_patchID);
                        }
                        this.rolledBackPatcheObjects[i5] = r_patchObject;
                    }
                    RollbackSession.autoRollbackDelayedActions(true, r_patchObjectList, oracleHomePath);
                    arp = r_patchObjectList;
                } else {
                    this.rolledBackPatcheObjects = r_patchObjectList;
                    if (!OPatchEnv.isReport() && !IOC.INSTANCE.isInventoryConverted()) {
                        for (int patchLength = 0; patchLength < r_patchObjectList.length; ++patchLength) {
                            OLogger.info("OUI-67120", new Object[]{sessionName, r_patchObjectList[patchLength].getPatchID()});
                            this.rwServices.remove(r_patchObjectList[patchLength]);
                        }
                    }
                }
                OPatchSessionHelper.constructJarActionTree(patchObject, oracleHomePath, COMPOSITE_FILTEREDPATCHACTIONS);
                OPatchUtilHelper.setAutoRollbackOneOffs(this.rolledBackPatcheObjects, oracleHomePath);
            } else {
                OLogger.debug(new StringBuffer("Shutting down database after backup up for restore"));
                SQLUtilities.shutdownAllDB(oracleHomePath);
                PatchObject[] allPatches = new PatchObject[]{patchObject};
                buff = new StringBuffer("ApplySession creates FP and DP file list for non-autorb case.");
                OLogger.debug(buff);
                this.generateRacFiles(oracleHomePath, patchObject);
                buff = new StringBuffer("ApplySession::createMPFinal() for non-autorb case, ");
                buff.append("use this patch Make Actions to create the file, cooked patchID = ");
                buff.append(cookedPatchID);
                OLogger.debug(buff);
                OPatchSessionHelper.createMPFinal(oracleHomePath, cookedPatchID, allPatches);
            }
            if (needRollback && systemWrite) {
                OLogger.info("OUI-67166", new Object[]{patchID});
            }
            OPatchStateManagerFactory.getInstance().setCurrentState("Back up for rollback");
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Backing up patch " + patchObject.getPatchID() + " for rollback");
            if (systemWrite && patchingModel != 2) {
                try {
                    buff = new StringBuffer("ApplySession: back up files for system roll-back");
                    OLogger.log(OLogger.FINE, buff.toString());
                    buff = new StringBuffer("ApplySession: calling PatchObject::backupForRollback()");
                    OLogger.debug(buff);
                    patchObject.backupForRollback(oracleHomePath, sessionName);
                }
                catch (RuntimeException e12) {
                    buff = new StringBuffer("   PatchObject::backupForRollback() throws RuntimeException");
                    OLogger.debug(buff);
                    b1 = new BackupFailureException(e12.getMessage(), e12.getCause());
                    b1.setStackTrace(e12.getStackTrace());
                    b1.setRollbackFailure();
                    throw b1;
                }
            }
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Finished backing up patch " + patchObject.getPatchID() + " for rollback");
            OLogger.debug(new StringBuffer("Shutting down database after backup up for rollback"));
            SQLUtilities.shutdownAllDB(oracleHomePath);
            if (systemWrite) {
                OPatchSession.setOracleHomeHasBeenModified(this);
            }
            String pid = patchObject.getPatchID();
            patchObject.getPreReadMeAction().process();
            if (!OPatchEnv.isNoPreScript()) {
                OPatchStateManagerFactory.getInstance().setCurrentState("Pre-script processing");
                PreScriptAction preScript = patchObject.getPreScriptAction();
                String preArg = OPatchSessionHelper.getPreScriptActionArgument(pid);
                int preReturnVal = preScript.process(preArg, "apply", pid);
                if (preReturnVal != 0) {
                    String preMsg = OLogger.getString("OUI-67133", new Object[]{"PRE", Integer.toString(preReturnVal)});
                    OLogger.warn("OUI-67133", new Object[]{"PRE", Integer.toString(preReturnVal)});
                    if (patchObject.isExitIfPreScriptError()) {
                        OPatchStateManagerFactory.getInstance().setErrorCode(101);
                        String exitIfPreErrMsg = OLogger.getString("OUI-67717", new Object[]{patchObject.getPatchID()});
                        RuntimeException exitIfPreErrRe = new RuntimeException(exitIfPreErrMsg);
                        throw exitIfPreErrRe;
                    }
                    if (!Rules.shouldContinueInCaseOfPrePostError("")) {
                        RuntimeException preRe = new RuntimeException(preMsg);
                        throw preRe;
                    }
                }
            }
            OPatchStateManagerFactory.getInstance().setCurrentState("Patch Oracle Home for apply");
            this.rwServices = this.apply(oracleHomePath, patchObject, this.rwServices);
            OLogger.printlnOnLog("ApplySession: Skip patch verification.\n");
            try {
                PostReadMeAction postRead = patchObject.getPostReadMeAction();
                postRead.process();
            }
            catch (Throwable t) {
                buff = new StringBuffer("ApplySession::processLocal(): PostReadMeAction failed: ");
                msg = t.getMessage();
                if (msg != null) {
                    buff.append(msg);
                } else {
                    buff.append("no detail available");
                }
                OLogger.println(buff.toString());
            }
            if (!OPatchEnv.isNoPostScript()) {
                OPatchStateManagerFactory.getInstance().setCurrentState("Post-script processing");
                PostScriptAction postScript = patchObject.getPostScriptAction();
                String postArg = OPatchSessionHelper.getPostScriptActionArgument(pid);
                int postReturnVal = postScript.process(postArg, "apply", pid);
                if (postReturnVal != 0) {
                    String postMsg = OLogger.getString("OUI-67133", new Object[]{"POST", Integer.toString(postReturnVal)});
                    OLogger.warn("OUI-67133", new Object[]{"POST", Integer.toString(postReturnVal)});
                    if (!Rules.shouldContinueInCaseOfPrePostError("")) {
                        OPatchStateManagerFactory.getInstance().setErrorCode(201);
                        RuntimeException postRe = new RuntimeException(postMsg);
                        throw postRe;
                    }
                }
            }
            try {
                ApplySession.applyDelayedActions(patchObject, oracleHomePath);
            }
            catch (Exception e13) {
                RuntimeException rt = new RuntimeException(e13);
                rt.setStackTrace(e13.getStackTrace());
                throw rt;
            }
        }
        catch (ExitOPatchException e14) {
            if (e14.isSysmodFailed()) {
                if (!OPatchSession.isOracleHomeHasBeenModified()) {
                    buff = new StringBuffer("Oracle Home is not modified. ");
                    buff.append(e14.getMessage());
                    OLogger.debug(buff);
                    ExitOPatchException re1 = new ExitOPatchException(buff.toString());
                    re1.initCause(e14);
                    re1.setStackTrace(e14.getStackTrace());
                    throw re1;
                }
                tmpS = OLogger.getString("OUI-67218", new Object[]{"ApplySession", e14.getMessage()});
                er = new Error(tmpS, e14);
                er.setStackTrace(e14.getStackTrace());
                throw er;
            }
            throw e14;
        }
        catch (BackupFailureException e15) {
            if (e15.isRestoreFailure()) {
                buff = new StringBuffer("ApplySession failed to prepare the system. ");
                buff.append(e15.getMessage());
                OLogger.debug(buff);
                re2 = new RuntimeException(buff.toString(), e15);
                re2.setStackTrace(e15.getStackTrace());
                throw re2;
            }
            tmpS = OLogger.getString("OUI-67218", new Object[]{"ApplySession", e15.getMessage()});
            er = new Error(tmpS, e15);
            er.setStackTrace(e15.getStackTrace());
            throw er;
        }
        catch (Throwable t) {
            if (!OPatchSession.isOracleHomeHasBeenModified()) {
                buff = new StringBuffer("ApplySession failed but Oracle Home has not been modified.");
                OLogger.debug(buff);
                re2 = new RuntimeException(buff.toString() + t.getMessage(), t);
                re2.setStackTrace(t.getStackTrace());
                throw re2;
            }
            tmpS = OLogger.getString("OUI-67218", new Object[]{"ApplySession", t.getMessage()});
            er = new Error(tmpS, t);
            er.setStackTrace(t.getStackTrace());
            throw er;
        }
        OPatchStateManagerFactory.getInstance().setCurrentState("Run custom SQL file");
        if (!calledFromUtil) {
            for (int i7 = 0; i7 < arp.length && OPatchEnv.isRunSql(); ++i7) {
                String originalPatchLoc = OPatchEnv.getPatchBackupDirectoryPath(oracleHomePath, arp[i7].getCookedPatchID());
                PatchmdXml rollbackSql = new PatchmdXml(oracleHomePath, originalPatchLoc, false, arp[i7].getAllIncludedCopyActions(), arp[i7].getPatchID());
                String rollbackSqlPath = rollbackSql.getSqlPath();
                if (rollbackSqlPath == null || rollbackSqlPath.equals("")) continue;
                try {
                    OLogger.println(OLogger.getString("OUI-67272", new Object[]{"auto-rollback", rollbackSqlPath, arp[i7].getPatchID()}));
                    OPatchSessionHelper.runSqlScript(rollbackSqlPath, arp[i7].getPatchInventory().isSqlMigrate());
                    continue;
                }
                catch (RuntimeException e16) {
                    OLogger.printStackTrace(e16);
                    OLogger.printlnOnLog(OLogger.INFO, e16.getMessage());
                    OLogger.warn(OLogger.getString("OUI-67273", new Object[]{"auto-rollback", rollbackSqlPath, arp[i7].getPatchID()}));
                }
            }
            PatchmdXml applySql = new PatchmdXml(oracleHomePath, patchLocation, true, patchObject.getAllIncludedCopyActions(), patchObject.getPatchID());
            String applySqlPath = applySql.getSqlPath();
            if (applySqlPath != null && !applySqlPath.equals("") && OPatchEnv.isRunSql()) {
                try {
                    OLogger.println(OLogger.getString("OUI-67272", new Object[]{"apply", applySqlPath, patchObject.getPatchID()}));
                    OPatchSessionHelper.runSqlScript(applySqlPath, patchObject.getPatchInventory().isSqlMigrate());
                }
                catch (RuntimeException e17) {
                    OLogger.printStackTrace(e17);
                    OLogger.printlnOnLog(OLogger.INFO, e17.getMessage());
                    OLogger.warn(OLogger.getString("OUI-67273", new Object[]{"apply", applySqlPath, patchObject.getPatchID()}));
                }
            }
            try {
                OPatchSession.runCustomScript();
            }
            catch (RuntimeException e18) {
                OLogger.printStackTrace(e18);
                OLogger.printlnOnLog(OLogger.INFO, e18.getMessage());
                OLogger.warn("OUI-67266", new Object[]{OPatchEnv.getSqlScriptFilePath()});
            }
        }
        if (!calledFromUtil) {
            if (OPatchEnv.isRunSql()) {
                for (int i8 = 0; i8 < arp.length; ++i8) {
                    if (!arp[i8].isSqlRelatedActions()) continue;
                    OPatchSessionHelper.removeSidFromSqlPropertyFile(oracleHomePath, arp[i8].getCookedPatchID());
                }
            }
            Properties prop = new Properties();
            if (OPatchEnv.isRunSql() && patchObject.isSqlRelatedActions()) {
                prop.setProperty("RUNSQL", "true");
                String[] sidArray = OPatchEnv.getDBSIDs();
                String[] dbNodes = OPatchEnv.getDBNodes();
                String lNode = OPatchEnv.getLocalNode();
                StringBuffer sidValue = new StringBuffer();
                for (int sidCount = 0; sidCount < sidArray.length; ++sidCount) {
                    if (!dbNodes[sidCount].equals(lNode) && !dbNodes[sidCount].equals("")) continue;
                    sidValue.append(sidArray[sidCount]);
                    if (sidCount == sidArray.length - 1) continue;
                    sidValue.append(",");
                }
                if (sidValue.toString().endsWith(",")) {
                    String temp = sidValue.toString().substring(0, sidValue.toString().length() - 1);
                    sidValue = new StringBuffer(temp);
                }
                prop.setProperty("SID", sidValue.toString());
            } else {
                prop.setProperty("RUNSQL", "unknown");
            }
            OPatchSessionHelper.setSqlPropertyToFile(prop, oracleHomePath, patchObject.getCookedPatchID());
            Properties onlineProp = OPatchSessionHelper.getOnlinePropertyFromFile(oracleHomePath);
            OPatchSessionHelper.removeOnlineRollbackSids(onlineProp, arp, OPatchEnv.getLocalNode(), oracleHomePath);
            if (patchObject.isOnlinePatch()) {
                OPatchSessionHelper.setOnlinePropertyToFile(oracleHomePath, OPatchEnv.getLocalNode(), patchObject.getPatchID());
            }
        }
        if (shouldPromptForStartup = patchObject.shouldPromptForStartup()) {
            buff = new StringBuffer("ApplySession: processes startup logics.");
            OLogger.debug(buff);
            RacProcessor.startupLogicsForProcessLocal(racType, order, localNode, remoteNodes, isShutdown);
        } else {
            buff = new StringBuffer("ApplySession: skips startup logics ");
            buff.append("per PatchObject's request.");
            OLogger.debug(buff);
        }
        OPatchSessionHelper.LocalInfo localInfo = new OPatchSessionHelper.LocalInfo(this.rwServices, patchObject, needRollback, racType, selects);
        return localInfo;
    }

    protected void processRemote(String oracleHomePath, Rac.RacType racType, IIPMReadServices readServices, PatchObject patchObject, boolean autoRollBack, PatchObject[] autoRolledBackPatchObjects, RacProcessor.MinDowntimeNodeSelection selects) throws RuntimeException, Error {
        StringBuffer buff = new StringBuffer("ApplySession::processRemote()");
        OLogger.debug(buff);
        Rac rac = OPatchExternalFactory.getRac(oracleHomePath);
        OPatchSessionHelper.loadRACRelatedLibFile();
        if (!readServices.isInventoryLoaded()) {
            buff.append(" needs a non-null Inventory");
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
        if (patchObject == null) {
            buff.append(" needs a non-null patchObject");
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
        String cookedPatchID = patchObject.getCookedPatchID();
        try {
            OPatchSessionHelper.checkArrayForNull("PatchObject", autoRolledBackPatchObjects);
        }
        catch (NullPointerException e2) {
            RuntimeException re = new RuntimeException(e2.getMessage(), e2);
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        if (!rac.shouldPropagate(racType) && !rac.shouldRemoteRun(racType)) {
            buff = new StringBuffer(" not a RAC system, no-op for ApplySession::processRemote()");
            OLogger.debug(buff);
        } else {
            buff = new StringBuffer("ApplySession::processRemote() will apply the patch on the following nodes: ");
            String localNode = racType.getLocalNode();
            String[] remoteNodes = racType.getRemoteNodes();
            if (remoteNodes != null) {
                for (int i2 = 0; i2 < remoteNodes.length; ++i2) {
                    String node = remoteNodes[i2];
                    buff.append(" (node ");
                    buff.append(node);
                    buff.append(")");
                }
            }
            buff.append(".  RAC mode is: ");
            buff.append(racType.getDetail());
            boolean local = OPatchEnv.isLocal();
            boolean minDT = OPatchEnv.isMinDowntime();
            boolean allNode = OPatchEnv.isAllNode();
            boolean rolling = patchObject.isRolling();
            boolean shutdown = patchObject.isShutdown();
            boolean silent = OPatchEnv.isSilent();
            Rules.RacPatchOrder order = Rules.getRacPatchOrder(racType, local, rolling, minDT, allNode, silent);
            buff.append(".  Applying order is: ");
            buff.append(order.toString());
            OLogger.debug(buff);
            try {
                String FP = null;
                String DP = null;
                String FR = null;
                String DR = null;
                String MP = null;
                String RC = null;
                String patchStorageRac = "";
                try {
                    patchStorageRac = OPatchEnv.getPatchStorageRacDirectoryPath(oracleHomePath, cookedPatchID);
                    boolean createRacFile = OPatchEnv.isCreateRacFile();
                    Path f2 = WrapperFactory.getNioServiceWrapper().getPath(patchStorageRac, new String[0]);
                    if (!createRacFile && !Files.exists(f2, new LinkOption[0])) {
                        buff = new StringBuffer("ApplySession::processRemote() was not able to locate the ");
                        buff.append("directory containing listed files/dirs to be propgated/removed on remote nodes.  ");
                        buff.append("Moreover, since users request that no RAC listed files be generated, ");
                        buff.append("OPatch cannot go on patching remote nodes.  ");
                        if (OPatchEnv.isReport()) {
                            buff.append("Report stops here.");
                            OLogger.println(buff.toString());
                            return;
                        }
                        OLogger.println(buff.toString());
                    }
                    RacFileCreator.checkPsRac(patchStorageRac);
                    FP = RacFileCreator.getFPFinalName(patchStorageRac);
                    DP = RacFileCreator.getDPFinalName(patchStorageRac);
                    RC = RacFileCreator.getRCFinalName(patchStorageRac);
                    if (autoRollBack) {
                        FR = RacFileCreator.getFRFinalName(patchStorageRac);
                        DR = RacFileCreator.getDRFinalName(patchStorageRac);
                    }
                    MP = RacFileCreator.getMPFinalName(patchStorageRac);
                }
                catch (IOException e3) {
                    RuntimeException re = new RuntimeException(e3.getMessage(), e3);
                    re.setStackTrace(e3.getStackTrace());
                    throw re;
                }
                StringBuffer report = new StringBuffer("OPatch will use the following files to patch remote nodes:\n");
                if (FP != null) {
                    report.append("   \"");
                    report.append(FP);
                    report.append("\"\n");
                }
                if (DP != null) {
                    report.append("   \"");
                    report.append(DP);
                    report.append("\"\n");
                }
                if (RC != null) {
                    report.append("   \"");
                    report.append(RC);
                    report.append("\"\n");
                }
                if (FR != null) {
                    report.append("   \"");
                    report.append(FR);
                    report.append("\"\n");
                }
                if (DR != null) {
                    report.append("   \"");
                    report.append(DR);
                    report.append("\"\n");
                }
                if (MP != null) {
                    report.append("   \"");
                    report.append(MP);
                    report.append("\"\n");
                }
                OLogger.verbose(this, report);
                boolean apply = true;
                boolean rollback = false;
                PatchObject[] patchObjects = new PatchObject[]{patchObject};
                if (rolling && OPatchEnv.isUserSuppliedNodes()) {
                    OLogger.printlnres("OUI-67657");
                }
                RacProcessor.patchRemoteNodes(oracleHomePath, remoteNodes, order, FP, DP, FR, DR, MP, RC, shutdown, sessionName, selects, apply, rollback, autoRollBack, patchStorageRac, patchObject.getShutdownMsg(), patchObjects, autoRolledBackPatchObjects, localNode, rac.shouldPropagate(racType), rac.shouldRemoteRun(racType));
            }
            catch (RuntimeException e4) {
                throw e4;
            }
            catch (Error e5) {
                throw e5;
            }
        }
    }

    public static PatchObject componentPrereqCheck(IIPMReadServices readServices, PatchObject patchObject) throws RuntimeException, IOException, UnsupportedOperationException {
        StringBuffer buff = new StringBuffer("ApplyProcess::componentPrereqCheck()");
        OLogger.debug(buff);
        String oracleHomePath = readServices.getOracleHomePath();
        String msg = "";
        try {
            boolean patchCompatible = PatchObjectUtil.patchApplicableOnPlatform(oracleHomePath, readServices, patchObject);
            if (!patchCompatible) {
                if (Rules.shouldIgnoreErrorToContinue()) {
                    OLogger.warn("OUI-67020", new Object[]{patchObject.getPatchID(), readServices.getOracleHomePath()});
                } else {
                    msg = OLogger.error("OUI-67020", new Object[]{patchObject.getPatchID(), readServices.getOracleHomePath()});
                    throw new UnsupportedOperationException(msg);
                }
            }
            buff = new StringBuffer("ApplySession searches for required compoments.");
            OLogger.debug(buff);
            boolean failedRequiredComponent = false;
            boolean failedOptionalComponent = false;
            StringBuilder failedReqPCs = new StringBuilder();
            StringBuilder failedOptPCs = new StringBuilder();
            Map<PatchComponent, PatchComponentCheckResult> analyzedPC = readServices.analyzePatchComponents(patchObject, OPatchEnv.isNRollback());
            boolean failedReqCompFirst = true;
            boolean failedOpCompFirst = true;
            for (PatchComponent pc : patchObject.getPatchComponents()) {
                PatchComponentCheckResult pcCheckResult = analyzedPC.get(pc);
                if (pcCheckResult.getResult().isProcessComponent() || pcCheckResult.getResult().isProcessingNotRequired()) continue;
                if (pc.isRequired()) {
                    failedRequiredComponent = true;
                    if (failedReqCompFirst) {
                        failedReqPCs.append("[ ").append(pc.getID()).append(", ").append(pc.getVersion()).append(" ] ");
                        failedReqCompFirst = false;
                    } else {
                        failedReqPCs.append(", [ ").append(pc.getID()).append(", ").append(pc.getVersion()).append(" ] ");
                    }
                    failedReqPCs.append("[ ").append(pc.getID()).append(", ").append(pc.getVersion()).append(" ] ");
                    failedReqPCs.append(", [ ").append(pc.getID()).append(", ").append(pc.getVersion()).append(" ] ");
                    continue;
                }
                if (!pc.isConditional()) {
                    failedOptionalComponent = true;
                    if (failedOpCompFirst) {
                        failedOptPCs.append("[ ").append(pc.getID()).append(", ").append(pc.getVersion()).append(" ] ");
                        failedOpCompFirst = false;
                    } else {
                        failedOptPCs.append(", [ ").append(pc.getID()).append(", ").append(pc.getVersion()).append(" ] ");
                    }
                    pc.setExcluded();
                    for (PatchAction pa : patchObject.getPatchActionsForComponent(pc)) {
                        pa.setApplyFailed();
                    }
                }
                if (!pc.isConditional()) continue;
                pc.setExcluded();
            }
            if (failedRequiredComponent) {
                if (Rules.shouldIgnoreErrorToContinue()) {
                    OLogger.warn("OUI-67092", new Object[]{sessionName, failedReqPCs.toString()});
                } else {
                    throw new RuntimeException(OLogger.getString("OUI-67092", new Object[]{sessionName, failedReqPCs.toString()}));
                }
            }
            if (failedOptionalComponent) {
                OLogger.info("OUI-67051", new Object[]{sessionName, failedOptPCs.toString()});
            }
        }
        catch (RuntimeException e2) {
            buff = new StringBuffer("ApplySession::componentPrereqCheck() failed: ");
            buff.append(e2.getMessage());
            OLogger.debug(buff);
            throw e2;
        }
        return patchObject;
    }

    public static PatchObject componentPrereqCheckIOC(String oracleHomePath, PatchObject patchObject) throws RuntimeException, IOException, UnsupportedOperationException {
        StringBuffer buff = new StringBuffer("ApplyProcess::componentPrereqCheck()");
        OLogger.debug(buff);
        String msg = "";
        try {
            boolean patchCompatible = PatchObjectUtil.patchApplicableOnPlatformIOC(oracleHomePath, patchObject);
            if (!patchCompatible) {
                if (Rules.shouldIgnoreErrorToContinue()) {
                    OLogger.warn("OUI-67020", new Object[]{patchObject.getPatchID(), oracleHomePath});
                } else {
                    msg = OLogger.error("OUI-67020", new Object[]{patchObject.getPatchID(), oracleHomePath});
                    throw new UnsupportedOperationException(msg);
                }
            }
            buff = new StringBuffer("ApplySession searches for required compoments.");
            OLogger.debug(buff);
            boolean failedRequiredComponent = false;
            boolean failedOptionalComponent = false;
            StringBuilder failedReqPCs = new StringBuilder();
            StringBuilder failedOptPCs = new StringBuilder();
            Map<PatchComponent, PatchComponentCheckResult> analyzedPC = IOCHelper.INSTANCE.analyzePatchComponents(patchObject, OPatchEnv.isNRollback());
            boolean failedReqCompFirst = true;
            boolean failedOpCompFirst = true;
            for (PatchComponent pc : patchObject.getPatchComponents()) {
                PatchComponentCheckResult pcCheckResult = analyzedPC.get(pc);
                if (pcCheckResult.getResult().isProcessComponent() || pcCheckResult.getResult().isProcessingNotRequired()) continue;
                if (pc.isRequired()) {
                    failedRequiredComponent = true;
                    if (failedReqCompFirst) {
                        failedReqPCs.append("[ ").append(pc.getID()).append(", ").append(pc.getVersion()).append(" ] ");
                        failedReqCompFirst = false;
                    } else {
                        failedReqPCs.append(", [ ").append(pc.getID()).append(", ").append(pc.getVersion()).append(" ] ");
                    }
                    failedReqPCs.append("[ ").append(pc.getID()).append(", ").append(pc.getVersion()).append(" ] ");
                    failedReqPCs.append(", [ ").append(pc.getID()).append(", ").append(pc.getVersion()).append(" ] ");
                    continue;
                }
                if (pc.isConditional()) continue;
                failedOptionalComponent = true;
                if (failedOpCompFirst) {
                    failedOptPCs.append("[ ").append(pc.getID()).append(", ").append(pc.getVersion()).append(" ] ");
                    failedOpCompFirst = false;
                } else {
                    failedOptPCs.append(", [ ").append(pc.getID()).append(", ").append(pc.getVersion()).append(" ] ");
                }
                pc.setExcluded();
                for (PatchAction pa : patchObject.getPatchActionsForComponent(pc)) {
                    pa.setApplyFailed();
                }
            }
            if (failedRequiredComponent) {
                if (Rules.shouldIgnoreErrorToContinue()) {
                    OLogger.warn("OUI-67092", new Object[]{sessionName, failedReqPCs.toString()});
                } else {
                    throw new RuntimeException(OLogger.getString("OUI-67092", new Object[]{sessionName, failedReqPCs.toString()}));
                }
            }
            if (failedOptionalComponent) {
                OLogger.info("OUI-67051", new Object[]{sessionName, failedOptPCs.toString()});
            }
        }
        catch (RuntimeException e2) {
            buff = new StringBuffer("ApplySession::componentPrereqCheck() failed: ");
            buff.append(e2.getMessage());
            OLogger.debug(buff);
            throw e2;
        }
        return patchObject;
    }

    protected void process(String patchLocation, String oracleHomePath, PatchObject patchObject, HashSet filteredPatchActions) throws RuntimeException, Error {
        StringBuffer buff = new StringBuffer("ApplySession::process()");
        buff.append(" with a given PatchObject");
        OLogger.debug(buff);
        try {
            this.NAPPLY_PATCHOBJECT = patchObject;
            calledFromUtil = true;
            COMPOSITE_FILTEREDPATCHACTIONS = filteredPatchActions;
            this.process(patchLocation, oracleHomePath);
            this.NAPPLY_PATCHOBJECT = null;
            calledFromUtil = false;
            COMPOSITE_FILTEREDPATCHACTIONS = new HashSet();
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Error e3) {
            throw e3;
        }
    }

    protected void process(String patchLocation, String oracleHomePath, PatchObject patchObject) throws RuntimeException, Error {
        StringBuffer buff = new StringBuffer("ApplySession::process()");
        buff.append(" with a given PatchObject");
        OLogger.debug(buff);
        try {
            this.NAPPLY_PATCHOBJECT = patchObject;
            calledFromUtil = true;
            this.process(patchLocation, oracleHomePath);
            this.NAPPLY_PATCHOBJECT = null;
            calledFromUtil = false;
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Error e3) {
            throw e3;
        }
    }

    protected void process(String patchLocation, String oracleHomePath) throws RuntimeException, Error {
        OLogger.debug("ApplySession::process()");
        OLogger.justlog(OLogger.INFO, "Starting apply session");
        PatchObject patchObject = null;
        boolean createInterimInventoryFile = true;
        boolean doRestore = false;
        Rac rac = OPatchExternalFactory.getRac(oracleHomePath);
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        try {
            if (this.NAPPLY_PATCHOBJECT == null) {
                if (this.APPLY_PATCHOBJECT == null) {
                    createInterimInventoryFile = true;
                    OLogger.debug("ApplySession::process(): loading patch object.");
                    patchObject = this.loadAndInitPatchObject(patchLocation);
                } else {
                    OLogger.debug("ApplySession::process(): using PatchObject from Apply subclass.");
                    patchObject = this.APPLY_PATCHOBJECT;
                }
                OPatchSessionHelper.printTranslationPatches(new PatchObject[]{patchObject});
            } else {
                createInterimInventoryFile = false;
                OLogger.debug("ApplySession::process(): using PatchObject from N-Apply.");
                patchObject = this.NAPPLY_PATCHOBJECT;
            }
            OPatchStateManagerFactory.getInstance().printMandatoryStates(oracleHomePath, new PatchObject[]{patchObject});
            OPatchStateManagerFactory.getInstance().setCurrentState("Oracle Home discovery");
            if (patchObject.hasArchiveButNoMakeActions() && !OPatchEnv.isNolink()) {
                OLogger.info("OUI-67158");
            }
            boolean local = OPatchEnv.isLocal();
            boolean minDowntime = OPatchEnv.isMinDowntime();
            boolean allNode = OPatchEnv.isAllNode();
            boolean silent = OPatchEnv.isSilent();
            if (patchObject.forceAllNodeMode() && !allNode && (patchObject.isRolling() || minDowntime)) {
                allNode = true;
                OPatchEnv.setAllNode(true);
                OLogger.info("OUI-67250");
            }
            if (patchObject.getPatchInventory().isMiniPatchSet()) {
                OLogger.justlog(OLogger.INFO, OLogger.getString("OUI-67613", new Object[]{sessionName, patchObject.getPatchID(), oracleHomePath}));
                OLogger.println("Applying patch set update " + patchObject.getPatchID() + " to " + oracleHomePath);
            } else {
                OLogger.justlog(OLogger.INFO, OLogger.getString("OUI-67086", new Object[]{sessionName, patchObject.getPatchID(), oracleHomePath}));
            }
            if (patchObject.getIsComposite()) {
                OLogger.println(OLogger.getString("OUI-67916", new Object[]{patchObject.getPatchID(), oracleHomePath}));
            } else {
                OLogger.println(OLogger.getString("OUI-67913", new Object[]{patchObject.getPatchID(), oracleHomePath}));
            }
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Starting to apply patch \"" + patchObject.getPatchID() + "\" to local system");
            OPatchSessionHelper.LocalInfo localInfo = this.processLocal(patchLocation, oracleHomePath, patchObject, local, minDowntime, allNode, silent, createInterimInventoryFile);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Finished applying patch \"" + patchObject.getPatchID() + "\" to local system");
            readServices = localInfo.getReadServices();
            patchObject = localInfo.getPatchObject();
            Boolean needRollback = localInfo.getNeedRollbac();
            Rac.RacType racType = localInfo.getRacType();
            if (!racType.getCrsDownPrompt().equals("")) {
                OLogger.warn("OUI-68010", new Object[]{"apply", "rollback", racType.getCrsDownPrompt()});
            }
            RacProcessor.MinDowntimeNodeSelection selects = localInfo.getSelection();
            try {
                OPatchStateManagerFactory.getInstance().setCurrentState("RAC propagation");
                boolean patchNoOp = patchObject.isNoOp();
                if ((!patchNoOp || patchObject.getIsComposite()) && rac.shouldPropagate(racType)) {
                    String[] remoteNodes = racType.getRemoteNodes();
                    String nodesString = RacProcessor.getNodesString(remoteNodes);
                    boolean autoRollBack = needRollback;
                    PatchObject[] autoRolledBackPatchObjects = this.getAutoRolledBackPatchObjects();
                    if (!IOC.INSTANCE.isInventoryConverted()) {
                        OLogger.justlog(OLogger.INFO, "Starting to apply patch to remote nodes " + nodesString);
                        this.processRemote(oracleHomePath, racType, readServices, patchObject, autoRollBack, autoRolledBackPatchObjects, selects);
                        OLogger.justlog(OLogger.INFO, "Finished applying patch to remote node " + nodesString);
                    }
                    if (Rules.shouldWarnAboutRemoteRelink(oracleHomePath, patchObject)) {
                        String remoteMakeCommands = patchObject.getListOfMakeCmdsOnRemoteNodes(oracleHomePath);
                        OLogger.info("OUI-67151", new Object[]{nodesString, remoteMakeCommands});
                    }
                }
            }
            catch (Throwable t) {
                String msg = t.getMessage();
                StringBuffer buff = new StringBuffer("ApplySession::process(): processRemote() failed.");
                buff.append("  Do not restore local system.  Ask users to apply patch ");
                buff.append("on remote node(s) using -local.  Error is: \"");
                if (msg != null) {
                    buff.append(msg);
                } else {
                    buff.append("no detail available");
                }
                buff.append("\"");
                OLogger.debug(buff);
                msg = OLogger.error("OUI-67081", new Object[]{msg});
                RuntimeException e2 = new RuntimeException(msg, t);
                e2.setStackTrace(t.getStackTrace());
                throw e2;
            }
        }
        catch (RuntimeException e3) {
            throw e3;
        }
        catch (Error e4) {
            doRestore = true;
            throw e4;
        }
        finally {
            if (!(doRestore || calledFromUtil || OPatchEnv.isDelayCleanUp())) {
                OPatchSessionHelper.cleanup(oracleHomePath);
            }
        }
        OLogger.debug("ApplySession::process() done");
        if (this.NAPPLY_PATCHOBJECT == null && OPatchEnv.isRLibSuccess()) {
            OLogger.println(OLogger.getString("OUI-67917", new Object[]{patchObject.getPatchID()}));
        }
    }

    @Override
    public boolean helpPresent() {
        return true;
    }

    @Override
    public void displayHelp() {
        StringBuffer helpM = new StringBuffer("\n");
        String helpFile = "";
        helpFile = "apply_help.txt";
        try {
            String thisLine;
            InputStream is = this.getClass().getResourceAsStream(helpFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((thisLine = br.readLine()) != null) {
                helpM.append(thisLine);
                helpM.append("\n");
            }
            OLogger.log(OLogger.INFO, helpM.toString());
            br.close();
            is.close();
        }
        catch (Exception e2) {
            String msg = OLogger.getString("OUI-67108", new Object[]{helpFile});
            OLogger.println(msg);
        }
    }
}

