/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.util.Map;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.opatchlogger.OLogger;

public class ChecksumEntity {
    private String checksum = "-1";
    private String appDir = "";
    private String metadataPath = "";

    private ChecksumEntity() {
    }

    public ChecksumEntity(String metadataPath, String checksum, String appDir) {
        try {
            this.metadataPath = metadataPath;
            this.checksum = checksum;
            this.appDir = appDir;
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            this.checksum = "-1";
        }
    }

    protected String getMetaDataFilePath() {
        return this.metadataPath;
    }

    public String getAppDir() {
        return this.appDir;
    }

    public String getComputeFilePath(String oracleHomePath, boolean isSparseCopy, String appVersion, Map<String, String> curAppVer) throws RuntimeException {
        try {
            StringBuffer buff = new StringBuffer("");
            if (!this.metadataPath.startsWith(oracleHomePath)) {
                buff.append(oracleHomePath);
            }
            String filteredFilePath = PatchObjectUtil.filterString(this.metadataPath);
            if (isSparseCopy) {
                if (OPatchEnv.isApplyOrNApplySession() || OPatchEnv.isNApplySDKSession()) {
                    filteredFilePath = filteredFilePath.replace("%VERSION%", appVersion).replace("%APP_DIR%", this.appDir);
                } else {
                    String applicationVersion = curAppVer.get(this.appDir);
                    if (applicationVersion != null && !"".equals(applicationVersion)) {
                        filteredFilePath = filteredFilePath.replace("%VERSION%", applicationVersion).replace("%APP_DIR%", this.appDir);
                    }
                }
            }
            if (buff.length() != 0) {
                buff.append(File.separator);
            }
            buff.append(filteredFilePath);
            return buff.toString();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public String getComputeFilePath(String oracleHomePath, PatchObject pObject) throws RuntimeException {
        if (pObject != null) {
            return this.getComputeFilePath(oracleHomePath, pObject.isSparseCopy(), pObject.getApplicationVersion(), pObject.getCurrentAppVerDirs());
        }
        StringBuffer buff = new StringBuffer(oracleHomePath);
        try {
            String filteredFilePath = PatchObjectUtil.filterString(this.metadataPath);
            if (buff.length() != 0) {
                buff.append(File.separator);
            }
            buff.append(filteredFilePath);
            return buff.toString();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    protected String getComputeFilePathWithLatestPtrFile(String oracleHomePath, PatchObject pObject) throws RuntimeException {
        try {
            String applicationVersion;
            StringBuffer buff = new StringBuffer();
            String filteredFilePath = PatchObjectUtil.filterString(this.metadataPath);
            if (pObject != null && pObject.isSparseCopy() && (applicationVersion = pObject.getCurrentAppVerDirs().get(this.appDir)) != null && !"".equals(applicationVersion)) {
                filteredFilePath = filteredFilePath.replace("%VERSION%", applicationVersion).replace("%APP_DIR%", this.appDir);
            }
            if (buff.length() != 0) {
                buff.append(File.separator);
            }
            buff.append(filteredFilePath);
            return buff.toString();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    protected void setChecksum(String oracleHomePath, PatchObject pObject) throws RuntimeException {
        String chksum = "";
        String path = this.getComputeFilePath(oracleHomePath, pObject);
        try {
            chksum = OPatchSessionHelper.computeChecksum(path);
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2);
            throw re;
        }
        this.checksum = chksum;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("\n");
        buff.append("[Metadata Path = " + this.getMetaDataFilePath() + ",");
        buff.append("Checksum value = " + this.getChecksum() + "]");
        buff.append("AppDir value = " + this.getAppDir() + "]");
        return buff.toString();
    }
}

