/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.opatch.ConflictDetectable;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OUIReplacer;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.RemoteShellPropagate;
import oracle.opatch.Restorable;
import oracle.opatch.Rules;
import oracle.opatch.SystemCall;
import oracle.opatch.UpdateTimeStamp;
import oracle.opatch.Verifiable;
import oracle.opatch.ZipUtilities;
import oracle.opatch.conflicttextualinterpreter.cbcc.CbccEngine;
import oracle.opatch.conflicttextualinterpreter.cbcc.CbccResult;
import oracle.opatch.napplyhelper.NApplyDataSerializer;
import oracle.opatch.opatchactions.DeleteAction;
import oracle.opatch.opatchactions.OrderedPatchAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.ConflictHandler;
import oracle.opatch.opatchutil.DeltaFileProcessor;
import oracle.opatch.opatchutil.OPatchUtilHelper;
import oracle.opatch.opatchutil.OUSession;
import oracle.opatch.patchlevel.FileVersion;
import oracle.opatch.wrappers.WrapperFactory;

public class CopyAction
extends OrderedPatchAction
implements Restorable,
RemoteShellPropagate,
ConflictDetectable,
Verifiable {
    private static String fileSeparator = File.separator;
    private String copyName;
    private String path;
    private String fileName;
    private boolean opatchBinary = false;
    private boolean updateTimeStamp = false;
    private String fileVersion = "";
    private FileVersion fileVersionObj = null;
    private boolean copyFlagBasedOnFileVersion = true;
    private String diagStr = "";
    private boolean retainPermission = true;
    private String permission = "";
    private boolean isSame = false;
    private static HashMap copyActVer = new HashMap();
    private static HashMap iCopyActVer = new HashMap();
    private static HashMap envCopyActVer = new HashMap();
    private static HashMap copyActionPatchIds = new HashMap();
    private String nonApplicableDesc;
    private String nonRollbackableDesc;
    private String backupForRollbackFailureDesc;
    private boolean snowBallCopyAction = false;
    private boolean hasFileVersion = false;
    private boolean builtFrom101 = false;
    private String parentLoc = "";
    private String unzipDstDir = "";
    private String unzipSrcLoc = "";
    private boolean isUnzip = false;
    private boolean backupZip = false;
    private static Map<String, Boolean> sameFileMap = new HashMap<String, Boolean>();
    private static String initilizedCID = "";

    protected CopyAction(PatchComponent pc, String copyName, String path, String fileName, int lineNumber, boolean updateTimeStamp, String fileVersion, String diagStr, boolean retainPermission, String permission, boolean hasFileVersion) throws NullPointerException, Exception {
        this(pc, copyName, path, fileName, lineNumber);
        this.updateTimeStamp = updateTimeStamp;
        this.fileVersion = fileVersion;
        this.diagStr = diagStr;
        this.hasFileVersion = hasFileVersion;
        this.retainPermission = retainPermission;
        this.permission = permission;
    }

    protected CopyAction(PatchComponent pc, String copyName, String path, String fileName, int lineNumber, String fileVersion, boolean retainPermission, boolean hasFileVersion, boolean updateTimeStamp, String parentLoc, String unzipSrcLoc, String unzipDstDir, boolean isUnzip) throws NullPointerException, Exception {
        this(pc, copyName, path, fileName, lineNumber);
        this.fileVersion = fileVersion;
        this.hasFileVersion = hasFileVersion;
        this.retainPermission = retainPermission;
        this.updateTimeStamp = updateTimeStamp;
        this.parentLoc = parentLoc;
        this.unzipSrcLoc = unzipSrcLoc;
        this.unzipDstDir = unzipDstDir;
        this.isUnzip = isUnzip;
    }

    public CopyAction(PatchComponent pc, String copyName, String path, String fileName, int lineNumber) throws NullPointerException, Exception {
        super(pc, lineNumber);
        if (copyName == null || path == null || fileName == null) {
            String errMsg = "The copy action is null";
            if (copyName == null) {
                errMsg = errMsg + "The copy name is null";
            }
            if (path == null) {
                errMsg = errMsg + "The file path is null";
            }
            if (fileName == null) {
                errMsg = errMsg + "The file name is null";
            }
            NullPointerException ne = new NullPointerException(errMsg);
            throw ne;
        }
        this.copyName = OPatchEnv.stringPool.getValue(copyName);
        String tmp = PatchObjectUtil.filterString(path);
        this.path = OPatchEnv.stringPool.getValue(tmp);
        tmp = PatchObjectUtil.getPlatformDependentPath(fileName);
        this.fileName = OPatchEnv.stringPool.getValue(tmp);
    }

    public boolean isUpdateTimeStamp() {
        return this.updateTimeStamp;
    }

    public boolean isRetainPermission() {
        return this.retainPermission;
    }

    public String getPermission() {
        return this.permission;
    }

    public boolean getIsSame() {
        return this.isSame;
    }

    public boolean getIsUnzip() {
        return this.isUnzip;
    }

    public String getParentLoc() {
        return this.parentLoc;
    }

    public static void getSameFileCache(String oracleHomePath, String cookedPatchID) {
        sameFileMap = CopyAction.getSrcFileInUnchangedFileList(oracleHomePath, cookedPatchID);
    }

    @Override
    public boolean isNewFile(String oracleHomePath, String cookedPatchID, boolean beforeApply) {
        StringBuffer buff = null;
        if (beforeApply) {
            Path copyFile = WrapperFactory.getNioServiceWrapper().getPath(this.getParentFilePath(oracleHomePath), new String[0]);
            if (Files.exists(copyFile, new LinkOption[0])) {
                buff = new StringBuffer("File \"");
                buff.append(copyFile.toString());
                buff.append("\" is not a new file.\n");
                OLogger.debug(buff);
                return false;
            }
            buff = new StringBuffer("File \"");
            buff.append(copyFile.toString());
            buff.append("\" is a new file.\n");
            OLogger.debug(buff);
            return true;
        }
        StringBuffer tmpFile = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        tmpFile.append(fileSeparator);
        tmpFile.append(this.fileName);
        Path copyFile = WrapperFactory.getNioServiceWrapper().getPath(tmpFile.toString(), new String[0]);
        if (!Files.exists(copyFile, new LinkOption[0])) {
            buff = new StringBuffer("File \"");
            buff.append(copyFile.toString());
            buff.append("\" is not present, so its a new file.\n");
            OLogger.debug(buff);
            return true;
        }
        buff = new StringBuffer("File \"");
        buff.append(copyFile.toString());
        buff.append("\" is present, so its not a new file.\n");
        OLogger.debug(buff);
        return false;
    }

    public String getCopyName() {
        return this.copyName;
    }

    public String getPath() {
        return this.path;
    }

    public String getFilename() {
        return this.fileName;
    }

    public boolean isOpatchBinary() {
        return this.opatchBinary;
    }

    public void setOpatchBinary(boolean value) {
        this.opatchBinary = value;
    }

    public boolean isBackupZip() {
        return this.backupZip;
    }

    public void setBackupZip(boolean backupZip) {
        this.backupZip = backupZip;
    }

    public String getFileVersion() {
        return this.fileVersion;
    }

    public FileVersion getFileVersionObject() {
        return this.fileVersionObj;
    }

    public boolean getCopyFlagBasedOnFileVersion() {
        return this.copyFlagBasedOnFileVersion;
    }

    public void setCopyFlagBasedOnFileVersion(boolean flag) {
        this.copyFlagBasedOnFileVersion = flag;
    }

    public void setFileVersionObject(FileVersion obj) {
        this.fileVersionObj = obj;
    }

    public String getFileDiagStr() {
        return this.diagStr;
    }

    public boolean isHasFileVersion() {
        return this.hasFileVersion;
    }

    public void setSnowBallCopyAction(boolean b2) {
        this.snowBallCopyAction = b2;
    }

    public boolean isSnowBallCopyAction() {
        return this.snowBallCopyAction;
    }

    public String getBackupRollbackPath(String oracleHomePath, String cookedPatchID) {
        StringBuffer path = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        path.append(fileSeparator);
        path.append(this.fileName);
        return path.toString();
    }

    public static void setHashMap(HashMap m2) {
        copyActVer = m2;
    }

    public static void setIHashMap(HashMap m2) {
        iCopyActVer = m2;
    }

    public static void setHashMapEnv(HashMap m2) {
        envCopyActVer = (HashMap)m2.clone();
    }

    public static HashMap getEnvCopyActVer() {
        return envCopyActVer;
    }

    protected boolean isBuiltFrom101Home() {
        return this.builtFrom101;
    }

    public void setBuiltFrom101Home(boolean value) {
        this.builtFrom101 = value;
    }

    public String getSourceFile(String patchLocation) {
        if (!this.isUnzip) {
            if (patchLocation == null) {
                patchLocation = fileSeparator;
            }
            StringBuffer buff = new StringBuffer(patchLocation);
            buff.append(fileSeparator);
            buff.append("files");
            buff.append(fileSeparator);
            buff.append(this.fileName);
            return buff.toString();
        }
        String parent = this.parentLoc;
        if (parent == null) {
            parent = fileSeparator;
        }
        StringBuffer buff = new StringBuffer(parent);
        buff.append(fileSeparator);
        buff.append(this.fileName);
        return buff.toString();
    }

    @Override
    public long getSpaceNeeded(String patchLocation) {
        Path f2 = WrapperFactory.getNioServiceWrapper().getPath(this.getSourceFile(patchLocation), new String[0]);
        if (Files.exists(f2, new LinkOption[0])) {
            try {
                return Files.size(f2);
            }
            catch (IOException e2) {
                OLogger.debug(e2.getMessage());
            }
        }
        return 0L;
    }

    public String getSourceFile() {
        return this.copyName;
    }

    @Override
    public String getParentFilePath(String oracleHomePath) {
        StringBuffer buff = new StringBuffer(this.getParentDirPath(oracleHomePath));
        buff.append(fileSeparator);
        buff.append(this.copyName);
        return buff.toString();
    }

    public String getParentDirPath(String oracleHomePath) {
        if (oracleHomePath == null) {
            oracleHomePath = fileSeparator;
        }
        StringBuffer buff = new StringBuffer(oracleHomePath);
        if (this.path != "") {
            buff.append(fileSeparator);
            buff.append(this.path);
        }
        return buff.toString();
    }

    @Override
    public ArrayList getFilesTouched(String oracleHomePath) {
        String[] s = new String[]{this.getSourceFile(), this.getParentFilePath(oracleHomePath)};
        ArrayList<String[]> a2 = new ArrayList<String[]>();
        a2.add(s);
        return a2;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("[CopyAction: copyName=\"");
        buff.append(this.copyName);
        buff.append("\", path=\"");
        buff.append(this.path);
        buff.append("\", fileName=\"");
        buff.append(this.fileName);
        buff.append("\", updateTimeStamp=\"");
        buff.append(this.updateTimeStamp);
        buff.append("\", fileVersion=\"");
        buff.append(this.fileVersion);
        buff.append("\", fileDiagnosticStr=\"");
        buff.append(this.diagStr);
        buff.append("\", retainPermission=\"");
        buff.append(this.retainPermission);
        buff.append("\", permission=\"");
        buff.append(this.permission);
        buff.append("\", lineNumber=\"");
        buff.append(String.valueOf(this.lineNumber));
        buff.append("\", parentPath=\"");
        buff.append(this.getParentFilePath("%ORACLE_HOME%"));
        buff.append("\", sourcePath=\"");
        buff.append(this.getSourceFile("%patch_path%"));
        buff.append("\" opatchBinary=\"");
        buff.append(this.opatchBinary);
        buff.append("\" rawCopyAction=\"");
        buff.append(this.getRawActionEntry());
        buff.append("\"]");
        return buff.toString();
    }

    @Override
    public boolean restorable(String oracleHomePath, String cookedPatchID) {
        StringBuffer buff = new StringBuffer("CopyAction::restorable()");
        OLogger.debug(buff);
        String source = this.getParentFilePath(oracleHomePath);
        String backupDir = OPatchEnv.getBackupDirectoryPath(oracleHomePath, cookedPatchID);
        StringBuffer path = new StringBuffer(backupDir);
        path.append(fileSeparator);
        path.append(this.path);
        path.append(fileSeparator);
        path.append(this.copyName);
        String dst = path.toString();
        buff = new StringBuffer("  Action details: src = \"");
        buff.append(source);
        buff.append("\", dst = \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.debug(buff);
        Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(source, new String[0]);
        Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
        if (Files.exists(srcFile, new LinkOption[0]) && !Files.isReadable(srcFile)) {
            return false;
        }
        Path parentFile = dstFile.getParent();
        if (!Files.exists(parentFile, new LinkOption[0])) {
            try {
                Files.createDirectories(parentFile, new FileAttribute[0]);
            }
            catch (IOException e2) {
                OLogger.debug(e2.getMessage());
            }
        }
        return Files.exists(parentFile, new LinkOption[0]) && Files.isWritable(parentFile);
    }

    @Override
    public void backupForRestore(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        StringBuffer buff = new StringBuffer("CopyAction::backupForRestore()");
        OLogger.debug(buff);
        String source = this.getParentFilePath(oracleHomePath);
        buff = new StringBuffer(OPatchEnv.getBackupDirectoryPath(oracleHomePath, cookedPatchID));
        buff.append(fileSeparator);
        buff.append(this.path);
        buff.append(fileSeparator);
        buff.append(this.copyName);
        String dst = buff.toString();
        Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(source, new String[0]);
        if (!Files.exists(srcFile, new LinkOption[0]) || !Files.isReadable(srcFile)) {
            buff = new StringBuffer("CopyAction::backupForRestore(): source file \"");
            buff.append(source);
            buff.append("\" not exist, do not back up");
            OLogger.debug(buff);
            return;
        }
        Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
        try {
            if (PatchObjectUtil.checkCreateSimlink(this, OPatchEnv.getAutoRollbackList())) {
                StringBuffer temp = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
                temp.append(fileSeparator);
                temp.append(this.fileName);
                String target = temp.toString();
                String simlinkLoc = dst;
                buff = new StringBuffer("CopyAction::backForRestore(): create simlink \"");
                buff.append(simlinkLoc);
                buff.append("\" to \"");
                buff.append(target);
                buff.append("\"");
                OLogger.debug(buff);
                OLogger.printlnOnLog("Creating simlink at \"" + simlinkLoc + "\"" + " to " + "\"" + target + "\"");
                OUIReplacer.createSimlink(target, simlinkLoc);
                return;
            }
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("Exception occured while trying to create simlink, so reverting back to previous way of copying the file");
            OLogger.printlnOnLog("Details are : " + t.getMessage());
        }
        try {
            buff = new StringBuffer("CopyAction::backupForRestore(): back up \"");
            buff.append(source);
            buff.append("\" to \"");
            buff.append(dst);
            buff.append("\"");
            OLogger.debug(buff);
            if (!Files.isDirectory(srcFile, new LinkOption[0])) {
                if (!OPatchEnv.isWindows() && Files.exists(dstFile, new LinkOption[0]) && !Files.isWritable(dstFile) && !"".equals(this.permission)) {
                    OUIReplacer.setPermission(dst.toString(), this.permission);
                }
                SystemCall.backupFile(srcFile, dstFile);
            }
        }
        catch (Throwable t) {
            RuntimeException e2 = new RuntimeException(t.getMessage());
            e2.setStackTrace(t.getStackTrace());
            throw e2;
        }
    }

    @Override
    public void restore(String oracleHomePath, String sessionID, boolean apply, boolean rollback, String cookedPatchID) throws RuntimeException {
        StringBuffer buff = new StringBuffer("CopyAction::restore()");
        OLogger.debug(buff);
        buff = new StringBuffer(OPatchEnv.getBackupDirectoryPath(oracleHomePath, sessionID));
        buff.append(fileSeparator);
        buff.append(this.fileName);
        String src = buff.toString();
        String dst = null;
        dst = this.isOpatchBinary() ? this.getParentFilePath(OPatchEnv.getOracleHome()) : this.getParentFilePath(oracleHomePath);
        Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(src, new String[0]);
        Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
        buff = new StringBuffer("CopyAction::restore(): restore file from \"");
        buff.append(src);
        buff.append("\" to \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.debug(buff);
        if (!(OPatchEnv.isWindows() || Files.isWritable(dstFile) || this.permission.equals(""))) {
            OUIReplacer.setPermission(dst, this.permission);
        }
        SystemCall.copyFile(srcFile, dstFile);
    }

    @Override
    public String getBackupForRestoreDesc(String oracleHomePath, String cookedPatchID) {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getParentFilePath(oracleHomePath));
        return buff.toString();
    }

    @Override
    public boolean rollbackable(String oracleHomePath, String cookedPatchID) {
        StringBuffer buff = new StringBuffer("CopyAction::rollbackable()");
        OLogger.debug(buff);
        if (this.isBuiltFrom101Home()) {
            StringBuffer path = new StringBuffer(oracleHomePath);
            path.append(fileSeparator);
            path.append(".patch_storage");
            path.append(fileSeparator);
            path.append(cookedPatchID);
            path.append(fileSeparator);
            path.append(this.fileName);
            String preFileName = path.toString() + "_pre_" + cookedPatchID;
            Path preF = WrapperFactory.getNioServiceWrapper().getPath(preFileName, new String[0]);
            if (Files.exists(preF, new LinkOption[0])) {
                if (!Files.isReadable(preF)) {
                    buff = new StringBuffer("Copy Action: Source file \"");
                    buff.append(preF.toAbsolutePath().toString());
                    buff.append("\" is not readable.");
                    this.nonRollbackableDesc = buff.toString();
                    return false;
                }
                if (Files.isDirectory(preF, new LinkOption[0])) {
                    buff = new StringBuffer("Copy Action: Source file \"");
                    buff.append(preF.toAbsolutePath().toString());
                    buff.append("\" is a directory.");
                    this.nonRollbackableDesc = buff.toString();
                    return false;
                }
            } else {
                String newFileName = path.toString() + "_opatch_new_" + cookedPatchID;
                Path newF = WrapperFactory.getNioServiceWrapper().getPath(newFileName, new String[0]);
                if (!Files.exists(newF, new LinkOption[0])) {
                    buff = new StringBuffer("Copy Action: Source file \"");
                    buff.append(preF.toAbsolutePath().toString());
                    buff.append("\" does not exists.");
                    this.nonRollbackableDesc = buff.toString();
                    return false;
                }
            }
            return true;
        }
        if (null != initilizedCID && !initilizedCID.equals(cookedPatchID)) {
            CopyAction.getSameFileCache(oracleHomePath, cookedPatchID);
        }
        StringBuffer path = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        path.append(fileSeparator);
        path.append(this.fileName);
        String src = path.toString();
        String dst = null;
        dst = this.isOpatchBinary() ? this.getParentFilePath(OPatchEnv.getOracleHome()) : this.getParentFilePath(oracleHomePath);
        buff = new StringBuffer("CopyAction::rollbackable() : ");
        buff.append(", src = \"");
        buff.append(src);
        buff.append("\", dst = \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.debug(buff);
        Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(src, new String[0]);
        Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
        if (Files.exists(srcFile, new LinkOption[0]) && !Files.isReadable(srcFile)) {
            buff = new StringBuffer("Copy Action: Source file \"");
            buff.append(srcFile.toAbsolutePath().toString());
            buff.append("\" is not readable.");
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        String psCookedPatchIDPath = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID);
        boolean isPSExist = this.checkPatchStorageExist(psCookedPatchIDPath);
        if (!isPSExist) {
            buff = new StringBuffer("Copy Action: Directory \"");
            buff.append(WrapperFactory.getNioServiceWrapper().getPath(psCookedPatchIDPath, new String[0]).toAbsolutePath().toString());
            buff.append("\" does not exists or is not readable. ");
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        Path parentFile = dstFile.getParent();
        if (!Files.exists(parentFile, new LinkOption[0])) {
            if (!Files.exists(srcFile, new LinkOption[0])) {
                buff = new StringBuffer("Dir :");
                buff.append(parentFile.toAbsolutePath().toString());
                buff.append(" does not exist, and file is a new file, so returning true");
                OLogger.printlnOnLog(buff.toString());
                return true;
            }
            try {
                Files.createDirectories(parentFile, new FileAttribute[0]);
            }
            catch (IOException e2) {
                OLogger.debug(e2.getMessage());
            }
        }
        if (!Files.exists(parentFile, new LinkOption[0])) {
            buff = new StringBuffer("Copy Action: ");
            buff.append("Cannot mkdirs on \"");
            try {
                buff.append(parentFile.toAbsolutePath().normalize().toString());
            }
            catch (Exception e3) {
                // empty catch block
            }
            buff.append("\".");
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        if (!(Files.exists(srcFile, new LinkOption[0]) || sameFileMap.containsKey(this.getFilename()) || Files.isWritable(parentFile))) {
            buff = new StringBuffer("Copy Action: Destination directory \"");
            buff.append(parentFile.toAbsolutePath().toString());
            buff.append("\" is not writable.");
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        buff = new StringBuffer("CopyAction::rollbackable() return true");
        OLogger.debug(buff);
        return true;
    }

    @Override
    public void backupForRollback(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        String patchLocation = OPatchEnv.getPatchloc();
        this.backupForRollback(oracleHomePath, cookedPatchID, patchLocation);
    }

    public void backupForRollback(String oracleHomePath, String cookedPatchID, String patchLocation) throws RuntimeException {
        if (this.getPatchObject().isNotRollBackable()) {
            StringBuffer buff = new StringBuffer("CopyAction::backupForRollback() not done because the patch is not rollbackable");
            OLogger.debug(buff);
            return;
        }
        StringBuffer buff = new StringBuffer("CopyAction::backupForRollback()");
        OLogger.debug(buff);
        String phSrc = this.getSourceFile(patchLocation);
        String src = null;
        src = this.isOpatchBinary() ? this.getParentFilePath(OPatchEnv.getOracleHome()) : this.getParentFilePath(oracleHomePath);
        StringBuffer path = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        path.append(fileSeparator);
        path.append(this.fileName);
        String dst = path.toString();
        Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(src, new String[0]);
        Path phFile = WrapperFactory.getNioServiceWrapper().getPath(phSrc, new String[0]);
        DeltaFileProcessor deltaFileProcessor = OUSession.getDeltaFileProcessor();
        Boolean sameHash = false;
        buff = new StringBuffer("CopyAction::backupForRollback() : ");
        buff.append(", src = \"");
        buff.append(src);
        buff.append("\", dst = \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.debug(buff);
        if (!Files.exists(srcFile, new LinkOption[0])) {
            buff = new StringBuffer("CopyAction::backupForRollback() : source ");
            buff.append(", src = \"");
            buff.append(src);
            buff.append("\" does not exist, will not back it up.");
            buff.append(dst);
            buff.append("\"");
            OLogger.debug(buff);
            buff = new StringBuffer("CopyAction::backupForRollback(): source file \"");
            buff.append(src);
            buff.append("\" not exist, so not creating ");
            buff.append(src);
            buff.append(" in the backup area. ");
            OLogger.debug(buff);
            StringBuffer dstFileName = new StringBuffer(this.fileName);
            dstFileName.append("_opatch_");
            dstFileName.append(cookedPatchID);
            path = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
            path.append(fileSeparator);
            path.append(dstFileName);
            dst = path.toString();
            path = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
            path.append(fileSeparator);
            path.append(this.fileName);
            Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(path.toString(), new String[0]);
            if (Files.exists(dstFile, new LinkOption[0])) {
                try {
                    Files.delete(dstFile);
                }
                catch (IOException e2) {
                    OLogger.debug(e2.getMessage());
                }
            }
            return;
        }
        if (Files.isDirectory(srcFile, new LinkOption[0])) {
            buff = new StringBuffer("CopyAction:: backupForRollback()");
            buff.append(" will not backup directory \"");
            buff.append(src);
            buff.append("\" to .patch_storage.");
            OLogger.debug(buff.toString());
            return;
        }
        if (this.backupZip) {
            try {
                Path dstDir = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]).getParent();
                if (!Files.exists(dstDir, new LinkOption[0])) {
                    try {
                        Files.createDirectories(dstDir, new FileAttribute[0]);
                    }
                    catch (Exception e3) {
                        buff = new StringBuffer("DeleteAction::backupForRollback(): cannot mkdirs on ");
                        buff.append(dstDir.toAbsolutePath().toString());
                        OLogger.debug(buff);
                        throw new RuntimeException(buff.toString());
                    }
                }
                ZipUtilities.compressZip(dst + ".zip", src);
            }
            catch (Exception e4) {
                e4.printStackTrace();
            }
        } else {
            if (!Files.isDirectory(phFile, new LinkOption[0])) {
                sameHash = deltaFileProcessor.compareHash(phFile, srcFile, this);
            }
            Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
            if (sameHash.booleanValue()) {
                boolean cbccResolved = CbccEngine.getInstance().hasCbccResolved(srcFile.toString());
                if (!cbccResolved) {
                    this.isSame = true;
                    return;
                }
                String newSrcForCbcc = this.getCbccNewSource(srcFile, dstFile);
                if (newSrcForCbcc == null) {
                    this.isSame = true;
                    return;
                }
                if (newSrcForCbcc.equals("NOT_BACKUP_IN_UNCHANGEDLIST")) {
                    this.isSame = true;
                    return;
                }
                if (newSrcForCbcc.equals("NOT_BACKUP_NOT_IN_UNCHANGEDLIST")) {
                    return;
                }
                OLogger.debug("Overwrite the new source for backupForRollback: " + newSrcForCbcc);
                Path newSrcForCbccFile = WrapperFactory.getNioServiceWrapper().getPath(newSrcForCbcc, new String[0]);
                this.doTheCopy(newSrcForCbccFile, dstFile);
            } else {
                this.doTheCopy(srcFile, dstFile);
            }
        }
    }

    private void doTheCopy(Path srcFile, Path dstFile) {
        StringBuffer buff = new StringBuffer();
        Path parentFile = dstFile.getParent();
        if (!Files.exists(parentFile, new LinkOption[0])) {
            try {
                Files.createDirectories(parentFile, new FileAttribute[0]);
            }
            catch (Exception e2) {
                buff = new StringBuffer("CopyAction::backupForRollback(): cannot mkdirs on ");
                buff.append(parentFile.toAbsolutePath().toString());
                OLogger.debug(buff);
                throw new RuntimeException(buff.toString());
            }
        }
        try {
            buff = new StringBuffer("CopyAction::backupForRollback(): back up ");
            buff.append(srcFile.toString());
            buff.append(" to ");
            buff.append(dstFile.toString());
            OLogger.debug(buff);
            if (!OPatchEnv.isWindows() && Files.exists(dstFile, new LinkOption[0]) && !Files.isWritable(dstFile) && !"".equals(this.permission)) {
                OUIReplacer.setPermission(dstFile.toString(), this.permission);
            }
            SystemCall.backupFile(srcFile, dstFile);
        }
        catch (RuntimeException e3) {
            this.backupForRollbackFailureDesc = OLogger.getString("OUI-67003", new Object[]{srcFile.toString(), dstFile.toString(), e3.getMessage()});
            OLogger.println(this.backupForRollbackFailureDesc);
            throw e3;
        }
    }

    @Override
    public String getRollbackScriptEntry(String oracleHomePath, String cookedPatchID) throws NullPointerException {
        StringBuffer buff = new StringBuffer("CopyAction::getRollbackScriptEntry()");
        OLogger.debug(buff);
        String source = this.getParentFilePath(oracleHomePath);
        StringBuffer path = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        path.append(fileSeparator);
        path.append(this.fileName);
        String dst = path.toString();
        boolean isWindow = OPatchEnv.isWindows();
        StringBuffer rollbackStr = new StringBuffer("\n");
        Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
        if (!Files.exists(dstFile, new LinkOption[0])) {
            buff = new StringBuffer(dst);
            buff.append("_opatch_");
            buff.append(cookedPatchID);
            Path dstNewFile = WrapperFactory.getNioServiceWrapper().getPath(buff.toString(), new String[0]);
            if (Files.exists(dstNewFile, new LinkOption[0])) {
                if (isWindow) {
                    rollbackStr.append("del ");
                } else {
                    rollbackStr.append("\\rm -f ");
                }
                rollbackStr.append(source);
                return rollbackStr.toString();
            }
            rollbackStr.append(source);
            return rollbackStr.toString();
        }
        if (isWindow) {
            rollbackStr.append("copy /Y ");
        } else {
            rollbackStr.append("\\cp -f ");
        }
        rollbackStr.append(dst);
        rollbackStr.append(" ");
        rollbackStr.append(source);
        return rollbackStr.toString();
    }

    public static Map<String, Boolean> getSrcFileInUnchangedFileList(String oracleHomePath, String cookedPatchID) {
        String fileLoc = OPatchEnv.getUnchangedFilePath(oracleHomePath, cookedPatchID);
        HashMap<String, Boolean> fileMap = new HashMap();
        NApplyDataSerializer serializer = new NApplyDataSerializer();
        try {
            fileMap = serializer.deserializeUnchangedFile(fileLoc);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            OLogger.printlnOnLogAndVerbose("Unable to parse cached OH files.");
        }
        initilizedCID = cookedPatchID;
        return fileMap;
    }

    @Override
    public void rollback(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        StringBuffer buff;
        block19: {
            String dst1;
            buff = new StringBuffer("CopyAction::rollback()");
            OLogger.debug(buff);
            StringBuilder tmpB = new StringBuilder(buff.toString());
            tmpB.append(" rollbacks Copy line ");
            tmpB.append(this.getLineNumber());
            OLogger.debug(tmpB.toString());
            if (null != initilizedCID && !initilizedCID.equals(cookedPatchID)) {
                sameFileMap = CopyAction.getSrcFileInUnchangedFileList(oracleHomePath, cookedPatchID);
            }
            this.isSame = sameFileMap.containsKey(dst1 = this.getFilename());
            buff = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
            buff.append(fileSeparator);
            buff.append(this.fileName);
            String src = buff.toString();
            String dst = null;
            dst = this.isOpatchBinary() ? this.getParentFilePath(OPatchEnv.getOracleHome()) : this.getParentFilePath(oracleHomePath);
            Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(src, new String[0]);
            Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
            boolean cont = Rules.SystemWrite_continue();
            buff = new StringBuffer(" CopyAction: src=\"");
            buff.append(src);
            buff.append("\", dst=\"");
            buff.append(dst);
            buff.append("\"");
            OLogger.verbose(this, buff);
            try {
                buff = new StringBuffer("CopyAction::rollback(): restore file from \"");
                buff.append(src);
                buff.append("\" to \"");
                buff.append(dst);
                buff.append("\"");
                OLogger.debug(buff);
                DeltaFileProcessor deltaFileProcessor = OUSession.getDeltaFileProcessor();
                boolean sameHash = false;
                if (!this.updateTimeStamp) {
                    sameHash = this.isSame;
                }
                if (!sameHash && !Files.isDirectory(srcFile, new LinkOption[0])) {
                    deltaFileProcessor.addNRollbackDeltaFiles(dst, this);
                }
                Map<String, Set<String>> fileRefCount = OUSession.getFileRefCount(oracleHomePath);
                String fileWithHash = dstFile + "_" + this.getHashValue();
                Set<String> rollbackPatchIds = OPatchUtilHelper.getNRollbackPatchIds();
                if (fileRefCount.containsKey(fileWithHash) && !rollbackPatchIds.containsAll((Collection)fileRefCount.get(fileWithHash))) {
                    HashSet temp = new HashSet(fileRefCount.get(fileWithHash));
                    temp.removeAll(rollbackPatchIds);
                    OLogger.justlog(OLogger.INFO, "Skipped rollback of file " + dstFile + " as it is required by other patches " + temp);
                    break block19;
                }
                if (Files.exists(srcFile, new LinkOption[0]) && Files.isReadable(srcFile)) {
                    buff = new StringBuffer();
                    buff.append(dst);
                    OLogger.onlyLogInfo("OUI-67047", new Object[]{buff.toString()});
                    if (cont && !sameHash && !Files.isDirectory(srcFile, new LinkOption[0])) {
                        String tempPerm = "";
                        if (!"".equals(this.permission)) {
                            tempPerm = this.permission;
                            this.permission = "";
                        }
                        if (Files.exists(dstFile, new LinkOption[0]) && Files.isDirectory(dstFile, new LinkOption[0])) {
                            SystemCall.deleteRecurse(dstFile, true);
                        }
                        this.performCopyOperation(oracleHomePath, srcFile, dstFile);
                        if (!"".equals(this.permission)) {
                            this.permission = tempPerm;
                        }
                    }
                    break block19;
                }
                if (!Files.exists(srcFile, new LinkOption[0]) && !this.isSame) {
                    Path srcFileZip = WrapperFactory.getNioServiceWrapper().getPath(src + ".zip", new String[0]);
                    if (this.backupZip && Files.exists(srcFileZip, new LinkOption[0])) {
                        if (cont) {
                            ZipUtilities.unzip(srcFileZip.toString(), dstFile.getParent().toString());
                        }
                    } else {
                        OLogger.justlog(OLogger.INFO, "Deleting file \"" + dst + "\"");
                        if (cont) {
                            try {
                                Path parentDir = dstFile.getParent();
                                Files.delete(dstFile);
                                OPatchUtilHelper.checkAndRemoveNewDirs(parentDir);
                            }
                            catch (Exception e2) {
                                buff = new StringBuffer("Unable to delete the file, so doing nothing.");
                                OLogger.printlnOnLog(buff.toString());
                            }
                        }
                    }
                    break block19;
                }
                if (!Files.exists(srcFile, new LinkOption[0]) && this.isSame) {
                    OLogger.justlog(OLogger.INFO, "Skip rollback file \"" + dst + "\"");
                    break block19;
                }
                throw new RuntimeException(src + "exists but it is not readable.");
            }
            catch (RuntimeException e3) {
                OLogger.printStackTrace(e3);
                String warnMsg = OLogger.getString("OUI-67204", new Object[]{src, dst, ""});
                buff = new StringBuffer("CopyAction::rollback() failed: \"");
                buff.append(e3.getMessage());
                buff.append("\"");
                OLogger.debug(buff);
                RuntimeException re = new RuntimeException(warnMsg);
                re.setStackTrace(e3.getStackTrace());
                throw re;
            }
        }
        buff = new StringBuffer(" CopyAction done");
        OLogger.verbose(this, buff);
    }

    @Override
    public boolean applicable(String oracleHomePath, String patchLocation) {
        StringBuffer buff = new StringBuffer("CopyAction::applicable()");
        OLogger.debug(buff);
        String src = this.getSourceFile(patchLocation);
        String dst = null;
        dst = this.isOpatchBinary() ? this.getParentFilePath(OPatchEnv.getOracleHome()) : this.getParentFilePath(oracleHomePath);
        buff = new StringBuffer("  Action details: src = \"");
        buff.append(src);
        buff.append("\", dst = \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.debug(buff);
        Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(src, new String[0]);
        Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
        if (Files.isDirectory(srcFile, new LinkOption[0])) {
            return true;
        }
        if (!Files.exists(srcFile, new LinkOption[0]) && this.isUnzip) {
            ZipUtilities.depressFiles(this.unzipSrcLoc, this.unzipDstDir);
        }
        if (!Files.exists(srcFile, new LinkOption[0]) || !Files.isReadable(srcFile)) {
            buff = new StringBuffer("Copy Action: Source File \"");
            buff.append(src);
            buff.append("\" does not exists or is not readable");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        Path parentFile = dstFile.getParent();
        if (Files.exists(parentFile, new LinkOption[0]) && !Files.isReadable(parentFile)) {
            buff = new StringBuffer("Copy Action: Directory is not readable: \"");
            buff.append(parentFile.toAbsolutePath().toString());
            buff.append("\"");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        if (Files.exists(dstFile, new LinkOption[0]) && !OPatchSessionHelper.CanWrite(oracleHomePath, dstFile) && (this.retainPermission || OPatchEnv.isWindows() || "".equals(this.permission))) {
            buff = new StringBuffer("Copy Action: Destination File \"");
            buff.append(dst);
            buff.append("\" is not writeable.");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        boolean dirCheck = false;
        if (OPatchEnv.isWindows()) {
            dirCheck = Files.exists(parentFile, new LinkOption[0]) && !Files.isWritable(parentFile);
        } else {
            boolean bl = dirCheck = !Files.exists(dstFile, new LinkOption[0]) && Files.exists(parentFile, new LinkOption[0]) && !Files.isWritable(parentFile);
        }
        if (dirCheck) {
            buff = new StringBuffer("Copy Action: Directory is not writeable: \"");
            buff.append(parentFile.toAbsolutePath().toString());
            buff.append("\"");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        if (!OPatchEnv.isWindows() && !Files.exists(parentFile, new LinkOption[0])) {
            try {
                Path oh = WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath, new String[0]);
                String ohPath = oh.toAbsolutePath().normalize().toString();
                while (true) {
                    if (Files.exists(parentFile = dstFile.getParent(), new LinkOption[0])) {
                        String curPath = parentFile.toAbsolutePath().normalize().toString();
                        if (!Files.isWritable(parentFile)) {
                            buff = new StringBuffer("Copy Action: Directory is not writeable: \"");
                            buff.append(parentFile.toAbsolutePath().toString());
                            buff.append("\"");
                            this.nonApplicableDesc = buff.toString();
                            return false;
                        }
                        if (curPath.equals(ohPath)) break;
                    }
                    dstFile = parentFile;
                }
            }
            catch (Throwable t) {
                buff = new StringBuffer("Copy Action: OPatch failed due to serious exception: ");
                buff.append(t.getMessage());
                this.nonApplicableDesc = buff.toString();
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean verify(String oracleHomePath, String patchLocation) throws IOException {
        StringBuffer buff = new StringBuffer("CopyAction::verify()");
        OLogger.debug(buff);
        if (this.isSnowBallCopyAction() && this.isHasFileVersion()) {
            int retVal;
            String appVersion = (String)copyActVer.get(this);
            String copyActVersion = this.getFileVersion();
            boolean skip = false;
            if (OPatchEnv.isFATwoPhase()) {
                if (!this.getFileVersion().equals(envCopyActVer.get(this.getFilename()))) {
                    skip = true;
                }
            } else if (appVersion != null && !appVersion.equals("") && (retVal = OPatchSessionHelper.isGreaterDecimal(appVersion, copyActVersion)) >= 0) {
                skip = true;
            }
            if (skip) {
                OLogger.printlnOnLogAndVerbose("Skipping verification for this copy action \"" + this.getParentFilePath(oracleHomePath) + "\"");
                OLogger.printlnOnLogAndVerbose("This is a snowball copy but not updated in OH due to less or equal file versions.");
                return true;
            }
        }
        String src = this.getSourceFile(patchLocation);
        String dst = this.getParentFilePath(oracleHomePath);
        buff = new StringBuffer("\n(C): Comparing file \"");
        buff.append(src);
        buff.append("\" and \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.log(OLogger.FINE, buff.toString());
        Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(src, new String[0]);
        Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
        if (!Files.exists(srcFile, new LinkOption[0])) {
            buff = new StringBuffer("Source file \"");
            buff.append(src);
            buff.append("\" does not exist.  Can't verify.");
            OLogger.log(OLogger.WARNING, buff.toString());
            return false;
        }
        if (!Files.exists(dstFile, new LinkOption[0])) {
            buff = new StringBuffer("Destination file \"");
            buff.append(dst);
            buff.append("\" does not exist.  Can't verify.");
            OLogger.log(OLogger.WARNING, buff.toString());
            return false;
        }
        if (!Files.isDirectory(srcFile, new LinkOption[0])) {
            boolean identical;
            InputStream srcStream = Files.newInputStream(WrapperFactory.getNioServiceWrapper().getPath(src, new String[0]), new OpenOption[0]);
            InputStream dstStream = Files.newInputStream(WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]), new OpenOption[0]);
            boolean bl = identical = this.updateTimeStamp ? true : CopyAction.fileCompare(srcStream, dstStream);
            if (this.updateTimeStamp) {
                OLogger.printlnOnLogAndVerbose("Skip verification for the copy action \"" + this.getParentFilePath(oracleHomePath) + "\" as timestamps are updated for this action");
            }
            srcStream.close();
            dstStream.close();
            buff = new StringBuffer("  2 files are identical? ");
            buff.append(String.valueOf(identical).toUpperCase());
            OLogger.log(OLogger.FINE, buff.toString());
            if (!identical) {
                this.printVerificationFailure(this, src, dst);
                OLogger.printlnOnLog(OLogger.INFO, new String("Failed file pair information (copy)::"));
                try {
                    StringBuffer srcBuffer = new StringBuffer("Source file name is : " + src);
                    srcBuffer.append(",  size is : ");
                    srcBuffer.append(new Long(Files.size(srcFile)).toString());
                    OLogger.printlnOnLog(OLogger.INFO, srcBuffer.toString());
                    StringBuffer destBuffer = new StringBuffer("Destination file name is : " + dst);
                    destBuffer.append(",  size is : ");
                    destBuffer.append(new Long(Files.size(dstFile)).toString());
                    OLogger.printlnOnLog(OLogger.INFO, destBuffer.toString());
                }
                catch (Exception e2) {
                    OLogger.printlnOnLog(OLogger.INFO, new String("Some error in recording this file size pair"));
                }
            }
            return identical;
        }
        return true;
    }

    public void performCopyOperation(String oracleHomePath, Path srcFile, Path dstFile) {
        if (this.updateTimeStamp && UpdateTimeStamp.isArchive(this.copyName)) {
            long time = System.currentTimeMillis();
            String mySrc = OPatchEnv.getPatchScratchDirectoryPath(oracleHomePath, OPatchEnv.getCookedPatchID()) + fileSeparator + this.copyName;
            OLogger.justlog(OLogger.INFO, "Updating TimeStamp of all entries recursively for --> \"" + mySrc + "\" at --> ");
            UpdateTimeStamp.updateTime(srcFile.toAbsolutePath().toString(), mySrc, time);
            OLogger.justlog(OLogger.INFO, "TimeStamp of all entries updated for --> \"" + mySrc + "\" at --> ");
            SystemCall.copyFile(WrapperFactory.getNioServiceWrapper().getPath(mySrc, new String[0]), dstFile, this);
            OPatchSessionHelper.deleteRecurse(mySrc);
        } else {
            SystemCall.copyFile(srcFile, dstFile, this);
        }
    }

    @Override
    public void apply(String oracleHomePath, String patchLocation) throws RuntimeException {
        StringBuffer buff = new StringBuffer("CopyAction::apply()");
        OLogger.debug(buff);
        buff = new StringBuffer("   Process CopyAction ");
        buff.append(this.toString());
        OLogger.debug(buff);
        String src = this.getSourceFile(patchLocation);
        String dst = null;
        dst = this.isOpatchBinary() ? this.getParentFilePath(OPatchEnv.getOracleHome()) : this.getParentFilePath(oracleHomePath);
        buff = new StringBuffer(" CopyAction: src=\"");
        buff.append(src);
        buff.append("\", dst=\"");
        buff.append(dst);
        buff.append("\"");
        OLogger.verbose(this, buff);
        Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(src, new String[0]);
        Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
        Path parentFile = dstFile.getParent();
        boolean cont = Rules.SystemWrite_continue();
        if (cont) {
            if (!Files.exists(parentFile, new LinkOption[0])) {
                try {
                    OPatchUtilHelper.saveNewDirPS(oracleHomePath, parentFile);
                    Files.createDirectories(parentFile, new FileAttribute[0]);
                }
                catch (IOException e2) {
                    OLogger.debug(e2.getMessage());
                }
            }
            if (!Files.exists(parentFile, new LinkOption[0])) {
                buff = new StringBuffer("CopyAction::apply(): cannot mkdirs on parent directory ");
                try {
                    buff.append(parentFile.toAbsolutePath().normalize().toString());
                }
                catch (Exception e3) {
                    // empty catch block
                }
                OLogger.debug(buff);
                throw new RuntimeException(buff.toString());
            }
        }
        if (!Files.exists(srcFile, new LinkOption[0])) {
            buff = new StringBuffer("CopyAction::apply()");
            buff.append(": the src file is not there.  This should not happen because ");
            buff.append("caller has certified that this CopyAction is applicable. src = ");
            buff.append(src);
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
        try {
            String srcVer = "";
            String destVer = "";
            boolean doCopy = true;
            boolean intra = false;
            if (!this.isHasFileVersion()) {
                doCopy = true;
            } else if (!this.isSnowBallCopyAction()) {
                if (this.fileVersionObj == null || this.fileVersionObj.getPl() == null) {
                    OLogger.debug("This copy action is not part of snowball patch, and don't have file version, then set to copy");
                    doCopy = true;
                } else {
                    OLogger.debug("This copy action is not part of snowball patch, and have file version, but copy or not depended on file version.");
                    doCopy = this.copyFlagBasedOnFileVersion;
                    if (!this.copyFlagBasedOnFileVersion) {
                        srcVer = this.fileVersion;
                        destVer = this.fileVersion;
                    }
                }
            } else {
                OLogger.debug("This copy has file version & is a snowball copy");
                if (OPatchEnv.isFATwoPhase()) {
                    if (!this.getFileVersion().equals(envCopyActVer.get(this.getFilename()))) {
                        srcVer = this.getFileVersion();
                        destVer = (String)copyActVer.get(this.getFilename());
                        if (destVer == null) {
                            intra = true;
                            destVer = (String)iCopyActVer.get(this.getFilename());
                        }
                        doCopy = false;
                        this.setApplyFailed();
                    }
                } else if (envCopyActVer.containsKey(this) && !DeleteAction.getDoneDeleteActVer().containsKey(this.getFilename())) {
                    srcVer = this.getFileVersion();
                    destVer = (String)envCopyActVer.get(this);
                    OLogger.printlnOnLogAndVerbose("To be Applied Version : " + srcVer);
                    OLogger.printlnOnLogAndVerbose("Present Highest Version in OH : " + destVer);
                    int retVal = OPatchSessionHelper.isGreaterDecimal(srcVer, destVer);
                    if (retVal == 1) {
                        doCopy = true;
                    } else {
                        doCopy = false;
                        this.setApplyFailed();
                    }
                } else {
                    doCopy = true;
                }
            }
            DeltaFileProcessor deltaFileProcessor = OUSession.getDeltaFileProcessor();
            boolean sameHash = false;
            this.isSame = !this.updateTimeStamp && !Files.isDirectory(srcFile, new LinkOption[0]) ? (sameHash = deltaFileProcessor.compareHash(srcFile, dstFile, this)) : false;
            boolean greatVersion = doCopy;
            if (Files.isDirectory(srcFile, new LinkOption[0])) {
                doCopy = false;
            }
            if (sameHash) {
                doCopy = false;
            } else if (sameFileMap.containsKey(this.getFilename())) {
                sameFileMap.remove(this.getFilename());
                this.backupForRollback(oracleHomePath, this.getPatchObject().getCookedPatchID());
            }
            if (doCopy) {
                deltaFileProcessor.addNApplyDeltaFiles(dst, this);
            }
            if (cont) {
                if (doCopy) {
                    if (this.isHasFileVersion() && this.isSnowBallCopyAction()) {
                        OLogger.info("OUI-67629", new Object[]{this.getParentFilePath(oracleHomePath), this.getFileVersion()});
                        if (!OPatchEnv.isFATwoPhase()) {
                            envCopyActVer.put(this, this.getFileVersion());
                        }
                    } else {
                        OLogger.justlog(OLogger.INFO, OLogger.getString("OUI-67047", new Object[]{this.getParentFilePath(oracleHomePath)}));
                    }
                    this.performCopyOperation(oracleHomePath, srcFile, dstFile);
                    if (OPatchEnv.isFATwoPhase()) {
                        Set keys = envCopyActVer.keySet();
                        Iterator itr = keys.iterator();
                        while (itr.hasNext()) {
                            String fileName = (String)itr.next();
                            if (!this.getFilename().equals(fileName)) continue;
                            itr.remove();
                        }
                    }
                } else if (!greatVersion) {
                    if (intra) {
                        OLogger.println(OLogger.getString("OUI-67659", new Object[]{this.getParentFilePath(oracleHomePath), srcVer, destVer}));
                    } else {
                        OLogger.println(OLogger.getString("OUI-67630", new Object[]{this.getParentFilePath(oracleHomePath), srcVer, destVer}));
                    }
                } else if (sameHash) {
                    OLogger.printlnOnLogAndVerbose(OLogger.getString("OUI-67661", new Object[]{this.getParentFilePath(oracleHomePath), src}));
                } else if (Files.isDirectory(srcFile, new LinkOption[0])) {
                    buff = new StringBuffer("CopyAction::apply() skips copying directory ");
                    buff.append(srcFile);
                    buff.append(" to ");
                    buff.append(dstFile);
                    buff.append(" , because it will be created by mkdirs().");
                    OLogger.debug(buff);
                }
            } else {
                buff = new StringBuffer("CopyAction::apply() skips copying the file from ");
                buff.append(srcFile);
                buff.append(" to ");
                buff.append(dstFile);
                OLogger.debug(buff);
            }
        }
        catch (RuntimeException e4) {
            OLogger.printStackTrace(e4);
            String warnMsg = OLogger.getString("OUI-67204", new Object[]{src, dst, ""});
            String retry = OLogger.getString("OUI-67621", new Object[]{oracleHomePath});
            String retryMessage = "\n" + warnMsg + " " + retry;
            OLogger.println(retryMessage);
            String question = OLogger.getString("OUI-67622");
            OLogger.debug("CopyAction::apply() failed: \"" + e4.getMessage() + "\"");
            if (!OPatchEnv.proceedWithOperationDefaultNo(question)) {
                RuntimeException re = new RuntimeException(warnMsg);
                re.setStackTrace(e4.getStackTrace());
                throw re;
            }
            try {
                retry = OLogger.getString("OUI-67623", new Object[]{dst});
                OLogger.println(retry);
                SystemCall.copyFile(srcFile, dstFile, this);
            }
            catch (RuntimeException ex) {
                OLogger.justlog(OLogger.INFO, warnMsg);
                RuntimeException re = new RuntimeException(warnMsg);
                re.setStackTrace(ex.getStackTrace());
                throw re;
            }
        }
        buff = new StringBuffer(" CopyAction done");
        OLogger.verbose(this, buff);
    }

    @Override
    public String getApplicableDesc(String oracleHomePath, String owningComp) {
        String src = this.getSourceFile();
        String dst = this.getParentFilePath(oracleHomePath);
        String desc = this.nonApplicableDesc + "\n" + OLogger.getString("OUI-67152", new Object[]{owningComp, src, dst});
        return desc;
    }

    @Override
    public String getRollbackableDesc(String oracleHomePath, String owningComp) {
        String src = this.getSourceFile();
        String dst = this.getParentFilePath(oracleHomePath);
        String desc = this.nonRollbackableDesc + "\n" + OLogger.getString("OUI-67152", new Object[]{owningComp, src, dst});
        return desc;
    }

    @Override
    public String getBackupForRollbackDesc(String oracleHomePath) {
        return this.backupForRollbackFailureDesc;
    }

    @Override
    public String getFilePathToPropagate(String oracleHomePath) throws RuntimeException {
        return this.getParentFilePath(oracleHomePath);
    }

    @Override
    public boolean conflictDetectable(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("CopyAction::conflictDetectable()  ");
        String dst = this.getParentFilePath(oracleHomePath);
        boolean tmpB = dst != null && !dst.equals("");
        buff.append(tmpB);
        OLogger.debug(buff);
        return tmpB;
    }

    @Override
    public String[] filesTouched(String oracleHomePath) throws RuntimeException {
        String dst = this.getParentFilePath(oracleHomePath);
        String[] filesList = new String[]{dst};
        return filesList;
    }

    @Override
    public String checkConflict(String oracleHomePath, OneOffEntry[] oneoffs) throws RuntimeException {
        return ConflictHandler.checkCommonConflict(oracleHomePath, oneoffs, this);
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 instanceof CopyAction) {
            String myFileName = this.getFilename();
            String myPath = this.getPath();
            String myCopyName = this.getCopyName();
            CopyAction it = (CopyAction)o2;
            String itFileName = it.getFilename();
            String itPath = it.getPath();
            String itCopyName = it.getCopyName();
            if (myFileName.equals(itFileName) && myPath.equals(itPath) && myCopyName.equals(itCopyName)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.fileName.length();
        result = 37 * result + this.copyName.length();
        result = 37 * result + this.path.length();
        return result;
    }

    @Override
    public String getActionName() {
        return "CopyAction";
    }

    @Override
    public String getActionDesc() {
        return "Copy a file from source to destination.";
    }

    @Override
    public String getApplyDescription(String oracleHomePath) {
        return "Copy the file to ORACLE_HOME from the patch.";
    }

    @Override
    public String getChildPath() {
        return "";
    }

    @Override
    public String getRollbackDescription(String oracleHomePath) {
        return "Copy the file from backup to ORACLE_HOME.";
    }

    @Override
    public int getBackupForRollbackFileNumber(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        return 1;
    }

    public void addCopyActToPatchID(String patchID) {
        copyActionPatchIds.put(this, patchID);
    }

    public static HashMap getCopyActionPatchIds() {
        return copyActionPatchIds;
    }

    public static void cleanSameFileCache(String oracleHomePath, String cookedPatchID) {
        if (!OPatchEnv.isReport() && null != sameFileMap) {
            try {
                NApplyDataSerializer serializer = new NApplyDataSerializer();
                serializer.serializeUnchangedFile(OPatchEnv.getUnchangedFilePath(oracleHomePath, cookedPatchID), sameFileMap);
            }
            catch (IOException e2) {
                OLogger.println("Can not write unchanged_files.txt...");
            }
        }
        CopyAction.cleanSameFilesMap();
    }

    public static void cleanSameFilesMap() {
        if (null != sameFileMap && sameFileMap.size() > 0) {
            sameFileMap.clear();
        }
        initilizedCID = "";
    }

    public static void destroyObject() {
        copyActVer.clear();
        iCopyActVer.clear();
        envCopyActVer.clear();
        copyActionPatchIds.clear();
    }

    private String getCbccNewSource(Path srcFile, Path dstFile) {
        CbccResult cbccResult = CbccEngine.getInstance().getResult();
        Object[] res = cbccResult.getResolvedBackupForRollbackPaths(srcFile.toString(), this.getPatchObject().getPatchID());
        if (res == null) {
            return null;
        }
        String newSrc = null;
        if (res[0] != null && res[0] instanceof String) {
            newSrc = (String)res[0];
        }
        PatchObject po = null;
        if (res[1] != null && res[1] instanceof PatchObject) {
            po = (PatchObject)res[1];
        }
        if (newSrc == null || po == null) {
            return null;
        }
        File newSrcFile = new File(newSrc + File.separator + this.fileName);
        if (newSrcFile.exists()) {
            OLogger.justlog(OLogger.INFO, "CBCC resolved: use this new source: " + newSrcFile);
            return newSrc + File.separator + this.fileName;
        }
        Map<String, Boolean> sameFileMap = CopyAction.getSrcFileInUnchangedFileList(OPatchEnv.getOracleHome(), po.getCookedPatchID());
        if (sameFileMap.containsKey(this.fileName)) {
            OLogger.justlog(OLogger.INFO, "CBCC: Backup for rollback not exists in peer storage, but exists in unchanged list " + newSrcFile);
            return "NOT_BACKUP_IN_UNCHANGEDLIST";
        }
        OLogger.justlog(OLogger.INFO, "CBCC: Backup for rollback not exists in both peer storage and unchanged list " + newSrcFile);
        return "NOT_BACKUP_NOT_IN_UNCHANGEDLIST";
    }
}

